/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.base.model;

public class Version
implements Comparable<Version> {
    final int major;
    final int minor;
    final String str;

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.str = this.major + "." + this.minor;
    }

    public static Version fromString(String versionStr) {
        int minor;
        int major;
        String[] segs = versionStr.split("[.]");
        if (segs.length != 2) {
            throw new IllegalArgumentException(versionStr);
        }
        try {
            major = Integer.parseInt(segs[0]);
            minor = Integer.parseInt(segs[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(versionStr);
        }
        return new Version(major, minor);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version av = (Version)obj;
        return this.major == av.major && this.minor == av.minor;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.major;
        hash = hash * 31 + this.minor;
        return hash;
    }

    @Override
    public int compareTo(Version av) {
        int i = this.major - av.major;
        if (i != 0) {
            return i;
        }
        return this.minor - av.minor;
    }

    public ChangeType changed(Version av) {
        if (this.major != av.major) {
            return ChangeType.Major;
        }
        if (this.minor != av.minor) {
            return ChangeType.Minor;
        }
        return ChangeType.None;
    }

    public static enum ChangeType {
        None,
        Minor,
        Major;

    }
}

