/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.base.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Field {
    public static final String SPECIAL_FIELD_PREFIX = "ez_";
    public static final String SPECIAL_FIELD = "ez";
    public static final String[] PASSWORD_FIELD_NAME_STEMS = new String[]{"password", "passwd"};
    public static final String FIELD_SEPARATOR = ".";
    public static final Set<String> ALL_SPECIAL_FIELDS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("ez_sync");
            this.add("formatVersion");
        }
    });

    public static boolean isSpecialField(String name) {
        String[] segs = name.split("[.]");
        String last = segs[segs.length - 1];
        return ALL_SPECIAL_FIELDS.contains(last) || last.startsWith(SPECIAL_FIELD_PREFIX) || segs[0].equals(SPECIAL_FIELD);
    }

    public static boolean isPasswordField(String name) {
        for (String stem : PASSWORD_FIELD_NAME_STEMS) {
            if (!name.toLowerCase().contains(stem)) continue;
            return true;
        }
        return false;
    }

    public static class Basic {
        public static final String F_SYNC = "ez_sync";
        public static final String F_FORMAT_VERSION = "formatVersion";
    }
}

