/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.idz.cics.gui;

import com.ez.rdz.resources.mainframe.analysis.CICSTransactionIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisJob;
import com.ez.rdz.utils.Messages;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ILocalTransaction;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMainframeAnalysisHandler
extends AbstractHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GetMainframeAnalysisHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String transactionName = "";
        String regionName = "";
        LinkedHashSet<CICSTransactionIdentifier> rdzResourceIdentifiers = new LinkedHashSet<CICSTransactionIdentifier>();
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection currentSelection = (IStructuredSelection)selection;
            for (Object item : currentSelection) {
                L.debug("\t------> {}", item.getClass());
                if (!(item instanceof ICICSResource) || !(item instanceof ILocalTransaction)) continue;
                ILocalTransaction cicsTransaction = (ILocalTransaction)item;
                regionName = cicsTransaction.getRegionName();
                transactionName = cicsTransaction.getName();
                rdzResourceIdentifiers.add(new CICSTransactionIdentifier(regionName, transactionName, "CICS Transaction"));
            }
            if (rdzResourceIdentifiers.size() == 0) {
                MessageDialog.openInformation((Shell)Display.getDefault().getShells()[0], (String)Messages.getString(GetMainframeAnalysisHandler.class, (String)"messageDialog.result.title"), (String)Messages.getString(GetMainframeAnalysisHandler.class, (String)"messageDialog.result.msg"));
            } else {
                new RDZMainframeAnalysisJob(Messages.getString(GetMainframeAnalysisHandler.class, (String)"job.rdzAnalysis.name"), rdzResourceIdentifiers).schedule();
            }
        }
        return null;
    }
}

