/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;

public final class UnsignedTypes {
    @NotNull
    private static final Set<Name> unsignedTypeNames;
    public static final UnsignedTypes INSTANCE;

    public final boolean isUnsignedType(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor2 = descriptor2 = classifierDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor2, "descriptor");
        return this.isUnsignedClass(classifierDescriptor2);
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor container = descriptor2.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)container).getFqName(), KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    private UnsignedTypes() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        UnsignedTypes unsignedTypes;
        INSTANCE = unsignedTypes = new UnsignedTypes();
        UnsignedType[] $receiver$iv = UnsignedType.values();
        UnsignedType[] unsignedTypeArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var7_7 = item$iv$iv = $receiver$iv$iv[i];
            Collection collection = destination$iv$iv;
            Name name = it.getTypeName();
            collection.add(name);
        }
        unsignedTypeNames = CollectionsKt.toSet((List)var3_3);
    }
}

