/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.zk.impl;

import com.ez.ezsource.connection.zkbridge.project.sso.HttpRequestRunnable;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.internal.Messages;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.HTTPErrorHandler;
import com.ibm.ad.oauth2.service.SSOService;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOHttpReqRunnable
implements HttpRequestRunnable {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(SSOHttpReqRunnable.class);

    public Object runRequest(String endpoint) throws Exception {
        return this.runRequest(endpoint, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object runRequest(String endpoint, String body) throws Exception {
        String ret = null;
        SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
        if (sso != null) {
            MPrjsContentConsumer consumer = new MPrjsContentConsumer();
            try {
                long t1 = System.currentTimeMillis();
                MFProjectsErrorHandler handler = new MFProjectsErrorHandler(endpoint);
                String method = body == null ? "GET" : "POST";
                sso.request(new URL(endpoint), method, body, (HttpResponseConsumer)consumer, (HTTPErrorHandler)handler);
                ret = consumer.getContent();
                Exception th = consumer.getException();
                if (th != null) {
                    throw th;
                }
                L.trace("projects service response time: {}millisec", (Object)(System.currentTimeMillis() - t1));
                if (consumer.getHttpCode() == 200) return ret;
                if (consumer.getHttpCode() == -401) {
                    L.debug("client is not authenticated; will not have projects in list");
                    return ret;
                }
                String msg = Messages.getString(SSOHttpReqRunnable.class, "mainfProjects.service.exception.message");
                MfProjectsException except = handler != null && handler.ex != null ? new MfProjectsException(msg, handler.ex) : new MfProjectsException(consumer.getHttpCode(), null, null, msg);
                handler.ex = null;
                throw except;
            }
            catch (Exception ex) {
                L.debug("error getting results from Mainframe Projects service; endpoint: {}", (Object)endpoint, (Object)ex);
                throw ex;
            }
        } else {
            L.error("cannot find SSOService!");
        }
        return ret;
    }

    private static MfProjectsException printErrorDetails(String endpoint, int responseCode, InputStream content) {
        return SSOHttpReqRunnable.printErrorDetails(endpoint, responseCode, content, null);
    }

    private static MfProjectsException printErrorDetails(String endpoint, int responseCode, InputStream content, String cont) {
        MfProjectsException ex = null;
        JsonObject root = null;
        BufferedReader in = null;
        byte[] bb = null;
        if (content != null) {
            bb = SSOHttpReqRunnable.readStream(content);
            in = new BufferedReader(new InputStreamReader(content));
        } else if (cont != null) {
            in = new BufferedReader(new StringReader(cont));
        }
        if (in != null) {
            try {
                JsonReader reader = Json.createReader(in);
                root = reader.readObject();
                Object err = root.get((Object)"error");
                Object code = root.get((Object)"code");
                Object msg = root.get((Object)"msg");
                L.error("request ({}) error;  code={}, msg={}, error={}", new Object[]{endpoint, msg, code, err});
                ex = new MfProjectsException(responseCode, err.toString(), code.toString(), msg.toString());
            }
            catch (Throwable th) {
                L.info("error printing details", th);
                String s = bb != null ? new String(bb) : cont;
                L.error("{} is the error content of request: {}", (Object)s, (Object)endpoint);
                String msg = Messages.getString(SSOHttpReqRunnable.class, "mainfProjects.service.request.exception", new String[]{endpoint});
                ex = new MfProjectsException(msg, th);
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    L.info("error closing input error stream", (Throwable)e);
                }
            }
        } else {
            L.error("printing response details; error content is empty for request ({})", (Object)endpoint);
            String msg = Messages.getString(SSOHttpReqRunnable.class, "mainfProjects.service.request.exception", new String[]{endpoint});
            ex = new MfProjectsException(msg, null);
        }
        return ex;
    }

    static byte[] readStream(InputStream input) {
        byte[] bucket = new byte[32768];
        ByteArrayOutputStream result = new ByteArrayOutputStream(bucket.length);
        try {
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = input.read(bucket);
                if (bytesRead <= 0) continue;
                result.write(bucket, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            L.warn("error reading stream", (Throwable)ex);
        }
        return result.toByteArray();
    }

    static class MFProjectsErrorHandler
    implements HTTPErrorHandler {
        String endpoint;
        MfProjectsException ex;

        public MFProjectsErrorHandler(String endpoint) {
            this.endpoint = endpoint;
        }

        public void execute(int responseCode, InputStream responseError) {
            L.debug("request error; response={}", (Object)responseCode);
            this.ex = SSOHttpReqRunnable.printErrorDetails(this.endpoint, responseCode, responseError);
        }

        public void treatException(Exception e) {
            if (!(e instanceof MfProjectsException)) {
                L.trace("exception running {}", (Object)this.endpoint, (Object)e);
                String msg = Messages.getString(SSOHttpReqRunnable.class, "mainfProjects.service.request.exception", new String[]{this.endpoint});
                throw new MfProjectsException(msg, e);
            }
        }
    }

    static class MPrjsContentConsumer
    extends HttpResponseConsumer {
        Exception ex = null;

        MPrjsContentConsumer() {
        }

        public void accept(String content) {
            L.trace("got a text in MPrjsContentConsumer: {}", (Object)content.length());
            if (content != null && !content.isEmpty()) {
                if (this.httpCode == 200) {
                    this.ret = content;
                } else {
                    try (JsonReader reader = null;){
                        try {
                            reader = Json.createReader((Reader)new StringReader(content));
                            JsonObject root = reader.readObject();
                            Object err = root.get((Object)"error");
                            Object code = root.get((Object)"code");
                            Object msg = root.get((Object)"msg");
                            L.error("request error;  code={}, msg={}, error={}", new Object[]{code, msg, err});
                            this.ex = new MfProjectsException(this.httpCode, err.toString(), code.toString(), msg.toString());
                        }
                        catch (Exception e) {
                            L.info("while parsing request reply", (Throwable)e);
                            this.ex = new MfProjectsException(this.httpCode, null, null, content);
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                }
            }
        }

        public Exception getException() {
            return this.ex;
        }

        public String getContent() {
            return this.ret;
        }
    }

    static class MfProjectsException
    extends RuntimeException {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        public String error;
        public String code;
        public int httpResponseCode;

        public MfProjectsException(int responseCode, String error, String code, String message) {
            super(message);
            this.error = error;
            this.code = code;
            this.httpResponseCode = responseCode;
        }

        public MfProjectsException(String msg, Throwable th) {
            super(msg, th);
        }
    }
}

