/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.utils;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.zkbridge.project.ProjectState;
import com.ez.ezsource.connection.zkbridge.project.Versions;
import com.ez.ezsource.connection.zkbridge.project.sso.IMFProjectsService;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.VersioningUtils;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.ProjectType;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.projects.internal.Messages;
import com.ibm.ad.oauth2.service.SSOService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.json.JsonObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectUtils.class);

    public static boolean checkProject(String project, ApplicationType appType) {
        boolean ok = true;
        if (project == null || project.isEmpty()) {
            L.error("cannot check a project without name!");
            ok = false;
        } else if (ApplicationType.EZViewer.equals((Object)appType)) {
            boolean enabled;
            SSOService serv = (SSOService)ServiceUtils.getService(SSOService.class);
            if (serv != null && (enabled = serv.isAuthEnabled()) && !serv.isAuthenticated()) {
                L.warn("user is not authenticated!");
                LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.mainframe.projects", Messages.getString(ProjectUtils.class, "notAuthenticated.error")), (boolean)true);
                ok = false;
            }
            if (ok) {
                IMFProjectsService prjServ = (IMFProjectsService)ServiceUtils.getService(IMFProjectsService.class);
                if (prjServ != null) {
                    String[] vers = VersioningUtils.instance(null).getVersions(appType);
                    ProjectState state = prjServ.checkProject(project, new Versions(vers[0], vers[1], vers[2]));
                    if (!ProjectState.OK.equals((Object)state)) {
                        L.warn("project {} is not accesible; state: {}!", (Object)project, (Object)state);
                        if (ApplicationType.EZViewer.equals((Object)appType)) {
                            String msg = null;
                            switch (state) {
                                case NOT_AUTHORIZED: {
                                    msg = Messages.getString(ProjectUtils.class, "notAuthorized.error", new String[]{project});
                                    break;
                                }
                                case LOCKED: {
                                    msg = Messages.getString(ProjectUtils.class, "projectLocked.error", new String[]{project});
                                    break;
                                }
                                case OBSOLETE_SCHEMA: {
                                    msg = Messages.getString(ProjectUtils.class, "obsoleteSchema.error", new String[]{project});
                                    break;
                                }
                                case OBSOLETE_APP: {
                                    msg = Messages.getString(ProjectUtils.class, "applicationObsolete.error");
                                    break;
                                }
                                case UNKNOWN: {
                                    msg = Messages.getString(ProjectUtils.class, "unknownState.error", new String[]{project});
                                    break;
                                }
                            }
                            LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.mainframe.projects", msg), (boolean)true);
                        }
                        ok = false;
                    }
                } else {
                    L.warn("Service communicating with Mainframe Projects service cannot be found; authority cannot be checked!");
                    LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.mainframe.projects", Messages.getString(ProjectUtils.class, "configuration.error")), (boolean)true);
                    ok = false;
                }
            }
        }
        L.info("check={} for project={} from application={}", new Object[]{ok, project, appType.toString()});
        return ok;
    }

    public static List<ProjectInfo> filterMainframeProjectsOnly(List<ProjectInfo> allProjects) {
        ArrayList<ProjectInfo> filteredProjects = new ArrayList<ProjectInfo>();
        if (allProjects != null) {
            for (ProjectInfo pi : allProjects) {
                if (pi == null || pi.isEclipse()) continue;
                filteredProjects.add(pi);
            }
        }
        return filteredProjects;
    }

    public static String[][] getPrjVersion(EZSourceConnection conn, String project) {
        if (conn == null) {
            throw new RuntimeException("null connection!");
        }
        String[][] rez = conn.executeSQL("SELECT version, avatar from VC_Version");
        if (rez != null && rez.length > 0) {
            L.trace("extra info: {} - version={}, uid={}", new Object[]{project, rez[0][0], rez[0][1]});
        } else {
            L.warn("no extra info for project: {}", (Object)project);
        }
        return rez;
    }

    public static String[] getPrjVersion(String projectName) {
        String[] ret = null;
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(projectName, null);
        if (ph != null) {
            try {
                EzIMFRunnable runn = new EzIMFRunnable(projectName);
                ph.executeWithLock(ph, runn, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                ret = runn.getResult();
            }
            catch (InterruptedException e) {
                L.error("", (Throwable)e);
            }
            catch (ExecutionException e) {
                L.error("", (Throwable)e);
            }
        }
        return ret;
    }

    public static ProjectType getProjectType(Map<String, Object> prjInfo) {
        ProjectType type = null;
        if (prjInfo != null) {
            String env = (String)prjInfo.get("environment");
            type = env.equals("VME") ? ProjectType.vme : (env.equals("MVS") ? ProjectType.zos : (env.equals("JVM") ? ProjectType.javaWazi : (env.equals("VSE") ? ProjectType.vse : (env.startsWith("SMART") ? ProjectType.smart : ProjectType.mainframe))));
        } else {
            L.warn("please give a not-null project info map");
        }
        return type;
    }

    private static JsonObject getProjectMetadata(Map<String, Object> prjInfo) {
        JsonObject metadataJson = null;
        if (prjInfo != null) {
            metadataJson = (JsonObject)prjInfo.get("project_metadata");
        }
        return metadataJson;
    }

    public static String getProjectMetadataKeys(Map<String, Object> prjInfo) {
        String metadataKeys = "";
        JsonObject metadataJson = ProjectUtils.getProjectMetadata(prjInfo);
        Set keys = null;
        if (metadataJson != null) {
            keys = metadataJson.keySet();
        }
        if (keys != null && !keys.isEmpty()) {
            ArrayList keysList = new ArrayList(keys);
            Collections.sort(keysList);
            metadataKeys = String.join((CharSequence)", ", keysList);
        }
        return metadataKeys;
    }

    public static Map<String, Object> getProjectMetadataTable(Map<String, Object> prjInfo) {
        HashMap<String, Object> metadataTable = new HashMap<String, Object>();
        JsonObject metadataJson = ProjectUtils.getProjectMetadata(prjInfo);
        if (metadataJson != null) {
            for (String key : metadataJson.keySet()) {
                metadataTable.put(key, metadataJson.get((Object)key));
            }
        }
        return metadataTable;
    }

    private static class EzIMFRunnable
    implements IMFRunnable {
        String projectName = null;
        String[] ret = null;

        public EzIMFRunnable(String prjName) {
            this.projectName = prjName;
        }

        @Override
        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
            String[][] rez = ProjectUtils.getPrjVersion(conn, this.projectName);
            if (rez != null && rez.length > 0) {
                this.ret = new String[]{rez[0][0], rez[0][1]};
            }
        }

        public String[] getResult() {
            return this.ret;
        }
    }
}

