/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezsource.versioning.ApplicationType;
import com.ez.mainframe.projects.info.IMFConnectionServiceEventGenerator;
import com.ez.mainframe.projects.internal.ProjectThread;
import com.ez.mainframe.projects.listener.MFEZSOurceConnectionListener;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectThreadFactory
implements ThreadFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectThreadFactory.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final String project;
    private Long projectType;
    private MFEZSOurceConnectionListener mFEZSourceConnectionListener;
    private IMFConnectionServiceEventGenerator eventGenerator;
    private ApplicationType applicationType;

    public ProjectThreadFactory(String project, Long projectType, MFEZSOurceConnectionListener mFEZSourceConnectionListener, IMFConnectionServiceEventGenerator eventGenerator, ApplicationType applicationType) {
        this.project = project;
        this.projectType = projectType;
        this.mFEZSourceConnectionListener = mFEZSourceConnectionListener;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = String.valueOf(this.project) + ":pool-" + poolNumber.getAndIncrement() + "-thread-";
        this.eventGenerator = eventGenerator;
        this.applicationType = applicationType;
    }

    @Override
    public Thread newThread(Runnable r) {
        ProjectThread t = new ProjectThread(this.project, this.projectType, this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L, this.mFEZSourceConnectionListener, this.applicationType);
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ProjectThreadFactory.this.eventGenerator.fireMFServiceErrorEvent(e);
                L.error(e.getMessage(), e);
            }
        });
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

