/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionListener;
import com.ez.ezsource.connection.EZSourceConnectionStateEvent;
import com.ez.ezsource.connection.EZSourceRemoteConnectionListener;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.ProjectUtils;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.Activator;
import com.ez.mainframe.projects.info.IMFProjectContext;
import com.ez.mainframe.projects.internal.Messages;
import com.ez.mainframe.projects.listener.MFEZSOurceConnectionListener;
import com.ez.workspace.BridgeConfigurator;
import com.ez.workspace.bridge.BridgeInitException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectThread
extends Thread
implements IMFProjectContext {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectThread.class);
    protected Runnable target;
    private String project;
    private Long projectType;
    private volatile EZSourceConnection conn = null;
    private volatile boolean init = false;
    private MFEZSOurceConnectionListener mFEZSourceConnectionListener;
    private static Map<String, Boolean> versionChecked = new HashMap<String, Boolean>();
    private static Map<String, Map<String, Object>> projectInfo = new HashMap<String, Map<String, Object>>();
    private static Object vLock = new Object();
    private static Object iLock = new Object();
    private static LockType LOCK_TYPE = LockType.Shared;
    private final ApplicationType applicationType;
    private volatile boolean expired = false;
    EZSourceConnectionListener ezSourceConnectionListener = null;
    private EZSourceRemoteConnectionListener remoteListener = new EZSourceRemoteConnectionListener(){

        public void onRemoteNetworkEvent(EZSourceConnectionStateEvent stateEvent) {
            L.info("remote network event: {}", (Object)stateEvent);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThread(String project, Long projectType, ThreadGroup group, Runnable target, String name, long stackSize, MFEZSOurceConnectionListener mFEZSourceConnectionListener, ApplicationType applicationType) {
        super(group, target, name, stackSize);
        if (applicationType == null) {
            throw new IllegalArgumentException("applicationType must not be null");
        }
        this.applicationType = applicationType;
        this.mFEZSourceConnectionListener = mFEZSourceConnectionListener;
        this.target = target;
        this.project = project;
        this.projectType = projectType;
        Object object = vLock;
        synchronized (object) {
            if (!versionChecked.containsKey(project)) {
                versionChecked.put(project, false);
            }
        }
        object = iLock;
        synchronized (object) {
            if (!projectInfo.containsKey(project)) {
                projectInfo.put(project, null);
            }
        }
    }

    public String getProject() {
        return this.project;
    }

    public Long getProjectType() {
        return this.projectType;
    }

    @Override
    public boolean isActive() {
        return this.isAlive();
    }

    public static Map<String, Object> getProjectInfo(EZSourceConnection conn, String mp) {
        HashMap<String, Object> info = null;
        try {
            ProjectInfo pInfo = conn.getProjectInfo();
            info = new HashMap<String, Object>();
            info.put("drive", pInfo.getDrive());
            info.put("projectName", pInfo.getProjectName());
            info.put("projectLocation", pInfo.getProjectLocation());
            info.put("environment", pInfo.getEnvironment());
            info.put("languages", pInfo.getLanguages());
            info.put("dbTypes", pInfo.getDbTypes());
            info.put("mapTypes", pInfo.getMapTypes());
            info.put("isUCMDB", pInfo.isUMCDB());
            info.put("dbEngine", pInfo.getDbEngine() == null ? null : Integer.valueOf(pInfo.getDbEngine().getValue()));
            info.put("onMainframe", pInfo.isOnMainframe());
            info.put("schemaName", pInfo.getDatabaseInfo() == null ? null : pInfo.getDatabaseInfo().getSchema());
            info.put("ccs_uuid", pInfo.getProjectUUID());
            info.put("project_metadata", pInfo.getMetadataJson());
            info.put("useCross", pInfo.useCross());
            if ("JVM".equals(pInfo.getEnvironment()) || "MVS".equals(pInfo.getEnvironment()) && (pInfo.getLanguages() == null || "".equals(pInfo.getLanguages())) || pInfo.getLanguages().isEmpty()) {
                L.debug("project {} has no definition", (Object)mp);
                info.put("noDefinition", true);
            }
        }
        catch (Throwable t) {
            ProjectThread.logError(t, Messages.getString(ProjectThread.class, "connectionError.errorLog.message", new String[]{mp}), Messages.getString(ProjectThread.class, "connectionError.errorLog.title"));
        }
        return info;
    }

    @Override
    public void run() {
        try {
            this.target.run();
        }
        finally {
            L.debug("project thread is closing {}", (Object)this.project);
            this.ensureClosed();
        }
        L.debug("{} project thread finishing", (Object)this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProjectInfo() {
        Map<String, Object> info = null;
        Object object = iLock;
        synchronized (object) {
            info = projectInfo.get(this.project);
        }
        return info == null ? null : new HashMap<String, Object>(info);
    }

    @Override
    public EZSourceConnection getConnection() {
        return this.conn;
    }

    private void releaseLock(EZSourceConnection conn, LockType expectedLock) {
        try {
            LockType lock = conn.getProjectLockType();
            if (lock != null) {
                if (lock != expectedLock) {
                    L.error(String.format("Unexpected lock: %s, but %s expected.", lock, expectedLock));
                } else if (!conn.releaseProjectLock()) {
                    L.error(String.format("Can't release lock: %s.", lock));
                }
            } else {
                L.debug("No lock held, nothing to do.");
            }
        }
        catch (Exception e) {
            L.error("Could not release project lock ", (Throwable)e);
        }
    }

    @Override
    public Pair<String, String> getBridge() {
        L.error("getBridge(); not implemented");
        return null;
    }

    private static void logError(Throwable t, String msg, String title) {
        if (ServiceUtils.isOsgi()) {
            LogUtil.displayErrorMessage((Throwable)t, (String)msg, (String)title, (Plugin)Activator.getDefault(), (boolean)false);
        } else {
            L.error(msg, t);
        }
    }

    void ensureConnected() {
        if (this.expired || this.conn == null || !this.conn.isConnectionValid()) {
            if (this.conn != null) {
                this.ensureClosed();
                L.debug("ec: making conn = null");
                this.conn = null;
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        boolean ok = false;
        if (!this.init) {
            L.debug("initializing bridge on thread {}", (Object)this);
            int k = 0;
            while (k < 5 && !this.init) {
                try {
                    BridgeConfigurator.init();
                    this.init = true;
                }
                catch (BridgeInitException ex) {
                    long t = 5000L;
                    L.debug("{}; will wait {}sec and try again", (Object)ex.getMessage(), (Object)(t / 1000L));
                    ProjectThread projectThread = this;
                    synchronized (projectThread) {
                        try {
                            this.wait(t);
                        }
                        catch (InterruptedException e) {
                            L.error("Error:", (Throwable)e);
                        }
                    }
                    ++k;
                }
                catch (Exception e) {
                    L.error("Can't initialize the connection to bridge server", (Throwable)e);
                    k = 5;
                }
            }
        }
        if (this.init) {
            HashMap<String, String> opMap = new HashMap<String, String>();
            opMap.put("Project Name", this.project);
            try {
                try {
                    this.conn = EZSourceConnectionManager.getCurrent();
                    if (this.conn != null) {
                        L.debug("opening project {}", (Object)this.project);
                        this.conn.setCurrentOperation(ProjectUtils.OPEN_PROJECT_OP, opMap);
                        this.conn.openProject(this.project);
                        this.conn.openConnection();
                        ProjectUtils.VersioningCodes code = ProjectUtils.VersioningCodes.NO_ERROR;
                        Object t = vLock;
                        synchronized (t) {
                            if (!versionChecked.get(this.project).booleanValue()) {
                                L.debug("force version check for project: {}", (Object)this.project);
                                code = ProjectUtils.updateProject(null, (EZSourceConnection)this.conn, (String)this.project, (ApplicationType)this.applicationType);
                                if (!(code.equals((Object)ProjectUtils.VersioningCodes.NO_ERROR) || code.equals((Object)ProjectUtils.VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE) || code.equals((Object)ProjectUtils.VersioningCodes.PROJECT_WITHOUT_TYPE_DEFINITION_ERROR))) {
                                    L.error("opening project {} code: {}", (Object)this.project, (Object)code);
                                }
                                if (code.equals((Object)ProjectUtils.VersioningCodes.NO_ERROR) || code.equals((Object)ProjectUtils.VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE)) {
                                    versionChecked.put(this.project, true);
                                }
                            }
                        }
                        if (code.equals((Object)ProjectUtils.VersioningCodes.NO_ERROR) || code.equals((Object)ProjectUtils.VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE)) {
                            if (code.equals((Object)ProjectUtils.VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE)) {
                                ProjectThread.logError(null, Messages.getString(ProjectThread.class, "app.obsolete.but.compatible.error.message", new String[]{this.project, code.getErrorMessage()}), Messages.getString(ProjectThread.class, "app.obsolete.but.compatible.error.title", new String[]{this.project}));
                            }
                            t = iLock;
                            synchronized (t) {
                                Map<String, Object> info = projectInfo.get(this.project);
                                if (info == null) {
                                    L.debug("retrieving project info for {}", (Object)this.project);
                                    this.conn.acquireProjectLock(LOCK_TYPE);
                                    try {
                                        info = ProjectThread.getProjectInfo(this.conn, this.project);
                                        projectInfo.put(this.project, info);
                                    }
                                    finally {
                                        this.releaseLock(this.conn, LOCK_TYPE);
                                    }
                                }
                            }
                            try {
                                if (this.mFEZSourceConnectionListener != null) {
                                    this.ezSourceConnectionListener = new EZSourceConnectionListener(){

                                        public void notify(EZSourceConnection message, String projectThread) {
                                            ProjectThread.this.mFEZSourceConnectionListener.notify(message, projectThread, ProjectThread.this);
                                        }
                                    };
                                    this.conn.addListener(this.ezSourceConnectionListener);
                                }
                                L.debug("initialize done for {} lock status: {}", (Object)this.target, (Object)this.conn.getProjectLockType());
                                ok = true;
                                return;
                            }
                            catch (Throwable t2) {
                                ProjectThread.logError(t2, Messages.getString(ProjectThread.class, "errorWhileExecuting.errorLog.message", new String[]{this.project}), Messages.getString(ProjectThread.class, "errorWhileExecuting.errorLog.title"));
                            }
                            return;
                        }
                        if (code.equals((Object)ProjectUtils.VersioningCodes.APPLICATION_OBSOLETE_ERROR)) {
                            ProjectThread.logError(null, Messages.getString(ProjectThread.class, "projectUpgradeFailed.obsolete.error.message", new String[]{this.project}), Messages.getString(ProjectThread.class, "projectUpgradeFailed.obsolete.error.title"));
                            return;
                        }
                        ProjectThread.logError(null, Messages.getString(ProjectThread.class, "projectUpgradeFailed.error.message", new String[]{this.project, code.getErrorMessage()}), Messages.getString(ProjectThread.class, "projectUpgradeFailed.error.title", new String[]{this.project}));
                        return;
                    }
                    L.error("No connection available for project {}", (Object)this.project);
                    return;
                }
                catch (Throwable e) {
                    L.error("Error while working with project {}", (Object)this.project, (Object)e);
                    ProjectThread.logError(e, Messages.getString(ProjectThread.class, "exceptionOnProject.errorLog.title", new String[]{this.project}), e.getMessage());
                    if (ok || this.conn == null) return;
                    this.ensureClosed();
                }
                return;
            }
            finally {
                if (!ok && this.conn != null) {
                    this.ensureClosed();
                }
            }
        }
        L.warn("cannot initialize project thread!");
    }

    void ensureClosed() {
        block18: {
            L.debug("ensure closed called: {}", (Object)this.conn);
            if (this.conn != null) {
                try {
                    if (this.ezSourceConnectionListener != null) {
                        this.conn.removeListener(this.ezSourceConnectionListener);
                    }
                }
                catch (Exception e) {
                    L.error("could not remove ezsource connection listener", (Throwable)e);
                }
                try {
                    try {
                        this.conn.closeConnection();
                    }
                    catch (Exception e) {
                        L.debug("closing db connection failed for project {}", (Object)this.project, (Object)e);
                        try {
                            L.debug("releasing connection for project {}", (Object)this.project);
                            EZSourceConnectionManager.release((EZSourceConnection)this.conn);
                        }
                        catch (Exception e2) {
                            L.error("could not release connection on thread {}", (Object)this, (Object)e2);
                        }
                        this.conn = null;
                        L.debug("end: making conn = null");
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        L.debug("releasing connection for project {}", (Object)this.project);
                        EZSourceConnectionManager.release((EZSourceConnection)this.conn);
                    }
                    catch (Exception e) {
                        L.error("could not release connection on thread {}", (Object)this, (Object)e);
                    }
                    this.conn = null;
                    L.debug("end: making conn = null");
                    throw throwable;
                }
                try {
                    L.debug("releasing connection for project {}", (Object)this.project);
                    EZSourceConnectionManager.release((EZSourceConnection)this.conn);
                }
                catch (Exception e) {
                    L.error("could not release connection on thread {}", (Object)this, (Object)e);
                }
                this.conn = null;
                L.debug("end: making conn = null");
            }
        }
        if (this.init && this.init) {
            try {
                this.init = false;
                L.debug("releasing bridge on thread {}", (Object)this);
                BridgeConfigurator.release();
            }
            catch (Exception e) {
                L.error("could not release bridge on thread {}", (Object)this, (Object)e);
            }
        }
    }
}

