/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceLockException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.internal.utils.ErrorUtils;
import com.ez.mainframe.projects.info.IMFConnectionServiceEventGenerator;
import com.ez.mainframe.projects.info.IMFProjectContext;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.projects.internal.ProjectThread;
import com.ez.mainframe.projects.internal.ProjectThreadFactory;
import com.ez.mainframe.projects.listener.MFEZSOurceConnectionListener;
import com.ez.mainframe.projects.listener.MFProjectAdapter;
import com.ez.mainframe.projects.listener.MFProjectEvent;
import com.ez.mainframe.projects.listener.MFProjectListener;
import com.ez.mainframe.projects.utils.ProjectUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectHandler
extends ThreadPoolExecutor
implements IMFProjectHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectHandler.class);
    private String project;
    private Long projectType;
    private ApplicationType applicationType;
    private final Set<MFProjectListener> mFProjectListeners = new HashSet<MFProjectListener>();
    private final IMFConnectionServiceEventGenerator eventGenerator;

    public ProjectHandler(String project, Long projectType, int coreSize, int maxPoolSize, long timeout, boolean prestart, IMFConnectionServiceEventGenerator eventGenerator, ApplicationType applicationType) {
        super(coreSize, maxPoolSize, timeout, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        MFEZSOurceConnectionListener mFEZSourceConnectionListener = new MFEZSOurceConnectionListener(){
            private ProjectThread selectedToListen;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notify(EZSourceConnection conn, String message, ProjectThread projectThread) {
                boolean execute = false;
                1 var5_5 = this;
                synchronized (var5_5) {
                    if (this.selectedToListen == null || this.selectedToListen.isActive() || this.selectedToListen == projectThread) {
                        L.trace("connection event on {} with message: {}\n", (Object)projectThread, (Object)message);
                        execute = true;
                        this.selectedToListen = projectThread;
                    } else {
                        L.trace("event ignored on {}", (Object)projectThread);
                    }
                }
                if (execute) {
                    ProjectHandler.this.fireEvent(message);
                }
            }
        };
        this.setThreadFactory(ProjectHandler.getThreadFactory(project, projectType, mFEZSourceConnectionListener, eventGenerator, applicationType));
        prestart = true;
        if (prestart) {
            this.prestartAllCoreThreads();
        }
        this.project = project;
        this.projectType = projectType;
        this.applicationType = applicationType;
        this.eventGenerator = eventGenerator;
    }

    @Override
    public Long getProjectType() {
        return this.projectType;
    }

    private static ThreadFactory getThreadFactory(String project, Long projectType, MFEZSOurceConnectionListener mFEZSourceConnectionListener, IMFConnectionServiceEventGenerator eventGenerator, ApplicationType applicationType) {
        return new ProjectThreadFactory(project, projectType, mFEZSourceConnectionListener, eventGenerator, applicationType);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        L.trace("before execute: {}:{}", (Object)t, (Object)r);
        if (this.projectType == null || this.projectType != null && !this.projectType.equals(Long.valueOf("16384"))) {
            ((ProjectThread)t).ensureConnected();
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        block14: {
            if (r instanceof FutureTask) {
                FutureTask ft = (FutureTask)r;
                try {
                    if (ft.isDone()) {
                        ft.get();
                    }
                }
                catch (CancellationException ex) {
                    L.info("action canceled", (Throwable)ex);
                }
                catch (InterruptedException e) {
                    L.error("Unexpected interrupt", (Throwable)e);
                }
                catch (ExecutionException ex) {
                    try {
                        ErrorUtils.handleExecutionException((ExecutionException)ex);
                    }
                    catch (RuntimeException e) {
                        this.eventGenerator.fireMFServiceErrorEvent(e);
                        ((ProjectThread)Thread.currentThread()).ensureClosed();
                        break block14;
                    }
                    catch (Error e) {
                        try {
                            this.eventGenerator.fireMFServiceErrorEvent(e);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((ProjectThread)Thread.currentThread()).ensureClosed();
                        }
                    }
                    ((ProjectThread)Thread.currentThread()).ensureClosed();
                }
            }
        }
        if (t != null) {
            ((ProjectThread)Thread.currentThread()).ensureClosed();
        }
        super.afterExecute(r, t);
    }

    @Override
    public String toString() {
        return String.valueOf(this.project) + ":" + super.toString();
    }

    @Override
    public void executeWithLock(IMFProjectHandler ph, IMFRunnable what, LockType lockType, IProgressMonitor pmonitor) throws InterruptedException, ExecutionException {
        this.executeWithLock(ph, what, lockType, -1L, pmonitor);
    }

    @Override
    public void executeWithLock(IMFProjectHandler ph, final IMFRunnable what, LockType lockType, long timeout, final IProgressMonitor pmonitor) throws InterruptedException, ExecutionException {
        Future<?> future = null;
        boolean ok = ProjectUtils.checkProject(this.project, this.applicationType);
        if (ok) {
            future = this.submitWithLock(ph, new IMFRunnable(){

                @Override
                public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                    try {
                        what.run(conn, pmonitor);
                    }
                    catch (RuntimeException e) {
                        ProjectHandler.this.eventGenerator.fireMFServiceErrorEvent(e);
                        throw e;
                    }
                    catch (Error e) {
                        ProjectHandler.this.eventGenerator.fireMFServiceErrorEvent(e);
                        throw e;
                    }
                }
            }, lockType, timeout, pmonitor);
        }
        if (future != null) {
            future.get();
        }
    }

    @Override
    public Future<?> submitWithLock(IMFProjectHandler ph, IMFRunnable what, LockType lockType, IProgressMonitor pmonitor) throws InterruptedException, ExecutionException {
        return this.submitWithLock(ph, what, lockType, -1L, pmonitor);
    }

    @Override
    public Future<?> submitWithLock(IMFProjectHandler ph, final IMFRunnable what, final LockType lockType, final long timeout, final IProgressMonitor pmonitor) throws InterruptedException, ExecutionException {
        Future<?> f = null;
        if (!pmonitor.isCanceled()) {
            f = ph.submit(new Runnable(){

                @Override
                public void run() {
                    block28: {
                        try {
                            EZSourceConnection conn = ((IMFProjectContext)((Object)Thread.currentThread())).getConnection();
                            boolean lockAcquired = false;
                            if (conn != null) {
                                block27: {
                                    EZSourceConnectionException e = null;
                                    try {
                                        try {
                                            if (timeout == -1L) {
                                                L.debug("acquiring lock: {}", (Object)lockType);
                                                lockAcquired = conn.acquireProjectLock(lockType);
                                            } else {
                                                L.debug("acquiring lock: {} for timeout: {}", (Object)lockType, (Object)timeout);
                                                lockAcquired = conn.acquireProjectLock(lockType, timeout);
                                            }
                                        }
                                        catch (EZSourceConnectionException ex) {
                                            try {
                                                L.debug("releasing lock: {}", (Object)lockType);
                                                conn.releaseProjectLock();
                                            }
                                            catch (EZSourceConnectionException ezsce) {
                                                L.error("while trying to cleanup possible acquired lock ", (Throwable)ezsce);
                                            }
                                            e = ex;
                                            if (!lockAcquired) {
                                                e = new EZSourceLockException("could not acquire lock type " + lockType, (Throwable)e);
                                                pmonitor.setCanceled(true);
                                            }
                                            if (e != null) {
                                                throw e;
                                            }
                                            break block27;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (!lockAcquired) {
                                            e = new EZSourceLockException("could not acquire lock type " + lockType, (Throwable)e);
                                            pmonitor.setCanceled(true);
                                        }
                                        if (e != null) {
                                            throw e;
                                        }
                                        throw throwable;
                                    }
                                    if (!lockAcquired) {
                                        e = new EZSourceLockException("could not acquire lock type " + lockType, (Throwable)e);
                                        pmonitor.setCanceled(true);
                                    }
                                    if (e != null) {
                                        throw e;
                                    }
                                }
                                try {
                                    what.run(conn, pmonitor);
                                    break block28;
                                }
                                finally {
                                    try {
                                        L.debug("releasing lock: {}", (Object)lockType);
                                        conn.releaseProjectLock();
                                    }
                                    catch (EZSourceConnectionException ezsce) {
                                        L.error("could not close previously acquired lock ", (Throwable)ezsce);
                                    }
                                }
                            }
                            if (ProjectHandler.this.projectType == null || ProjectHandler.this.projectType != null && !ProjectHandler.this.projectType.equals(Long.valueOf("16384"))) {
                                pmonitor.setCanceled(true);
                                throw new EZSourceConnectionException("connection not available for thread " + Thread.currentThread());
                            }
                        }
                        catch (RuntimeException e) {
                            ProjectHandler.this.eventGenerator.fireMFServiceErrorEvent(e);
                            throw e;
                        }
                        catch (Error e) {
                            ProjectHandler.this.eventGenerator.fireMFServiceErrorEvent(e);
                            throw e;
                        }
                    }
                }
            });
        }
        return f;
    }

    @Override
    public void addMFProjectListener(MFProjectListener listener) {
        this.mFProjectListeners.add(listener);
    }

    @Override
    public void removeMFProjectListener(MFProjectListener listener) {
        this.mFProjectListeners.remove(listener);
    }

    private void fireEvent(String message) {
        String deletePrjMessagePart = "initiated a deletion process on the project.";
        String endBuildProcessMessagePart = "The build process is completed.";
        String endRecreateProcessWithFaild = "The project's repository recreation process failed";
        String endRecreateProcess = "The project's repository recreation process is completed !";
        String startBuildProcessMessagePart = "initiated a build process on the project";
        String startRecreateProcessMessagePart = "initiated a repository recreation process on the project";
        String adminNotificationMessage = "IBM Application Discovery Administrator notification:";
        String userNotificationMessage = "event";
        String mvsMessage = "The Mainframe related process is completed.";
        MFProjectEventImpl event = new MFProjectEventImpl(this.project);
        for (MFProjectListener listener : this.mFProjectListeners) {
            if (message.indexOf(mvsMessage) != -1) {
                listener.mainframeRelatedProcessCompleted(event);
            }
            if (message.indexOf(deletePrjMessagePart) != -1) {
                listener.projectDeleted(event);
            }
            if (message.indexOf(startBuildProcessMessagePart) != -1) {
                listener.buildStarted(event);
            }
            if (message.indexOf(endBuildProcessMessagePart) != -1) {
                listener.buildEnded(event);
            }
            if (message.indexOf(startRecreateProcessMessagePart) != -1) {
                listener.projectRecreateStarted(event);
            }
            if (message.indexOf(endRecreateProcess) != -1) {
                listener.projectRecreateEnded(event);
            }
            if (message.indexOf(endRecreateProcessWithFaild) != -1) {
                listener.projectRecreateEndedWithFail(event);
            }
            if (message.indexOf(adminNotificationMessage) != -1) {
                listener.adminNotificationMessage(event);
            }
            if (message.indexOf(userNotificationMessage) == -1) continue;
            listener.userNotificationMessage(event);
        }
    }

    private void test() {
        this.addMFProjectListener(new MFProjectAdapter(){

            @Override
            public void buildStarted(MFProjectEventImpl event) {
                L.trace("***********buildStarted***********");
            }

            @Override
            public void buildEnded(MFProjectEventImpl event) {
                L.trace("***********buildEnded***********");
            }

            @Override
            public void projectDeleted(MFProjectEventImpl event) {
                L.trace("***********projectDeleted***********");
            }

            @Override
            public void projectRecreateStarted(MFProjectEventImpl event) {
                L.trace("***********projectRecreateStarted***********");
            }

            @Override
            public void projectRecreateEnded(MFProjectEventImpl event) {
                L.trace("***********projectRecreateEnded***********");
            }

            @Override
            public void projectRecreateEndedWithFail(MFProjectEventImpl event) {
                L.trace("***********projectRecreateEndedWithFail***********");
            }

            @Override
            public void mainframeRelatedProcessCompleted(MFProjectEventImpl event) {
                L.trace("***********projectRecreateEndedWithFail***********");
            }

            @Override
            public void adminNotificationMessage(MFProjectEventImpl event) {
                L.trace("***********adminNotificationMessage***********");
            }

            @Override
            public void userNotificationMessage(MFProjectEventImpl event) {
                L.trace("***********userNotificationMessage***********");
            }
        });
    }

    public class MFProjectEventImpl
    implements MFProjectEvent {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private String projectName;

        public MFProjectEventImpl(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        public String toString() {
            return "MFProjectEventImpl [projectName=" + this.projectName + "]";
        }
    }
}

