/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.eclient.service.Pair;
import com.ez.eclient.service.rsrv.mfprojects.IMainframeProjectsService;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.ezsource.connection.zkbridge.project.ProjectState;
import com.ez.ezsource.connection.zkbridge.project.Versions;
import com.ez.ezsource.connection.zkbridge.project.ZkProjectInfo;
import com.ez.ezsource.connection.zkbridge.project.sso.ChangeEvent;
import com.ez.ezsource.connection.zkbridge.project.sso.ErrorEvent;
import com.ez.ezsource.connection.zkbridge.project.sso.ErrorListener;
import com.ez.ezsource.connection.zkbridge.project.sso.IMFProjectsService;
import com.ez.ezsource.connection.zkbridge.project.sso.ListChangedListener;
import com.ez.ezsource.connection.zkbridge.project.sso.impl.MFProjectsServiceImpl;
import com.ez.internal.model.IMFProjectsServiceFacade;
import com.ez.internal.model.MFProjListChangedListener;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.PathUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.Activator;
import com.ez.mainframe.projects.internal.Messages;
import com.ez.mainframe.projects.internal.ProjectThread;
import com.ez.mainframe.projects.zk.impl.SSOHttpReqRunnable;
import com.ez.workspace.BridgeConfigurator;
import com.ez.workspace.bridge.BridgeInitException;
import com.ibm.ad.oauth2.service.SSOService;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFProjectsServiceFacadeImpl
implements IMFProjectsServiceFacade,
IMFProjectsService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(MFProjectsServiceFacadeImpl.class);
    private volatile boolean bridgeInit = false;
    MFProjectsServiceImpl mfProjService = null;
    private volatile Supplier<Pair<String, Boolean>> identity = null;
    Set<MFProjListChangedListener> guiListeners = new HashSet<MFProjListChangedListener>();

    public Map<String, Object> getProjectInfo(String projectName, IProgressMonitor pmonitor) {
        Map<String, Object> info;
        block16: {
            info = null;
            if (!this.bridgeInit) {
                this.initBridge();
            }
            EZSourceConnection conn = null;
            try {
                try {
                    conn = EZSourceConnectionManager.getCurrent();
                    if (conn != null) {
                        L.debug("opening project {}", (Object)projectName);
                        conn.openProject(projectName);
                        info = ProjectThread.getProjectInfo(conn, projectName);
                    }
                }
                catch (Throwable th) {
                    L.error("error getting information for project: {}", (Object)projectName, (Object)th);
                    if (conn == null) break block16;
                    conn.closeProject();
                    try {
                        L.debug("releasing connection for project {}", (Object)projectName);
                        EZSourceConnectionManager.release((EZSourceConnection)conn);
                    }
                    catch (Exception e) {
                        L.error("could not release connection on thread {}", (Object)this, (Object)e);
                    }
                    conn = null;
                    L.trace("end releasing connection");
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    conn.closeProject();
                    try {
                        L.debug("releasing connection for project {}", (Object)projectName);
                        EZSourceConnectionManager.release((EZSourceConnection)conn);
                    }
                    catch (Exception e) {
                        L.error("could not release connection on thread {}", (Object)this, (Object)e);
                    }
                    conn = null;
                    L.trace("end releasing connection");
                }
                throw throwable;
            }
            if (conn != null) {
                conn.closeProject();
                try {
                    L.debug("releasing connection for project {}", (Object)projectName);
                    EZSourceConnectionManager.release((EZSourceConnection)conn);
                }
                catch (Exception e) {
                    L.error("could not release connection on thread {}", (Object)this, (Object)e);
                }
                conn = null;
                L.trace("end releasing connection");
            }
        }
        if (pmonitor != null) {
            pmonitor.done();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBridge() {
        int k = 0;
        while (k < 5 && !this.bridgeInit) {
            L.debug("initializing bridge in mf proj facade; try {}", (Object)k);
            try {
                BridgeConfigurator.init();
                this.bridgeInit = true;
            }
            catch (BridgeInitException ex) {
                long t = 5000L;
                L.debug("{}; will wait {}sec and try again", (Object)ex.getMessage(), (Object)(t / 1000L));
                MFProjectsServiceFacadeImpl mFProjectsServiceFacadeImpl = this;
                synchronized (mFProjectsServiceFacadeImpl) {
                    try {
                        this.wait(t);
                    }
                    catch (InterruptedException e) {
                        L.error("Error:", (Throwable)e);
                    }
                }
                ++k;
            }
            catch (Exception e) {
                L.error("Can't initialize the connection to bridge server", (Throwable)e);
                k = 5;
            }
        }
    }

    public List<String> availableMainframeProjects(IProgressMonitor monitor) {
        if (this.mfProjService != null && this.mfProjService.isStarted()) {
            return this.mfProjService.getAllMainframeProjects();
        }
        L.warn("service accessing Mainframe Projects service is not started! Check the log");
        SSOService serv = (SSOService)ServiceUtils.getService(SSOService.class);
        if (serv != null && serv.isAuthEnabled() && !serv.isAuthenticated()) {
            L.warn("user is not authenticated!");
            LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.mainframe.projects", Messages.getString(MFProjectsServiceFacadeImpl.class, "notAuthenticated.error")), (boolean)false);
        }
        return new ArrayList<String>();
    }

    public List<String[]> allAvailableProjects(IProgressMonitor monitor) {
        if (this.mfProjService != null && this.mfProjService.isStarted()) {
            return this.mfProjService.getAllProjects();
        }
        L.warn("service accessing Mainframe Projects service is not started! Check the log");
        SSOService serv = (SSOService)ServiceUtils.getService(SSOService.class);
        if (serv != null && serv.isAuthEnabled() && !serv.isAuthenticated()) {
            L.warn("user is not authenticated!");
            LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.mainframe.projects", Messages.getString(MFProjectsServiceFacadeImpl.class, "notAuthenticated.error")), (boolean)false);
        }
        return new ArrayList<String[]>();
    }

    public List<String[]> getAllProjects() {
        L.warn("not implemented method: getAllProjects()");
        return null;
    }

    public List<String> getAllMainframeProjects() {
        L.warn("not implemented method: getAllMainframeProjects()");
        return null;
    }

    public List<ZkProjectInfo> getAllProjectsInfo() {
        if (this.mfProjService != null && this.mfProjService.isStarted()) {
            return this.mfProjService.getAllProjectsInfo();
        }
        L.info("service accessing Mainframe Projects service is not started! Check the log files!");
        return new ArrayList<ZkProjectInfo>();
    }

    public synchronized void start() {
        if (this.mfProjService != null && this.mfProjService.isStarted()) {
            L.info("Service accessing mf projects service is already started!");
        } else {
            this.mfProjService = new MFProjectsServiceImpl();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.putAll(this.getProjectSettings());
            properties.put("use.access.control", true);
            properties.put("request.runnable", new SSOHttpReqRunnable());
            this.identity = this.buildIdentitySupplier();
            properties.put("whoami.supplier", this.identity);
            properties.put("ccsreader", this.getCCSReader());
            this.mfProjService.setProperties(properties);
            ErrorListener errorListener = new ErrorListener(){

                public void errorOccured(ErrorEvent ev) {
                    L.debug("error in project service", ev.getError());
                    LogUtil.displayErrorMessage((Throwable)ev.getError().getCause(), (String)ev.getError().getMessage(), (Plugin)Activator.getDefault(), (boolean)false);
                }
            };
            this.mfProjService.addMFServiceErrorListener(errorListener);
            this.mfProjService.addMFProjectsListener(new ListChangedListener(){

                public void listChanged(ChangeEvent event) {
                    L.debug("changeEvent: {}", (Object)event.getType());
                    if (ChangeEvent.ChangeEventType.LIST.equals((Object)event.getType())) {
                        for (MFProjListChangedListener lst : MFProjectsServiceFacadeImpl.this.guiListeners) {
                            lst.listChanged();
                        }
                    }
                }
            });
            this.mfProjService.start();
            this.initBridge();
        }
    }

    private IMainframeProjectsService getCCSReader() {
        IMainframeProjectsService ccsPrjServ = (IMainframeProjectsService)ServiceUtils.getService(IMainframeProjectsService.class);
        return ccsPrjServ;
    }

    private Supplier<Pair<String, Boolean>> buildIdentitySupplier() {
        return new Supplier<Pair<String, Boolean>>(){

            @Override
            public Pair<String, Boolean> get() {
                Pair ret = new Pair(null, (Object)false);
                SSOService serv = (SSOService)ServiceUtils.getService(SSOService.class);
                if (serv != null) {
                    boolean enabled = serv.isAuthEnabled();
                    if (enabled) {
                        if (!serv.isAuthenticated()) {
                            L.warn("user is not authenticated!");
                        }
                        L.trace("SSO auth=true; user is empty");
                        ret = new Pair((Object)"", (Object)true);
                    } else {
                        L.info("SSO authentication is disabled");
                    }
                } else {
                    L.warn("Authentication service not found! Presume SSO authentication is disabled");
                }
                return ret;
            }
        };
    }

    private Map<String, Object> getProjectSettings() {
        Set<String> set;
        Properties p;
        HashMap<String, Object> settings;
        block17: {
            settings = new HashMap<String, Object>();
            p = new Properties();
            InputStreamReader reader = null;
            try {
                try {
                    File file = new File(PathUtils.METADATA_FOLDER, "projects.properties");
                    if (file.exists()) {
                        reader = new FileReader(file);
                        p.load(reader);
                    }
                }
                catch (Exception e) {
                    L.error("could not read project setttings", (Throwable)e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            L.warn("could not close reader ", (Throwable)e2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close reader ", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    L.warn("could not close reader ", (Throwable)e);
                }
            }
        }
        if ((set = this.getSet("blacklist", p)) != null && !set.isEmpty()) {
            settings.put("blacklist", set);
        }
        if ((set = this.getSet("whitelist", p)) != null && !set.isEmpty()) {
            settings.put("whitelist", set);
        }
        return settings;
    }

    private Set<String> getSet(String key, Properties p) {
        HashSet<String> s = new HashSet<String>();
        String values = p.getProperty(key);
        if (values != null) {
            String[] vals;
            String[] stringArray = vals = values.split(",");
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    s.add(v.trim());
                }
                ++n2;
            }
        }
        return s.isEmpty() ? null : s;
    }

    public void shutdown() {
        if (this.mfProjService != null) {
            this.mfProjService.shutdown();
            this.mfProjService = null;
        } else {
            L.info("facade accessing Mainframe Projects service was null at shutdown");
        }
        if (this.bridgeInit) {
            try {
                this.bridgeInit = false;
                L.debug("releasing bridge in mf proj facade");
                BridgeConfigurator.release();
            }
            catch (Exception e) {
                L.error("could not release bridge in mf proj facade", (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        boolean vb = this.mfProjService != null && this.mfProjService.isStarted();
        return vb;
    }

    public void setIdentity(Supplier<Pair<String, Boolean>> arg0) {
        L.warn("method not supported; call identityChanged() instead!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identityChanged() {
        MFProjectsServiceFacadeImpl mFProjectsServiceFacadeImpl = this;
        synchronized (mFProjectsServiceFacadeImpl) {
            this.identity = this.buildIdentitySupplier();
        }
        if (this.mfProjService != null) {
            this.mfProjService.setIdentity(this.identity);
        } else {
            L.info("facade accessing Mainframe Projects service is null; check log files");
        }
    }

    public void addMFServiceErrorListener(ErrorListener listener) {
        if (this.mfProjService != null) {
            this.mfProjService.addMFServiceErrorListener(listener);
        }
    }

    public void removeMFServiceErrorListener(ErrorListener listener) {
        if (this.mfProjService != null) {
            this.mfProjService.removeMFServiceErrorListener(listener);
        }
    }

    public void addMFProjectsListener(ListChangedListener listener) {
        L.info("method not supported!");
    }

    public void removeMFProjectsListener(ListChangedListener listener) {
        L.info("method not supported!");
    }

    public void setCCSReader(IMainframeProjectsService srv) {
        L.warn("method not supported; call ccsReaderChanged() instead!");
    }

    public void setProjectsEndpoint(String url) {
        L.warn("method not supported!");
    }

    public void addPrjListListener(MFProjListChangedListener listChangedListener) {
        this.guiListeners.add(listChangedListener);
    }

    public void removePrjListListener(MFProjListChangedListener listChangedListener) {
        this.guiListeners.remove(listChangedListener);
    }

    public ProjectState checkProject(String project, Versions vers) {
        ProjectState state = ProjectState.UNKNOWN;
        if (this.mfProjService != null && this.mfProjService.isStarted()) {
            state = this.mfProjService.checkProject(project, vers);
        } else {
            L.warn("Facade accessing Mainframe Projects service is {}; cannot check project's state!", (Object)(this.mfProjService != null ? (this.mfProjService.isStarted() ? "started" : "not started") : "null"));
        }
        return state;
    }
}

