/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezsource.connection.zkbridge.project.sso.ErrorEvent;
import com.ez.ezsource.connection.zkbridge.project.sso.ErrorListener;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFConnectionServiceEventGenerator;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.internal.ProjectHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFConnectionServiceImpl
implements IMFConnectionService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MFConnectionServiceImpl.class);
    private static final int DEFAULT_CORE_THREADS = 1;
    private static final int DEFAULT_MAX_THREADS = Integer.MAX_VALUE;
    private static final long DEFAULT_TIMEOUT = 180L;
    private static final boolean DEFAULT_PRESTART_CORE_THREADS = false;
    private Map<String, IMFProjectHandler> handlers = Collections.synchronizedMap(new HashMap());
    private final IMFConnectionServiceEventGenerator eventGenerator = new MFConnectionServiceEventGenerator();
    private final Set<ErrorListener> errorListeners = new HashSet<ErrorListener>();
    private ApplicationType applicationType;

    public MFConnectionServiceImpl(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMFProjectHandler getProjectHandler(String project, Long projectType) {
        IMFProjectHandler ph = null;
        Map<String, IMFProjectHandler> map = this.handlers;
        synchronized (map) {
            if (this.handlers.containsKey(project) && (ph = this.handlers.get(project)).isTerminated()) {
                if (projectType == null && ph.getProjectType() != null) {
                    projectType = ph.getProjectType();
                }
                this.handlers.remove(ph);
                ph = null;
            }
            if (ph == null) {
                int coreThreads = this.getCoreThreads(project);
                int maxThreads = this.getMaxThreads();
                long timeout = this.getTimeout();
                boolean prestart = this.prestartCoreThreads();
                ph = new ProjectHandler(project, projectType, coreThreads, maxThreads, timeout, prestart, this.eventGenerator, this.applicationType);
                this.handlers.put(project, ph);
            }
        }
        return ph;
    }

    private long getTimeout() {
        long timeout = -1L;
        String tt = System.getProperty("THREAD_TIMEOUT");
        if (tt != null) {
            timeout = Long.parseLong(tt);
        }
        if (timeout < 0L) {
            timeout = 180L;
        }
        return timeout;
    }

    private int getMaxThreads() {
        int maxThreads = -1;
        String mt = System.getProperty("MAX_THREADS");
        if (mt != null) {
            maxThreads = Integer.parseInt(mt);
        }
        if (maxThreads < 0) {
            maxThreads = Integer.MAX_VALUE;
        }
        return maxThreads;
    }

    private int getCoreThreads(String project) {
        int coreThreads = -1;
        String cttp = System.getProperty("CORE_THREADS_" + project);
        if (cttp == null) {
            String ctpp = System.getProperty("CORE_THREADS_PP");
            if (ctpp != null) {
                coreThreads = Integer.parseInt(ctpp);
            }
        } else {
            coreThreads = Integer.parseInt(cttp);
        }
        if (coreThreads < 0) {
            coreThreads = 1;
        }
        return coreThreads;
    }

    private boolean prestartCoreThreads() {
        boolean prestart = false;
        String ps = System.getProperty("PRESTART_CORE_THREADS", new Boolean(false).toString());
        prestart = Boolean.parseBoolean(ps);
        return prestart;
    }

    public void removeProjectHandler(String project) {
        ProjectHandler ph = (ProjectHandler)this.handlers.get(project);
        if (ph != null) {
            ph.shutdown();
            try {
                ph.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (!ph.isTerminated()) {
                ph.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.handlers != null) {
            HashMap<String, IMFProjectHandler> copy;
            Map<String, IMFProjectHandler> map = this.handlers;
            synchronized (map) {
                copy = new HashMap<String, IMFProjectHandler>(this.handlers);
            }
            for (String project : copy.keySet()) {
                L.debug("requiring shutdown for {}", (Object)project);
                this.removeProjectHandler(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDown() {
        boolean down = true;
        if (this.handlers != null) {
            HashMap<String, IMFProjectHandler> copy;
            Map<String, IMFProjectHandler> map = this.handlers;
            synchronized (map) {
                copy = new HashMap<String, IMFProjectHandler>(this.handlers);
            }
            down = true;
            for (IMFProjectHandler iph : copy.values()) {
                ProjectHandler ph = (ProjectHandler)iph;
                if (ph.isTerminated()) continue;
                down = false;
                break;
            }
        }
        return down;
    }

    public void printHandlerStatistics() {
        for (IMFProjectHandler iph : this.handlers.values()) {
            ProjectHandler ph = (ProjectHandler)iph;
            L.info("{}", (Object)ph.toString());
        }
    }

    @Override
    public void addMFServiceErrorListener(ErrorListener errorListener) {
        this.errorListeners.add(errorListener);
    }

    @Override
    public void removeMFServiceErrorListener(ErrorListener errorListener) {
        this.errorListeners.remove(errorListener);
    }

    private class MFConnectionServiceEventGenerator
    implements IMFConnectionServiceEventGenerator {
        private MFConnectionServiceEventGenerator() {
        }

        @Override
        public void fireMFServiceErrorEvent(final Throwable t) {
            ErrorEvent event = new ErrorEvent(){

                public Throwable getError() {
                    return t;
                }
            };
            for (ErrorListener listener : MFConnectionServiceImpl.this.errorListeners) {
                listener.errorOccured(event);
            }
        }
    }
}

