/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionStateEvent;
import com.ez.ezsource.connection.EZSourceRemoteConnectionListener;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.Activator;
import com.ez.mainframe.projects.info.IMFConnectionContext;
import com.ez.mainframe.projects.internal.Messages;
import com.ez.workspace.BridgeConfigurator;
import com.ez.workspace.bridge.BridgeInitException;
import org.eclipse.core.runtime.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionThread
extends Thread
implements IMFConnectionContext {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ConnectionThread.class);
    private Runnable target;
    private volatile EZSourceConnection conn;
    private volatile boolean expired = false;
    private volatile boolean init = false;
    private Pair<String, String> bridge;
    private EZSourceRemoteConnectionListener remoteListener = new EZSourceRemoteConnectionListener(){

        public void onRemoteNetworkEvent(EZSourceConnectionStateEvent stateEvent) {
            L.info("remote network event: {}", (Object)stateEvent);
        }
    };

    public ConnectionThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.target = target;
    }

    @Override
    public void run() {
        try {
            this.target.run();
        }
        finally {
            L.debug("ConnectionThread is closing {}", (Object)this);
            this.ensureClosed();
        }
        L.debug("{} connection thread closed", (Object)this);
    }

    @Override
    public EZSourceConnection getConnection() {
        return this.conn;
    }

    @Override
    public Pair<String, String> getBridge() {
        return this.bridge;
    }

    private void logError(Throwable t, String msg, String title) {
        if (ServiceUtils.isOsgi()) {
            LogUtil.displayErrorMessage((Throwable)t, (String)msg, (String)title, (Plugin)Activator.getDefault(), (boolean)false);
        } else {
            L.error(msg, t);
        }
    }

    void ensureConnected() {
        if (this.expired || this.conn == null) {
            if (this.conn != null) {
                this.ensureClosed();
                L.debug("making conn = null");
                this.conn = null;
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() {
        boolean ok = false;
        if (!this.init) {
            int k = 0;
            while (k < 5 && !this.init) {
                try {
                    L.debug("initializing bridge on thread {}", (Object)this);
                    BridgeConfigurator.init();
                    this.bridge = BridgeConfigurator.getBridge();
                    this.init = true;
                }
                catch (BridgeInitException ex) {
                    long t = 5000L;
                    L.debug("{}; will wait {}sec and try again", (Object)ex.getMessage(), (Object)(t / 1000L));
                    ConnectionThread connectionThread = this;
                    synchronized (connectionThread) {
                        try {
                            this.wait(t);
                        }
                        catch (InterruptedException e) {
                            L.error("Error:", (Throwable)e);
                        }
                    }
                    ++k;
                }
                catch (Throwable t) {
                    ok = false;
                    L.error("Can't initialize the connection to bridge server.", t);
                    this.logError(t, Messages.getString(ConnectionThread.class, "configure.error"), Messages.getString(ConnectionThread.class, "errorLog.errorTitle"));
                    k = 5;
                }
            }
        }
        if (this.init) {
            try {
                try {
                    this.conn = EZSourceConnectionManager.getCurrent();
                    L.debug("got conn: {}", (Object)this.conn);
                    L.debug("initialize done for {}", (Object)this);
                    ok = true;
                    return;
                }
                catch (Throwable e) {
                    L.error("Can't connect to bridge server.", e);
                    this.logError(e, Messages.getString(ConnectionThread.class, "errorLog.errorInitiatingConnection"), Messages.getString(ConnectionThread.class, "errorLog.errorTitle"));
                    if (ok || this.conn == null) return;
                    this.ensureClosed();
                }
                return;
            }
            finally {
                if (!ok && this.conn != null) {
                    this.ensureClosed();
                }
            }
        } else {
            L.warn("cannot initialize connection thread!");
        }
    }

    void ensureClosed() {
        L.debug("ConnectionThread: called ensureClosed: {}", (Object)this.conn);
        if (this.conn != null) {
            try {
                L.debug("releasing connection for ConnectionThread");
                EZSourceConnectionManager.release((EZSourceConnection)this.conn);
                L.debug("connection released {}", (Object)this.conn);
            }
            catch (Throwable e) {
                L.error("could not release connection on thread " + this, e);
                this.logError(e, Messages.getString(ConnectionThread.class, "errorLog.errorReleasingConnection"), Messages.getString(ConnectionThread.class, "errorLog.errorTitle"));
            }
        }
        if (this.init) {
            try {
                L.debug("releasing bridge on thread {}", (Object)this);
                BridgeConfigurator.release();
                this.init = false;
            }
            catch (Exception e) {
                L.error("could not release bridge on thread {}", (Object)this, (Object)e);
            }
        }
    }
}

