/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.mainframe.projects.internal.ConnectionThread;
import com.ez.mainframe.projects.internal.ConnectionThreadFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
extends ThreadPoolExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ConnectionHandler.class);

    public ConnectionHandler(int coreSize, int maxPoolSize, long timeout, boolean prestart) {
        super(coreSize, maxPoolSize, timeout, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.setThreadFactory(new ConnectionThreadFactory());
        prestart = true;
        if (prestart) {
            this.prestartAllCoreThreads();
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        L.trace("before execute: {}: {}", (Object)t, (Object)r);
        ((ConnectionThread)t).ensureConnected();
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            ((ConnectionThread)Thread.currentThread()).ensureClosed();
        }
        super.afterExecute(r, t);
    }

    @Override
    public String toString() {
        return "connection-pool:" + super.toString();
    }
}

