/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects.internal;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.projects.Activator;
import com.ez.mainframe.projects.info.AnnotationsDbCheckerService;
import com.ez.mainframe.projects.internal.Messages;
import com.ibm.ad.ann.core.AnnotationsDBUtils;
import org.eclipse.core.runtime.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsDbCheckerImpl
implements AnnotationsDbCheckerService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnotationsDbCheckerImpl.class);
    private Boolean available = null;
    private Object lock = new Object();
    private CheckThread thread = null;
    private DatabaseInfo dbInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnnDbAvailable() {
        boolean ret = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.available == null) {
                if (!this.thread.executed) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    ret = this.available;
                } else {
                    ret = false;
                }
            } else {
                ret = this.available;
            }
        }
        L.trace("isAnnDbAvailable: {}", (Object)ret);
        return ret;
    }

    protected void uninitialize() {
        this.thread.shouldStop = true;
        this.thread.interrupt();
        this.dbInfo = null;
    }

    protected void initialize() {
        this.thread = new CheckThread("check annotations database");
        this.thread.start();
    }

    class CheckThread
    extends Thread {
        int timeout;
        boolean shouldStop;
        boolean executed;

        public CheckThread(String name) {
            super(name);
            this.timeout = 60000;
            this.shouldStop = false;
            this.executed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            L.trace("annotations database check thread started");
            while (!this.shouldStop) {
                Object object = AnnotationsDbCheckerImpl.this.lock;
                synchronized (object) {
                    if (AnnotationsDbCheckerImpl.this.available == null || !AnnotationsDbCheckerImpl.this.available.booleanValue()) {
                        AnnotationsDbCheckerImpl.this.available = this.checkAnnDb();
                    }
                    if (!this.executed) {
                        try {
                            AnnotationsDbCheckerImpl.this.lock.notifyAll();
                        }
                        catch (Exception exception) {}
                    }
                    this.executed = true;
                }
                if (AnnotationsDbCheckerImpl.this.available.booleanValue()) {
                    this.shouldStop = true;
                    continue;
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private boolean checkAnnDb() {
            boolean ret = false;
            boolean err = false;
            this.configureDataSource();
            if (AnnotationsDbCheckerImpl.this.dbInfo != null) {
                try {
                    ret = AnnotationsDBUtils.getInstance().checkDatabase(AnnotationsDbCheckerImpl.this.dbInfo);
                }
                catch (Exception e) {
                    L.error("error while checking annotations repository", (Throwable)e);
                    err = true;
                }
            } else {
                L.debug("annotations repo details not found");
                err = true;
            }
            if (!ret) {
                L.warn("Annotations database cannot be reached; analyzes will continue without marking resources!");
            }
            if (err) {
                LogUtil.displayErrorMessage(null, (String)Messages.getString(AnnotationsDbCheckerImpl.class, "logView.error.message"), (Plugin)Activator.getDefault(), (boolean)false);
            }
            return ret;
        }

        private synchronized void configureDataSource() {
            if (AnnotationsDbCheckerImpl.this.dbInfo == null) {
                AnnotationsDbCheckerImpl.this.dbInfo = AnnotationsDBUtils.getAnnDbInfo();
            }
        }
    }
}

