/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.projects;

import com.ez.eclient.service.rsrv.mfprojects.IMainframeProjectsService;
import com.ez.ezsource.connection.zkbridge.project.sso.IMFProjectsService;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.internal.model.IMFProjectsServiceFacade;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.internal.MFConnectionServiceImpl;
import com.ez.mainframe.projects.internal.MFProjectsServiceFacadeImpl;
import com.ez.mainframe.projects.internal.dummy.MFDummyConnectionServiceImpl;
import com.ez.mainframe.projects.internal.dummy.MFDummyProjectsServiceImpl;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends Plugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.ez.mainframe.projects";
    private static BundleContext context;
    private static Plugin plugin;

    public static BundleContext getContext() {
        return context;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        IMFConnectionService connectionService;
        super.start(bundleContext);
        boolean useDummy = Boolean.getBoolean("useDummy");
        context = bundleContext;
        Object projectsService = !useDummy ? new MFProjectsServiceFacadeImpl() : new MFDummyProjectsServiceImpl();
        context.registerService(IMFProjectsServiceFacade.class.getName(), projectsService, null);
        ServiceReference ss = context.getServiceReference(IMainframeProjectsService.class);
        if (ss != null) {
            L.debug("ccsreader is registered; facade can start");
            projectsService.start();
        } else {
            String filter = "(objectClass=" + IMainframeProjectsService.class.getName() + ")";
            context.addServiceListener(new ServiceListener((IMFProjectsServiceFacade)projectsService){
                private final /* synthetic */ IMFProjectsServiceFacade val$projectsService;
                {
                    this.val$projectsService = iMFProjectsServiceFacade;
                }

                public void serviceChanged(ServiceEvent event) {
                    if (1 == event.getType()) {
                        L.debug("ccsreader ({}) registered; facade can start now", event.getSource());
                        this.val$projectsService.start();
                    }
                }
            }, filter);
        }
        L.debug("registering service: {}", (Object)IMFProjectsServiceFacade.class.getName());
        context.registerService(IMFProjectsService.class.getName(), projectsService, null);
        L.debug("registering service: {}", (Object)IMFProjectsService.class.getName());
        if (!useDummy) {
            connectionService = new MFConnectionServiceImpl(ApplicationType.EZViewer);
            context.registerService(IMFConnectionService.class.getName(), (Object)connectionService, null);
        } else {
            connectionService = new MFDummyConnectionServiceImpl();
            context.registerService(IMFConnectionService.class.getName(), (Object)connectionService, null);
        }
        L.debug("registering service: {}", (Object)IMFConnectionService.class.getName());
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Object service;
        boolean useDummy = Boolean.getBoolean("useDummy");
        ServiceReference serviceReference = context.getServiceReference(IMFProjectsServiceFacade.class.getName());
        if (serviceReference != null) {
            if (!useDummy) {
                service = (MFProjectsServiceFacadeImpl)context.getService(serviceReference);
                ((MFProjectsServiceFacadeImpl)service).shutdown();
            }
            L.debug("unregistering service: {}", (Object)IMFProjectsServiceFacade.class.getName());
            L.debug("unregistering service: {}", (Object)IMFProjectsService.class.getName());
            context.ungetService(serviceReference);
        }
        if ((serviceReference = context.getServiceReference(IMFConnectionService.class.getName())) != null) {
            if (!useDummy) {
                service = (MFConnectionServiceImpl)context.getService(serviceReference);
                ((MFConnectionServiceImpl)service).shutdown();
            }
            L.debug("unregistering service: {}", (Object)MFConnectionServiceImpl.class.getName());
            context.ungetService(serviceReference);
        }
        context = null;
        plugin = null;
    }
}

