/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.transaction;

import com.ez.ezdao.transaction.LocalTransaction;
import com.ez.ezdao.transaction.SqlTransaction;
import com.ez.ezdao.transaction.TransactionException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedLocalTransaction
implements LocalTransaction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(NestedLocalTransaction.class);
    private SqlTransaction impl;
    private Stack<TransactionLocalInfo> tranStack;
    private boolean commited;
    private boolean rollbacked;

    public NestedLocalTransaction(SqlTransaction impl) {
        this.impl = impl;
        this.tranStack = new Stack();
        this.commited = false;
        this.rollbacked = false;
    }

    @Override
    public void beginTransaction() {
        if (this.tranStack.empty()) {
            this.commited = false;
            this.rollbacked = false;
            this.tranStack.push(new TransactionLocalInfo());
            this.impl.beginTransaction();
        } else {
            this.tranStack.push(new TransactionLocalInfo());
            logger.debug("Nested transaction, only increase level.");
        }
    }

    @Override
    public void endTransaction() {
        if (this.tranStack.empty()) {
            throw new TransactionException("Unexpected call to endTransaction().");
        }
        TransactionLocalInfo li = this.tranStack.pop();
        if (!(this.tranStack.empty() || li.mustCommit || li.mustRollback)) {
            li.mustRollback = true;
            logger.debug("Neither rollback nor commit voted for nested transaction, transaction is marked for rollback.");
        }
        this.mergeTransactionState(li);
        if (this.tranStack.empty()) {
            logger.debug("Ending transaction...");
            this.doEndTransaction(li);
        } else {
            logger.debug("Nested transaction, only decrease level.");
        }
    }

    @Override
    public void voteCommit() {
        logger.debug("Commit voted.");
        TransactionLocalInfo li = this.tranStack.peek();
        li.mustCommit = true;
    }

    @Override
    public void voteRollback() {
        logger.debug("Rollback voted.");
        TransactionLocalInfo li = this.tranStack.peek();
        li.mustRollback = true;
    }

    public int getLevel() {
        return this.tranStack.size();
    }

    boolean isCommited() {
        return this.commited;
    }

    boolean isRollbacked() {
        return this.rollbacked;
    }

    private void doEndTransaction(TransactionLocalInfo li) {
        boolean hasError = true;
        try {
            if (li.mustRollback) {
                logger.debug("Rollback voted, doing rollback...");
                this.impl.rollback();
                this.rollbacked = true;
            } else if (li.mustCommit) {
                logger.debug("Commit voted, commiting...");
                this.impl.commit();
                this.commited = true;
            } else {
                logger.debug("Neither rollback nor commit voted, doing rollback...");
                this.impl.rollback();
                this.rollbacked = true;
            }
            hasError = false;
        }
        catch (TransactionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransactionException(ex);
        }
        finally {
            try {
                this.impl.endTransaction();
            }
            catch (Exception ex) {
                if (hasError) {
                    logger.error("Can't end transaction.", (Throwable)ex);
                }
                throw new TransactionException(ex);
            }
        }
    }

    private void mergeTransactionState(TransactionLocalInfo li) {
        if (!this.tranStack.empty()) {
            TransactionLocalInfo parent = this.tranStack.peek();
            parent.mustCommit = parent.mustCommit || li.mustCommit;
            parent.mustRollback = parent.mustRollback || li.mustRollback;
        }
    }

    private static class TransactionLocalInfo {
        boolean mustRollback = false;
        boolean mustCommit = false;

        private TransactionLocalInfo() {
        }
    }
}

