/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private static final Logger L = LoggerFactory.getLogger(Proxies.class);

    public static Object invoke(Object target, Method method, Object[] args) {
        Object r = null;
        try {
            r = method.invoke(target, args);
        }
        catch (InvocationTargetException te) {
            Proxies.handle(te);
        }
        catch (Exception ex) {
            Proxies.handle(ex);
        }
        return r;
    }

    private static void handle(InvocationTargetException te) {
        Throwable t;
        if (L.isDebugEnabled()) {
            L.trace("Invocation failed.", (Throwable)te);
        }
        if (!((t = te.getTargetException()) instanceof Exception)) {
            throw new RuntimeException("Invocation failed.", t);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    private static void handle(Exception ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException(ex);
    }
}

