/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.DataSourceFactory;
import com.ez.ezdao.impl.ExUtils;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDataSourceFactory
implements DataSourceFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SqlServerDataSourceFactory.class);
    public static final String CONNECTION_DRIVER = SQLServerDriver.class.getName();
    private Configuration conf;

    public SqlServerDataSourceFactory(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf");
        }
        this.conf = conf;
    }

    @Override
    public DataSource create(DatabaseInfo dbi) {
        L.debug("Data source creating...");
        BasicDataSource ds = new BasicDataSource(){

            protected ConnectionFactory createConnectionFactory() throws SQLException {
                String user;
                Class<?> clazz;
                try {
                    clazz = this.driverClassLoader.loadClass(this.driverClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Cannot load JDBC driver class '" + this.driverClassName + "'", e);
                }
                Driver driver = null;
                try {
                    driver = (Driver)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate JDBC driver class '" + this.driverClassName + "'", e);
                }
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
                if (this.validationQuery == null) {
                    this.setTestOnBorrow(false);
                    this.setTestOnReturn(false);
                    this.setTestWhileIdle(false);
                }
                if ((user = this.username) != null) {
                    this.connectionProperties.put("user", user);
                } else {
                    this.log("DBCP DataSource configured without a 'username'");
                }
                String pwd = this.password;
                if (pwd != null) {
                    this.connectionProperties.put("password", pwd);
                } else {
                    this.log("DBCP DataSource configured without a 'password'");
                }
                DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
                return driverConnectionFactory;
            }
        };
        String url = this.buildDataSourceUrl(dbi);
        String user = dbi.getUsername();
        String password = dbi.getPassword();
        String databaseName = dbi.getDatabase();
        L.debug("JDBC connection url: " + url);
        ds.setDriverClassLoader(SQLServerDriver.class.getClassLoader());
        ds.setDriverClassName(CONNECTION_DRIVER);
        int batchSize = this.conf.getInt("jdbc.batch_size", 1000);
        L.debug("Batch size: {}", (Object)batchSize);
        ds.addConnectionProperty("batchSize", String.valueOf(batchSize));
        if (user != null) {
            user = user.trim();
        }
        if (user != null && user.length() > 0) {
            L.debug("JDBC user: " + user);
            ds.setUsername(user);
            if (password != null) {
                ds.setPassword(password);
            }
        } else {
            L.debug("No username configured, using windows authentication.");
        }
        if (databaseName != null && !databaseName.isEmpty()) {
            ds.addConnectionProperty("databaseName", dbi.getDatabase());
        } else {
            L.debug("databaseName property not set when DataSouce is created. It can be set later, but if it is not set the connection will not be established.");
        }
        ds.setMaxActive(-1);
        ds.setUrl(url);
        if (dbi.getProtocol() != null) {
            L.debug("Protocol: " + dbi.getProtocol());
            L.debug("trustServerCertificate: " + String.valueOf(dbi.isTrustServerCertificate()));
            if (dbi.getProtocol().equals("TLSv1.2") && dbi.isTrustServerCertificate()) {
                ds.addConnectionProperty("encrypt", "true");
                ds.addConnectionProperty("trustServerCertificate", String.valueOf(dbi.isTrustServerCertificate()));
                ds.addConnectionProperty("sslProtocol", dbi.getProtocol());
            } else if (dbi.getProtocol().equals("TLSv1.2") && !dbi.isTrustServerCertificate()) {
                String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
                if (trustStorePath == null || trustStorePath.trim().isEmpty()) {
                    throw new RuntimeException("TLSv1.2 - property javax.net.ssl.trustStore was not set to a valid path.");
                }
                String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
                    throw new RuntimeException("TLSv1.2 - property javax.net.ssl.trustStorePassword was not set to a valid password.");
                }
                ds.addConnectionProperty("encrypt", "true");
                ds.addConnectionProperty("trustServerCertificate", String.valueOf(dbi.isTrustServerCertificate()));
                ds.addConnectionProperty("hostNameInCertificate", dbi.getHost());
                ds.addConnectionProperty("sslProtocol", dbi.getProtocol());
                ds.addConnectionProperty("trustStore", trustStorePath);
                ds.addConnectionProperty("trustStorePassword", trustStorePassword);
            } else if (dbi.getProtocol().equals("TLSv1.3")) {
                String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
                if (trustStorePath == null || trustStorePath.trim().isEmpty()) {
                    throw new RuntimeException("TLSv1.3 - property javax.net.ssl.trustStore was not set to a valid path.");
                }
                String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
                    throw new RuntimeException("TLSv1.3 - property javax.net.ssl.trustStorePassword was not set to a valid password.");
                }
                ds.addConnectionProperty("encrypt", "strict");
                ds.addConnectionProperty("trustServerCertificate", "false");
                ds.addConnectionProperty("hostNameInCertificate", dbi.getHost());
                ds.addConnectionProperty("sslProtocol", dbi.getProtocol());
                ds.addConnectionProperty("trustStore", trustStorePath);
                ds.addConnectionProperty("trustStorePassword", trustStorePassword);
            }
        } else {
            L.debug("Protocol: null => encrypt=true;trustServerCertificate=true;");
            ds.addConnectionProperty("encrypt", "true");
            ds.addConnectionProperty("trustServerCertificate", "true");
        }
        L.debug("Data source initialized.");
        return ds;
    }

    @Override
    public void destroy(DataSource ds) {
        if (!(ds instanceof BasicDataSource)) {
            throw new IllegalArgumentException("ds not a " + BasicDataSource.class);
        }
        try {
            ((BasicDataSource)ds).close();
        }
        catch (SQLException ex) {
            ExUtils.throwEx(ex);
        }
    }

    String buildDataSourceUrl(DatabaseInfo dbi) {
        String instance;
        StringBuilder sb = new StringBuilder();
        Integer port = dbi.getPort();
        sb.append("jdbc:sqlserver://");
        sb.append(dbi.getHost());
        if (port != null) {
            sb.append(":");
            sb.append(dbi.getPort());
        }
        if ((instance = dbi.getInstance()) != null && (instance = instance.trim()).length() > 0) {
            sb.append(";instanceName=");
            sb.append(instance);
        }
        return sb.toString();
    }
}

