/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExUtils.class);

    public static void throwEx(SQLException ex) {
        ExUtils.throwEx(ex, null);
    }

    public static void throwEx(SQLException ex, String message) {
        throw message != null ? new DatabaseException(message, (Throwable)ex) : new DatabaseException((Throwable)ex);
    }

    public static void throwEx(Exception ex) {
        ExUtils.throwEx(ex, null);
    }

    public static void throwEx(Exception ex, String message) {
        if (ex instanceof SQLException) {
            throw message != null ? new DatabaseException(message, (Throwable)ex) : new DatabaseException((Throwable)ex);
        }
        if (ex instanceof DatabaseException) {
            if (message != null) {
                L.error(message);
            }
            throw (DatabaseException)ex;
        }
        if (ex instanceof RuntimeException) {
            if (message != null) {
                L.error(message);
            }
            throw (RuntimeException)ex;
        }
        throw message != null ? new RuntimeException(message, ex) : new RuntimeException(ex);
    }
}

