/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.DataSourceFactory;
import com.ez.ezdao.impl.ExUtils;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ServerDataSourceFactory
implements DataSourceFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Db2ServerDataSourceFactory.class);
    public static final String CONNECTION_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private Configuration conf;
    private boolean zos;

    public Db2ServerDataSourceFactory(Configuration conf, boolean zos) {
        if (conf == null) {
            throw new IllegalArgumentException("conf");
        }
        this.zos = zos;
        this.conf = conf;
    }

    @Override
    public DataSource create(DatabaseInfo dbi) {
        L.debug("Data source creating...");
        BasicDataSource ds = new BasicDataSource(){

            protected ConnectionFactory createConnectionFactory() throws SQLException {
                String user;
                Class<?> clazz;
                try {
                    clazz = this.driverClassLoader.loadClass(this.driverClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Cannot load JDBC driver class '" + this.driverClassName + "'", e);
                }
                Driver driver = null;
                try {
                    driver = (Driver)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot instantiate JDBC driver class '" + this.driverClassName + "'", e);
                }
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
                if (this.validationQuery == null) {
                    this.setTestOnBorrow(false);
                    this.setTestOnReturn(false);
                    this.setTestWhileIdle(false);
                }
                if ((user = this.username) != null) {
                    this.connectionProperties.put("user", user);
                } else {
                    this.log("DBCP DataSource configured without a 'username'");
                }
                String pwd = this.password;
                if (pwd != null) {
                    this.connectionProperties.put("password", pwd);
                } else {
                    this.log("DBCP DataSource configured without a 'password'");
                }
                DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
                return driverConnectionFactory;
            }
        };
        String url = this.buildDataSourceUrl(dbi);
        String user = dbi.getUsername();
        String password = dbi.getPassword();
        L.debug("JDBC connection url: " + url);
        ds.setDriverClassLoader(this.getClass().getClassLoader());
        ds.setDriverClassName(CONNECTION_DRIVER);
        int batchSize = this.conf.getInt("jdbc.batch_size", 1000);
        L.debug("Batch size: {}", (Object)batchSize);
        ds.addConnectionProperty("batchSize", String.valueOf(batchSize));
        if (user != null) {
            user = user.trim();
        }
        if (user != null && user.length() > 0) {
            L.debug("JDBC user: " + user);
            ds.setUsername(user);
            if (password != null) {
                ds.setPassword(password);
            }
        } else {
            L.debug("No username configured, using windows authentication.");
        }
        ds.setMaxActive(-1);
        ds.setUrl(url);
        L.debug("Data source initialized.");
        return ds;
    }

    @Override
    public void destroy(DataSource ds) {
        if (!(ds instanceof BasicDataSource)) {
            throw new IllegalArgumentException("ds not a " + BasicDataSource.class);
        }
        try {
            ((BasicDataSource)ds).close();
        }
        catch (SQLException ex) {
            ExUtils.throwEx(ex);
        }
    }

    String buildDataSourceUrl(DatabaseInfo dbi) {
        StringBuilder sb = new StringBuilder();
        Integer port = dbi.getPort();
        String database = dbi.getDatabase();
        String host = dbi.getHost();
        String schema = dbi.getSchema();
        String location = dbi.getInstance();
        if (schema == null) {
            L.warn("Schema not provided, for to DBO");
            schema = "EZSCH";
        }
        if (host == null) {
            throw new IllegalArgumentException("No host.");
        }
        if (database == null) {
            throw new IllegalArgumentException("No database.");
        }
        sb.append("jdbc:db2://");
        sb.append(host);
        if (port != null) {
            sb.append(":");
            sb.append(port);
        }
        sb.append("/");
        sb.append(this.zos ? location : database);
        sb.append(":currentPath=");
        sb.append(schema);
        sb.append(";currentSchema=");
        sb.append(schema);
        sb.append(";currentFunctionPath=");
        sb.append(schema);
        if (!this.zos && dbi.useTLS()) {
            sb.append(";sslConnection=");
            sb.append(true);
            sb.append(";sslVersion=");
            sb.append(dbi.getProtocol());
            String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
            if (trustStorePath == null || trustStorePath.trim().isEmpty()) {
                throw new RuntimeException(dbi.getProtocol() + " - property javax.net.ssl.trustStore was not set to a valid path.");
            }
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
                throw new RuntimeException(dbi.getProtocol() + " - property javax.net.ssl.trustStorePassword was not set to a valid password.");
            }
            sb.append(";sslTrustStoreLocation=");
            sb.append(trustStorePath);
            sb.append(";sslTrustStorePassword=");
            sb.append(trustStorePassword);
        }
        sb.append(";");
        return sb.toString();
    }
}

