/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.ConnectionRegistry;
import com.ez.ezdao.impl.DataConnection;
import com.ez.ezdao.impl.DataOperation;
import com.ez.ezdao.impl.DataSourceFactory;
import com.ez.ezdao.impl.Db2ServerDataSourceFactory;
import com.ez.ezdao.impl.ExUtils;
import com.ez.ezdao.impl.JdbcDataOperation;
import com.ez.ezdao.impl.Lifecycle;
import com.ez.ezdao.impl.SqlServerDataSourceFactory;
import com.ez.ezdao.proxy.Proxies;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectionFactory {
    private static final Logger L = LoggerFactory.getLogger(DataConnectionFactory.class);
    private ConnectionRegistry dsRegistry;

    public DataConnectionFactory(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf");
        }
        HashMap<String, DataSourceFactory> factories = new HashMap<String, DataSourceFactory>();
        factories.put("db2", new Db2ServerDataSourceFactory(conf, false));
        factories.put("db2z", new Db2ServerDataSourceFactory(conf, true));
        factories.put("sqlserver", new SqlServerDataSourceFactory(conf));
        this.dsRegistry = new ConnectionRegistry(factories);
    }

    public DataOperation create(String database, DatabaseInfo dbi) {
        Connection connImpl = null;
        DataSource ds = null;
        try {
            ds = this.dsRegistry.get(dbi);
            connImpl = ds.getConnection();
            if (database == null) {
                L.debug("Database not set, user default will be used.");
            } else {
                L.debug("Set database: " + database);
                connImpl.setCatalog(database);
            }
            connImpl.setAutoCommit(true);
        }
        catch (Exception ex) {
            if (connImpl != null) {
                try {
                    connImpl.close();
                }
                catch (SQLException e) {
                    L.error("Can't close connection.", (Throwable)e);
                }
            }
            if (ds != null) {
                try {
                    this.dsRegistry.release(dbi);
                }
                catch (Exception e) {
                    L.error("Can't release datasource.", (Throwable)e);
                }
            }
            ExUtils.throwEx(ex);
        }
        DataConnection conn = new DataConnection(dbi, connImpl);
        try {
            conn.initialize();
        }
        catch (Exception ex) {
            if (connImpl != null) {
                try {
                    connImpl.close();
                }
                catch (SQLException e) {
                    L.error("Can't close connection.", (Throwable)e);
                }
            }
            throw new RuntimeException(ex);
        }
        return DataConnectionFactory.createProxy(conn);
    }

    public void destroy(DataOperation c) {
        Connection jc;
        block6: {
            jc = c.getConnection();
            try {
                c.uninitialize();
            }
            catch (Exception ex) {
                L.error("Unexpected exception.", (Throwable)ex);
            }
            try {
                jc.setCatalog(null);
            }
            catch (Exception ex) {
                if (!L.isDebugEnabled()) break block6;
                L.debug("Can't reset catalog.", (Throwable)ex);
            }
        }
        try {
            jc.close();
        }
        catch (SQLException ex) {
            L.error("Can't close connection.", (Throwable)ex);
        }
        this.dsRegistry.release(c.getDatabaseInfo());
    }

    private static DataOperation createProxy(DataConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("conn is null");
        }
        return (DataOperation)Proxy.newProxyInstance(conn.getClass().getClassLoader(), new Class[]{DataOperation.class, Lifecycle.class}, (InvocationHandler)new ConnectionInvocationHandler(conn));
    }

    private static class ConnectionInvocationHandler
    implements InvocationHandler {
        DataConnection conn;
        static final Set<String> SKIPED = new HashSet<String>(){
            {
                this.add("getAvailableData");
                this.add("finished");
                this.add("beginTransaction");
                this.add("endTransaction ");
                this.add("voteCommitTransaction");
                this.add("voteRollbackTransaction");
            }
        };

        public ConnectionInvocationHandler(DataConnection conn) {
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            block21: {
                Object r;
                block22: {
                    boolean success;
                    String name;
                    block19: {
                        if (!method.getDeclaringClass().equals(JdbcDataOperation.class)) break block21;
                        name = method.getName();
                        r = null;
                        boolean skip = SKIPED.contains(name);
                        if (!name.equals("end") && !skip) {
                            this.conn.enterWorking();
                        } else if (L.isTraceEnabled()) {
                            L.trace(String.format("Method %s skipped by enterWorking().", name));
                        }
                        if (L.isTraceEnabled()) {
                            L.trace("in " + name + "()");
                        }
                        success = false;
                        try {
                            r = Proxies.invoke(this.conn, method, args);
                            if (L.isTraceEnabled()) {
                                L.trace("out " + name + "()");
                            }
                            success = true;
                            if (!skip) break block19;
                        }
                        catch (Throwable throwable) {
                            block20: {
                                if (skip) {
                                    if (L.isTraceEnabled()) {
                                        L.trace(String.format("Method %s skipped by enterIdle().", name));
                                    }
                                } else if (!name.startsWith("begin") || !success) {
                                    try {
                                        this.conn.enterIdle();
                                    }
                                    catch (Exception ex) {
                                        if (!success) {
                                            L.error("Unexpected error.", (Throwable)ex);
                                            break block20;
                                        }
                                        throw new RuntimeException("Unexpected error.", ex);
                                    }
                                }
                            }
                            throw throwable;
                        }
                        if (L.isTraceEnabled()) {
                            L.trace(String.format("Method %s skipped by enterIdle().", name));
                        }
                        break block22;
                    }
                    if (!name.startsWith("begin") || !success) {
                        try {
                            this.conn.enterIdle();
                        }
                        catch (Exception ex) {
                            if (!success) {
                                L.error("Unexpected error.", (Throwable)ex);
                            }
                            throw new RuntimeException("Unexpected error.", ex);
                        }
                    }
                }
                return r;
            }
            return Proxies.invoke(this.conn, method, args);
        }
    }
}

