/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezdao.impl.DataOperation;
import com.ez.ezdao.impl.ExUtils;
import com.ez.ezdao.impl.Lifecycle;
import com.ez.ezdao.transaction.NestedLocalTransaction;
import com.ez.ezdao.transaction.SqlTransaction;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnection
implements DataOperation,
Lifecycle {
    private static final Logger L = LoggerFactory.getLogger(DataConnection.class);
    private DatabaseInfo dbi;
    private Connection conn;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss");
    private NestedLocalTransaction tran;
    private FetchOperation fetchOperation;
    private Statement statementOperation;
    private State state = State.Idle;
    private final Object stateGuard = new Object();

    public DataConnection(DatabaseInfo dbi, Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("conn");
        }
        if (dbi == null) {
            throw new IllegalArgumentException("conn");
        }
        this.dbi = dbi;
        this.conn = conn;
        this.tran = new NestedLocalTransaction(new SqlTransactionImpl(this.conn));
        this.fetchOperation = null;
        this.statementOperation = null;
    }

    boolean inTransaction() {
        return this.tran.getLevel() > 0;
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.dbi;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void uninitialize() {
        if (this.fetchOperation != null) {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterWorking() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == State.Working) {
                throw new IllegalStateException("Already in working state.");
            }
            this.state = State.Working;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterIdle() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != State.Working && this.state != State.Canceling) {
                throw new IllegalStateException(this.state.toString());
            }
            if (this.statementOperation != null) {
                L.debug("Statement operation not null.");
                this.statementOperation = null;
            }
            if (this.fetchOperation != null) {
                L.warn("Fetch operation not null.");
                this.fetchOperation = null;
            }
            this.state = State.Idle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        boolean r = false;
        Object object = this.stateGuard;
        synchronized (object) {
            block10: {
                try {
                    L.debug("Start canceling...");
                    if (this.state == State.Working) {
                        L.info("Operation in progress, canceling...");
                        if (this.statementOperation != null) {
                            try {
                                L.info("Statement in progress, canceling...");
                                this.statementOperation.cancel();
                                L.info("Statement canceled.");
                            }
                            catch (SQLException ex) {
                                ExUtils.throwEx(ex);
                            }
                        }
                        r = true;
                        break block10;
                    }
                    L.debug("No operation in progress, mark connection as canceling...");
                }
                finally {
                    this.state = State.Canceling;
                }
            }
        }
        return r;
    }

    private void checkCanceled() {
        if (this.state == State.Canceling) {
            throw new IllegalStateException("Operation canceled by user.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeInsert(String sql) {
        L.trace("in: executeInsert()");
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            int r;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                this.statementOperation = this.conn.createStatement();
            }
            try {
                r = this.statementOperation.executeUpdate(sql);
            }
            finally {
                this.statementOperation.close();
                this.statementOperation = null;
            }
            L.trace("Return: " + r);
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: executeInsert()");
    }

    @Override
    public String[][] executeSql(String sql) {
        return this.executeSql(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] executeSql(String sql, Object[] params) {
        String[][] data = null;
        L.trace("in: executeSql() {} with param {}", (Object)sql, (Object)params);
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                this.statementOperation = this.conn.prepareStatement(sql);
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] != null) {
                        ((PreparedStatement)this.statementOperation).setObject(i + 1, params[i]);
                        continue;
                    }
                    L.warn("ignore null param with index {} for query {} ", (Object)(i + 1), (Object)sql);
                }
            }
            try {
                ResultSet rs = ((PreparedStatement)this.statementOperation).executeQuery();
                data = DataConnection.fetchRecordSet(rs, null);
            }
            finally {
                this.statementOperation.close();
                this.statementOperation = null;
            }
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: executeSql()");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(String sql) {
        L.trace("in: executeUpdate()");
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            int r;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                this.statementOperation = this.conn.createStatement();
            }
            try {
                r = this.statementOperation.executeUpdate(sql);
            }
            finally {
                this.statementOperation.close();
                this.statementOperation = null;
            }
            L.trace("Return: " + r);
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: executeUpdate()");
    }

    @Override
    public String[][] execStoredProc(String sql, String[] params) {
        L.trace("in: execStoredProc()");
        String[][] data = this.doExecCallable(sql, params, null);
        L.trace("out: execStoredProc()");
        return data;
    }

    @Override
    public String[][] execStoredProc(String proc, Object[] params, ParameterInfo[] paramsInfo) {
        L.trace("in: execStoredProc()");
        String[][] data = this.doExecCallable(proc, params, paramsInfo);
        L.trace("out: execStoredProc()");
        return data;
    }

    @Override
    public String[][] execStoredProc(String sql, Object[] params) {
        L.trace("in: execStoredProc()");
        String[][] data = this.doExecCallable(sql, params, null);
        L.trace("out: execStoredProc()");
        return data;
    }

    @Override
    public Integer beginStoredProc(String sql, String[] params, int chunkSize) {
        L.trace("in: beginStoredProc()");
        Integer r = this.doBeginCallable(sql, params, chunkSize);
        L.trace("out : beginStoredProc()");
        return r;
    }

    @Override
    public Integer beginStoredProc(String sql, Object[] params, int chunkSize) {
        L.trace("in: beginStoredProc()");
        Integer r = this.doBeginCallable(sql, params, chunkSize);
        L.trace("out : beginStoredProc()");
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer beginExecuteSql(String sql, int chunkSize) {
        L.trace("in: beginExecuteSql()");
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            Statement s;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                this.statementOperation = s = this.conn.createStatement();
            }
            ResultSet rs = s.executeQuery(sql);
            rs.setFetchSize(chunkSize);
            this.fetchOperation = new FetchOperation(s, rs);
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: beginExecuteSql()");
        return null;
    }

    @Override
    public String[][] getAvailableData(int rows) {
        String[][] data = null;
        this.checkCanceled();
        if (this.fetchOperation == null) {
            throw new IllegalStateException("No operation in progress.");
        }
        try {
            data = this.fetchOperation.fetch(rows);
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        return data;
    }

    @Override
    public boolean finished() {
        L.trace("in: finished()");
        if (this.fetchOperation == null) {
            throw new IllegalStateException("No operation in progress.");
        }
        boolean f = this.fetchOperation.finished();
        L.trace("out: finished()");
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        L.trace("in: end()");
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.fetchOperation == null) {
                throw new IllegalStateException("No operation in progress.");
            }
            try {
                this.fetchOperation.close();
            }
            finally {
                this.fetchOperation = null;
            }
        }
        L.trace("out: end()");
    }

    @Override
    public int[] execBatch(String sql, Object[][] params) {
        L.trace("in: execBatch()");
        int[] r = this.doExecBatch(sql, params);
        L.trace("out: execBatch()");
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertBatch(String table, String[][] recordset, List<EZSourceDataType> types) {
        block27: {
            EZSourceDataType[] dataTypes = types.toArray(new EZSourceDataType[0]);
            L.trace("in: insertBatch()");
            if (recordset.length < 1) {
                throw new IllegalArgumentException("Empty recordset.");
            }
            int params = recordset[0].length;
            if (params < 1) {
                throw new IllegalArgumentException("First row has no columns.");
            }
            try {
                PreparedStatement ps;
                String q = this.buildBatchQuery(table, params);
                L.trace("Batch statement: " + q);
                Object object = this.stateGuard;
                synchronized (object) {
                    this.checkCanceled();
                    ps = this.conn.prepareStatement(q);
                    this.statementOperation = ps;
                }
                try {
                    int i = 0;
                    String[][] stringArray = recordset;
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++i, ++j) {
                        String[] row = stringArray[j];
                        if (row.length != dataTypes.length) {
                            throw new IllegalArgumentException("Row " + i + ": wrong number of columns.");
                        }
                        ps.clearParameters();
                        if (L.isTraceEnabled()) {
                            L.trace("Row " + i + ": " + Arrays.asList(row));
                        }
                        int j2 = 0;
                        String[] stringArray2 = row;
                        int n2 = stringArray2.length;
                        for (int k = 0; k < n2; ++j2, ++k) {
                            String col = stringArray2[k];
                            ps.setObject(j2 + 1, this.getColumnValue(i, j2, col, dataTypes[j2]));
                        }
                        ps.addBatch();
                    }
                    Object object2 = this.stateGuard;
                    synchronized (object2) {
                        this.checkCanceled();
                    }
                    int[] r = ps.executeBatch();
                    if (r == null) {
                        L.trace("Result: " + r);
                        break block27;
                    }
                    if (L.isTraceEnabled()) {
                        void var10_15;
                        boolean bl = false;
                        while (var10_15 < r.length) {
                            L.trace("Result " + (int)var10_15 + ": " + Arrays.asList(new int[][]{r}));
                            ++var10_15;
                        }
                    }
                }
                finally {
                    try {
                        ps.close();
                    }
                    catch (Exception ex) {
                        L.error("Can't close statement.", (Throwable)ex);
                    }
                    finally {
                        this.statementOperation = null;
                    }
                }
            }
            catch (Exception ex) {
                ExUtils.throwEx(ex);
            }
        }
        L.trace("out: insertBatch()");
    }

    @Override
    public void beginTransaction() {
        L.trace("in: beginTransaction()");
        this.tran.beginTransaction();
        L.trace("out: beginTransaction()");
    }

    @Override
    public void endTransaction() {
        L.trace("in: endTransaction()");
        this.tran.endTransaction();
        L.trace("out: endTransaction()");
    }

    @Override
    public void voteCommitTransaction() {
        L.trace("in: voteCommitTransaction()");
        this.tran.voteCommit();
        L.trace("out: voteCommitTransaction()");
    }

    @Override
    public void voteRollbackTransaction() {
        L.trace("in: voteRollbackTransaction()");
        this.tran.voteRollback();
        L.trace("out: voteRollbackTransaction()");
    }

    private Object getColumnValue(int row, int col, String value, EZSourceDataType type) {
        Object ovalue = value;
        if (value != null) {
            switch (type) {
                case String: {
                    break;
                }
                case Integer: {
                    try {
                        ovalue = Integer.parseInt(value);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException(String.format("%s is not an integer (row %d, column %d).", value, row, col));
                    }
                }
                case Datetime: {
                    try {
                        ovalue = new Date(DATE_TIME_FORMAT.parse(value).getTime());
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(String.format("%s is not a datetime in format %s (row %d, column %d).", value, DATE_FORMAT.toPattern(), row, col));
                    }
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s type is not supported (row %d, column %d).", type, row, col));
                }
            }
        }
        return ovalue;
    }

    private String buildProcQuery(String proc, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("'count' < 0");
        }
        StringBuilder b = new StringBuilder();
        b.append("{call ");
        b.append(proc);
        b.append(" (");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    b.append(",");
                }
                b.append(" ?");
            }
        }
        b.append(")}");
        return b.toString();
    }

    private String buildBatchQuery(String table, int count) {
        if (count < 1) {
            throw new IllegalArgumentException("'count' < 1");
        }
        StringBuilder b = new StringBuilder();
        b.append("insert into ");
        b.append(table);
        b.append(" values (?");
        for (int i = 1; i < count; ++i) {
            b.append(", ?");
        }
        b.append(")");
        return b.toString();
    }

    private static String[][] fetchRecordSet(ResultSet rs, Integer maxRows) throws SQLException {
        int i = 0;
        if (maxRows != null && maxRows < 1) {
            throw new IllegalArgumentException("'maxRows' < 1");
        }
        ResultSetMetaData m = rs.getMetaData();
        int cols = m.getColumnCount();
        LinkedList<String[]> rows = new LinkedList<String[]>();
        while (rs.next()) {
            String[] row = new String[cols];
            for (int j = 0; j < cols; ++j) {
                Object value = rs.getObject(j + 1);
                if (value instanceof Clob) {
                    value = DataConnection.clobToString((Clob)value);
                }
                row[j] = value != null ? value.toString() : null;
            }
            rows.add(row);
            if (maxRows == null || ++i != maxRows) continue;
            break;
        }
        return rows.size() > 0 ? (String[][])rows.toArray((T[])new String[0][]) : (String[][])null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String clobToString(Clob data) throws SQLException {
        StringBuilder sb = new StringBuilder();
        try (Reader reader = data.getCharacterStream();){
            char[] buffer = new char[1024];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer, 0, 1024)) >= 0) {
                sb.append(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            L.error("", (Throwable)e);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] doExecCallable(String sql, Object[] params, ParameterInfo[] paramsInfo) {
        String[][] data = null;
        if (paramsInfo != null) {
            if (params == null) {
                throw new IllegalArgumentException("Parameters not supplied.");
            }
            if (paramsInfo.length != params.length) {
                throw new IllegalArgumentException("Parameters and parameters info lists do not match.");
            }
        }
        if (paramsInfo == null && params != null) {
            paramsInfo = new ParameterInfo[params.length];
            for (int i = 0; i < paramsInfo.length; ++i) {
                paramsInfo[i] = ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input);
            }
        }
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            CallableStatement cs;
            ResultSet rs = null;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                cs = this.conn.prepareCall(this.buildProcQuery(sql, params.length));
                this.statementOperation = cs;
            }
            try {
                int i;
                for (i = 0; i < params.length; ++i) {
                    Object p = params[i];
                    ParameterInfo pi = paramsInfo[i];
                    Integer sqlType = pi.getSqlType();
                    if (!pi.getDirection().equals((Object)ParameterDirection.Output)) {
                        if (sqlType == null) {
                            cs.setObject(i + 1, p);
                        } else {
                            cs.setObject(i + 1, p, (int)sqlType);
                        }
                    }
                    if (!pi.getDirection().equals((Object)ParameterDirection.Output) && !pi.getDirection().equals((Object)ParameterDirection.InputOutput)) continue;
                    if (sqlType == null) {
                        throw new IllegalArgumentException("Parameter type no set for output parameter index " + i);
                    }
                    cs.registerOutParameter(i + 1, (int)sqlType);
                }
                cs.execute();
                rs = cs.getResultSet();
                if (rs != null) {
                    data = DataConnection.fetchRecordSet(rs, null);
                }
                for (i = 0; i < params.length; ++i) {
                    ParameterInfo pi = paramsInfo[i];
                    if (!pi.getDirection().equals((Object)ParameterDirection.Output) && !pi.getDirection().equals((Object)ParameterDirection.InputOutput)) continue;
                    params[i] = cs.getObject(i + 1);
                }
            }
            finally {
                cs.close();
                this.statementOperation = null;
            }
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: doExecCallable()");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer doBeginCallable(String sql, Object[] params, int chunkSize) {
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            CallableStatement cs;
            ResultSet rs = null;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                cs = this.conn.prepareCall(this.buildProcQuery(sql, params.length));
                this.statementOperation = cs;
            }
            for (int i = 0; i < params.length; ++i) {
                cs.setObject(i + 1, params[i]);
            }
            cs.execute();
            rs = cs.getResultSet();
            this.fetchOperation = new FetchOperation(cs, rs);
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        L.trace("out: doBeginCallable()");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] doExecBatch(String sql, Object[][] params) {
        int[] r = null;
        if (this.fetchOperation != null) {
            throw new IllegalStateException("Operation in progress.");
        }
        try {
            PreparedStatement ps;
            Object object = this.stateGuard;
            synchronized (object) {
                this.checkCanceled();
                ps = this.conn.prepareStatement(sql);
                this.statementOperation = ps;
            }
            try {
                for (int i = 0; i < params.length; ++i) {
                    Object[] row = params[i];
                    if (L.isTraceEnabled()) {
                        L.trace("Row " + i + ": " + Arrays.asList(row));
                    }
                    ps.clearParameters();
                    for (int j = 0; j < row.length; ++j) {
                        ps.setObject(j + 1, row[j]);
                    }
                    ps.addBatch();
                }
                Object i = this.stateGuard;
                synchronized (i) {
                    this.checkCanceled();
                }
                r = ps.executeBatch();
                if (r == null) {
                    L.trace("Result: " + r);
                } else if (L.isTraceEnabled()) {
                    for (int k = 0; k < r.length; ++k) {
                        L.trace("Result " + k + ": " + Arrays.asList(new int[][]{r}));
                    }
                }
            }
            finally {
                ps.close();
                this.statementOperation = null;
            }
        }
        catch (SQLException e) {
            ExUtils.throwEx(e);
        }
        return r;
    }

    private static class FetchOperation {
        private Statement s;
        private ResultSet rs;
        private boolean finished;
        private boolean closed;

        FetchOperation(Statement s, ResultSet rs) {
            this.s = s;
            this.rs = rs;
            this.finished = false;
            this.closed = false;
        }

        public boolean finished() {
            if (this.closed) {
                throw new IllegalStateException("Operation closed.");
            }
            return this.finished;
        }

        public String[][] fetch(int rows) throws SQLException {
            String[][] data = null;
            if (rows <= 0) {
                throw new IllegalArgumentException("rows");
            }
            if (this.closed) {
                throw new IllegalStateException("Operation closed.");
            }
            if (this.finished) {
                throw new IllegalStateException("Result set is closed already.");
            }
            if (this.rs != null) {
                data = DataConnection.fetchRecordSet(this.rs, rows);
            }
            this.finished = data == null || data.length < rows;
            return data;
        }

        public void close() {
            if (this.closed) {
                throw new IllegalStateException("Operation closed.");
            }
            try {
                this.s.close();
            }
            catch (SQLException e) {
                L.error("", (Throwable)e);
            }
        }
    }

    private class SqlTransactionImpl
    implements SqlTransaction {
        Connection conn;

        SqlTransactionImpl(Connection conn) {
            this.conn = conn;
        }

        @Override
        public void beginTransaction() {
            try {
                L.debug("Set auto commit to false.");
                this.conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                ExUtils.throwEx(e);
            }
        }

        @Override
        public void commit() {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                ExUtils.throwEx(e);
            }
            try {
                L.debug("Set auto commit to true.");
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                ExUtils.throwEx(e);
            }
        }

        @Override
        public void endTransaction() {
        }

        @Override
        public void rollback() {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                ExUtils.throwEx(e);
            }
            try {
                L.debug("Set auto commit to true.");
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                ExUtils.throwEx(e);
            }
        }
    }

    public static enum State {
        Idle,
        Working,
        Canceling;

    }
}

