/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.impl;

import com.ez.ezdao.api.DatabaseException;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.impl.DataSourceFactory;
import com.ez.ezdao.impl.DatabaseInstance;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionRegistry {
    private static final Logger L = LoggerFactory.getLogger(ConnectionRegistry.class);
    Map<String, DataSourceFactory> factories;
    Map<DatabaseInstance, DataSourceInfo> dataSources = new HashMap<DatabaseInstance, DataSourceInfo>();

    public ConnectionRegistry(Map<String, DataSourceFactory> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories");
        }
        this.factories = new HashMap<String, DataSourceFactory>(factories);
    }

    public synchronized DataSource get(DatabaseInfo dbi) {
        DatabaseInstance di = new DatabaseInstance(dbi.getHost(), dbi.getPort(), dbi.getServerType(), dbi.getInstance(), dbi.getDatabase(), dbi.getSchema());
        DataSourceInfo dsi = this.dataSources.get(di);
        if (dsi == null) {
            dsi = new DataSourceInfo();
            L.info("Creating datasource for " + dbi);
            DataSourceFactory f = this.factories.get(dbi.getServerType());
            if (f == null) {
                throw new DatabaseException("Unknown server type: " + dbi.getServerType());
            }
            dsi.connCount = 0;
            dsi.ds = f.create(dbi);
            this.dataSources.put(di, dsi);
        }
        L.debug("Increment usage counter for datasource: " + di);
        ++dsi.connCount;
        return dsi.ds;
    }

    public synchronized void release(DatabaseInfo dbi) {
        DatabaseInstance di = new DatabaseInstance(dbi.getHost(), dbi.getPort(), dbi.getServerType(), dbi.getInstance(), dbi.getDatabase(), dbi.getSchema());
        DataSourceInfo dsi = this.dataSources.get(di);
        if (dsi == null) {
            throw new IllegalArgumentException("No datasource for " + dsi);
        }
        L.debug("Decrement usage counter for datasource: " + di);
        --dsi.connCount;
        if (dsi.connCount == 0) {
            L.info("Closing datasource for " + dbi);
            try {
                DataSourceFactory f = this.factories.get(dbi.getServerType());
                f.destroy(dsi.ds);
            }
            catch (Exception ex) {
                L.error("Can't destroy datasource.", (Throwable)ex);
            }
            this.dataSources.remove(di);
        }
    }

    private static class DataSourceInfo {
        int connCount = 0;
        DataSource ds;

        private DataSourceInfo() {
        }
    }
}

