/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.versioning;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.SPInfo;
import com.ez.ezsource.versioning.SPInfoComparator;
import com.ez.ezsource.versioning.Version;
import com.ez.ezsource.versioning.internal.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningUtils {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(VersioningUtils.class);
    private static VersioningUtils instance = null;
    private EZSourceConnection conn = null;
    private Properties app = null;
    private Map<String, SPInfo> appSPInfo = null;
    private SPInfoComparator spComp = null;
    private SPInfoComparator spRevComp = null;
    private Properties tbls = null;
    private Map<String, SPInfo> tablesInfo = null;
    public static final String EZSOURCE_DBVERSION = "8.7.122.3";

    private VersioningUtils(EZSourceConnection conn) {
        this.conn = conn;
        this.spRevComp = new SPInfoComparator(false);
        this.spComp = new SPInfoComparator();
    }

    UpgradeType shouldUpgradeTables() {
        UpgradeType ret;
        block15: {
            block14: {
                ret = UpgradeType.NONE;
                L.debug("verify EZReports table schema");
                boolean locked = false;
                try {
                    try {
                        locked = this.conn.acquireProjectLock(LockType.Shared);
                    }
                    catch (EZSourceConnectionException e) {
                        L.debug("cannot acquire shared lock on project {}", (Object)this.conn.getOpenedProject(), (Object)e);
                        if (!locked) {
                            throw new EZSourceConnectionException(Messages.getString(VersioningUtils.class, "cannotAcquireLock.exception"));
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (!locked) {
                        throw new EZSourceConnectionException(Messages.getString(VersioningUtils.class, "cannotAcquireLock.exception"));
                    }
                    throw throwable;
                }
                if (!locked) {
                    throw new EZSourceConnectionException(Messages.getString(VersioningUtils.class, "cannotAcquireLock.exception"));
                }
            }
            try {
                try {
                    String[][] rez = this.conn.executeSQL("select * from EZReports");
                    if (rez != null) {
                        L.info("EZReports={}", (Object)rez[0][0]);
                        break block15;
                    }
                    L.error("EZReports table is empty!");
                }
                catch (EZSourceConnectionException e) {
                    L.debug("EZReports table is not available; it will be create later", (Throwable)e);
                    ret = UpgradeType.CREATE;
                    VersioningUtils.releaseLock(this.conn);
                }
            }
            finally {
                VersioningUtils.releaseLock(this.conn);
            }
        }
        return ret;
    }

    public static VersioningUtils instance(EZSourceConnection conn) {
        if (instance == null || VersioningUtils.instance.conn != conn) {
            instance = new VersioningUtils(conn);
        }
        return instance;
    }

    public Version getAppVersion(ApplicationType type) {
        this.loadAppProperties();
        String propName = type.toString().concat(".version");
        String versionProperty = this.app.getProperty(propName, "0.0");
        Version appVersion = new Version(versionProperty);
        L.debug("Application version: {}", (Object)versionProperty);
        return appVersion;
    }

    private Map<String, SPInfo> getAppSPInfo() {
        this.loadAppProperties();
        return this.appSPInfo;
    }

    private void loadAppProperties() {
        if (this.app == null) {
            block23: {
                this.app = new Properties();
                this.appSPInfo = new HashMap<String, SPInfo>();
                InputStream inStream = null;
                try {
                    try {
                        inStream = VersioningUtils.class.getResourceAsStream("app.properties");
                        this.app.load(inStream);
                    }
                    catch (IOException e) {
                        L.error("loadAppProperties()", (Throwable)e);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e2) {
                                L.warn("could not close stream ", (Throwable)e2);
                            }
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            L.warn("could not close stream ", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close stream ", (Throwable)e);
                    }
                }
            }
            int count = Integer.parseInt(this.app.getProperty("sp.count", "0"));
            int i = 0;
            while (i < count) {
                String spName = this.app.getProperty("sp." + i + ".name");
                if (spName != null && !spName.trim().equals("")) {
                    String dbType;
                    String spVerProperty = this.app.getProperty("sp." + i + ".version");
                    Version spVersion = new Version(spVerProperty);
                    String spFile = this.app.getProperty("sp." + i + ".file");
                    SPInfo spInfo = new SPInfo(spName, spVersion, spFile);
                    spInfo.setId(i);
                    String type = this.app.getProperty("sp." + i + ".type");
                    spInfo.setType(type);
                    String action = this.app.getProperty("sp." + i + ".action", "change");
                    spInfo.setAction(action);
                    String sParams = this.app.getProperty("sp." + i + ".params", null);
                    if (sParams != null) {
                        int params = Integer.parseInt(sParams);
                        int k = 0;
                        while (k < params) {
                            spInfo.addParam(this.app.getProperty("sp." + i + ".param." + k));
                            ++k;
                        }
                    }
                    if ((dbType = this.app.getProperty("sp." + i + ".dbType")) != null) {
                        spInfo.setDbEngine(Integer.valueOf(dbType));
                    }
                    HashSet<ApplicationType> appTypes = new HashSet<ApplicationType>();
                    String apps = this.app.getProperty("sp." + i + ".applications");
                    if (apps != null) {
                        String[] parts = apps.split(",");
                        int j = 0;
                        while (j < parts.length) {
                            String appName = parts[j].trim();
                            ApplicationType t = ApplicationType.getByValue(appName);
                            appTypes.add(t);
                            ++j;
                        }
                    } else {
                        L.info("procedure {} is used in all applications", (Object)spName);
                    }
                    spInfo.setApplications(appTypes);
                    this.appSPInfo.put(spName.toUpperCase(), spInfo);
                }
                ++i;
            }
        }
    }

    private String getSPSource(SPInfo sp, ServerType dbType) {
        L.debug("getting source for: {}", (Object)sp.getSpName());
        String prefix = ServerType.Db2Z.equals((Object)dbType) ? "db2/" : (ServerType.Db2.equals((Object)dbType) ? "db2luw/" : "");
        String fileName = null;
        InputStream is = null;
        boolean cont = true;
        while (cont) {
            fileName = String.valueOf(prefix) + sp.getSpFile();
            is = VersioningUtils.class.getResourceAsStream(fileName);
            if (is == null && ServerType.Db2.equals((Object)dbType) && !"db2/".equals(prefix)) {
                prefix = "db2/";
                continue;
            }
            cont = false;
        }
        StringBuffer srcBuf = new StringBuffer();
        if (is == null) {
            if (ServerType.SqlServer.equals((Object)dbType) && sp.getType().equalsIgnoreCase("TABLE")) {
                L.trace("fileName: {} of table {} not found!", (Object)fileName, (Object)sp.getSpName());
            } else {
                L.error("fileName: {} not found!", (Object)fileName);
            }
        } else {
            byte[] buf = new byte[512];
            try {
                while (is.available() > 0) {
                    int read = is.read(buf, 0, 512);
                    if (read <= -1) continue;
                    srcBuf.append(new String(buf, 0, read));
                }
            }
            catch (IOException ioex) {
                L.error("getSPSource() for {}", (Object)sp.getSpName(), (Object)ioex);
            }
        }
        return srcBuf.toString().trim();
    }

    boolean updatePrjData(IProgressMonitor pmonitor, Version currVersion, ApplicationType appType, UpgradeType upgradeType) throws EZSourceConnectionException {
        long t1;
        SubMonitor monitor;
        boolean updateOk;
        block14: {
            updateOk = true;
            L.debug("update project data");
            monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)50);
            monitor.subTask(Messages.getString(VersioningUtils.class, "update.data"));
            monitor.setWorkRemaining(100);
            boolean lockAcquired = VersioningUtils.acquireLock(this.conn, LockType.Exclusive);
            if (!lockAcquired) {
                L.info("Exclusive lock failed");
                throw new EZSourceConnectionException(Messages.getString(VersioningUtils.class, "projectLocked.exception"));
            }
            t1 = System.currentTimeMillis();
            try {
                try {
                    VersioningUtils vutils = VersioningUtils.instance(this.conn);
                    switch (upgradeType) {
                        case CREATE: {
                            vutils.createTables();
                            break;
                        }
                    }
                    Map<String, SPInfo> prjSPInfoMap = this.getPrjSPInfo();
                    Set<String> existingProcNames = prjSPInfoMap.keySet();
                    Map<String, SPInfo> appSPInfoMap = this.getAppSPInfo();
                    Map<String, SPInfo> tablesInfoMap = this.getAppTablesInfo();
                    monitor.worked(10);
                    ServerType engine = this.getProjectDbEngine();
                    Collection<ApplicationType> appToUpdate = this.getAppToUpdate(appType, existingProcNames, appSPInfoMap, prjSPInfoMap);
                    Collection<ApplicationType> appToUpdate4Tbls = this.getAppToUpdate(appType, existingProcNames, tablesInfoMap, prjSPInfoMap);
                    appToUpdate.addAll(appToUpdate4Tbls);
                    this.checkObjects(this.conn, existingProcNames, appSPInfoMap, tablesInfoMap);
                    this.createFunctions(this.conn);
                    this.updateApplication(currVersion, appType, monitor, prjSPInfoMap, existingProcNames, appSPInfoMap, tablesInfoMap, engine);
                    for (ApplicationType app : appToUpdate) {
                        if (appType.equals((Object)app) || ApplicationType.NoType.equals((Object)app)) continue;
                        Version currentVersion = vutils.getAppVersion(app);
                        Version prjVersion = vutils.getAppVersionInPrj(app);
                        int comp = prjVersion.compareTo(currentVersion);
                        if (comp < 0) {
                            L.debug("{} must be updated too", (Object)app);
                            prjSPInfoMap = this.getPrjSPInfo();
                            existingProcNames = prjSPInfoMap.keySet();
                            this.updateApplication(currentVersion, app, monitor, prjSPInfoMap, existingProcNames, appSPInfoMap, tablesInfoMap, engine);
                            continue;
                        }
                        if (comp <= 0) continue;
                        L.warn("{} has a bigger version in DB ({}) than in application ({})", new Object[]{app, prjVersion, currentVersion});
                    }
                }
                catch (RuntimeException ex) {
                    L.error("exception occurred; update not ok", (Throwable)ex);
                    updateOk = false;
                    boolean released = this.conn.releaseProjectLock();
                    if (!released) {
                        L.info("exclusive lock release failed");
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                boolean released = this.conn.releaseProjectLock();
                if (!released) {
                    L.info("exclusive lock release failed");
                }
                throw throwable;
            }
            boolean released = this.conn.releaseProjectLock();
            if (!released) {
                L.info("exclusive lock release failed");
            }
        }
        monitor.subTask("");
        monitor.setWorkRemaining(0);
        monitor.done();
        long t2 = System.currentTimeMillis();
        L.trace("-------------- total time: {} sec; updateok={}", (Object)((t2 - t1) / 1000L), (Object)updateOk);
        return updateOk;
    }

    private void checkObjects(EZSourceConnection conn, Set<String> existingProcNames, Map<String, SPInfo> appSPInfoMap, Map<String, SPInfo> tablesInfoMap) {
        String sql = this.getObjInventoryStr(conn);
        if (sql != null && !sql.isEmpty()) {
            HashSet<String> searchedObjs = new HashSet<String>(appSPInfoMap.keySet());
            searchedObjs.addAll(tablesInfoMap.keySet());
            ArrayList<EZSourceDataType> types = new ArrayList<EZSourceDataType>(searchedObjs.size());
            int i = 0;
            while (i < searchedObjs.size()) {
                types.add(EZSourceDataType.String);
                ++i;
            }
            ArrayList<String> values = new ArrayList<String>(searchedObjs);
            String[][] res = conn.executeSQL(sql, types, values);
            if (res != null) {
                int i2 = 0;
                while (i2 < res.length) {
                    String name = res[i2][0];
                    String type = res[i2][1];
                    SPInfo sp = appSPInfoMap.get(name);
                    if (sp == null) {
                        sp = tablesInfoMap.get(name);
                    }
                    if (sp == null) {
                        L.warn("object with name {} found in db (type={}), but not in app.properties", (Object)name, (Object)type);
                    } else {
                        sp.addObjType(type);
                    }
                    ++i2;
                }
            }
        }
    }

    private String getObjInventoryStr(EZSourceConnection conn) {
        String sql = null;
        String schemaMarker = "<schema>";
        String dbMarker = "<dbName>";
        ProjectInfo projectInfo = conn.getProjectInfo();
        ServerType dbType = projectInfo.getDbEngine();
        switch (dbType) {
            case SqlServer: {
                sql = "SELECT UPPER(ROUTINE_NAME), ROUTINE_TYPE FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_TYPE IN ('PROCEDURE', 'FUNCTION')    AND ROUTINE_CATALOG = '<dbName>' AND ROUTINE_SCHEMA = '<schema>' AND UPPER(ROUTINE_NAME) IN (select * from #string_param_temp)  \nUNION \nSELECT UPPER(TABLE_NAME), CASE TABLE_TYPE WHEN 'BASE TABLE' THEN 'TABLE' ELSE 'VIEW' END FROM INFORMATION_SCHEMA.TABLES WHERE    TABLE_TYPE IN ('BASE TABLE', 'VIEW') AND TABLE_CATALOG = '<dbName>' AND TABLE_SCHEMA = '<schema>' AND UPPER(TABLE_NAME) IN (select * from #string_param_temp)  \nORDER BY 1;";
                break;
            }
            case Db2: {
                sql = "SELECT ROUTINENAME, CASE ROUTINETYPE WHEN 'P' THEN 'PROCEDURE' WHEN 'F' THEN 'FUNCTION' END FROM SYSCAT.ROUTINES WHERE    ROUTINETYPE IN ('P', 'F') AND ROUTINESCHEMA = '<schema>'  AND ROUTINENAME IN (select * from SESSION.string_param_temp)  \nUNION \nSELECT TABNAME, CASE TYPE WHEN 'T' THEN 'TABLE' WHEN 'V' THEN  'VIEW' END FROM SYSCAT.TABLES WHERE TYPE IN ('T', 'V')      AND TABSCHEMA ='<schema>' AND TABNAME IN (select * from SESSION.string_param_temp) \nORDER BY 1";
                break;
            }
            case Db2Z: {
                sql = "SELECT NAME, CASE ROUTINETYPE WHEN 'P' THEN 'PROCEDURE' WHEN 'F' THEN 'FUNCTION' END FROM SYSIBM.SYSROUTINES WHERE    ROUTINETYPE IN ('P', 'F') AND SCHEMA = '<schema>'  AND NAME IN (select * from SESSION.string_param_temp)  \nUNION \nSELECT NAME, CASE TYPE WHEN 'T' THEN 'TABLE' WHEN 'V' THEN  'VIEW' END FROM SYSIBM.SYSTABLES WHERE TYPE IN ('T', 'V')    AND CREATOR ='<schema>' AND NAME IN (select * from SESSION.string_param_temp)  \nORDER BY 1;";
                break;
            }
        }
        if (sql != null) {
            DatabaseInfo databaseInfo = projectInfo.getDatabaseInfo();
            String dbName = databaseInfo.getDatabase();
            String projectName = projectInfo.getProjectName();
            if (dbName == null) {
                L.error("no database name for project: {}", (Object)projectName);
            } else {
                sql = sql.replaceAll(dbMarker, dbName);
            }
            String schema = databaseInfo.getSchema();
            if (schema == null || schema.isEmpty()) {
                switch (dbType) {
                    case Db2Z: {
                        L.error("no schema name for project: {}!", (Object)projectName);
                        throw new RuntimeException("Project " + projectName + " has no schemaName! Check CCS settings!");
                    }
                }
                L.info("no schema name for project: {}; assume it's DBO", (Object)projectName);
                schema = "DBO";
            }
            sql = sql.replaceAll(schemaMarker, schema);
        } else {
            L.warn("object inventory string NULL for serverType={}", (Object)dbType);
        }
        L.trace("sql for object type = {}", (Object)sql);
        return sql;
    }

    private ServerType getProjectDbEngine() {
        return this.conn.getProjectInfo().getDbEngine();
    }

    private Collection<ApplicationType> getAppToUpdate(ApplicationType appType, Set<String> existingProcNames, Map<String, SPInfo> appSPInfoMap, Map<String, SPInfo> prjSPInfoMap) {
        int size;
        SPInfo appSPInfo;
        String changedProcedure;
        HashSet<ApplicationType> appToUpdate = new HashSet<ApplicationType>();
        appToUpdate.add(appType);
        LinkedList<String> proceduresToUpdate = new LinkedList<String>();
        HashSet<String> changedProcedures = new HashSet<String>(appSPInfoMap.keySet());
        changedProcedures.removeAll(prjSPInfoMap.keySet());
        for (String existingProcName : existingProcNames) {
            SPInfo appSPInfo2 = appSPInfoMap.get(existingProcName);
            SPInfo prjSPInfo = prjSPInfoMap.get(existingProcName);
            if (appSPInfo2 == null || appSPInfo2.getSpVersion().compareTo(prjSPInfo.getSpVersion()) <= 0) continue;
            changedProcedures.add(existingProcName);
        }
        int dbEngineInt = this.getProjectDbEngine().getValue();
        Iterator iterator = changedProcedures.iterator();
        while (iterator.hasNext()) {
            changedProcedure = (String)iterator.next();
            appSPInfo = appSPInfoMap.get(changedProcedure);
            if (!VersioningUtils.isDbEngineCompatible(appSPInfo, dbEngineInt)) {
                iterator.remove();
                continue;
            }
            if (appSPInfo.getAction() != 1 || prjSPInfoMap.containsKey(changedProcedure)) continue;
            iterator.remove();
        }
        do {
            size = appToUpdate.size();
            iterator = ((Set)changedProcedures).iterator();
            block3: while (iterator.hasNext()) {
                changedProcedure = (String)iterator.next();
                appSPInfo = appSPInfoMap.get(changedProcedure);
                Collection<ApplicationType> applicationTypes = appSPInfo.getApplicationTypes();
                for (ApplicationType applicationType : applicationTypes) {
                    if (!appToUpdate.contains((Object)applicationType)) continue;
                    proceduresToUpdate.add(changedProcedure);
                    iterator.remove();
                    appToUpdate.addAll(applicationTypes);
                    continue block3;
                }
            }
        } while (size != appToUpdate.size());
        return appToUpdate;
    }

    private void createFunctions(EZSourceConnection conn) throws EZSourceConnectionException {
        Exception ex;
        block6: {
            ex = null;
            conn.beginTransaction();
            try {
                try {
                    VersioningUtils.createAncestorFunction(conn);
                    conn.voteCommitTransaction();
                }
                catch (Exception e) {
                    L.trace("error creating functions", (Throwable)e);
                    ex = e;
                    conn.endTransaction();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                conn.endTransaction();
                throw throwable;
            }
            conn.endTransaction();
        }
        if (ex != null) {
            throw new EZSourceConnectionException((Throwable)ex);
        }
    }

    private static void createAncestorFunction(EZSourceConnection conn) throws Exception {
        ServerType dbType = conn.getProjectInfo().getDbEngine();
        try {
            String sql = null;
            switch (dbType) {
                case SqlServer: {
                    sql = "IF not EXISTS (SELECT *\n           FROM   sys.objects\n           WHERE  object_id = OBJECT_ID(N'[dbo].[ancestor]')\n                  AND type IN ( N'FN', N'IF', N'TF', N'FS', N'FT' )\n          )\n     exec sp_executesql @Statement = N'CREATE FUNCTION [dbo].[ancestor] (@prgid int, @anc varchar(250)) RETURNS varchar(250)       as begin DECLARE @ret varchar(200); set @ret = case @prgid when 19 then '''' else isNull(@anc,'''') end; return(@ret); end'; ";
                    break;
                }
                case Db2: {
                    sql = "CREATE OR REPLACE FUNCTION ancestor ( \n p_prgid INTEGER,\n p_anc   VARCHAR(200)\n)\n     RETURNS VARCHAR(200)\n     LANGUAGE SQL\n     CONTAINS SQL\n     NO EXTERNAL ACTION\n     DETERMINISTIC\nss: BEGIN ATOMIC\n\n     DECLARE v_prgid INTEGER;\n     DECLARE v_anc, v_ret VARCHAR(200);\n\t\n     SET v_prgid = p_prgid;\n     SET v_anc = p_anc;\n     SET v_ret = CASE v_prgid WHEN 19 THEN ''\n                            ELSE COALESCE(v_anc, '')\n                 END;\n\n\tRETURN v_ret;\nEND ss ";
                    break;
                }
                case Db2Z: {
                    String fName = "ancestor";
                    boolean exists = VersioningUtils.functionExists(conn, fName);
                    sql = !exists ? "CREATE FUNCTION " + fName + " ( \n" : "ALTER FUNCTION " + fName + " REPLACE ACTIVE VERSION ( \n";
                    sql = String.valueOf(sql) + " p_prgid INTEGER,\n p_anc   VARCHAR(256)\n)\n     RETURNS VARCHAR(256)\n     LANGUAGE SQL\n     CONTAINS SQL\n     NO EXTERNAL ACTION\n     DETERMINISTIC\nss: BEGIN \n\n     DECLARE v_prgid INTEGER;\n     DECLARE v_anc, v_ret VARCHAR(256);\n\t\n     SET v_prgid = p_prgid;\n     SET v_anc = p_anc;\n     SET v_ret = CASE v_prgid WHEN 19 THEN ''\n                            ELSE COALESCE(v_anc, '')\n                 END;\n\n\tRETURN v_ret;\nEND ss ";
                    break;
                }
                case Access: {
                    L.info("database type not supported: {}", (Object)dbType);
                    break;
                }
            }
            if (sql != null) {
                conn.executeUpdate(sql);
                L.debug("done: {}", (Object)sql);
            } else {
                L.info("no string for ancestor() function!");
            }
        }
        catch (Exception e) {
            L.info("cannot create ancestor function; skip it", (Throwable)e);
            throw e;
        }
    }

    private static boolean functionExists(EZSourceConnection conn, String functionName) {
        boolean ret = true;
        String schema = conn.getProjectInfo().getDatabaseInfo().getSchema();
        if (schema == null) {
            String projectName = conn.getProjectInfo().getProjectName();
            L.error("schema name is NULL for project: {}; please check settings!", (Object)projectName);
            throw new RuntimeException("Project " + projectName + " has no schemaName! Check CCS settings!");
        }
        String sql = String.format("SELECT NAME FROM SYSIBM.SYSROUTINES WHERE SCHEMA = '%s' and ROUTINETYPE='F' and NAME=UPPER('%s')", schema, functionName);
        String[][] res = conn.executeSQL(sql);
        if (res == null || res.length == 0 || res[0][0] == null) {
            ret = false;
        }
        return ret;
    }

    private void updateApplication(Version currentVersion, ApplicationType appType, SubMonitor monitor, Map<String, SPInfo> prjSPinfo, Set<String> existingProcNames, Map<String, SPInfo> appSPinfo, Map<String, SPInfo> tablesInfo, ServerType engine) {
        SPChanges tableChanges = this.getSPChanges(prjSPinfo, tablesInfo, appType);
        monitor.worked(5);
        SPChanges changes = this.getSPChanges(prjSPinfo, appSPinfo, appType);
        monitor.worked(5);
        int size = tableChanges.toUpdate.size() + tableChanges.toInsert.size() + tableChanges.toDrop.size() + tableChanges.toReplace.size() + changes.toUpdate.size() + changes.toInsert.size() + changes.toDrop.size() + changes.toReplace.size();
        monitor.setWorkRemaining(size);
        L.trace("before update {}; tableChanges.toReplace.size={}, changes.toReplace.size={}", new Object[]{appType.name(), tableChanges.toReplace.size(), changes.toReplace.size()});
        this.processChanges(existingProcNames, tableChanges, engine, monitor);
        this.processChanges(existingProcNames, changes, engine, monitor);
        String colName = appType.getColumnName();
        L.debug("colName to update: {} for appType: {}", (Object)colName, (Object)appType);
        this.conn.beginTransaction();
        try {
            String sql = String.format("update EZReports set %s='%s'", colName, currentVersion.toString());
            this.conn.executeUpdate(sql);
            L.debug("done: {}", (Object)sql);
            this.conn.voteCommitTransaction();
        }
        finally {
            this.conn.endTransaction();
        }
    }

    private void processChanges(Set<String> existingProcNames, SPChanges changes, ServerType engine, SubMonitor monitor) {
        this.drop(monitor, changes.toDrop, engine);
        this.replace(monitor, changes.toReplace, existingProcNames, engine);
        this.updateOrInsert(monitor, changes.toUpdate, existingProcNames, true, engine);
        this.updateOrInsert(monitor, changes.toInsert, existingProcNames, false, engine);
    }

    public static boolean acquireLock(EZSourceConnection bridge, LockType lock) {
        boolean lockAcquired = false;
        boolean tryAgain = true;
        boolean tried = false;
        while (tryAgain) {
            tryAgain = false;
            try {
                lockAcquired = bridge.acquireProjectLock(lock);
                if (!lockAcquired) continue;
                L.debug("project locked");
            }
            catch (EZSourceConnectionException e) {
                L.error("error locking project", (Throwable)e);
                LockType status = null;
                try {
                    status = bridge.getProjectLockType();
                }
                catch (EZSourceConnectionException e2) {
                    L.error("error getting project lock", (Throwable)e2);
                }
                if (!status.equals((Object)LockType.Exclusive) && !tried) {
                    tryAgain = true;
                    tried = true;
                    continue;
                }
                L.error("the project is locked due to performing a structural operation somewhere else and it could not be updated!\\n The project cannot be opened!\\nPlease retry later.\\n", (Throwable)e);
                throw e;
            }
        }
        return lockAcquired;
    }

    private void drop(SubMonitor monitor, Map<String, SPInfo> procs, ServerType engine) throws EZSourceConnectionException {
        ArrayList<SPInfo> spList = new ArrayList<SPInfo>(procs.values());
        if (!spList.isEmpty()) {
            Collections.sort(spList, this.spRevComp);
            for (SPInfo sp : spList) {
                this.doDrop(sp, engine, false);
            }
            this.conn.beginTransaction();
            try {
                for (SPInfo sp : spList) {
                    try {
                        String q = String.format("delete from EZReportsStoredProcedures where Name='%s'", sp.getSpName());
                        this.conn.executeUpdate(q);
                    }
                    catch (EZSourceConnectionException eZSourceConnectionException) {
                        L.debug("could not delete {} from EZReportsStoredProcedures", (Object)sp.getSpName());
                    }
                }
                this.conn.voteCommitTransaction();
            }
            finally {
                this.conn.endTransaction();
            }
        }
    }

    private void replace(SubMonitor monitor, Map<String, SPInfo> procs, Set<String> existingProcNames, ServerType engine) throws EZSourceConnectionException {
        ArrayList<SPInfo> spList = new ArrayList<SPInfo>(procs.values());
        if (!spList.isEmpty()) {
            Collections.sort(spList, this.spRevComp);
            long t1 = System.currentTimeMillis();
            for (SPInfo sp : spList) {
                this.doDrop(sp, engine, true);
            }
            long t2 = System.currentTimeMillis();
            L.trace("total time for drop of replace: {}sec", (Object)((t2 - t1) / 1000L));
            RuntimeException ex = null;
            SPInfo spErr = null;
            this.conn.beginTransaction();
            try {
                Iterator spIt = spList.iterator();
                while (spIt.hasNext() && ex == null) {
                    SPInfo sp = (SPInfo)spIt.next();
                    try {
                        this.doUpdateOrInsert(sp, existingProcNames, engine, true);
                    }
                    catch (RuntimeException err) {
                        ex = err;
                        spErr = sp;
                        L.error("error at replace of {}: {}", new Object[]{sp.getType(), sp.getSpName(), err});
                    }
                    monitor.worked(1);
                }
                if (ex != null) {
                    this.conn.voteRollbackTransaction();
                } else {
                    this.conn.voteCommitTransaction();
                }
            }
            finally {
                this.conn.endTransaction();
            }
            if (ex != null) {
                String errMsg = "Error trying to replace " + spErr.getType() + " named: " + spErr.getSpName();
                throw new EZSourceConnectionException(errMsg, (Throwable)ex);
            }
        }
    }

    private void updateOrInsert(SubMonitor monitor, Map<String, SPInfo> procs, Set<String> existingProcNames, boolean update, ServerType engine) throws EZSourceConnectionException {
        ArrayList<SPInfo> spList = new ArrayList<SPInfo>(procs.values());
        if (!spList.isEmpty()) {
            Collections.sort(spList, this.spComp);
            if (update) {
                for (SPInfo sp : spList) {
                    if ((ServerType.Db2Z.equals((Object)engine) || ServerType.Db2.equals((Object)engine)) && sp.getType().equalsIgnoreCase("PROCEDURE")) {
                        L.debug("not try DROP for {}, UPDATE will be used", (Object)sp.getSpName());
                    } else {
                        this.doDrop(sp, engine, false);
                    }
                    monitor.subTask(Messages.getString(VersioningUtils.class, "upgrading.info", new String[]{sp.getSpName()}));
                }
                monitor.worked(1);
            }
            RuntimeException ex = null;
            SPInfo spErr = null;
            this.conn.beginTransaction();
            try {
                Iterator spIt = spList.iterator();
                while (spIt.hasNext() && ex == null) {
                    SPInfo sp = (SPInfo)spIt.next();
                    try {
                        this.doUpdateOrInsert(sp, existingProcNames, engine, update);
                    }
                    catch (RuntimeException err) {
                        ex = err;
                        spErr = sp;
                        L.error("error at update/insert of {}: {}", new Object[]{sp.getType(), sp.getSpName(), err});
                    }
                    monitor.worked(1);
                }
                if (ex != null) {
                    this.conn.voteRollbackTransaction();
                } else {
                    this.conn.voteCommitTransaction();
                }
            }
            finally {
                this.conn.endTransaction();
            }
            if (ex != null) {
                String errMsg = "Error trying to update/insert of " + spErr.getType() + " named: " + spErr.getSpName();
                throw new EZSourceConnectionException(errMsg, (Throwable)ex);
            }
        }
    }

    private void doUpdateOrInsert(SPInfo sp, Set<String> existingProcNames, ServerType engine, boolean update) throws EZSourceConnectionException {
        String preparedSource = this.prepareSource(sp, engine);
        if (preparedSource == null || preparedSource.isEmpty()) {
            L.warn("cannot load query for sp: {}; skip it!", (Object)sp.getSpName());
        } else {
            L.debug("executing query for sp: {}", (Object)sp.getSpName());
            this.conn.executeUpdate(preparedSource);
            L.debug("done.");
            StringBuffer upgradeQuery = new StringBuffer();
            if (update && existingProcNames.contains(sp.getSpName().toUpperCase())) {
                L.debug("updating {} metadata", (Object)sp.getSpName());
                upgradeQuery.append("update EZReportsStoredProcedures set ");
                upgradeQuery.append("Version='");
                upgradeQuery.append(sp.getSpVersion().toString());
                upgradeQuery.append("' where Name='");
                upgradeQuery.append(sp.getSpName());
                upgradeQuery.append("'");
            } else {
                L.debug("inserting {} metadata", (Object)sp.getSpName());
                upgradeQuery.append("insert into EZReportsStoredProcedures values ('");
                upgradeQuery.append(sp.getSpName());
                upgradeQuery.append("', '");
                upgradeQuery.append(sp.getSpVersion().toString());
                upgradeQuery.append("')");
            }
            L.debug("updating metadata: {}", (Object)upgradeQuery.toString());
            this.conn.executeInsert(upgradeQuery.toString());
            L.debug("done.");
        }
    }

    private void doDrop(SPInfo sp, ServerType engine, boolean useChoices) throws EZSourceConnectionException {
        this.conn.beginTransaction();
        try {
            StringBuffer dropStatement = new StringBuffer();
            String[] choices = null;
            if (engine.equals((Object)ServerType.Access)) {
                choices = new String[]{"VIEW"};
            } else if (useChoices) {
                choices = sp.databaseObjTypes != null && !sp.databaseObjTypes.isEmpty() ? sp.databaseObjTypes.toArray(new String[0]) : new String[]{};
                if (choices == null) {
                    choices = new String[]{"VIEW", "PROCEDURE", "TABLE", "FUNCTION"};
                }
            } else {
                choices = new String[]{sp.getType()};
            }
            int i = 0;
            while (i < choices.length) {
                dropStatement.delete(0, dropStatement.length());
                dropStatement.append("drop ").append(choices[i]);
                dropStatement.append(" ");
                dropStatement.append(sp.getSpName());
                L.debug("doing a safeDrop for {}", (Object)sp.getSpName());
                L.debug("drop stmt: {}", (Object)dropStatement.toString());
                try {
                    this.conn.executeUpdate(dropStatement.toString());
                    L.debug("dropStatement {} was ok", (Object)dropStatement);
                    break;
                }
                catch (EZSourceConnectionException eZSourceConnectionException) {
                    L.debug("dropStatement: {} did not work", (Object)dropStatement);
                    ++i;
                }
            }
            this.conn.voteCommitTransaction();
        }
        finally {
            this.conn.endTransaction();
        }
    }

    private String prepareSource(SPInfo sp, ServerType engine) {
        String source = this.getSPSource(sp, engine);
        StringBuffer prepared = new StringBuffer();
        if (source != null && !source.isEmpty()) {
            boolean replaceExisting = false;
            if (ServerType.Db2Z.equals((Object)engine) && sp.getAction() == 3) {
                if (sp.databaseObjTypes != null && !sp.databaseObjTypes.isEmpty() && sp.getType().equalsIgnoreCase("PROCEDURE")) {
                    this.testSPInfo(sp);
                    replaceExisting = true;
                    prepared.append("ALTER");
                } else {
                    prepared.append("CREATE");
                }
            } else if (ServerType.Db2.equals((Object)engine) && (sp.getType().equalsIgnoreCase("PROCEDURE") || sp.getType().equalsIgnoreCase("VIEW"))) {
                prepared.append("CREATE OR REPLACE");
                L.debug("CREATE OR REPLACE ", (Object)sp.getType());
            } else {
                prepared.append("CREATE");
            }
            prepared.append(" ");
            if (ServerType.Access.equals((Object)engine)) {
                prepared.append("PROCEDURE");
            } else {
                prepared.append(sp.getType());
            }
            prepared.append(" ");
            prepared.append(sp.getSpName()).append(" ");
            if (replaceExisting) {
                prepared.append("REPLACE ACTIVE VERSION ");
            }
            if (ServerType.Access.equals((Object)engine)) {
                int idx = source.toUpperCase().indexOf("AS");
                StringBuffer sb = new StringBuffer(source.substring(idx));
                int len = sb.length();
                int i = 0;
                boolean word = false;
                while (i < len) {
                    if (sb.charAt(i) == '@') {
                        sb.deleteCharAt(i);
                        sb.insert(i, '[');
                        word = true;
                    } else if (word && !Character.isLetterOrDigit(sb.charAt(i)) && sb.charAt(i) != '_') {
                        word = false;
                        sb.insert(i, ']');
                        ++len;
                    }
                    ++i;
                }
                prepared.append(sb);
            } else {
                prepared.append(source);
            }
            if ((ServerType.Db2Z.equals((Object)engine) || ServerType.Db2.equals((Object)engine)) && "TABLE".equalsIgnoreCase(sp.getType())) {
                if (ServerType.Db2Z.equals((Object)engine)) {
                    String dbName = this.conn.getProjectInfo().getDatabaseInfo().getDatabase();
                    if (dbName == null) {
                        L.warn("DB2 z/OS project without database name!");
                    }
                    prepared.append(" IN DATABASE ").append(dbName);
                } else {
                    prepared.append(" IN TS_DATA INDEX IN TS_IDX ");
                }
                prepared.append(" COMPRESS YES ");
            }
        }
        L.debug("Object to create: ", (Object)prepared.toString());
        return prepared.toString();
    }

    private void testSPInfo(SPInfo sp) {
        if (!(sp.databaseObjTypes == null || sp.databaseObjTypes.isEmpty() || sp.databaseObjTypes.contains(sp.getType()) || sp.databaseObjTypes.contains(sp.getType().toUpperCase()))) {
            L.info("object with name {} has in app.prop type={} and in database: {}", new Object[]{sp.getSpName(), sp.getType(), sp.databaseObjTypes});
        }
    }

    private static boolean isAnyDb2Engine(int dbEngine) {
        return ServerType.Db2.getValue() == dbEngine || ServerType.Db2Z.getValue() == dbEngine;
    }

    private static boolean isDbEngineCompatible(SPInfo appInfo, int prjDbEngine) {
        int appDbEngine = appInfo.getDbEngine();
        return appDbEngine == 0 || appDbEngine == prjDbEngine || appInfo.getType().equalsIgnoreCase("TABLE") && ServerType.Db2Z.getValue() == appDbEngine && VersioningUtils.isAnyDb2Engine(prjDbEngine);
    }

    private SPChanges getSPChanges(Map<String, SPInfo> prjSPinfo, Map<String, SPInfo> appSPinfo, ApplicationType appType) {
        boolean revertDB = System.getProperties().containsKey("revertDB");
        SPChanges changes = new SPChanges();
        int dbEngineInt = this.getProjectDbEngine().getValue();
        for (String spName : appSPinfo.keySet()) {
            SPInfo prjSP;
            SPInfo appSP = appSPinfo.get(spName);
            if (!VersioningUtils.isDbEngineCompatible(appSP, dbEngineInt)) continue;
            boolean considerProcedure = false;
            if (appSP.hasNoType()) {
                L.debug("procedure with no specific type {} will be ignored", (Object)spName);
            } else if (appSP.hasType(appType)) {
                if (prjSPinfo.containsKey(spName)) {
                    prjSP = prjSPinfo.get(spName);
                    if (appSP.newerThan(prjSP) || revertDB) {
                        L.debug("procedure (type: {}) needs update: {}", (Object)appType, (Object)spName);
                        considerProcedure = true;
                    } else if (!appSP.hasSameVersion(prjSP)) {
                        L.warn("procedure <{}> with type <{}> has an older version than in DB. It will be ignored", (Object)spName, (Object)appType);
                    } else {
                        L.trace("procedure <{}> with type <{}> has the same version", (Object)spName, (Object)appType);
                    }
                } else {
                    L.debug("{} procedure with {} type it wasn't in db; it will be added now", (Object)spName, (Object)appType);
                    considerProcedure = true;
                }
            } else {
                L.trace("{} it will be ignored; hasn't type: {}", (Object)spName, (Object)appType);
            }
            if (!considerProcedure) continue;
            switch (appSP.getAction()) {
                case 1: {
                    L.debug("toDrop: {}", (Object)spName);
                    changes.toDrop.put(spName, appSP);
                    break;
                }
                case 2: {
                    L.debug("toReplace: {}", (Object)spName);
                    changes.toReplace.put(spName, appSP);
                    break;
                }
                case 3: {
                    L.debug("toUpdate: {}", (Object)spName);
                    changes.toUpdate.put(spName, appSP);
                    break;
                }
                default: {
                    if (prjSPinfo.containsKey(spName)) {
                        prjSP = prjSPinfo.get(spName);
                        if (appSP.newerThan(prjSP) || revertDB) {
                            L.debug("to update: {}", (Object)spName);
                            changes.toUpdate.put(spName, appSP);
                            break;
                        }
                        L.debug("ignore: {}", (Object)spName);
                        break;
                    }
                    L.debug("to Insert: {}", (Object)spName);
                    changes.toInsert.put(spName, appSP);
                }
            }
        }
        return changes;
    }

    private Map<String, SPInfo> getPrjSPInfo() {
        HashMap<String, SPInfo> prjMap = new HashMap<String, SPInfo>();
        try {
            String[][] procs = this.conn.executeSQL("select Name, Version from EZReportsStoredProcedures");
            if (procs != null) {
                int i = 0;
                while (i < procs.length) {
                    String name = procs[i][0];
                    Version version = new Version(procs[i][1].trim());
                    SPInfo currentSPInfo = (SPInfo)prjMap.get(name.toUpperCase());
                    if (currentSPInfo != null && currentSPInfo.getSpVersion() != null) {
                        Version currentVersion = currentSPInfo.getSpVersion();
                        if (currentVersion.compareTo(version) < 0) {
                            SPInfo spInfo = new SPInfo(name, version, null);
                            prjMap.put(name.toUpperCase(), spInfo);
                        }
                    } else {
                        SPInfo spInfo = new SPInfo(name, version, null);
                        prjMap.put(name.toUpperCase(), spInfo);
                    }
                    ++i;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("getPrjSPInfo()", (Throwable)e);
        }
        return prjMap;
    }

    void createTables() throws EZSourceConnectionException {
        L.debug("create project tables");
        ServerType engine = this.getProjectDbEngine();
        L.debug("engine: {}", (Object)engine);
        this.conn.beginTransaction();
        try {
            try {
                String str1 = "create table EZReports (EZViewerVersion char(20) not null, EZIntegrationVersion char(20) not null)";
                String str2 = "create table EZReportsStoredProcedures (Name varchar (200) NOT NULL, Version char(20) NOT NULL)";
                switch (engine) {
                    case Db2: 
                    case Db2Z: {
                        String dbName = this.conn.getProjectInfo().getDatabaseInfo().getDatabase();
                        if (dbName == null) {
                            L.warn("DB2 z/OS project without database name!");
                        }
                        str1 = String.valueOf(str1) + " IN DATABASE " + dbName;
                        str2 = String.valueOf(str2) + " IN DATABASE " + dbName;
                    }
                    case SqlServer: {
                        this.conn.executeUpdate(str1);
                        this.conn.executeInsert("insert into EZReports values ('0.0','0.0')");
                        this.conn.executeUpdate(str2);
                        break;
                    }
                    case Access: {
                        this.conn.executeUpdate(str1);
                        this.conn.executeInsert("insert into EZReports values ('0.0','0.0')");
                        this.conn.executeUpdate(str2);
                        break;
                    }
                    default: {
                        EZSourceConnectionException ex = new EZSourceConnectionException();
                        throw ex;
                    }
                }
                this.conn.voteCommitTransaction();
            }
            catch (EZSourceConnectionException ex) {
                L.error("create project tables error", (Throwable)ex);
                throw ex;
            }
        }
        finally {
            this.conn.endTransaction();
        }
        L.trace("tables created ok");
    }

    public Version getAppVersionInPrj(ApplicationType type) {
        L.debug("getting application version for the project");
        Version result = null;
        String colName = type.getColumnName();
        int tryAgain = 0;
        while (tryAgain < 2) {
            String sql = String.format("select %s from EZReports", colName);
            try {
                String[][] rez = this.conn.executeSQL(sql);
                if (rez != null) {
                    L.trace("{}", (Object)rez[0][0]);
                    result = new Version(rez[0][0].trim());
                } else {
                    L.trace("EZReports table does not exists");
                    result = new Version("0.0");
                }
                tryAgain = 100;
            }
            catch (EZSourceConnectionException e) {
                L.warn("EZReports table is not available; tryAgain={}", (Object)tryAgain, (Object)e);
                tryAgain = 2;
                colName = ApplicationType.NoType.getColumnName();
            }
        }
        return result;
    }

    public String getPrjTypeInfo() {
        String result;
        block16: {
            result = null;
            boolean lockAcquired = false;
            try {
                try {
                    if (!VersioningUtils.acquireLock(this.conn, LockType.Shared)) break block16;
                    lockAcquired = true;
                    L.info("getting project type informations");
                    try {
                        String[][] rez = this.conn.executeSQL("select * from ProjectType");
                        result = "";
                        if (rez != null && rez.length > 0) {
                            result = rez[0][0];
                            L.info("prjInfo={}", (Object)result);
                        } else {
                            L.warn("ProjectType table is empty!");
                        }
                    }
                    catch (EZSourceConnectionException e) {
                        L.warn("ProjectType table is not available", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    L.error("cannot acquire lock", (Throwable)e);
                    if (!lockAcquired) break block16;
                    try {
                        this.conn.releaseProjectLock();
                    }
                    catch (Exception e2) {
                        L.error("could not release lock", (Throwable)e2);
                    }
                }
            }
            finally {
                if (lockAcquired) {
                    try {
                        this.conn.releaseProjectLock();
                    }
                    catch (Exception e) {
                        L.error("could not release lock", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private void initPrjTypeTable(long value, boolean shouldCreate) throws EZSourceConnectionException {
        L.debug("create project type table");
        this.conn.beginTransaction();
        try {
            try {
                if (shouldCreate) {
                    this.conn.executeUpdate("CREATE TABLE ProjectType (PjType INT NOT NULL)");
                    L.debug("project type table created ok");
                }
                String q = String.format("insert into ProjectType values ('%s')", value);
                this.conn.executeInsert(q);
                L.debug("{} was inserted into project type table", (Object)value);
                this.conn.voteCommitTransaction();
            }
            catch (EZSourceConnectionException ex) {
                L.error("create project type table error", (Throwable)ex);
                throw ex;
            }
        }
        finally {
            this.conn.endTransaction();
        }
        L.debug("project type table was created and value: {} was inserted", (Object)value);
    }

    private void checkTemp2Table() throws EZSourceConnectionException {
    }

    boolean canOpen() {
        boolean ret = false;
        L.debug("verify EZSource table schema");
        try {
            String[][] rez = this.conn.executeSQL("select * from Version");
            String strVersion = rez[0][0];
            L.trace("{}", (Object)strVersion);
            Version dbVers = null;
            if (strVersion.indexOf(" ") > -1) {
                String[] parts = strVersion.split("\\ ", 0);
                if (parts.length > 1) {
                    dbVers = new Version(parts[1].trim(), (Integer)3);
                }
            } else {
                dbVers = new Version(strVersion.trim());
            }
            if (dbVers != null) {
                Version minVersion = new Version(EZSOURCE_DBVERSION, (Integer)3);
                if (dbVers.compareTo(minVersion) >= 0) {
                    L.trace("accepted database; version={}", (Object)dbVers);
                    ret = true;
                } else {
                    L.warn("database is too old (dbVersion={}, minVersion={})", (Object)dbVers, (Object)minVersion);
                }
            } else {
                L.error("cannot find database version! {} ", (Object)strVersion);
            }
        }
        catch (EZSourceConnectionException e) {
            L.debug("Version table is not available; open project in AD Build Client first", (Throwable)e);
        }
        return ret;
    }

    private static void releaseLock(EZSourceConnection conn) {
        try {
            conn.releaseProjectLock();
        }
        catch (Exception e) {
            L.error("could not release project lock", (Throwable)e);
        }
    }

    private void loadTablesProperties() {
        if (this.tbls == null) {
            block21: {
                this.tbls = new Properties();
                this.tablesInfo = new HashMap<String, SPInfo>();
                InputStream inStream = null;
                try {
                    try {
                        inStream = VersioningUtils.class.getResourceAsStream("tables.properties");
                        this.tbls.load(inStream);
                    }
                    catch (IOException e) {
                        L.error("loadTablesProperties()", (Throwable)e);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e2) {
                                L.warn("could not close tablesProps stream", (Throwable)e2);
                            }
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            L.warn("could not close tablesProps stream", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close tablesProps stream", (Throwable)e);
                    }
                }
            }
            int count = Integer.parseInt(this.tbls.getProperty("tables.count", "0"));
            int i = 1;
            while (i < count + 1) {
                String spName = this.tbls.getProperty("t." + i + ".name");
                if (spName != null && !spName.trim().equals("")) {
                    String spVerProperty = this.tbls.getProperty("t." + i + ".version");
                    Version spVersion = new Version(spVerProperty);
                    String spFile = this.tbls.getProperty("t." + i + ".file");
                    SPInfo spInfo = new SPInfo(spName, spVersion, spFile);
                    spInfo.setId(i);
                    spInfo.setType("TABLE");
                    String action = this.tbls.getProperty("t." + i + ".action", "change");
                    spInfo.setAction(action);
                    String dbType = this.tbls.getProperty("t." + i + ".dbType");
                    if (dbType != null) {
                        spInfo.setDbEngine(Integer.valueOf(dbType));
                    }
                    HashSet<ApplicationType> appTypes = new HashSet<ApplicationType>();
                    String apps = this.tbls.getProperty("t." + i + ".applications");
                    if (apps != null) {
                        String[] parts = apps.split(",");
                        int j = 0;
                        while (j < parts.length) {
                            String appName = parts[j].trim();
                            ApplicationType t = ApplicationType.getByValue(appName);
                            appTypes.add(t);
                            ++j;
                        }
                    } else {
                        L.info("table {} is used in all applications", (Object)spName);
                    }
                    spInfo.setApplications(appTypes);
                    this.tablesInfo.put(spName.toUpperCase(), spInfo);
                }
                ++i;
            }
        }
    }

    private Map<String, SPInfo> getAppTablesInfo() {
        this.loadTablesProperties();
        return this.tablesInfo;
    }

    public String[] getVersions(ApplicationType appType) {
        String clientV = ApplicationType.EZViewer.equals((Object)appType) ? this.getAppVersion(appType).toString() : null;
        String batchV = ApplicationType.EZIntegration.equals((Object)appType) ? this.getAppVersion(appType).toString() : null;
        return new String[]{EZSOURCE_DBVERSION, clientV, batchV};
    }

    class SPChanges {
        public Map<String, SPInfo> toUpdate = new HashMap<String, SPInfo>();
        public Map<String, SPInfo> toInsert = new HashMap<String, SPInfo>();
        public Map<String, SPInfo> toDrop = new HashMap<String, SPInfo>();
        public Map<String, SPInfo> toReplace = new HashMap<String, SPInfo>();

        SPChanges() {
        }
    }

    static enum UpgradeType {
        NONE,
        CREATE;

    }
}

