/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.versioning;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version
implements Comparable<Version> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(Version.class);
    private ArrayList<Integer> segments = new ArrayList();
    private int maxSegments = -1;
    private String versionString = null;

    public Version() {
        this("0.0");
    }

    public Version(String version) throws NumberFormatException {
        this(version, null);
        this.versionString = version;
    }

    public Version(Version version, Integer positions) throws NumberFormatException {
        this(version.versionString, positions);
    }

    public Version(String version, Integer positions) throws NumberFormatException {
        String[] sgs = version.split("\\.", 0);
        boolean parsed = false;
        try {
            int count = positions != null ? Math.min(positions, sgs.length) : sgs.length;
            int i = 0;
            while (i < count) {
                this.segments.add(new Integer(Integer.parseInt(sgs[i])));
                ++i;
            }
            if (count != sgs.length) {
                i = count;
                while (i < sgs.length) {
                    L.debug("this digit {} from version will be ignored on comparation", (Object)sgs[i]);
                    ++i;
                }
            }
            parsed = true;
        }
        finally {
            if (!parsed) {
                L.debug("clear segments");
                this.segments.clear();
            }
        }
    }

    @Override
    public int compareTo(Version other) {
        int max = Math.max(this.segments.size(), other.segments.size());
        int segs = Math.max(this.maxSegments, 0);
        max = (segs = Math.max(segs, other.maxSegments)) > 0 ? segs : max;
        Integer zero = new Integer(0);
        int result = 0;
        int i = 0;
        while (i < max) {
            Integer otherSegment;
            Integer thisSegment = i < this.segments.size() ? this.segments.get(i) : zero;
            result = thisSegment.compareTo(otherSegment = i < other.segments.size() ? other.segments.get(i) : zero);
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            throw new ClassCastException("cannot cast " + obj.getClass() + " to " + Version.class.getName());
        }
        return this.equals(obj);
    }

    public boolean equals(Version other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.segments.size()) {
            if (i != 0) {
                buf.append(".");
            }
            buf.append(this.segments.get(i));
            ++i;
        }
        return buf.toString();
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments > 0 ? maxSegments : -1;
    }

    public static void main(String[] args) {
        try {
            Version v1 = new Version();
            Version v2 = new Version("0.0.0.0");
            Version v3 = new Version("0.1.0");
            Version v4 = new Version("2.3");
            Version v5 = new Version("2.1");
            Version v6 = new Version("4");
            Version v7 = new Version("0.0.1.17");
            L.debug(v1 + " ? " + v2 + v1.compareTo(v2));
            L.debug(v1 + " ? " + v7 + v1.compareTo(v7));
            L.debug(v2 + " ? " + v3 + v2.compareTo(v3));
            L.debug(v3 + " ? " + v2 + v3.compareTo(v2));
            L.debug(v4 + " ? " + v5 + v4.compareTo(v5));
            L.debug(v5 + " ? " + v5 + v5.compareTo(v5));
            L.debug(v6 + " ? " + v5 + v6.compareTo(v5));
            L.debug(v7 + " ? " + v4 + v7.compareTo(v4));
            L.debug(v4 + " ? " + v6 + v4.compareTo(v6));
            L.debug(v7 + " ? " + v6 + v7.compareTo(v6));
            L.debug(v7 + " =? " + v2 + v7.equals(v2));
            L.debug(v1 + " =? " + v2 + v1.equals(v2));
            Version v8 = new Version("8.7.119.0");
            Version v9 = new Version("8.7.118");
            L.debug(v8 + " ? " + v9 + v8.compareTo(v9));
            Version v10 = new Version("8.7.119.38");
            L.debug(v10 + " ? " + v8 + v10.compareTo(v8));
            Version v11 = new Version("8.7.119.0", (Integer)3);
            Version v12 = new Version("8.7.119.38", (Integer)3);
            L.debug(v11 + " ? " + v12 + v11.compareTo(v12));
            Version v13 = new Version("8.7.118", (Integer)3);
            L.debug(v11 + " ? " + v13 + v11.compareTo(v13));
        }
        catch (NumberFormatException ex) {
            L.debug("should not happen");
            L.error("Error:", (Throwable)ex);
        }
        try {
            new Version("1,2");
        }
        catch (NumberFormatException numberFormatException) {
            L.debug("ok, got error");
        }
        try {
            new Version("1.a");
        }
        catch (NumberFormatException numberFormatException) {
            L.debug("ok, got error");
        }
        Version v10 = new Version("1.0.1");
        Version v11 = new Version("1.0.5");
        L.debug(v10 + " ? " + v11 + v10.compareTo(v11));
        v10.setMaxSegments(2);
        L.debug(v10 + " ? " + v11 + v10.compareTo(v11));
        v11.setMaxSegments(1);
        L.debug(v10 + " ? " + v11 + v10.compareTo(v11));
        v10.setMaxSegments(-1);
        L.debug(v10 + " ? " + v11 + v10.compareTo(v11));
        v11.setMaxSegments(-1);
        L.debug(v10 + " ? " + v11 + v10.compareTo(v11));
    }
}

