/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.versioning;

import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SPInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final int SP_ACTION_CHANGE = 0;
    public static final int SP_ACTION_DROP = 1;
    public static final int SP_ACTION_REPLACE = 2;
    public static final int SP_ACTION_UPDATE = 3;
    public static final String SP_TYPE_TABLE = "TABLE";
    public static final String SP_TYPE_VIEW = "VIEW";
    public static final String SP_TYPE_PROCEDURE = "PROCEDURE";
    public static final String SP_TYPE_FUNCTION = "FUNCTION";
    private String spName;
    private int action;
    private Version spVersion;
    private String spFile;
    private String type;
    private List<String> params;
    private int id;
    private int dbEngine = 0;
    @Deprecated
    private boolean ucmdb = false;
    private Set<ApplicationType> applications = null;
    Set<String> databaseObjTypes = null;

    public SPInfo(String spName, Version spVersion, String spFile) {
        this.spName = spName;
        this.spVersion = spVersion;
        this.spFile = spFile;
    }

    public boolean newerThan(SPInfo compareTo) {
        boolean newer = this.spVersion.compareTo(compareTo.spVersion) > 0;
        return newer;
    }

    public boolean hasSameVersion(SPInfo compareTo) {
        boolean same = this.spVersion.compareTo(compareTo.spVersion) == 0;
        return same;
    }

    public String getSpName() {
        return this.spName;
    }

    public Version getSpVersion() {
        return this.spVersion;
    }

    public String getSpFile() {
        return this.spFile;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addParam(String paramName) {
        if (this.params == null) {
            this.params = new ArrayList<String>();
        }
        this.params.add(paramName);
    }

    public List<String> getParams() {
        return this.params;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(this.spName).append(", ");
        buf.append(this.spVersion).append(", ").append(this.spFile);
        buf.append("]");
        return buf.toString();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setAction(String saction) {
        if (saction.equalsIgnoreCase("change")) {
            this.action = 0;
        }
        if (saction.equalsIgnoreCase("drop")) {
            this.action = 1;
        }
        if (saction.equalsIgnoreCase("replace")) {
            this.action = 2;
        }
        if (saction.equalsIgnoreCase("update")) {
            this.action = 3;
        }
    }

    public int getAction() {
        return this.action;
    }

    public int getDbEngine() {
        return this.dbEngine;
    }

    public void setDbEngine(int dbEngine) {
        this.dbEngine = dbEngine;
    }

    public boolean onlyOnUCMDB() {
        return this.ucmdb;
    }

    public void setOnlyOnUCMDB(boolean isUcmdb) {
        this.ucmdb = isUcmdb;
    }

    public void setApplications(Set<ApplicationType> appTypes) {
        this.applications = appTypes;
    }

    public boolean hasType(ApplicationType appType) {
        boolean vb = this.applications.contains((Object)appType);
        return vb;
    }

    public boolean hasNoType() {
        return this.applications == null || this.applications.isEmpty();
    }

    public Collection<ApplicationType> getApplicationTypes() {
        return new HashSet<ApplicationType>(this.applications);
    }

    public void addObjType(String type) {
        if (this.databaseObjTypes == null) {
            this.databaseObjTypes = new HashSet<String>();
        }
        this.databaseObjTypes.add(type);
    }
}

