/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.versioning;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegQuery {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(RegQuery.class);
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String NETWORK_DRIVE_CMD1 = "reg query \"HKCU\\Network\\";
    private static final String NETWORK_DRIVE_CMD2 = "\" /v RemotePath";
    private static final String PERSONAL_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v Personal";
    private static final String CPU_SPEED_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ~MHz";
    private static final String CPU_NAME_CMD = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString";

    public static String getFullNetworkPath(String letter) {
        int p;
        String result;
        block3: {
            try {
                String cmd = NETWORK_DRIVE_CMD1 + letter + NETWORK_DRIVE_CMD2;
                L.debug(cmd);
                Process process = Runtime.getRuntime().exec(cmd);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf(REGSTR_TOKEN);
                if (p != -1) break block3;
                return null;
            }
            catch (Exception e) {
                L.error("", (Throwable)e);
                return null;
            }
        }
        return result.substring(p + REGSTR_TOKEN.length()).trim();
    }

    public static String getCurrentUserPersonalFolderPath() {
        int p;
        String result;
        block3: {
            try {
                Process process = Runtime.getRuntime().exec(PERSONAL_FOLDER_CMD);
                L.debug(PERSONAL_FOLDER_CMD);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf(REGSTR_TOKEN);
                if (p != -1) break block3;
                return null;
            }
            catch (Exception e) {
                L.error("", (Throwable)e);
                return null;
            }
        }
        return result.substring(p + REGSTR_TOKEN.length()).trim();
    }

    public static String getCPUSpeed() {
        int p;
        String result;
        block3: {
            try {
                Process process = Runtime.getRuntime().exec(CPU_SPEED_CMD);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf(REGDWORD_TOKEN);
                if (p != -1) break block3;
                return null;
            }
            catch (Exception e) {
                L.error("", (Throwable)e);
                return null;
            }
        }
        String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
        return Integer.toString(Integer.parseInt(temp.substring("0x".length()), 16) + 1);
    }

    public static String getCPUName() {
        int p;
        String result;
        block3: {
            try {
                Process process = Runtime.getRuntime().exec(CPU_NAME_CMD);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf(REGSTR_TOKEN);
                if (p != -1) break block3;
                return null;
            }
            catch (Exception e) {
                L.error("", (Throwable)e);
                return null;
            }
        }
        return result.substring(p + REGSTR_TOKEN.length()).trim();
    }

    public static void main(String[] s) {
        L.debug("Personal directory : " + RegQuery.getCurrentUserPersonalFolderPath());
        L.debug("CPU Name : " + RegQuery.getCPUName());
        L.debug("CPU Speed : " + RegQuery.getCPUSpeed() + " Mhz");
        L.debug("Network path for Z: " + RegQuery.getFullNetworkPath("Z"));
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {}
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

