/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.versioning;

import com.ez.ezsource.connection.EZSourceAuthorizatonException;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.ezsource.versioning.ApplicationType;
import com.ez.ezsource.versioning.Version;
import com.ez.ezsource.versioning.VersioningUtils;
import com.ez.ezsource.versioning.internal.GuiErrorLog;
import com.ez.ezsource.versioning.internal.Messages;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(ProjectUtils.class);
    public static int OPEN_PROJECT_OP = 1000;
    public static int CLOSE_PROJECT_OP = 1001;
    static final int FLAG_FUJITSU = (int)Math.pow(2.0, 0.0);
    static final int FLAG_MVS = (int)Math.pow(2.0, 1.0);
    static final int FLAG_PL1 = (int)Math.pow(2.0, 2.0);
    static final int FLAG_NATURAL = (int)Math.pow(2.0, 3.0);
    static final int FLAG_VSE = (int)Math.pow(2.0, 4.0);
    static final int FLAG_PT_AS400_COBOL = (int)Math.pow(2.0, 5.0);
    static final int FLAG_PT_AS400_CL = (int)Math.pow(2.0, 6.0);
    static final int FLAG_PT_ASSEMBLER = (int)Math.pow(2.0, 7.0);
    static final int FLAG_PT_REXX = (int)Math.pow(2.0, 8.0);
    static final int FLAG_PT_ADS = (int)Math.pow(2.0, 9.0);
    static final int FLAG_DB_AIM = (int)Math.pow(2.0, 16.0);
    static final int FLAG_DB_ADABAS = (int)Math.pow(2.0, 17.0);
    static final int FLAG_DB_RELATIONAL = (int)Math.pow(2.0, 18.0);
    static final int FLAG_DB_IDMS = (int)Math.pow(2.0, 19.0);
    static final int FLAG_DB_IMS = (int)Math.pow(2.0, 20.0);
    static final int FLAG_DBT_DB400 = (int)Math.pow(2.0, 21.0);
    static final int FLAG_MPT_BMS = (int)Math.pow(2.0, 24.0);
    static final int FLAG_MPT_MFS = (int)Math.pow(2.0, 25.0);
    static final int FLAG_MPT_LNM = (int)Math.pow(2.0, 26.0);
    static final int FLAG_MPT_DDS = (int)Math.pow(2.0, 27.0);
    private static final String PRJ_TYPE_FILE_KEY = "PrjType";

    public static VersioningCodes openProject(IProgressMonitor pmonitor, String projectName, ApplicationType appType) throws EZSourceConnectionException {
        return ProjectUtils.openProject(pmonitor, projectName, appType, null);
    }

    public static VersioningCodes updateProject(IProgressMonitor pmonitor, EZSourceConnection conn, String projectName, ApplicationType appType) throws EZSourceConnectionException {
        VersioningCodes retur = VersioningCodes.NO_ERROR;
        if (pmonitor == null) {
            pmonitor = new NullProgressMonitor();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean ret = true;
        HashMap<String, String> opMap = new HashMap<String, String>();
        opMap.put("Project Name", projectName);
        try {
            Object[] msgParams = new String[]{projectName};
            monitor.setTaskName(Messages.getString(ProjectUtils.class, "openProject.task.name", msgParams));
            monitor.setWorkRemaining(100);
            VersioningUtils vutils = VersioningUtils.instance(conn);
            boolean prjCanBeOpened = vutils.canOpen();
            if (prjCanBeOpened) {
                VersioningUtils.UpgradeType shouldUpgrade = vutils.shouldUpgradeTables();
                Version prjVersion = new Version();
                if (shouldUpgrade.equals((Object)VersioningUtils.UpgradeType.NONE)) {
                    prjVersion = vutils.getAppVersionInPrj(appType);
                }
                Version currentVersion = vutils.getAppVersion(appType);
                monitor.worked(10);
                monitor.setWorkRemaining(50);
                int comp = prjVersion.compareTo(currentVersion);
                if (comp < 0) {
                    comp = -1;
                }
                if (comp > 0) {
                    comp = 1;
                }
                boolean revertDB = System.getProperties().containsKey("revertDB");
                boolean ignoreDBVersion = System.getProperties().containsKey("ignoreDBVersion");
                if (comp != 0 && ignoreDBVersion) {
                    comp = 0;
                    L.debug("Versioning mechanism will be ignored");
                }
                if (comp == 1 && revertDB) {
                    comp = -1;
                    L.debug("Database versioning will be reverted: {} -> {}", (Object)currentVersion, (Object)prjVersion);
                }
                switch (comp) {
                    case -1: {
                        L.debug("{} < {} application will update tables", (Object)prjVersion, (Object)currentVersion);
                        monitor.setTaskName(Messages.getString(ProjectUtils.class, "applicationupdate.task.name"));
                        ret = false;
                        ret = vutils.updatePrjData((IProgressMonitor)monitor, currentVersion, appType, shouldUpgrade);
                        if (ret) break;
                        retur = VersioningCodes.GENERIC_ERROR;
                        break;
                    }
                    case 0: {
                        L.debug("{} == {} project is open", (Object)prjVersion, (Object)currentVersion);
                        break;
                    }
                    case 1: {
                        Version prjV2 = new Version(prjVersion, (Integer)2);
                        Version currentV2 = new Version(currentVersion, (Integer)2);
                        int comp2 = prjV2.compareTo(currentV2);
                        if (comp2 == 0) {
                            L.warn("{} > {} application is obsolete but still compatible", (Object)prjV2, (Object)currentV2);
                            ret = true;
                            retur = VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE;
                            break;
                        }
                        L.error("{} > {} application is obsolete. User should update.", (Object)prjVersion, (Object)currentVersion);
                        L.debug("versions comparation at first two numbers is {}: db version {} and current client version {}", new Object[]{comp2, prjV2, currentV2});
                        ret = false;
                        retur = VersioningCodes.APPLICATION_OBSOLETE_ERROR;
                    }
                }
                if (ret) {
                    retur = ProjectUtils.verifyPrjTypeInfo(monitor, projectName, conn, retur);
                }
            } else {
                ret = false;
                retur = VersioningCodes.DATABASE_NEEDS_UPGRADE_ERROR;
                L.error("{}:{}", (Object)projectName, (Object)retur.getErrorMessage());
            }
            monitor.setWorkRemaining(0);
            monitor.done();
        }
        catch (EZSourceAuthorizatonException e) {
            L.error("operation not allowed");
            throw e;
        }
        catch (EZSourceConnectionException ex) {
            Object[] msgParams = new String[]{projectName, ex.getMessage()};
            String msg = Messages.getString(ProjectUtils.class, "unspecified.open.error", msgParams);
            L.error("error at update project {}", (Object)projectName, (Object)ex);
            EZSourceConnectionException newEx = new EZSourceConnectionException(msg, (Throwable)ex);
            ret = false;
            throw newEx;
        }
        return retur;
    }

    public static VersioningCodes openProject(IProgressMonitor pmonitor, String projectName, ApplicationType appType, Runnable onUpgrade) throws EZSourceConnectionException {
        VersioningCodes retur = VersioningCodes.NO_ERROR;
        if (pmonitor == null) {
            pmonitor = new NullProgressMonitor();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        boolean ret = true;
        boolean connIsOpened = false;
        EZSourceConnection conn = null;
        HashMap<String, String> opMap = new HashMap<String, String>();
        opMap.put("Project Name", projectName);
        try {
            try {
                conn = EZSourceConnectionManager.getCurrent();
                Object[] msgParams = new String[]{projectName};
                monitor.setTaskName(Messages.getString(ProjectUtils.class, "openProject.task.name", msgParams));
                monitor.setWorkRemaining(100);
                conn.setCurrentOperation(OPEN_PROJECT_OP, opMap);
                conn.openProject(projectName);
                conn.openConnection();
                connIsOpened = true;
                VersioningUtils vutils = VersioningUtils.instance(conn);
                boolean prjCanBeOpened = vutils.canOpen();
                if (prjCanBeOpened) {
                    VersioningUtils.UpgradeType shouldUpgrade = vutils.shouldUpgradeTables();
                    Version prjVersion = new Version();
                    if (shouldUpgrade.equals((Object)VersioningUtils.UpgradeType.NONE)) {
                        prjVersion = vutils.getAppVersionInPrj(appType);
                    }
                    Version currentVersion = vutils.getAppVersion(appType);
                    monitor.worked(10);
                    monitor.setWorkRemaining(50);
                    int comp = prjVersion.compareTo(currentVersion);
                    if (comp < 0) {
                        comp = -1;
                    }
                    if (comp > 0) {
                        comp = 1;
                    }
                    boolean revertDB = System.getProperties().containsKey("revertDB");
                    boolean ignoreDBVersion = System.getProperties().containsKey("ignoreDBVersion");
                    if (comp != 0 && ignoreDBVersion) {
                        comp = 0;
                        L.debug("Versioning mechanism will be ignored");
                    }
                    if (comp == 1 && revertDB) {
                        comp = -1;
                        L.debug("Database versioning will be reverted: {} -> {}", (Object)currentVersion, (Object)prjVersion);
                    }
                    switch (comp) {
                        case -1: {
                            L.debug("{} < {} application will update tables", (Object)prjVersion, (Object)currentVersion);
                            monitor.setTaskName(Messages.getString(ProjectUtils.class, "applicationupdate.task.name"));
                            ret = false;
                            ret = vutils.updatePrjData((IProgressMonitor)monitor, currentVersion, appType, shouldUpgrade);
                            if (onUpgrade == null) break;
                            try {
                                onUpgrade.run();
                            }
                            catch (Exception e) {
                                L.error("custom upgrade code had error", (Throwable)e);
                            }
                            break;
                        }
                        case 0: {
                            L.debug("{} == {} project is open", (Object)prjVersion, (Object)currentVersion);
                            break;
                        }
                        case 1: {
                            Version prjV2 = new Version(prjVersion, (Integer)2);
                            Version currentV2 = new Version(currentVersion, (Integer)2);
                            int comp2 = prjV2.compareTo(currentV2);
                            if (comp2 == 0) {
                                L.warn("{} > {} application is obsolete but still compatible", (Object)prjV2, (Object)currentV2);
                                ret = true;
                                retur = VersioningCodes.APPLICATION_OBSOLETE_BUT_COMPATIBLE;
                                break;
                            }
                            L.error("{} > {} application is obsolete. User should update.", (Object)prjVersion, (Object)currentVersion);
                            L.debug("versions comparation at first two numbers is {}: db version {} and current client version {}", new Object[]{comp2, prjV2, currentV2});
                            ret = false;
                            retur = VersioningCodes.APPLICATION_OBSOLETE_ERROR;
                        }
                    }
                    if (ret) {
                        retur = ProjectUtils.verifyPrjTypeInfo(monitor, projectName, conn, retur);
                    }
                } else {
                    ret = false;
                    retur = VersioningCodes.DATABASE_NEEDS_UPGRADE_ERROR;
                    L.error("{}:{}", (Object)projectName, (Object)retur.getErrorMessage());
                }
                monitor.setWorkRemaining(0);
                monitor.done();
            }
            catch (EZSourceAuthorizatonException e) {
                L.error("operation not allowed");
                throw e;
            }
            catch (EZSourceConnectionException ex) {
                Object[] msgParams = new String[]{projectName, ex.getMessage()};
                String msg = Messages.getString(ProjectUtils.class, "unspecified.open.error", msgParams);
                L.error("error at opening project {}", (Object)projectName, (Object)ex);
                EZSourceConnectionException newEx = new EZSourceConnectionException(msg, (Throwable)ex);
                ret = false;
                throw newEx;
            }
        }
        finally {
            try {
                if (connIsOpened) {
                    conn.closeConnection();
                }
            }
            finally {
                conn.unsetCurrentOperation(opMap);
                if (!ret) {
                    try {
                        conn.setCurrentOperation(CLOSE_PROJECT_OP, opMap);
                        conn.closeProject();
                    }
                    finally {
                        conn.unsetCurrentOperation(opMap);
                    }
                }
                EZSourceConnectionManager.release((EZSourceConnection)conn);
            }
        }
        return retur;
    }

    private static VersioningCodes verifyPrjTypeInfo(SubMonitor monitor, String projectName, EZSourceConnection conn, VersioningCodes retur) throws EZSourceConnectionException {
        boolean shouldCreate;
        ProjectInfo prjInfo = conn.getProjectInfo();
        long nr = 0L;
        VersioningCodes ret = retur;
        VersioningUtils vutils = VersioningUtils.instance(conn);
        String prjTypeInfo = vutils.getPrjTypeInfo();
        boolean bl = shouldCreate = prjTypeInfo == null;
        if (!shouldCreate && !prjTypeInfo.equals("")) {
            try {
                nr = Long.valueOf(prjTypeInfo);
            }
            catch (NumberFormatException ex) {
                L.error("wrong format for project type: {}", (Object)nr, (Object)ex);
                ret = VersioningCodes.WRONG_FORMAT_PROJECT_TYPE_ERROR;
            }
        }
        if (nr != 0L) {
            if (L.isDebugEnabled()) {
                ProjectUtils.printBinaryLong("", nr);
            }
        } else {
            ret = VersioningCodes.PROJECT_WITHOUT_TYPE_DEFINITION_ERROR;
        }
        String message = null;
        Object[] msgParams = new String[]{prjInfo.getProjectLocation() != null ? prjInfo.getProjectLocation() : projectName};
        switch (ret) {
            case PROJECT_FILE_NOT_FOUND_ERROR: {
                message = Messages.getString(ProjectUtils.class, "errorReadingPrjFile.log.text", msgParams);
                GuiErrorLog.err(message, null);
                break;
            }
            case WRONG_FORMAT_PROJECT_TYPE_ERROR: {
                message = Messages.getString(ProjectUtils.class, "errorWrongFormatPrjType.log.text", msgParams);
                GuiErrorLog.err(message, null);
                break;
            }
            case PROJECT_WITHOUT_TYPE_DEFINITION_ERROR: {
                break;
            }
        }
        return ret;
    }

    private static void printBinaryLong(String s, long l) {
        L.debug("-------print projectType -----------------");
        L.debug("{}, long: {}, binary: ", (Object)s, (Object)l);
        L.trace("   ");
        int i = 63;
        while (i >= 0) {
            if ((1L << i & l) != 0L) {
                L.trace("1");
            } else {
                L.trace("0");
            }
            --i;
        }
        L.debug("------------------------");
    }

    public static enum VersioningCodes {
        NO_ERROR{

            @Override
            public String getErrorMessage() {
                return null;
            }
        }
        ,
        APPLICATION_OBSOLETE_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.applicationobsolete");
            }
        }
        ,
        PROJECT_FILE_NOT_FOUND_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.projectfilenotfound");
            }
        }
        ,
        WRONG_FORMAT_PROJECT_TYPE_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.wrongformat");
            }
        }
        ,
        PROJECT_WITHOUT_TYPE_DEFINITION_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.projectwithoutdefinition");
            }
        }
        ,
        DATABASE_NEEDS_UPGRADE_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.needsupgrade", new Object[]{"8.7.122.3"});
            }
        }
        ,
        GENERIC_ERROR{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.genericerror");
            }
        }
        ,
        APPLICATION_OBSOLETE_BUT_COMPATIBLE{

            @Override
            public String getErrorMessage() {
                return Messages.getString(ProjectUtils.class, "versioning.message.client.compatible");
            }
        };


        public String getErrorMessage() {
            return Messages.getString(ProjectUtils.class, "versioning.message.projectgenericerror", new Object[]{this.ordinal()});
        }
    }
}

