/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.model;

public class LogMessage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    String message = "";
    int severity = 0;
    String pluginID = null;
    Throwable th = null;

    public LogMessage(String message, int severity, String pluginID, Throwable th) {
        this.message = message;
        this.severity = severity;
        this.pluginID = pluginID;
        this.th = th;
    }

    public LogMessage(String message, int severity, Throwable th) {
        this(message, severity, null, th);
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public Throwable getThrowable() {
        return this.th;
    }

    public String toString() {
        return "[" + this.getSeverityString() + ": " + this.message + "]";
    }

    private String getSeverityString() {
        switch (this.severity) {
            case 4: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Info";
            }
            case 0: {
                return "Ok";
            }
            case 8: {
                return "Cancel";
            }
        }
        return "Unknown severity";
    }
}

