/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.model;

import com.ez.common.model.BaseListable;
import java.io.Serializable;

public abstract class BaseResourceInput
implements BaseListable,
Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Integer type = new Integer(-1);
    protected Integer resourceID = new Integer(0);
    protected String odbRID = null;

    public String getOdbRID() {
        return this.odbRID;
    }

    public void setOdbRID(String odbRID) {
        this.odbRID = odbRID;
    }

    public Integer getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(Integer resourceID) {
        this.resourceID = resourceID;
    }

    public BaseResourceInput(String name) {
        this.name = name;
    }

    public BaseResourceInput(String name, String odbRID) {
        this.name = name;
        this.odbRID = odbRID;
    }

    public BaseResourceInput(String name, Integer type) {
        this(name);
        this.type = type;
    }

    public BaseResourceInput(String name, Integer type, Integer dbID) {
        this(name, type);
        this.resourceID = dbID;
    }

    public BaseResourceInput(String name, Integer type, Integer dbID, String odbRID) {
        this(name, type);
        this.resourceID = dbID;
        this.odbRID = odbRID;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getListableName() {
        return this.name;
    }

    @Override
    public Integer getTypeCode() {
        return this.type;
    }

    @Override
    public abstract String getTypeText();

    @Override
    public boolean hasType() {
        return !this.type.equals(new Integer(-1));
    }

    public int compareTo(Object o) {
        int res = 0;
        if (o instanceof BaseResourceInput) {
            BaseResourceInput other = (BaseResourceInput)o;
            res = this.name.compareTo(other.name);
            if (res == 0 && !this.type.equals(other.type)) {
                res = -this.type.compareTo(other.type);
            }
        }
        return res;
    }
}

