/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.source.utils;

import com.ez.analysis.mainframe.source.gui.ResultElement;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDDName;
import com.ez.internal.analysis.config.inputs.EZSourceInclude;
import com.ez.internal.analysis.config.inputs.EZSourceVariable;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.IMSDBAccessType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDBIIDSg;
import com.ez.workspace.model.segments.EZSourceDDNameIDSg;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceFileIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBSegmentIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDatabaseIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceQueueIDSg;
import com.ez.workspace.model.segments.EZSourceQueueManagerIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import java.util.HashSet;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void setPropertiesViewer(ResultElement resultElement, String name, String path, String programType) {
        if (programType.equals(ResultElementType.UTILITY.getDisplayName())) {
            GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(name, ResultElementType.UTILITY.getDisplayName());
            resultElement.addProperty("Node_Mainframe", prgNode);
        } else if (programType.equals(ResultElementType.LOAD_MODULE.getDisplayName())) {
            GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(name, ResultElementType.LOAD_MODULE.getDisplayName());
            resultElement.addProperty("Node_Mainframe", prgNode);
        } else {
            MainframeSourceNode prgNode = new MainframeSourceNode(programType, path);
            resultElement.addProperty("Node_Mainframe", prgNode);
        }
    }

    public static void setFileAttribute(ResultElement resultElement, String programTypeId, String path, Integer ... positionInfos) {
        TextSelectionInFile infoSel = new TextSelectionInFile(path, programTypeId, positionInfos);
        HashSet<TextSelectionInFile> infoSelSet = (HashSet<TextSelectionInFile>)resultElement.getProperty("FILE");
        if (infoSelSet == null) {
            infoSelSet = new HashSet<TextSelectionInFile>();
        }
        infoSelSet.add(infoSel);
        resultElement.addProperty("FILE", infoSelSet);
        resultElement.addProperty("GOTOSOURCE", true);
    }

    public static EZObjectType createApplicableInputType(ResultElement resultElement) {
        EZObjectType inputType = (EZObjectType)resultElement.getProperty("APPLICABLE_INPUT");
        if (inputType != null) {
            return inputType;
        }
        ProjectInfo pInfo = (ProjectInfo)resultElement.getProperty("ProjectInfo");
        EZSourceProgramIDSg resourceSg = null;
        EZEntityID temporarEntity = null;
        switch (resultElement.getType()) {
            case PROGRAM: {
                Integer programTypeId = (Integer)resultElement.getProperty("ProgramTypeID");
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programTypeId);
                resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                break;
            }
            case VARIABLE: {
                inputType = new EZSourceVariable();
                resourceSg = Utils.makeProgramSegment(inputType, resultElement);
                Integer level = (Integer)resultElement.getProperty("iLevel");
                Integer varID = (Integer)resultElement.getProperty("VarID");
                String isField = (String)resultElement.getProperty("IsField");
                String isFiller = (String)resultElement.getProperty("IsFiller");
                Integer varStartRow = (Integer)resultElement.getProperty("VarStartRow");
                String pic = (String)resultElement.getProperty("PIC");
                Integer father = (Integer)resultElement.getProperty("Father");
                Integer ancestor = (Integer)resultElement.getProperty("VarAncestor");
                String type = (String)resultElement.getProperty("VarTypeID");
                Integer prgRefId = (Integer)resultElement.getProperty("ProgIDReference");
                EZSourceVariableIDSg varSeg = new EZSourceVariableIDSg(resultElement.getName(), varID.toString(), String.valueOf(level), isField, isFiller, String.valueOf(varStartRow), pic, type, ancestor != null ? ancestor.toString() : null, prgRefId != null ? prgRefId.toString() : null, father != null ? father.toString() : null);
                inputType.addProperty("mainframe resource id sg", (Object)varSeg);
                temporarEntity = new EZEntityID();
                temporarEntity.addSegment((EZSegment)varSeg);
                temporarEntity.addSegment((EZSegment)Utils.makeProgramTypeIDSegment(resultElement));
                break;
            }
            case LOGICAL_NAME: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceFileIDSg(resultElement.getDisplayName(), 9);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                inputType.addProperty("logical file attribute", (Object)resultElement.getDisplayName());
                break;
            }
            case FILE: {
                if (pInfo.isVME()) {
                    inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                    resourceSg = new EZSourceFileIDSg(resultElement.getDisplayName(), 9);
                    inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                    if (resultElement.getProperty("isPhysicalFile attribute") == null) break;
                    inputType.addProperty("isPhysicalFile attribute", resultElement.getProperty("isPhysicalFile attribute"));
                    break;
                }
                inputType = new EZSourceDDName();
                String ddName = resultElement.getDisplayName();
                inputType.setName(ddName);
                resourceSg = new EZSourceDDNameIDSg(ddName);
                break;
            }
            case SQL_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceSQLTableIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                String propKey = "TableName";
                inputType.addProperty(propKey, resultElement.getProperty(propKey));
                propKey = "SqlTableId";
                inputType.addProperty(propKey, resultElement.getProperty(propKey));
                break;
            }
            case SQL_FIELD_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(187), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String propKey = "SqlFieldID";
                Integer fieldId = (Integer)resultElement.getProperty(propKey);
                inputType.addProperty(propKey, (Object)fieldId);
                propKey = "FieldName";
                String fieldName = (String)resultElement.getProperty(propKey);
                inputType.addProperty(propKey, (Object)fieldName);
                propKey = "TableName";
                String tableName = (String)resultElement.getProperty(propKey);
                inputType.addProperty(propKey, (Object)tableName);
                propKey = "SqlTableId";
                inputType.addProperty(propKey, resultElement.getProperty(propKey));
                resourceSg = new EZSourceSQLFieldTableIDSg(fieldName, fieldId, tableName);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case DAL: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(189), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceDALIDSg(resultElement.getDisplayName());
                String occurID = (String)resultElement.getProperty("OccurID");
                ((EZSourceDALIDSg)resourceSg).setVirtual(occurID);
                break;
            }
            case DBI_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(190), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                Integer dbiID = (Integer)resultElement.getProperty("ResourceID");
                resourceSg = new EZSourceDBIIDSg(dbiID, resultElement.getDisplayName());
                break;
            }
            case ADABAS_VIEW: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(62), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                ((EZSourceAdabasIDSg)resourceSg).setViewName((String)resultElement.getProperty("AdabasView"));
                break;
            }
            case ADABAS_FILE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(56), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                resourceSg.setNumber(((Integer)resultElement.getProperty("FileID")).intValue());
                ((EZSourceAdabasIDSg)resourceSg).setFileName((String)resultElement.getProperty("FileName"));
                break;
            }
            case ADABAS_DB: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(194), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceAdabasIDSg(resultElement.getDisplayName());
                ((EZSourceAdabasIDSg)resourceSg).setDbName((String)resultElement.getProperty("DBName"));
                break;
            }
            case IDMS_RECORD: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75));
                resourceSg = new EZSourceIDMSRecordIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case IDMS_SET: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76));
                resourceSg = new EZSourceIDMSSetIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case IMSDB_DATABASE: 
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FAST_PATH: 
            case IMSDB_FILE_ACCESS: 
            case IMSDB_LOGICAL: 
            case IMSDB_NOT_AVAILABLE: {
                Integer dbid = (Integer)resultElement.getProperty("IMSDBId");
                Integer dbtype = (Integer)resultElement.getProperty("IMSDBType");
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(18), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceIMSDatabaseIDSg(resultElement.getDisplayName());
                inputType.addProperty("IMSDB_DATABASE_TYPE", (Object)dbtype);
                inputType.addProperty("IMSDB_DATABASE_ID", (Object)dbid);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case INCLUDE: {
                Integer pathID = (Integer)resultElement.getProperty("IncludePathId");
                inputType = new EZSourceInclude();
                inputType.addProperty("include is not on disk", resultElement.getProperty("include is not on disk"));
                temporarEntity = new EZEntityID();
                temporarEntity.addSegment((EZSegment)Utils.makeProgramTypeIDSegment(resultElement));
                resourceSg = new EZSourceIncludeIDSg(resultElement.getDisplayName(), pathID);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case MQ_QUEUE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(81), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceQueueIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case MQ_MANAGER: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(79), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceQueueManagerIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case DATACOM_TABLE: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(182), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceDatacomTableIDSg(resultElement.getDisplayName());
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case BMS_MAP: {
                Integer bmsMapId = (Integer)resultElement.getProperty("BmsId");
                String bmsMapName = (String)resultElement.getProperty("BmsName");
                String occurId = (String)resultElement.getProperty("OccurID");
                String mapSet = (String)resultElement.getProperty("MapSet");
                Boolean isMapSet = (Boolean)resultElement.getProperty("IsMapSet");
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(6), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceScreenIDSg(bmsMapId, isMapSet != false ? null : bmsMapName, 119, Integer.valueOf(occurId));
                ((EZSourceScreenIDSg)resourceSg).setMapSet(isMapSet != false ? bmsMapName : mapSet);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(209), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                String dbName = (String)resultElement.getProperty("ResourceName");
                resourceSg = new EZSourceIMSDBSegmentIDSg(resultElement.getDisplayName(), dbName);
                Integer sid = (Integer)resultElement.getProperty("IMSDBSegmentID");
                if (sid != null) {
                    ((EZSourceIMSDBSegmentIDSg)resourceSg).setSegmentID(sid);
                }
                if (!resultElement.getType().equals((Object)ResultElementType.IMSDB_LOGICAL_SEGMENT)) break;
                inputType.addProperty("LOGICAL_SEGMENT_TYPE", (Object)true);
            }
        }
        if (inputType != null) {
            if (inputType.getName() == null) {
                inputType.setName(resultElement.getName());
            }
            if (resourceSg != null) {
                EZEntityID entityId = new EZEntityID();
                entityId.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
                entityId.addSegment((EZSegment)resourceSg);
                if (temporarEntity != null) {
                    entityId.addEntitySegments(temporarEntity);
                }
                inputType.setEntID(entityId);
            }
            resultElement.addProperty("APPLICABLE_INPUT", inputType);
        }
        return inputType;
    }

    private static EZSourceProgramIDSg makeProgramSegment(EZObjectType inpType, ResultElement resultElement) {
        Integer programId = (Integer)resultElement.getProperty("ProgramId");
        Integer programTypeId = (Integer)resultElement.getProperty("ProgramTypeID");
        String prgName = (String)resultElement.getProperty("ProgramName");
        if (prgName == null) {
            prgName = resultElement.getName();
        }
        String programPath = (String)resultElement.getProperty("ProgramPath");
        Boolean occur = null;
        if (programPath != null) {
            occur = !programPath.isEmpty();
        }
        inpType.addProperty("program occur", occur);
        EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(prgName, programId, programTypeId, occur);
        String ancestorName = (String)resultElement.getProperty("ProgramAncestor");
        prgSg.setAncestorName(ancestorName);
        return prgSg;
    }

    private static EZSourceProgramTypeIDSg makeProgramTypeIDSegment(ResultElement resultElement) {
        Integer programTypeId = (Integer)resultElement.getProperty("ProgramTypeID");
        return new EZSourceProgramTypeIDSg(programTypeId);
    }

    public static ResultElement getCategory(ResultElementType type, ResultElement parent, String forcedCategoryName) {
        ResultElement categoryResultElement;
        ResultElementType categoryType = null;
        switch (type) {
            case PROGRAM: {
                categoryType = ResultElementType.PROGRAM_CATEGORY;
                break;
            }
            case LOAD_MODULE: {
                categoryType = ResultElementType.LOAD_MODULE_CATEGORY;
                break;
            }
            case UTILITY: {
                categoryType = ResultElementType.UTILITY_CATEGORY;
                break;
            }
            case STMT_TYPE: {
                categoryType = ResultElementType.STMT_READ_WRITE_CATEGORY;
                break;
            }
            case VARIABLE: {
                categoryType = ResultElementType.VARIABLE_CATEGORY;
                break;
            }
            case PARAGRAPH: {
                categoryType = ResultElementType.PARAGRAPH_CATEGORY;
                break;
            }
            case SUBROUTINE: {
                categoryType = ResultElementType.SUBROUTINE_CATEGORY;
                break;
            }
            case PROCEDURE: {
                categoryType = ResultElementType.PROCEDURE_CATEGORY;
                break;
            }
            case INCLUDE: {
                categoryType = ResultElementType.INCLUDE_CATEGORY;
                break;
            }
            case MACRO: {
                categoryType = ResultElementType.MACRO_CATEGORY;
                break;
            }
            case ASSEMBLER_CSECT: {
                categoryType = ResultElementType.ASSEMBLER_CSECT_CATEGORY;
                break;
            }
            case ASSEMBLER_ENTRY: {
                categoryType = ResultElementType.ASSEMBLER_ENTRY_CATEGORY;
                break;
            }
            case IDMS_SET: {
                categoryType = ResultElementType.IDMS_SET_CATEGORY;
                break;
            }
            case IDMS_RECORD: {
                categoryType = ResultElementType.IDMS_RECORD_CATEGORY;
                break;
            }
            case JCL_JOB: {
                categoryType = ResultElementType.INVOKEDBY_CATEGORY;
                break;
            }
            case JCL_STEP: {
                categoryType = ResultElementType.STEP_CATEGORY;
                break;
            }
            case DATASET: {
                categoryType = ResultElementType.DATASET_CATEGORY;
                break;
            }
            case JCL_PROCEDURE: {
                categoryType = ResultElementType.JCL_PROCEDURE_CATEGORY;
                break;
            }
            case PARAMETER: {
                categoryType = ResultElementType.PARAMETER_CATEGORY;
                break;
            }
            case SCL_VARIABLE: {
                categoryType = ResultElementType.SCL_VARIABLE_CATEGORY;
                break;
            }
            case SCL_PROC_SYNONYM: {
                categoryType = ResultElementType.SCL_PROC_SYNONYM_CATEGORY;
                break;
            }
            case DDCL_ELEMENT_NAME: 
            case DDCL_ELEMENT: 
            case COBOL_OR_DDCL: {
                categoryType = ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY;
                break;
            }
            case IMSDB_TERMINAL: {
                categoryType = ResultElementType.IMSDB_TERMINAL_CATEGORY;
                break;
            }
            case IMSDB_DATABASE: {
                categoryType = ResultElementType.IMSDB_DATABASE_CATEGORY;
                break;
            }
            case IMSDB_FAST_PATH: {
                categoryType = ResultElementType.IMSDB_FAST_PATH_CATEGORY;
                break;
            }
            case IMSDB_FULL_FUNCTION: {
                categoryType = ResultElementType.IMSDB_FULL_FUNCTION_CATEGORY;
                break;
            }
            case IMSDB_FILE_ACCESS: {
                categoryType = ResultElementType.IMSDB_FILE_ACCESS_CATEGORY;
                break;
            }
            case IMSDB_LOGICAL: {
                categoryType = ResultElementType.IMSDB_LOGICAL_CATEGORY;
                break;
            }
            case IMSDB_NOT_AVAILABLE: {
                categoryType = ResultElementType.IMSDB_NOT_AVAILABLE_CATEGORY;
                break;
            }
            case ADABAS: {
                categoryType = ResultElementType.ADABAS_CATEGORY;
                break;
            }
            case BMS_MAP: {
                categoryType = ResultElementType.BMS_MAP_CATEGORY;
                break;
            }
            case DAL: {
                categoryType = ResultElementType.DAL_CATEGORY;
                break;
            }
            case DATACOM: {
                categoryType = ResultElementType.DATACOM_CATEGORY;
                break;
            }
            case DBI_TABLE: {
                categoryType = ResultElementType.DBI_CATEGORY;
                break;
            }
            case FILE: {
                categoryType = ResultElementType.FILE_CATEGORY;
                break;
            }
            case MQ_MANAGER: {
                categoryType = ResultElementType.MQ_MANAGER_CATEGORY;
                break;
            }
            case MQ_QUEUE: {
                categoryType = ResultElementType.MQ_QUEUE_CATEGORY;
                break;
            }
            case SQL_TABLE: {
                categoryType = ResultElementType.SQL_TABLE_CATEGORY;
            }
        }
        String categoryKey = forcedCategoryName;
        String categoryDisplayName = forcedCategoryName;
        if (forcedCategoryName == null) {
            categoryKey = categoryType.name();
            categoryDisplayName = categoryType.getDisplayName();
        }
        if ((categoryResultElement = parent.getChild(categoryKey)) == null) {
            categoryResultElement = new ResultElement(categoryDisplayName, categoryType, parent);
            parent.addChild(categoryKey, categoryResultElement);
        }
        return categoryResultElement;
    }

    public static ResultElementType getIMSDBType(Integer accessType) {
        IMSDBAccessType type = null;
        if (accessType != null) {
            IMSDBAccessType[] iMSDBAccessTypeArray = IMSDBAccessType.values();
            int n = iMSDBAccessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMSDBAccessType val = iMSDBAccessTypeArray[n2];
                if (val.ordinal() == accessType - 1) {
                    type = val;
                    break;
                }
                ++n2;
            }
        }
        if (type == null) {
            return ResultElementType.IMSDB_NOT_AVAILABLE;
        }
        switch (type) {
            case MSDB: 
            case DEDB: {
                return ResultElementType.IMSDB_FAST_PATH;
            }
            case HSAM: 
            case GSAM: 
            case SHSAM: {
                return ResultElementType.IMSDB_FILE_ACCESS;
            }
            case LOGICAL: {
                return ResultElementType.IMSDB_LOGICAL;
            }
        }
        return ResultElementType.IMSDB_FULL_FUNCTION;
    }
}

