/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.source.gui;

import com.ez.analysis.mainframe.source.Activator;
import com.ez.analysis.mainframe.source.gui.ResultElement;
import com.ez.analysis.mainframe.source.internal.Messages;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.Utils;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsTreeLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Logger L = LoggerFactory.getLogger(ResultsTreeLabelProvider.class);
    protected ImageRegistry registry;

    public ResultsTreeLabelProvider(ImageRegistry registry) {
        this.registry = registry;
    }

    public String getText(Object element) {
        return ((ResultElement)((Object)element)).getDisplayName();
    }

    public String getToolTipText(Object element) {
        String elemStr;
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String ret = null;
        String string = elemStr = re == null ? "" : re.getDisplayName();
        if (type == null) {
            ret = "";
        } else {
            ret = type.getDisplayName();
            if (type.isCategory()) {
                if (!ret.isEmpty()) {
                    String categoryText = Messages.getString(ResultsTreeLabelProvider.class, "tooltip.category.text");
                    ret = String.valueOf(ret) + " " + categoryText;
                } else {
                    L.warn("category type without displayName: {}", (Object)elemStr);
                    ret = elemStr;
                }
            } else {
                ret = ret.isEmpty() ? elemStr : String.valueOf(ret) + " - " + elemStr;
            }
        }
        if (ret.isEmpty()) {
            ret = Messages.getString(ResultsTreeLabelProvider.class, "no.results.tooltip.text");
        }
        return ResultsTreeLabelProvider.escapeText(ret);
    }

    protected static String escapeText(String text) {
        if (text.contains("&")) {
            text = text.replaceAll("&", "&&");
        }
        return text;
    }

    public Image getImage(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        Image img = null;
        if (type != null) {
            String reTypeString = type.name();
            if (type.equals((Object)ResultElementType.PROGRAM)) {
                Integer programTypeId = (Integer)re.getProperty("ProgramTypeID");
                reTypeString = Utils.getPrgType((String)programTypeId.toString());
            }
            if (type.equals((Object)ResultElementType.PROGRAM_CATEGORY)) {
                reTypeString = re.getName();
            }
            if (reTypeString.equals(ResultElementType.VARIABLE.name())) {
                Integer isCopy = (Integer)re.getProperty("IsCopy");
                reTypeString = String.valueOf(ResultElementType.VARIABLE.name()) + "_" + re.getProperty("ProgramTypeID") + (isCopy != 0 ? "_Include" : "_Program");
            }
            if ((img = this.registry.get(reTypeString)) == null && (img = this.createImage(re)) != null) {
                this.registry.put(reTypeString, img);
            }
        }
        return img;
    }

    protected Image createImage(ResultElement element) {
        Image ret = null;
        switch (element.getType()) {
            case PROGRAM: 
            case PROGRAM_CATEGORY: {
                ret = this.getImageByPrgTypeId(element);
                break;
            }
            case SQL_TABLE: 
            case SQL_TABLE_CATEGORY: 
            case DATACOM_CATEGORY: 
            case DATACOM_TABLE: {
                ret = Activator.getImageDescriptor("icons/SQLTable.png").createImage();
                break;
            }
            case SQL_FIELD_TABLE: {
                ret = Activator.getImageDescriptor("icons/SQLTableField.png").createImage();
                break;
            }
            case IMSDB_TERMINAL: {
                ret = Activator.getImageDescriptor("icons/imsdb_terminal.png").createImage();
                break;
            }
            case IMSDB_DATABASE: {
                ret = Activator.getImageDescriptor("icons/imsdb_database.png").createImage();
                break;
            }
            case IMSDB_TERMINAL_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsdb_terminal_group.png").createImage();
                break;
            }
            case IMSDB_DATABASE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsdb_database_group.png").createImage();
                break;
            }
            case IDMS_RECORD_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/idmsRecord.png").createImage();
                break;
            }
            case IDMS_SET_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/idmsSet.png").createImage();
                break;
            }
            case IDMS_SET: {
                ret = Activator.getImageDescriptor("icons/idmsSet.png").createImage();
                break;
            }
            case IDMS_RECORD: {
                ret = Activator.getImageDescriptor("icons/idmsRecord.png").createImage();
                break;
            }
            case FILE: {
                ret = Activator.getImageDescriptor("icons/dataset2_16x16.png").createImage();
                break;
            }
            case FILE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/datasets.png").createImage();
                break;
            }
            case VARIABLE_SECTION_TYPE: {
                ret = Activator.getImageDescriptor("icons/variablesection.png").createImage();
                break;
            }
            case VARIABLE: {
                Integer isCopy = (Integer)element.getProperty("IsCopy");
                if (isCopy != 0) {
                    ret = Activator.getImageDescriptor("icons/cobolVariableInInclude.png").createImage();
                    break;
                }
                ret = Activator.getImageDescriptor("icons/cobolVariable.png").createImage();
                break;
            }
            case VARIABLE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/cobolVariable.png").createImage();
                break;
            }
            case INCLUDE: 
            case INCLUDE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/include.png").createImage();
                break;
            }
            case LOGICAL_NAME: {
                ret = Activator.getImageDescriptor("icons/logicalname_16x16.png").createImage();
                break;
            }
            case MQ_MANAGER: 
            case MQ_MANAGER_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/queue_manager.png").createImage();
                break;
            }
            case MQ_QUEUE: 
            case MQ_QUEUE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/queue.png").createImage();
                break;
            }
            case ADABAS_DB: {
                ret = Activator.getImageDescriptor("icons/adabasDB.png").createImage();
                break;
            }
            case ADABAS_FILE: {
                ret = Activator.getImageDescriptor("icons/adabas_table.png").createImage();
                break;
            }
            case ADABAS_VIEW: 
            case ADABAS_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/adabas_view.png").createImage();
                break;
            }
            case DAL: 
            case DAL_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/dal_16X16.png").createImage();
                break;
            }
            case DBI_TABLE: 
            case DBI_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/dbi_16.png").createImage();
                break;
            }
            case BMS_MAP_CATEGORY: 
            case BMS_MAP: {
                ret = Activator.getImageDescriptor("icons/bms.png").createImage();
                break;
            }
            case IMSDB_LOGICAL: {
                ret = Activator.getImageDescriptor("icons/imsDB3.png").createImage();
                break;
            }
            case IMSDB_LOGICAL_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB3.png").createImage();
                break;
            }
            case IMSDB_FAST_PATH: 
            case IMSDB_FAST_PATH_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB1.png").createImage();
                break;
            }
            case IMSDB_FILE_ACCESS: 
            case IMSDB_FILE_ACCESS_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB4.png").createImage();
                break;
            }
            case IMSDB_FULL_FUNCTION: 
            case IMSDB_FULL_FUNCTION_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB2.png").createImage();
                break;
            }
            case IMSDB_NOT_AVAILABLE: 
            case IMSDB_NOT_AVAILABLE_CATEGORY: {
                ret = Activator.getImageDescriptor("icons/imsDB5.png").createImage();
                break;
            }
            case IMSDB_SEGMENT: 
            case IMSDB_LOGICAL_SEGMENT: {
                ret = Activator.getImageDescriptor("icons/RecordFormatMetaData161.gif").createImage();
            }
        }
        return ret;
    }

    protected Image getImageByPrgTypeId(ResultElement element) {
        Image ret;
        Integer programTypeId = (Integer)element.getProperty("ProgramTypeID");
        switch (programTypeId) {
            case 1: {
                ret = Activator.getImageDescriptor("icons/cobol.png").createImage();
                break;
            }
            case -1: {
                ret = Activator.getImageDescriptor("icons/cobol.png").createImage();
                break;
            }
            default: {
                ret = Activator.getImageDescriptor("icons/unknown.png").createImage();
            }
        }
        return ret;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

