/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.source.gui;

import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.results.comparator.VariableSectionTypeComparator;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import java.util.Comparator;
import java.util.HashMap;

public class ResultElement
extends AbstractResultElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PROGRAM_ID_KEY = "ProgramId";
    public static final String PROGRAM_NAME_KEY = "ProgramName";
    public static final String PROGRAM_TYPE_ID_KEY = "ProgramTypeID";
    public static final String PROGRAM_PATH_KEY = "ProgramPath";
    public static final String PROGRAM_START_ROW_KEY = "ProgStartRow";
    public static final String PROGRAM_START_COL_KEY = "ProgStartCol";
    public static final String PROGRAM_END_ROW_KEY = "ProgEndRow";
    public static final String PROGRAM_END_COL_KEY = "ProgEndCol";
    public static final String ANCESTOR_NAME_KEY = "ProgramAncestor";
    public static final String VAR_IS_COPY_KEY = "IsCopy";
    public static final String VAR_ID_KEY = "VarID";
    public static final String VAR_SECTION_TYPE_KEY = "VarSectionType";
    public static final String VAR_I_LEVEL_KEY = "iLevel";
    public static final String VAR_PIC_KEY = "PIC";
    public static final String VAR_IS_FIELD_KEY = "IsField";
    public static final String VAR_IS_FILLER_KEY = "IsFiller";
    public static final String VAR_TYPE_ID_KEY = "VarTypeID";
    public static final String VAR_PROG_ID_REF_KEY = "ProgIDReference";
    public static final String VAR_TYPE_DESCRIPTION_KEY = "VarTypeDescription";
    public static final String VAR_FATHER_KEY = "Father";
    public static final String VAR_ANCESTOR_KEY = "VarAncestor";
    public static final String VAR_START_ROW_KEY = "VarStartRow";
    public static final String VAR_START_COL_KEY = "VarStartCol";
    public static final String VAR_END_ROW_KEY = "VarEndRow";
    public static final String VAR_END_COL_KEY = "VarEndCol";
    public static final String VAR_PATH_STR_KEY = "VarPathStr";
    public static final String FILE_ID_KEY = "FileID";
    public static final String FILE_NAME_KEY = "FileName";
    public static final String SQL_TABLE_ID_KEY = "SqlTableId";
    public static final String SQL_TABLE_NAME_KEY = "TableName";
    public static final String SQL_TABLE_FIELD_ID_KEY = "SqlFieldID";
    public static final String SQL_TABLE_FIELD_NAME_KEY = "FieldName";
    public static final String RESOURCE_ID_KEY = "ResourceID";
    public static final String RESOURCE_NAME_KEY = "ResourceName";
    public static final String RESOURCE_OCCURID_KEY = "OccurID";
    public static final String ADABAS_VIEW_ID_KEY = "AdabasViewID";
    public static final String ADABAS_VIEW_NAME_KEY = "AdabasView";
    public static final String ADABAS_FILE_ID_KEY = "FileID";
    public static final String ADABAS_FILE_NAME_KEY = "FileName";
    public static final String ADABAS_DB_ID_KEY = "AdabasDBID";
    public static final String ADABAS_DB_NAME_KEY = "DBName";
    public static final String IMSDB_ID_KEY = "IMSDBId";
    public static final String IMSDB_NAME_KEY = "ResourceName";
    public static final String IMSDB_TYPE_KEY = "IMSDBType";
    public static final String IMSDB_SEGMENT_ID = "IMSDBSegmentID";
    public static final String INCLUDE_ID_KEY = "IncludeId";
    public static final String INCLUDE_NAME_KEY = "IncludeName";
    public static final String INCLUDE_PATH_ID_KEY = "IncludePathId";
    public static final String INCLUDE_PATH_STR_KEY = "IncludePathStr";
    public static final String INCLUDE_START_ROW_KEY = "IncludeStartRow";
    public static final String INCLUDE_START_COL_KEY = "IncludeStartCol";
    public static final String INCLUDE_END_ROW_KEY = "IncludeEndRow";
    public static final String INCLUDE_END_COL_KEY = "IncludeEndCol";
    public static final String BMS_MAP_ID_KEY = "BmsId";
    public static final String BMS_MAP_NAME_KEY = "BmsName";
    public static final String BMS_MAP_OCCUR_ID_KEY = "OccurID";
    public static final String BMS_MAP_SET_KEY = "MapSet";
    public static final String BMS_IS_MAP_SET_KEY = "IsMapSet";
    public static final String BMS_MAP_PATH_STR_KEY = "BmsPathStr";
    public static final String BMS_MAP_START_ROW_KEY = "BmsStartRow";
    public static final String BMS_MAP_START_COL_KEY = "BmsStartCol";
    public static final String BMS_MAP_END_ROW_KEY = "BmsEndRow";
    public static final String BMS_MAP_END_COL_KEY = "BmsEndCol";
    public static final String STMT_START_ROW_KEY = "StatementStartRow";
    public static final String STMT_PATH_STR_KEY = "StmtPathStr";

    public ResultElement(String name, ResultElementType type, ResultElement parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
    }

    public String getDisplayName() {
        Integer level;
        String ret = this.name;
        if (ResultElementType.VARIABLE.equals((Object)this.type) && (level = (Integer)this.getProperty(VAR_I_LEVEL_KEY)) != null) {
            ret = String.valueOf(String.format("%02d", level)) + " " + this.name;
        }
        return ret;
    }

    public ResultElement getParent() {
        return (ResultElement)this.parent;
    }

    public void addChild(String nameKey, ResultElement child) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        if (child != null) {
            this.children.put(nameKey, child);
        }
    }

    public ResultElement getChild(String childKey) {
        return (ResultElement)(this.children != null ? (AbstractResultElement)this.children.get(childKey) : null);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public int compareTo(AbstractResultElement o) {
        int ret = 0;
        if (o instanceof ResultElement) {
            ResultElement other = (ResultElement)o;
            if (ResultElementType.VARIABLE.equals((Object)this.type) && ResultElementType.VARIABLE.equals((Object)o.getType())) {
                if (Integer.valueOf(1).equals(this.getProperty(PROGRAM_TYPE_ID_KEY))) {
                    ret = this.commpareCobolVariableToCobolVariable(other);
                }
            } else if (ResultElementType.VARIABLE_SECTION_TYPE.equals((Object)this.type) && ResultElementType.VARIABLE_SECTION_TYPE.equals((Object)o.getType()) && Integer.valueOf(1).equals(this.getProperty(PROGRAM_TYPE_ID_KEY))) {
                ret = this.commpareCobolVariableSectionTypeToCobolVariableSectionType(other);
            }
            if (ret == 0) {
                ret = this.getDisplayName().compareToIgnoreCase(other.getDisplayName());
            }
        }
        return ret;
    }

    private int commpareCobolVariableToCobolVariable(ResultElement other) {
        SortingProperty[] sortingProperties = new SortingProperty[]{new SortingProperty(VAR_ID_KEY)};
        return this.compareToByProperties(other, sortingProperties);
    }

    private int commpareCobolVariableSectionTypeToCobolVariableSectionType(ResultElement other) {
        SortingProperty[] sortingProperties = new SortingProperty[]{new SortingProperty(VAR_SECTION_TYPE_KEY, (Comparator<Object>)new VariableSectionTypeComparator())};
        return this.compareToByProperties(other, sortingProperties);
    }

    private int compareToByProperties(ResultElement other, SortingProperty[] sortingProperties) {
        int retVal = 0;
        SortingProperty[] sortingPropertyArray = sortingProperties;
        int n = sortingProperties.length;
        int n2 = 0;
        while (n2 < n) {
            SortingProperty sortingPropery = sortingPropertyArray[n2];
            Object thisProperty = this.getProperty(sortingPropery.getPropertyName());
            Object otherProperty = other.getProperty(sortingPropery.getPropertyName());
            if (thisProperty != null && otherProperty != null) {
                if (!thisProperty.getClass().equals(otherProperty.getClass())) {
                    throw new IllegalStateException("unexpected state: properties are expected to be of the same type");
                }
                if (sortingPropery.getComparator() != null) {
                    retVal = sortingPropery.getComparator().compare(thisProperty, otherProperty);
                } else if (thisProperty instanceof Number) {
                    retVal = Double.valueOf(((Number)thisProperty).doubleValue()).compareTo(((Number)otherProperty).doubleValue());
                } else if (thisProperty instanceof String) {
                    retVal = ((String)thisProperty).compareTo((String)otherProperty);
                } else if (thisProperty instanceof Boolean) {
                    retVal = ((Boolean)thisProperty).compareTo((Boolean)otherProperty);
                } else {
                    throw new IllegalStateException("unexpected state: " + thisProperty.getClass() + " compare");
                }
            }
            if (retVal != 0) break;
            ++n2;
        }
        return retVal;
    }

    private static class SortingProperty {
        private final String propertyName;
        private final Comparator<Object> comparator;

        public SortingProperty(String propertyName) {
            this(propertyName, null);
        }

        public SortingProperty(String propertyName, Comparator<Object> comparator) {
            this.propertyName = propertyName;
            this.comparator = comparator;
        }

        public Comparator<Object> getComparator() {
            return this.comparator;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

