/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.source.cobol;

import com.ez.analysis.mainframe.source.Activator;
import com.ez.analysis.mainframe.source.annotations.CobolSourceAnnotationPartStateManager;
import com.ez.analysis.mainframe.source.cobol.MainframeSourceCobolDescriptor;
import com.ez.analysis.mainframe.source.gui.ElementAction;
import com.ez.analysis.mainframe.source.gui.ElementActionWithJob;
import com.ez.analysis.mainframe.source.gui.ResultElement;
import com.ez.analysis.mainframe.source.gui.ResultsTreeContentProvider;
import com.ez.analysis.mainframe.source.internal.Messages;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceLockException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.ProjectsListWrapper;
import com.ez.mainframe.gui.annotatedresults.AnnotatedResultsContentProvider;
import com.ez.mainframe.gui.annotatedresults.AnnotatedViewer;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.projects.utils.ExecutionExceptionHandler;
import com.ez.mainframe.projects.utils.ProjectUtils;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeSourceCobolViewer
extends AnnotatedViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeSourceCobolViewer.class);
    public static final String CONTEXT_PRJ_AND_PROGRAMS_KEY = "context projects and programs";
    private static final String SHOW_FILTERS_AREA_KEY = "show filters area";
    public static final String SOURCE_FILE_PATH_KEY = "source file path";
    public static final String START_LINE_KEY = "start line";
    public static final String END_LINE_KEY = "end line";
    protected static final String SELECTED_TEXT_KEY = "selected text in editor";
    public static final String PARENT_ELEMENT_KEY = "parent element";
    private static final String ROOT_ELEMENT_KEY = "root";
    private static final String HIDE_FILTERS_AREA_TOOLTIP = Messages.getString(MainframeSourceCobolViewer.class, "hide.filters.area.tooltip");
    private static final String SHOW_FILTERS_AREA_TOOLTIP = Messages.getString(MainframeSourceCobolViewer.class, "show.filters.area.tooltip");
    private final String EXPAND_ACTION_TEXT = Messages.getString(MainframeSourceCobolViewer.class, "expand.action.text");
    private static final int space5px = 5;
    private static final int space20px = 20;
    private MainframeSourceCobolDescriptor descriptor;
    private IActionManager manager;
    private ImageRegistry imgRegistry;
    private Label filtersSummary = null;
    private Text sourcePreviewText;
    private Button analyzeButton;
    private Combo contextCombo;
    private CustomProjectsList projectsList;
    private ElementActionWithJob linkEditor = null;
    private ElementAction expandNodeAction = null;
    private ActionContributionItem expandNodeActionContributionItem = null;
    private final String SHOW_SOURCE = Messages.getString(MainframeSourceCobolViewer.class, "goToSource.button");

    public MainframeSourceCobolViewer(MainframeSourceCobolDescriptor mainframeSourceCobolDescriptor) {
        this.descriptor = mainframeSourceCobolDescriptor;
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        manager.setCurrentContext(null);
        this.initImageRegistry(manager);
        final Composite mainPanel = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        mainPanel.setLayout((Layout)formLayout);
        final Button toggleFiltersButton = new Button(mainPanel, 2);
        this.filtersSummary = new Label(mainPanel, 0);
        this.filtersSummary.setText(Messages.getString(MainframeSourceCobolViewer.class, "filters.label"));
        final SashForm hSashMain = new SashForm(mainPanel, 512);
        Composite filtersMainArea = new Composite((Composite)hSashMain, 0);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        filtersMainArea.setLayout((Layout)formLayout);
        final Composite resultsArea = new Composite((Composite)hSashMain, 2048);
        formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        resultsArea.setLayout((Layout)formLayout);
        toggleFiltersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSourceCobolViewer.this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, resultsArea);
                mainPanel.layout();
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        toggleFiltersButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton, 0, 0x1000000);
        formData.left = new FormAttachment((Control)toggleFiltersButton, 5);
        this.filtersSummary.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toggleFiltersButton);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        hSashMain.setLayoutData((Object)formData);
        Boolean showFiltersArea = (Boolean)this.descriptor.getState().getData().get(SHOW_FILTERS_AREA_KEY);
        toggleFiltersButton.setSelection(showFiltersArea != null ? showFiltersArea : true);
        this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, resultsArea);
        this.completeFiltersMainArea(filtersMainArea);
        this.completeResultsArea(resultsArea);
        return mainPanel;
    }

    private void initImageRegistry(IActionManager manager) {
        if (this.imgRegistry == null) {
            this.imgRegistry = ((BrowserManager)manager).getImageRegistry();
        }
        if (this.imgRegistry.get("filtersCollapsed") == null) {
            this.imgRegistry.put("filtersCollapsed", Activator.getImageDescriptor("icons/collapsed_16.png"));
        }
        if (this.imgRegistry.get("filtersExpanded") == null) {
            this.imgRegistry.put("filtersExpanded", Activator.getImageDescriptor("icons/expanded_16.png"));
        }
    }

    private void showOrHideFiltersArea(Button toggleFiltersButton, SashForm hSashMain, Composite resultsArea) {
        if (toggleFiltersButton.getSelection()) {
            hSashMain.setMaximizedControl(null);
            toggleFiltersButton.setImage(this.imgRegistry.get("filtersExpanded"));
            toggleFiltersButton.setToolTipText(HIDE_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, true);
        } else {
            hSashMain.setMaximizedControl((Control)resultsArea);
            toggleFiltersButton.setImage(this.imgRegistry.get("filtersCollapsed"));
            toggleFiltersButton.setToolTipText(SHOW_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, false);
        }
    }

    private void completeFiltersMainArea(Composite filtersMainArea) {
        SashForm vSashFiltersArea = new SashForm(filtersMainArea, 256);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        vSashFiltersArea.setLayoutData((Object)formData);
        Composite leftFiltersArea = new Composite((Composite)vSashFiltersArea, 2048);
        Composite rightFiltersArea = new Composite((Composite)vSashFiltersArea, 2048);
        vSashFiltersArea.setWeights(new int[]{70, 30});
        this.createLeftFilterArea(leftFiltersArea);
        this.createProjectsArea(rightFiltersArea);
        this.enableOrDisableAnalyze();
    }

    private void createLeftFilterArea(Composite leftFiltersArea) {
        Font sourceTextFont = JFaceResources.getTextFont();
        FormLayout formLayout = new FormLayout();
        leftFiltersArea.setLayout((Layout)formLayout);
        Group sourceSelectionGroup = new Group(leftFiltersArea, 2048);
        sourceSelectionGroup.setText(Messages.getString(MainframeSourceCobolViewer.class, "sourceSelection.label"));
        formLayout = new FormLayout();
        sourceSelectionGroup.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        sourceSelectionGroup.setLayoutData((Object)formData);
        Label filePathLabel = new Label((Composite)sourceSelectionGroup, 0);
        filePathLabel.setText(Messages.getString(MainframeSourceCobolViewer.class, "filePath.label"));
        Text filePathValue = new Text((Composite)sourceSelectionGroup, 8);
        filePathValue.setToolTipText(Messages.getString(MainframeSourceCobolViewer.class, "filePath.tooltip"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)filePathValue, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        filePathLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment((Control)filePathLabel, 5);
        formData.right = new FormAttachment(100, -5);
        filePathValue.setLayoutData((Object)formData);
        Label startLineLabel = new Label((Composite)sourceSelectionGroup, 0);
        startLineLabel.setText(Messages.getString(MainframeSourceCobolViewer.class, "startLine.label"));
        Text startLineValue = new Text((Composite)sourceSelectionGroup, 8);
        startLineValue.setToolTipText(Messages.getString(MainframeSourceCobolViewer.class, "startLine.tooltip"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)startLineValue, 0, 0x1000000);
        formData.left = new FormAttachment(0, 5);
        startLineLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)filePathValue, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment((Control)startLineLabel, 5);
        startLineValue.setLayoutData((Object)formData);
        Label endLineLabel = new Label((Composite)sourceSelectionGroup, 0);
        endLineLabel.setText(Messages.getString(MainframeSourceCobolViewer.class, "endLine.label"));
        Text endLineValue = new Text((Composite)sourceSelectionGroup, 8);
        endLineValue.setToolTipText(Messages.getString(MainframeSourceCobolViewer.class, "endLine.tooltip"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)endLineValue, 0, 0x1000000);
        formData.left = new FormAttachment((Control)startLineValue, 5);
        endLineLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)startLineValue, 0, 0x1000000);
        formData.left = new FormAttachment((Control)endLineLabel, 5);
        endLineValue.setLayoutData((Object)formData);
        Label contextOf = new Label((Composite)sourceSelectionGroup, 0);
        contextOf.setText(Messages.getString(MainframeSourceCobolViewer.class, "contextOf.label"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)startLineValue, 0, 0x1000000);
        formData.left = new FormAttachment((Control)endLineValue, 20);
        contextOf.setLayoutData((Object)formData);
        this.contextCombo = new Combo((Composite)sourceSelectionGroup, 8);
        formData = new FormData();
        formData.top = new FormAttachment((Control)startLineValue, 0, 0x1000000);
        formData.left = new FormAttachment((Control)contextOf, 5);
        formData.right = new FormAttachment(100, -5);
        this.contextCombo.setLayoutData((Object)formData);
        Group sourceTextGroup = new Group(leftFiltersArea, 2048);
        sourceTextGroup.setText(Messages.getString(MainframeSourceCobolViewer.class, "sourceText.label"));
        sourceTextGroup.setLayout((Layout)new FillLayout());
        this.analyzeButton = new Button(leftFiltersArea, 0);
        this.analyzeButton.setText(Messages.getString(MainframeSourceCobolViewer.class, "analyze.label"));
        this.analyzeButton.setToolTipText(Messages.getString(MainframeSourceCobolViewer.class, "analyze.tooltip"));
        this.sourcePreviewText = new Text((Composite)sourceTextGroup, 778);
        this.sourcePreviewText.setFont(sourceTextFont);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sourceSelectionGroup, 5);
        formData.bottom = new FormAttachment((Control)this.analyzeButton, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        sourceTextGroup.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment(100, -5);
        this.analyzeButton.setLayoutData((Object)formData);
        this.loadFiltersDataFromContext(filePathValue, startLineValue, endLineValue);
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSourceCobolViewer.this.analyze();
            }
        });
    }

    private void createProjectsArea(Composite rightFiltersArea) {
        FormLayout formLayout = new FormLayout();
        rightFiltersArea.setLayout((Layout)formLayout);
        Group projectsGroup = new Group(rightFiltersArea, 2048);
        projectsGroup.setText(Messages.getString(MainframeSourceCobolViewer.class, "projectsGroup.label"));
        formLayout = new FormLayout();
        projectsGroup.setLayout((Layout)formLayout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        projectsGroup.setLayoutData((Object)formData);
        this.projectsList = new CustomProjectsList((Composite)projectsGroup, 2564);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.projectsList.getList().setLayoutData((Object)formData);
        this.projectsList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainframeSourceCobolViewer.this.updateSelectedProjectsList();
                MainframeSourceCobolViewer.this.updateSelectedComboList();
                MainframeSourceCobolViewer.this.enableOrDisableAnalyze();
            }
        });
        this.loadProjectsListFromContext();
    }

    private void completeResultsArea(Composite resultsArea) {
        Group resultsGroup = new Group(resultsArea, 2048);
        resultsGroup.setText(Messages.getString(MainframeSourceCobolViewer.class, "resultsGroup.label"));
        resultsGroup.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        resultsGroup.setLayoutData((Object)formData);
        this.buildTreeViewer((Composite)resultsGroup);
        Accessible accResultsGroup = resultsGroup.getAccessible();
        Accessible accTree = this.resultsTreeViewer.getTree().getAccessible();
        accTree.addRelation(10, accResultsGroup);
        accTree.addRelation(9, accResultsGroup);
        this.resultsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainframeSourceCobolViewer.this.handleResultElementSelection(event);
            }
        });
        this.resultsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                ResultElement resultElem = (ResultElement)((Object)thisSelection.getFirstElement());
                ElementActionWithJob action = MainframeSourceCobolViewer.this.makeLinkEditorAction(resultElem);
                if (action != null) {
                    action.run();
                }
            }
        });
        this.setInputForResultsTree(false);
        this.handleContextMenu();
    }

    private void enableOrDisableAnalyze() {
        boolean enable = true;
        this.descriptor.getState().getData();
        if (enable && this.projectsList.getList().getSelectionIndex() == -1) {
            enable = false;
        }
        if (enable && this.contextCombo.getSelectionIndex() == -1) {
            enable = false;
        }
        if (enable && this.sourcePreviewText.getText().isEmpty()) {
            enable = false;
        }
        this.analyzeButton.setEnabled(enable);
    }

    private void loadFiltersDataFromContext(Text filePathValue, Text startLineValue, Text endLineValue) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        if (filePath != null) {
            filePathValue.setText(filePath);
        }
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        if (startLine != null) {
            startLineValue.setText(startLine.toString());
            if (endLine != null && !endLine.equals(startLine)) {
                endLineValue.setText(endLine.toString());
            }
        }
        this.updateSourceTextPreview();
    }

    private void loadProjectsListFromContext() {
        Map data = this.descriptor.getState().getData();
        Map contextProjectsAndPrograms = (Map)data.get(CONTEXT_PRJ_AND_PROGRAMS_KEY);
        this.projectsList.setContext(contextProjectsAndPrograms);
        List allProjects = (List)data.get("projects");
        List mainframeProjects = ProjectUtils.filterMainframeProjectsOnly((List)allProjects);
        List inputProjects = (List)data.get("PROJECT_LIST");
        ProjectInfo inputProjectInfo = null;
        if (inputProjects != null && !inputProjects.isEmpty()) {
            inputProjectInfo = (ProjectInfo)inputProjects.get(0);
        }
        ArrayList<ProjectInfo> tmp = new ArrayList<ProjectInfo>();
        tmp.add(inputProjectInfo);
        this.projectsList.fill(mainframeProjects, tmp);
    }

    private void updateSelectedProjectsList() {
        Map data = this.descriptor.getState().getData();
        ArrayList<ProjectInfo> selectedProjectsList = (ArrayList<ProjectInfo>)data.get("PROJECT_LIST");
        if (selectedProjectsList == null) {
            selectedProjectsList = new ArrayList<ProjectInfo>();
            data.put("PROJECT_LIST", selectedProjectsList);
        }
        selectedProjectsList.clear();
        int index = this.projectsList.getList().getSelectionIndex();
        selectedProjectsList.add((ProjectInfo)this.projectsList.getList().getData(String.valueOf(index)));
    }

    private void updateSelectedComboList() {
        String selected;
        String[][] results;
        this.contextCombo.removeAll();
        Map data = this.descriptor.getState().getData();
        Map contextProjectsAndPrograms = (Map)data.get(CONTEXT_PRJ_AND_PROGRAMS_KEY);
        if (this.projectsList.getList().getSelectionCount() > 0 && (results = (String[][])contextProjectsAndPrograms.get(selected = new String(this.projectsList.getList().getSelection()[0]))) != null) {
            Arrays.sort(results, new Comparator<String[]>(){

                @Override
                public int compare(String[] firstRow, String[] secondRow) {
                    String name1 = firstRow[1];
                    String name2 = secondRow[1];
                    return name1.compareTo(name2);
                }
            });
            int i = 0;
            while (i < results.length) {
                this.contextCombo.setData(String.valueOf(String.valueOf(i)) + "id", (Object)results[i][0]);
                this.contextCombo.add(results[i][1]);
                this.contextCombo.setData(String.valueOf(String.valueOf(i)) + "type", (Object)results[i][2]);
                ++i;
            }
        }
        if (this.contextCombo.getItemCount() > 0) {
            this.contextCombo.select(0);
        }
    }

    private void updateSourceTextPreview() {
        String selectedSourceText = "";
        String sourceFilePath = (String)this.descriptor.getState().getData().get(SOURCE_FILE_PATH_KEY);
        if (sourceFilePath != null && !sourceFilePath.isEmpty()) {
            Integer startLine = (Integer)this.descriptor.getState().getData().get(START_LINE_KEY);
            Integer endLine = (Integer)this.descriptor.getState().getData().get(END_LINE_KEY);
            if (startLine != null) {
                endLine = endLine != null ? endLine : startLine;
                selectedSourceText = (String)this.descriptor.getState().getData().get(SELECTED_TEXT_KEY);
            }
        }
        this.sourcePreviewText.setText(selectedSourceText);
    }

    private void analyze() {
        final long startTime = System.currentTimeMillis();
        L.info("{} - start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()), (Object)this.descriptor.getAnalysisType().toString());
        Job j = new Job(Messages.getString(MainframeSourceCobolViewer.class, "job.analyze.source.text")){

            protected IStatus run(IProgressMonitor monitor) {
                MainframeSourceCobolViewer.this.analyzeSourceSelection(monitor);
                long duration = System.currentTimeMillis() - startTime;
                L.info("{} - duration: {} ms.", (Object)MainframeSourceCobolViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void analyzeSourceSelection(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "analyze.source.task.text"));
        Map data = this.descriptor.getState().getData();
        List selProjects = (List)data.get("PROJECT_LIST");
        ProjectInfo selectedPrjInfo = (ProjectInfo)selProjects.get(0);
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(selectedPrjInfo.getName(), null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)130);
                    monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.data.task.text"));
                    MainframeSourceCobolViewer.this.buildProgramElement(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildVariablesResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildFilesResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildSQLTablesAndFieldsResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildDalResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildDbiResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildAdabasResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildIDMSResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildIMSDBResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildIncludeResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildMQResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildDatacomResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.buildBMSMapResults(conn, (IProgressMonitor)monitor.newChild(10));
                    MainframeSourceCobolViewer.this.setInputForResultsTree(true);
                }
            }, LockType.Shared, (IProgressMonitor)monitor.newChild(100));
        }
        catch (InterruptedException e) {
            L.error("unexpected interrupt", (Throwable)e);
        }
        catch (ExecutionException e) {
            L.error("while getting data", (Throwable)e);
            ExecutionExceptionHandler.checkForEZSourceLockException((ExecutionException)e, (String)selectedPrjInfo.getName());
        }
        catch (EZSourceLockException e) {
            L.error("lock exception for project: {}", (Object)selectedPrjInfo.getName(), (Object)e);
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(MainframeSourceCobolViewer.class, "project.lock.exception.text", new String[]{selectedPrjInfo.getName()}), (Plugin)Activator.getDefault(), (boolean)false);
        }
        catch (Exception e) {
            L.error("could not retrieve data for project: {}", (Object)selectedPrjInfo.getName(), (Object)e);
        }
    }

    private void buildProgramElement(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.program.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        ResultElement programElement = null;
        ResultElement includeElement = null;
        boolean isInclude = false;
        final String[] selected = new String[2];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                selected[0] = (String)MainframeSourceCobolViewer.this.contextCombo.getData(String.valueOf(String.valueOf(MainframeSourceCobolViewer.this.contextCombo.getSelectionIndex())) + "id");
                selected[1] = (String)MainframeSourceCobolViewer.this.contextCombo.getData(String.valueOf(String.valueOf(MainframeSourceCobolViewer.this.contextCombo.getSelectionIndex())) + "type");
            }
        });
        String query = "SELECT \n\tB.ProgramID, \n\tB.ProgramName, \n\tB.ProgramTypeID, \n\tA.StartRow AS ProgramStartRow, \n\tA.StartCol AS ProgramStartCol, \n\tA.EndRow AS ProgramEndRow, \n\tA.EndCol AS ProgramEndCol, \n\tB.Ancestor \nFROM Occurrences A \n\tINNER JOIN ( \n\t\tSELECT P.ProgramID, PA.AliasName AS ProgramName, P.ProgramTypeID, P.OccurID, P.Ancestor \n\t\tFROM Programs P \n\t\t\tINNER JOIN ProgramAliases PA ON P.ProgramID = PA.ProgramId AND PA.AliasType = 0 \n\t) B ON A.OccurID = B.OccurID AND B.ProgramTypeID = 1 \nWHERE (B.ProgramID = ?) ";
        L.trace("query for program: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{selected[0]});
        if (results != null) {
            Integer programId = Integer.valueOf(results[0][0]);
            String programName = results[0][1];
            Integer programTypeId = Integer.valueOf(results[0][2]);
            programElement = new ResultElement(programName, ResultElementType.PROGRAM, null);
            programElement.addProperty("ProgramId", programId);
            programElement.addProperty("ProgramName", programName);
            programElement.addProperty("ProgramTypeID", programTypeId);
            programElement.addProperty("ProgramPath", filePath);
            Integer startRow = Integer.valueOf(results[0][3]);
            programElement.addProperty("ProgStartRow", startRow);
            Integer startCol = Integer.valueOf(results[0][4]);
            programElement.addProperty("ProgStartCol", startCol);
            Integer endRow = Integer.valueOf(results[0][5]);
            programElement.addProperty("ProgEndRow", endRow);
            Integer endCol = Integer.valueOf(results[0][6]);
            programElement.addProperty("ProgEndCol", endCol);
            programElement.addProperty("ProgramAncestor", results[0][7]);
            this.addPrjInfoToResultElement(programElement);
            String programType = Utils.getPrgType((String)programTypeId.toString());
            com.ez.analysis.mainframe.source.utils.Utils.setPropertiesViewer(programElement, programName, filePath, programType);
            com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(programElement, programTypeId.toString(), filePath, startRow, startCol, endRow, endCol);
            if (selected[1] != null) {
                includeElement = new ResultElement(selected[1], ResultElementType.INCLUDE, programElement);
                includeElement.addProperty("ProgramId", Integer.parseInt(selected[0]));
                includeElement.addProperty("ProgramTypeID", programTypeId);
                includeElement.addProperty("ProgramName", programName);
                includeElement.addProperty("ProgramPath", filePath);
                includeElement.addProperty("ProgStartRow", startRow);
                includeElement.addProperty("ProgStartCol", startCol);
                includeElement.addProperty("ProgEndRow", endRow);
                includeElement.addProperty("ProgEndCol", endCol);
                programElement.addChild(selected[1], includeElement);
                isInclude = true;
                this.addPrjInfoToResultElement(includeElement);
            }
        }
        data.put(ROOT_ELEMENT_KEY, programElement);
        if (isInclude) {
            data.put(PARENT_ELEMENT_KEY, includeElement);
        } else {
            data.put(PARENT_ELEMENT_KEY, programElement);
        }
    }

    private void setInputForResultsTree(boolean showNoResults) {
        ArrayList<ResultElement> topElements;
        Map data = this.descriptor.getState().getData();
        ResultElement rootElement = (ResultElement)((Object)data.get(ROOT_ELEMENT_KEY));
        if (showNoResults && rootElement == null) {
            rootElement = new ResultElement(Messages.getString(MainframeSourceCobolViewer.class, "no.results.text"), null, null);
        }
        if (rootElement != null) {
            topElements = new ArrayList<ResultElement>();
            topElements.add(rootElement);
        } else {
            topElements = null;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!MainframeSourceCobolViewer.this.resultsTreeViewer.getControl().isDisposed()) {
                    MainframeSourceCobolViewer.this.resultsTreeViewer.setInput((Object)topElements);
                }
            }
        });
    }

    private void buildVariablesResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.variables.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String queryPart1 = "SELECT \n\tA.VarID, \n\tA.VarName, \n\tA.iLevel, \n\tA.PIC, \n\tA.IsField, \n\tA.IsFiller, \n\tA.type AS VarTypeID, \n\tA.ProgIDReference, \n\tB.Description AS VarTypeDescription, \n\tA.Father, \n\tA.Ancestor AS VarAncestor, \n\tA.IsCopy, \n\tE.Description AS VarSectionType, \n\tC.StartRow AS VarStartRow, \n\tC.StartCol AS VarStartCol, \n\tC.EndRow AS VarEndRow, \n\tC.EndCol AS VarEndCol, \n\tD.PathStr AS VarPathStr, \n\tCAST(NULL AS INTEGER) AS StmtStartRow, \n\tCAST(NULL AS INTEGER) AS StmtStartCol, \n\tCAST(NULL AS INTEGER) AS bRead, \n\tCAST(NULL AS VARCHAR(250)) AS Description, \n\tCAST(NULL AS VARCHAR(250)) AS StmtPathStr \nFROM Variables A \n\tLEFT JOIN VarTypes B ON A.Type = B.VarType \n\tINNER JOIN Occurrences C ON A.OccurID = C.OccurID \n\tINNER JOIN Paths D ON C.PathID = D.PathID \n\tINNER JOIN SectionTypes E ON A.SectionType = E.SecID \nWHERE (A.ProgIDReference = ?) \n\tAND (UPPER(D.PathStr) = UPPER(?)) \n\tAND (C.StartRow <= ?) \n\tAND (C.EndRow >= ?) ";
            String queryPart2 = "SELECT \n\tA.VarID, \n\tA.VarName, \n\tA.iLevel, \n\tA.PIC, \n\tA.IsField, \n\tA.IsFiller, \n\tA.type AS VarTypeID, \n\tA.ProgIDReference, \n\tB.Description AS VarTypeDescription, \n\tA.Father, \n\tA.Ancestor AS VarAncestor, \n\tA.IsCopy, \n\tE.Description AS VarSectionType, \n\tC.StartRow AS VarStartRow, \n\tC.StartCol AS VarStartCol, \n\tC.EndRow AS VarEndRow, \n\tC.EndCol AS VarEndCol, \n\tD.PathStr AS VarPathStr, \n\tF.StartRow AS StmtStartRow, \n\tF.StartCol AS StmtStartCol, \n\tF.bRead, \n\tH.Description AS Description, \n\tI.PathStr AS StmtPathStr \nFROM Variables A \n\tLEFT JOIN VarTypes B ON A.Type = B.VarType \n\tINNER JOIN Occurrences C ON A.OccurID = C.OccurID \n\tINNER JOIN Paths D ON C.PathID = D.PathID \n\tLEFT JOIN SectionTypes E ON A.SectionType = E.SecID \n\tINNER JOIN StatementReference F ON A.VarID = F.ResourceID \n\t\tAND 4 = F.ResourceType \n\tINNER JOIN OccurrencesStmt G ON F.OccurID = G.OccurID \n\tINNER JOIN Statements H ON G.StatementType = H.StatementType \n\tINNER JOIN Paths I ON G.PathID = I.PathID \nWHERE (A.ProgIDReference = ?) \n\tAND (UPPER(I.PathStr) = UPPER(?)) \n\tAND (F.StartRow >= ?) \n\tAND (F.StartRow <= ?) \n\nORDER BY VarID ";
            String query = String.valueOf(queryPart1) + "\n\nUNION \n\n" + queryPart2;
            L.trace("query for variables: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, endLine, startLine, programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.VARIABLE, parentElement, null);
                HashMap<Integer, ResultElement> variablesMap = new HashMap<Integer, ResultElement>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processVariableDataRow(row, category, variablesMap);
                    ++n2;
                }
            }
        }
    }

    private void processVariableDataRow(String[] row, ResultElement parent, Map<Integer, ResultElement> variablesMap) {
        Integer varId = Integer.valueOf(row[0]);
        ResultElement variableElement = variablesMap.get(varId);
        if (variableElement == null) {
            Integer headFatherId = Integer.valueOf(row[9]);
            ResultElement varParent = variablesMap.get(headFatherId);
            if (varParent != null && headFatherId != 0) {
                parent = varParent;
            }
            parent = this.addVarSectionType(row, parent);
            String varName = row[1];
            variableElement = new ResultElement(varName, ResultElementType.VARIABLE, parent);
            variableElement.addProperty("VarID", varId);
            parent.addChild(varId.toString(), variableElement);
            variablesMap.put(varId, variableElement);
            Map data = this.descriptor.getState().getData();
            ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
            Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
            variableElement.addProperty("ProgramTypeID", programTypeId);
            variableElement.addProperty("ProgramId", parentElement.getProperty("ProgramId"));
            variableElement.addProperty("ProgramName", parentElement.getProperty("ProgramName"));
            variableElement.addProperty("iLevel", Integer.valueOf(row[2]));
            variableElement.addProperty("PIC", row[3]);
            variableElement.addProperty("IsField", row[4]);
            variableElement.addProperty("IsFiller", row[5]);
            variableElement.addProperty("VarTypeID", row[6]);
            variableElement.addProperty("ProgIDReference", Integer.valueOf(row[7]));
            variableElement.addProperty("VarTypeDescription", row[8]);
            variableElement.addProperty("Father", Integer.valueOf(row[9]));
            variableElement.addProperty("VarAncestor", Integer.valueOf(row[10]));
            variableElement.addProperty("IsCopy", Integer.valueOf(row[11]));
            variableElement.addProperty("VarSectionType", row[12]);
            Integer startRow = Integer.valueOf(row[13]);
            variableElement.addProperty("VarStartRow", startRow);
            Integer startCol = Integer.valueOf(row[14]);
            variableElement.addProperty("VarStartCol", startCol);
            Integer endRow = Integer.valueOf(row[15]);
            variableElement.addProperty("VarEndRow", endRow);
            Integer endCol = Integer.valueOf(row[16]);
            variableElement.addProperty("VarEndCol", endCol);
            String varPath = row[17];
            variableElement.addProperty("VarPathStr", varPath);
            com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(variableElement, programTypeId.toString(), varPath, startRow, startCol, endRow, endCol);
            this.addPrjInfoToResultElement(variableElement);
        }
    }

    protected ResultElement addVarSectionType(String[] row, ResultElement parent) {
        ResultElement sectionElement;
        String sectionType = row[12];
        if (parent.getType().equals((Object)ResultElementType.VARIABLE)) {
            sectionElement = parent;
        } else if (sectionType == null) {
            L.warn("NULL section type for variable {}", (Object)row[1]);
            sectionElement = parent;
        } else {
            if (!parent.hasChildren() || (sectionElement = parent.getChild(sectionType)) == null) {
                sectionElement = new ResultElement(sectionType, ResultElementType.VARIABLE_SECTION_TYPE, parent);
                Map data = this.descriptor.getState().getData();
                ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
                Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
                sectionElement.addProperty("ProgramTypeID", programTypeId);
            }
            parent.addChild(sectionType, sectionElement);
        }
        return sectionElement;
    }

    private void buildFilesResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.files.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String queryPart1 = "SELECT \n\tC.FileID, \n\tCASE \n\t\tWHEN D.Name IS NULL THEN C.Name \n\t\tELSE D.Name \n\tEND AS FileName, \n\tC.LogicalName, \n\tCAST(NULL AS VARCHAR(250)) AS StmtDescription, \n\tCAST(NULL AS INTEGER) AS StmtStartRow, \n\tCAST(NULL AS INTEGER) AS StmtStartCol, \n\tCAST(NULL AS INTEGER) AS StmtEndRow, \n\tCAST(NULL AS INTEGER) AS StmtEndCol, \n\tCAST(NULL AS VARCHAR(250)) AS StmtPathStr \nFROM Occurrences A \n\tINNER JOIN Paths B ON A.PathID = B.PathID \n\tINNER JOIN Files C ON A.ResourceID = C.FileID \n\tLEFT JOIN SCLSystemFiles D ON C.Name = D.SystemFileId \nWHERE (A.ProgID = ?) \n\tAND (UPPER(B.PathStr) = UPPER(?)) \n\tAND (A.StartRow <= ?) \n\tAND (A.EndRow >= ?) \n\tAND (A.ResourceType = 9) ";
            String queryPart2 = "SELECT \n\tA.FileID, \n\tCASE \n\t\tWHEN F.Name IS NULL THEN A.Name \n\t\tELSE F.Name \n\tEND AS FileName, \n\tA.LogicalName, \n\tD.Description AS StmtDescription, \n\tC.StartRow AS StmtStartRow, \n\tC.StartCol AS StmtStartCol, \n\tC.EndRow AS StmtEndRow, \n\tC.EndCol AS StmtEndCol, \n\tE.PathStr AS StmtPathStr \nFROM Files A \n\tINNER JOIN StatementReference B ON A.FileID = B.ResourceID \n\t\tAND 9 = B.ResourceType \n\tINNER JOIN OccurrencesStmt C ON B.OccurID = C.OccurID \n\tINNER JOIN Statements D ON B.StatementType = D.StatementType \n\tINNER JOIN Paths E ON C.PathID = E.PathID \n\tLEFT JOIN SCLSystemFiles F ON A.Name = F.SystemFileId \nWHERE (C.ProgID = ?) \n\tAND (UPPER(E.PathStr) = UPPER(?)) \n\tAND (B.StartRow >= ?) \n\tAND (B.StartRow <= ?) ";
            String query = String.valueOf(queryPart1) + "\n\nUNION \n\n" + queryPart2;
            L.trace("query for files: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, endLine, startLine, programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.FILE, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processFileDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processFileDataRow(String[] row, ResultElement parent) {
        String logicalKey;
        ResultElement logicalNameElement;
        String fileKey;
        ResultElement fileElement;
        int sepIndex;
        Integer fileId = Integer.valueOf(row[0]);
        String fileName = row[1];
        String logicalName = row[2];
        if (fileName != null && !fileName.isEmpty() && (sepIndex = fileName.lastIndexOf("-")) > 0) {
            fileName = fileName.substring(sepIndex + 1);
        }
        if ((fileElement = parent.getChild(fileKey = String.valueOf(fileId.toString()) + ResultElementType.FILE.toString() + fileName)) == null) {
            if (fileName == null || fileName.isEmpty()) {
                fileName = logicalName;
            }
            fileElement = new ResultElement(fileName, ResultElementType.FILE, parent);
            fileElement.addProperty("FileName", fileName);
            fileElement.addProperty("FileID", fileId);
            fileElement.addProperty("isPhysicalFile attribute", fileName);
            parent.addChild(fileKey, fileElement);
            this.addPrjInfoToResultElement(fileElement);
        }
        if ((logicalNameElement = parent.getChild(logicalKey = String.valueOf(fileId.toString()) + ResultElementType.LOGICAL_NAME.toString())) == null) {
            logicalNameElement = new ResultElement(logicalName, ResultElementType.LOGICAL_NAME, parent);
            parent.addChild(logicalKey, logicalNameElement);
            this.addPrjInfoToResultElement(logicalNameElement);
        }
    }

    private void buildSQLTablesAndFieldsResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.sqltable.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String queryPart0 = "SELECT DISTINCT \n\tC.SqlTableID, \n\tC.TableName, \n\tCAST(NULL AS INT) AS SqlFieldID, \n\tCAST(NULL AS VARCHAR(250)) AS FieldName, \n\tE.StartRow as DeclareStmtStartRow, \n\tE.StartCol as DeclareStmtStartCol, \n\tE.EndRow as DeclareStmtEndRow, \n\tE.EndCol as DeclareStmtEndCol, \n\tB.PathStr AS TablePath, \n\tF.Description, \n\tE.StartRow AS StmtStartRow, \n\tE.StartCol AS StmtStartCol, \n\tE.EndRow AS StmtEndRow, \n\tE.EndCol AS StmtEndCol, \n\tB.PathStr as StmtPathStr \nFROM Occurrences A \n\tINNER JOIN Paths B ON A.PathID = B.PathID \n\tINNER JOIN SqlTables C ON A.ResourceID = C.SqlTableID \n\tINNER JOIN StatementReference D ON A.ResourceID = D.ResourceID \n\tINNER JOIN OccurrencesStmt E ON D.OccurID = E.OccurID \n\t\tAND (E.StatementType = 226) \n\tINNER JOIN Statements F ON E.StatementType = F.StatementType \nWHERE (A.ProgID = ?) \n\tAND (UPPER(B.PathStr) = Upper(?)) \n\tAND (A.StartRow <= ?) \n\tAND (A.EndRow >= ?) \n\tAND (A.ResourceType = 1) ";
            String queryPart1 = "SELECT DISTINCT \n\tD.SqlTableID, \n\tD.TableName, \n\tCAST(NULL AS INTEGER) AS SqlFieldID, \n\tCAST(NULL AS VARCHAR(250)) AS FieldName, \n\tG.StartRow as DeclareStmtStartRow, \n\tG.StartCol as DeclareStmtStartCol, \n\tG.EndRow as DeclareStmtEndRow, \n\tG.EndCol as DeclareStmtEndCol, \n\tH.PathStr AS TablePath, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN SqlTables D ON A.ResourceID = D.SqlTableID \n\tINNER JOIN Statements E ON B.StatementType = E.StatementType \n\tLEFT JOIN StatementReference F ON D.SqlTableID = F.ResourceID \n\tLEFT JOIN OccurrencesStmt G ON F.OccurID = G.OccurID \n\t\tAND (G.StatementType = 226) \n\tLEFT JOIN Paths H ON G.PathID = H.PathID \nWHERE (A.ResourceType = 1) \n\tAND (B.StatementType <> 226) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            String queryPart2 = "SELECT DISTINCT \n\tE.SqlTableID, \n\tE.TableName, \n\tD.SqlFieldID, \n\tD.FieldName, \n\tH.StartRow as DeclareStmtStartRow, \n\tH.StartCol as DeclareStmtStartCol, \n\tH.EndRow as DeclareStmtEndRow, \n\tH.EndCol as DeclareStmtEndCol, \n\tI.PathStr AS TablePath, \n\tF.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN SqlFields D ON A.ResourceID = D.SqlFieldID \n\tINNER JOIN SqlTables E ON D.SqlTableID = E.SqlTableID \n\tINNER JOIN Statements F ON B.StatementType = F.StatementType \n\tLEFT JOIN StatementReference G ON E.SqlTableID = G.ResourceID \n\tLEFT JOIN OccurrencesStmt H ON G.OccurID = H.OccurID \n\t\tAND (H.StatementType = 226) \n\tLEFT JOIN Paths I ON H.PathID = I.PathID \nWHERE (A.ResourceType = 187) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            String queryPart3 = "SELECT DISTINCT \n\tE.SqlTableID, \n\tE.TableName, \n\tF.SqlFieldID, \n\tF.FieldName, \n\tH.StartRow as DeclareStmtStartRow, \n\tH.StartCol as DeclareStmtStartCol, \n\tH.EndRow as DeclareStmtEndRow, \n\tH.EndCol as DeclareStmtEndCol, \n\tI.PathStr AS TablePath, \n\tG.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID  = C.PathID \n\tINNER JOIN StatementReference D ON A.OccurID = D.OccurID \n\t\tAND 1 = D.ResourceType \n\tINNER JOIN SqlTables E ON D.ResourceID = E.SqlTableID \n\tLEFT JOIN SqlFields F ON E.SqlTableID = F.SqlTableID \n\tINNER JOIN Statements G ON B.StatementType = G.StatementType \n\tLEFT JOIN OccurrencesStmt H ON D.OccurID = H.OccurID \n\t\tAND (H.StatementType = 226) \n\tLEFT JOIN Paths I ON H.PathID = I.PathID \nWHERE (A.ResourceType = 55) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            String query = String.valueOf(queryPart0) + "\n\nUNION \n\n" + queryPart1 + "\n\nUNION \n\n" + queryPart2 + "\n\nUNION \n\n" + queryPart3;
            L.trace("query for sql tables and fields: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, endLine, startLine, programId, filePath, startLine, endLine, programId, filePath, startLine, endLine, programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.SQL_TABLE, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processSQLTableDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processSQLTableDataRow(String[] row, ResultElement parent) {
        ResultElement tableElement = parent.getChild(row[0]);
        if (tableElement == null) {
            Integer tableId = Integer.valueOf(row[0]);
            tableElement = new ResultElement(row[1], ResultElementType.SQL_TABLE, parent);
            tableElement.addProperty("TableName", row[1]);
            tableElement.addProperty("SqlTableId", tableId);
            parent.addChild(tableId.toString(), tableElement);
            this.addDeclareInfoToSQLElement(row, tableElement);
            this.addPrjInfoToResultElement(tableElement);
        } else if (tableElement.getProperty("FILE") == null) {
            this.addDeclareInfoToSQLElement(row, tableElement);
        }
        String fieldIdString = row[2];
        if (fieldIdString != null) {
            Integer fieldId = Integer.valueOf(row[2]);
            ResultElement fieldElement = tableElement.getChild(fieldIdString);
            if (fieldElement == null) {
                fieldElement = new ResultElement(row[3], ResultElementType.SQL_FIELD_TABLE, tableElement);
                tableElement.addChild(fieldIdString, fieldElement);
                fieldElement.addProperty("SqlFieldID", fieldId);
                fieldElement.addProperty("FieldName", row[3]);
                fieldElement.addProperty("SqlTableId", Integer.valueOf(row[0]));
                fieldElement.addProperty("TableName", row[1]);
                this.addDeclareInfoToSQLElement(row, fieldElement);
                this.addPrjInfoToResultElement(fieldElement);
            } else if (fieldElement.getProperty("FILE") == null) {
                this.addDeclareInfoToSQLElement(row, fieldElement);
            }
        }
    }

    private void addDeclareInfoToSQLElement(String[] row, ResultElement sqlElement) {
        Map data = this.descriptor.getState().getData();
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
        String tableDeclarePath = row[8];
        if (tableDeclarePath != null && !tableDeclarePath.isEmpty()) {
            Integer declareStmtStartRow = Integer.valueOf(row[4]);
            Integer declareStmtStartCol = Integer.valueOf(row[5]);
            Integer declareStmtEndRow = Integer.valueOf(row[6]);
            Integer declareStmtEndCol = Integer.valueOf(row[7]);
            com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(sqlElement, programTypeId.toString(), tableDeclarePath, declareStmtStartRow, declareStmtStartCol, declareStmtEndRow, declareStmtEndCol);
        }
    }

    private void buildDalResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.dal.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\tD.ResourceID, \n\tD.Name AS ResourceName, \n\tD.OccurID, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN Resources D ON A.ResourceID = D.ResourceID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 189) \n\tAND (B.ProgID = ?) \n\tAND (C.PathStr = ?) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            L.trace("query for dal: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.DAL, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processDalDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processDalDataRow(String[] row, ResultElement parent) {
        Integer dalId = Integer.valueOf(row[0]);
        ResultElement dalElement = parent.getChild(dalId.toString());
        if (dalElement == null) {
            String dalName = row[1];
            dalElement = new ResultElement(dalName, ResultElementType.DAL, parent);
            dalElement.addProperty("ResourceID", dalId);
            dalElement.addProperty("ResourceName", dalName);
            dalElement.addProperty("OccurID", row[2]);
            parent.addChild(dalId.toString(), dalElement);
            this.addPrjInfoToResultElement(dalElement);
        }
    }

    private void buildDbiResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.dbi.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\tD.ResourceID, \n\tD.Name AS ResourceName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN Resources D ON A.ResourceID = D.ResourceID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 190) \n\tAND (B.ProgID = ?) \n\tAND (C.PathStr = ?) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            L.trace("query for dbi: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.DBI_TABLE, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processDbiDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processDbiDataRow(String[] row, ResultElement parent) {
        Integer dbiId = Integer.valueOf(row[0]);
        ResultElement dbiElement = parent.getChild(dbiId.toString());
        if (dbiElement == null) {
            String dbiName = row[1];
            dbiElement = new ResultElement(dbiName, ResultElementType.DBI_TABLE, parent);
            dbiElement.addProperty("ResourceID", dbiId);
            dbiElement.addProperty("ResourceName", dbiName);
            parent.addChild(dbiId.toString(), dbiElement);
            this.addPrjInfoToResultElement(dbiElement);
        }
    }

    private void buildAdabasResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.adabas.data.task.text"));
        Map data = this.descriptor.getState().getData();
        if (data.get(PARENT_ELEMENT_KEY) != null) {
            this.buildAdabasViewResults(conn);
            this.buildAdabasFileResults(conn);
            this.buildAdabasDBResults(conn);
        }
    }

    private void buildAdabasViewResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String queryPart1 = "SELECT DISTINCT \n\tD.ViewID, \n\tD.ViewName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\t\tAND (A.StartRow >= B.StartRow AND A.StartRow <= B.EndRow) \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN AdabasView D ON A.ResourceID = D.ViewID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 62) \n\tAND (B.ProgID = ?) \n\tAND (C.PathStr = ?) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        String queryPart2 = "SELECT DISTINCT \n\tE.ViewID, \n\tE.ViewName, \n\tF.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN StatementReference D ON A.OccurID = D.OccurID \n\t\tAND 62 = D.ResourceType \n\tINNER JOIN AdabasView E ON D.ResourceID = E.ViewID \n\tINNER JOIN Statements F ON B.StatementType = F.StatementType \nWHERE (A.ResourceType = 55) \n\tAND (B.ProgID = ?) \n\tAND (C.PathStr = ?) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        String query = String.valueOf(queryPart1) + "\n\nUNION \n\n" + queryPart2;
        L.trace("query for adabas views: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine, programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.ADABAS, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processAdabasViewDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processAdabasViewDataRow(String[] row, ResultElement parent) {
        Integer viewId = Integer.valueOf(row[0]);
        String childKey = String.valueOf(ResultElementType.ADABAS_VIEW.getDisplayName()) + viewId.toString();
        ResultElement viewElement = parent.getChild(childKey);
        if (viewElement == null) {
            String viewName = row[1];
            viewElement = new ResultElement(viewName, ResultElementType.ADABAS_VIEW, parent);
            viewElement.addProperty("AdabasViewID", viewId);
            viewElement.addProperty("AdabasView", viewName);
            parent.addChild(childKey, viewElement);
            this.addPrjInfoToResultElement(viewElement);
        }
    }

    private void buildAdabasFileResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT DISTINCT \n\tD.FileID, \n\tCASE \n\t\tWHEN E.FileName IS NOT NULL THEN E.FileName \n\t\tELSE CAST(D.FileNumber AS VARCHAR(16)) \n\tEND AS FileName, \n\tF.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr AS StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN AdabasFiles D ON A.ResourceID = D.FileID \n\tLEFT JOIN MFAdabasFiles E ON D.FileNumber = E.FileNumber \n\tINNER JOIN Statements F ON A.StatementType = F.StatementType \nWHERE (A.ResourceType = 56) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for adabas files: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.ADABAS, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processAdabasFileDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processAdabasFileDataRow(String[] row, ResultElement parent) {
        Integer fileId = Integer.valueOf(row[0]);
        String childKey = String.valueOf(ResultElementType.ADABAS_FILE.getDisplayName()) + fileId.toString();
        ResultElement fileElement = parent.getChild(childKey);
        if (fileElement == null) {
            String fileName = row[1];
            fileElement = new ResultElement(fileName, ResultElementType.ADABAS_FILE, parent);
            fileElement.addProperty("FileID", fileId);
            fileElement.addProperty("FileName", fileName);
            parent.addChild(childKey, fileElement);
            this.addPrjInfoToResultElement(fileElement);
        }
    }

    private void buildAdabasDBResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT DISTINCT \n\tD.AdabasDBID, \n\tCASE \n\t\tWHEN E.DBName IS  NOT NULL THEN E.DBName \n\t\tELSE CAST(D.DBNumber AS VARCHAR(16)) \n\tEND AS DBName, \n\tF.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN AdabasDatabases D ON A.ResourceID = D.AdabasDBID \n\tLEFT JOIN MFAdabasDB E ON D.DBNumber = E.DBNumber \n\tINNER JOIN Statements F ON A.StatementType = F.StatementType \nWHERE (A.ResourceType = 194) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for adabas dbs: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.ADABAS, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processAdabasDBDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processAdabasDBDataRow(String[] row, ResultElement parent) {
        Integer dbId = Integer.valueOf(row[0]);
        String childKey = String.valueOf(ResultElementType.ADABAS_DB.getDisplayName()) + dbId.toString();
        ResultElement dbElement = parent.getChild(childKey);
        if (dbElement == null) {
            String dbName = row[1];
            dbElement = new ResultElement(dbName, ResultElementType.ADABAS_DB, parent);
            dbElement.addProperty("AdabasDBID", dbId);
            dbElement.addProperty("DBName", dbName);
            parent.addChild(childKey, dbElement);
            this.addPrjInfoToResultElement(dbElement);
        }
    }

    private void buildIDMSResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        Map data = this.descriptor.getState().getData();
        List selProjects = (List)data.get("PROJECT_LIST");
        ProjectInfo selectedPrjInfo = (ProjectInfo)selProjects.get(0);
        if (selectedPrjInfo.isVME()) {
            monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.idmsx.data.task.text"));
        } else {
            monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.idms.data.task.text"));
        }
        if (data.get(PARENT_ELEMENT_KEY) != null) {
            this.buildIMDSRecordResults(conn);
            this.buildIMDSSetResults(conn);
        }
    }

    private void buildIMDSRecordResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT \n\tD.ID, \n\tD.RecordName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN IdmsSubschemaRecords D ON A.ResourceID = D.ID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE A.ResourceType = 77 \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for imds records: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.IDMS_RECORD, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processIMDSRecordDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processIMDSRecordDataRow(String[] row, ResultElement parent) {
        Integer recordId = Integer.valueOf(row[0]);
        ResultElement recordElement = parent.getChild(recordId.toString());
        if (recordElement == null) {
            String recordName = row[1];
            recordElement = new ResultElement(recordName, ResultElementType.IDMS_RECORD, parent);
            Map data = this.descriptor.getState().getData();
            ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
            Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
            recordElement.addProperty("ProgramTypeID", programTypeId);
            parent.addChild(recordId.toString(), recordElement);
            this.addPrjInfoToResultElement(recordElement);
        }
    }

    private void buildIMDSSetResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT \n\tD.ID, \n\tD.SetName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN IdmsSubschemaSets D ON A.ResourceID = D.ID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE A.ResourceType = 78 \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for imds sets: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.IDMS_SET, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processIMDSSetDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processIMDSSetDataRow(String[] row, ResultElement parent) {
        Integer setId = Integer.valueOf(row[0]);
        ResultElement setElement = parent.getChild(setId.toString());
        if (setElement == null) {
            String setName = row[1];
            setElement = new ResultElement(setName, ResultElementType.IDMS_SET, parent);
            Map data = this.descriptor.getState().getData();
            ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
            Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
            setElement.addProperty("ProgramTypeID", programTypeId);
            parent.addChild(setId.toString(), setElement);
            this.addPrjInfoToResultElement(setElement);
        }
    }

    private void buildIMSDBResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.imsdb.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\t\tT.IMSDBId, T.IMSDBName, T.IMSDBAccessType, \n\t\tT.IMSDBType, \n\t\tT.SegmentID, T.SegmentName, T.SourceSgID, \n\t\tT.Description, \n\t\tT.StmtStartRow, T.StmtStartCol, T.StmtEndRow, T.StmtEndCol, \n\t\tT.StmtPathStr \n\tFROM \n\t( \n\t\tSELECT \n\t\t\tCOALESCE(D.ResourceID, E.DBId, G.DBId)  AS IMSDBId, \n\t\t\tCOALESCE(D.Name, E.DBName, G.DBName) AS IMSDBName, \n\t\t\tCOALESCE(E.AccessTypeID, G.AccessTypeID) as IMSDBAccessType, \n\t\t\tA.ResourceType AS IMSDBType, \n\t\t\tF.SegmentId as SegmentID, \n\t\t\tF.SegmentName as SegmentName, \n\t\t\tF.SourceSegId as SourceSgID, \n\t\t\tA.StatementType, \n\t\t\tH.Description, \n\t\t\tB.StartRow AS StmtStartRow, \n\t\t\tB.StartCol AS StmtStartCol, \n\t\t\tB.EndRow AS StmtEndRow, \n\t\t\tB.EndCol AS StmtEndCol, \n\t\t\tC.PathID as StmtPathID, \n\t\t\tC.PathStr as StmtPathStr \n\t\tFROM StatementReference A \n\t\t\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\t\t\tINNER JOIN Paths C ON B.PathID = C.PathID \n\t\t\tLEFT OUTER JOIN Resources D ON  A.ResourceType = 19 AND  A.ResourceID = D.ResourceID \n\t\t\tLEFT OUTER JOIN IMSDBInfo E ON  A.ResourceType = 18 AND  A.ResourceID = E.DBId \n\t\t\tLEFT OUTER JOIN IMSDBSegments F ON  A.ResourceType = 209 AND  A.ResourceID = F.SegmentId \n\t\t\tLEFT OUTER JOIN IMSDBInfo G on F.DBId = G.DBId \n\t\t\tINNER JOIN Statements H ON A.StatementType = H.StatementType \n\t\tWHERE (A.ResourceType IN (18, 19, 209)) \n\t\t\tAND (B.ProgID = ?) \n\t\t\tAND (UPPER(C.PathStr) = UPPER(?)) \n\t\t\tAND (A.StartRow >= ?) \n\t\t\tAND (A.StartRow <= ?) \n\t) T \n";
            L.trace("query for imsdb: \n{}", (Object)query);
            try {
                String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
                if (results != null) {
                    String[][] stringArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] row = stringArray[n2];
                        this.processIMSDBDataRow(row, parentElement);
                        ++n2;
                    }
                }
            }
            catch (EZSourceConnectionException e) {
                L.error("connection error", (Throwable)e);
            }
        }
    }

    private void processIMSDBDataRow(String[] row, ResultElement parentElement) {
        Integer endCol;
        Integer imsResourceType = Integer.valueOf(row[3]);
        ResultElementType imsdbElementType = null;
        Integer imsdbAccessType = row[2] == null ? 0 : Integer.valueOf(row[2]);
        if (18 == imsResourceType || 209 == imsResourceType) {
            parentElement = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.IMSDB_DATABASE, parentElement, null);
            imsdbElementType = com.ez.analysis.mainframe.source.utils.Utils.getIMSDBType(imsdbAccessType);
        } else {
            imsdbElementType = ResultElementType.IMSDB_TERMINAL;
        }
        ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(imsdbElementType, parentElement, null);
        Integer imsdbId = Integer.valueOf(row[0]);
        String imsdbName = row[1];
        ResultElement imsdbElement = category.getChild(imsdbId.toString());
        if (imsdbElement == null) {
            imsdbElement = new ResultElement(imsdbName, imsdbElementType, category);
            imsdbElement.addProperty("IMSDBId", imsdbId);
            imsdbElement.addProperty("ResourceName", imsdbName);
            imsdbElement.addProperty("IMSDBType", imsdbAccessType);
            category.addChild(imsdbId.toString(), imsdbElement);
            this.addPrjInfoToResultElement(imsdbElement);
        }
        this.buildIMSDBSegmentResult(row, imsdbName, imsdbElement);
        String stmtPath = row[12];
        Integer startRow = row[8] == null ? null : Integer.valueOf(row[8]);
        Integer startCol = row[9] == null ? null : Integer.valueOf(row[9]);
        Integer endRow = row[10] == null ? null : Integer.valueOf(row[10]);
        Integer n = endCol = row[11] == null ? null : Integer.valueOf(row[11]);
        if (stmtPath != null && startRow != null) {
            ResultElement goToSrcElem = row[4] == null ? imsdbElement : imsdbElement.getChild(row[4]);
            Map data = this.descriptor.getState().getData();
            ResultElement prgElem = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
            Integer programTypeId = (Integer)prgElem.getProperty("ProgramTypeID");
            com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(goToSrcElem, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
        }
    }

    private void buildIMSDBSegmentResult(String[] row, String imsdbName, ResultElement imsdbElement) {
        Integer segId;
        Integer n = segId = row[4] == null ? null : Integer.valueOf(row[4]);
        if (segId != null && imsdbElement.getChild(segId.toString()) == null) {
            String segName = row[5];
            Integer sourceSgID = row[6] == null ? null : Integer.valueOf(row[6]);
            ResultElement segElement = new ResultElement(segName, sourceSgID != null ? ResultElementType.IMSDB_LOGICAL_SEGMENT : ResultElementType.IMSDB_SEGMENT, imsdbElement);
            segElement.addProperty("ResourceName", imsdbName);
            segElement.addProperty("IMSDBSegmentID", segId);
            imsdbElement.addChild(segId.toString(), segElement);
            this.addPrjInfoToResultElement(segElement);
        }
    }

    private void buildIncludeResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.include.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\tD.ResourceID AS IncludeId, \n\tD.Name AS IncludeName, \n\tF.PathID AS IncludePathId, \n\tE.StartRow AS IncludeStartRow, \n\tE.StartCol AS IncludeStartCol, \n\tE.EndRow AS IncludeEndRow, \n\tE.EndCol AS IncludeEndCol, \n\tF.PathStr AS IncludePathStr, \n\tG.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN Resources D ON A.ResourceID = D.ResourceID \n\tINNER JOIN Occurrences E ON D.OccurID = E.OccurID \n\tINNER JOIN Paths F ON E.PathID = F.PathID \n\tINNER JOIN Statements G ON A.StatementType = G.StatementType \nWHERE (A.ResourceType = 13) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            L.trace("query for include: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.INCLUDE, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processIncludeDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processIncludeDataRow(String[] row, ResultElement parent) {
        Integer includeId = Integer.valueOf(row[0]);
        ResultElement includeElement = parent.getChild(includeId.toString());
        if (includeElement == null) {
            String includeName = row[1];
            includeElement = new ResultElement(includeName, ResultElementType.INCLUDE, parent);
            String includePath = row[7];
            includeElement.addProperty("include is not on disk", includePath.equals(includeName));
            includeElement.addProperty("IncludePathId", Integer.valueOf(row[2]));
            MainframeSourceNode prgNode = new MainframeSourceNode(ResultElementType.INCLUDE.getDisplayName(), includePath);
            includeElement.addProperty("Node_Mainframe", prgNode);
            Map data = this.descriptor.getState().getData();
            ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
            Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
            includeElement.addProperty("ProgramTypeID", programTypeId);
            Integer startRow = Integer.valueOf(row[3]);
            Integer startCol = Integer.valueOf(row[4]);
            Integer endRow = Integer.valueOf(row[5]);
            Integer endCol = Integer.valueOf(row[6]);
            com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(includeElement, String.valueOf(programTypeId), includePath, startRow, startCol, endRow, endCol);
            parent.addChild(includeId.toString(), includeElement);
            this.addPrjInfoToResultElement(includeElement);
        }
    }

    private void buildMQResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.mq.data.task.text"));
        Map data = this.descriptor.getState().getData();
        if (data.get(PARENT_ELEMENT_KEY) != null) {
            this.buildManagerResults(conn);
            this.buildQueueResults(conn);
        }
    }

    private void buildManagerResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT \n\tD.QueueManagerID, \n\tD.QueueManagerName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN MQQueueManagers D ON A.ResourceID = D.QueueManagerID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 79) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for mq queue manager: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.MQ_MANAGER, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processManagerDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processManagerDataRow(String[] row, ResultElement parent) {
        Integer managerId = Integer.valueOf(row[0]);
        ResultElement managerElement = parent.getChild(managerId.toString());
        if (managerElement == null) {
            String managerName = row[1];
            managerElement = new ResultElement(managerName, ResultElementType.MQ_MANAGER, parent);
            parent.addChild(managerId.toString(), managerElement);
            this.addPrjInfoToResultElement(managerElement);
        }
    }

    private void buildQueueResults(EZSourceConnection conn) {
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        Integer programId = (Integer)parentElement.getProperty("ProgramId");
        String query = "SELECT \n\tD.QueueID, \n\tD.QueueName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN MQQueues D ON A.ResourceID = D.QueueID\t\n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 81) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
        L.trace("query for mq queue: \n{}", (Object)query);
        String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
        if (results != null) {
            ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.MQ_QUEUE, parentElement, null);
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] row = stringArray[n2];
                this.processQueueDataRow(row, category);
                ++n2;
            }
        }
    }

    private void processQueueDataRow(String[] row, ResultElement parent) {
        Integer queueId = Integer.valueOf(row[0]);
        ResultElement queueElement = parent.getChild(queueId.toString());
        if (queueElement == null) {
            String queueName = row[1];
            queueElement = new ResultElement(queueName, ResultElementType.MQ_QUEUE, parent);
            parent.addChild(queueId.toString(), queueElement);
            this.addPrjInfoToResultElement(queueElement);
        }
    }

    private void buildDatacomResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.datacom.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\tD.ID, \n\tD.TableName, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN DatacomTables D ON A.ResourceID = D.ID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \nWHERE (A.ResourceType = 182) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            L.trace("query for datacom: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.DATACOM, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processDatacomDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processDatacomDataRow(String[] row, ResultElement parent) {
        Integer tableId = Integer.valueOf(row[0]);
        ResultElement tableElement = parent.getChild(tableId.toString());
        if (tableElement == null) {
            String tableName = row[1];
            tableElement = new ResultElement(tableName, ResultElementType.DATACOM_TABLE, parent);
            parent.addChild(tableId.toString(), tableElement);
            this.addPrjInfoToResultElement(tableElement);
        }
    }

    private void buildBMSMapResults(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolViewer.class, "query.bms.data.task.text"));
        Map data = this.descriptor.getState().getData();
        String filePath = (String)data.get(SOURCE_FILE_PATH_KEY);
        Integer startLine = (Integer)data.get(START_LINE_KEY);
        Integer endLine = (Integer)data.get(END_LINE_KEY);
        ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
        if (parentElement != null) {
            Integer programId = (Integer)parentElement.getProperty("ProgramId");
            String query = "SELECT \n\tD.BmsID, \n\tD.BmsName, \n\tD.OccurID, \n\tD.IsMapSet, \n\tH.BmsName AS MapSet, \n\tF.StartRow AS BmsStartRow, \n\tF.StartCol AS BmsStartCol, \n\tF.EndRow AS BmsEndRow, \n\tF.EndCol AS BmsEndCol, \n\tG.PathStr AS BmsPathStr, \n\tE.Description, \n\tB.StartRow AS StmtStartRow, \n\tB.StartCol AS StmtStartCol, \n\tB.EndRow AS StmtEndRow, \n\tB.EndCol AS StmtEndCol, \n\tC.PathStr as StmtPathStr \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN Paths C ON B.PathID = C.PathID \n\tINNER JOIN Bms D ON A.ResourceID = D.BmsID \n\tINNER JOIN Statements E ON A.StatementType = E.StatementType \n\tLEFT JOIN Occurrences F ON D.OccurID = F.OccurID \n\tLEFT JOIN Paths G ON F.PathID = G.PathID \n\tLEFT JOIN Bms H ON D.AncestorID = H.BmsID \nWHERE (A.ResourceType = 6) \n\tAND (B.ProgID = ?) \n\tAND (UPPER(C.PathStr) = UPPER(?)) \n\tAND (A.StartRow >= ?) \n\tAND (A.StartRow <= ?) ";
            L.trace("query for bms maps: \n{}", (Object)query);
            String[][] results = conn.executeSQL(query, new Object[]{programId, filePath, startLine, endLine});
            if (results != null) {
                ResultElement category = com.ez.analysis.mainframe.source.utils.Utils.getCategory(ResultElementType.BMS_MAP, parentElement, null);
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] row = stringArray[n2];
                    this.processBMSMapDataRow(row, category);
                    ++n2;
                }
            }
        }
    }

    private void processBMSMapDataRow(String[] row, ResultElement parent) {
        Integer bmsMapId = Integer.valueOf(row[0]);
        ResultElement bmsMapElement = parent.getChild(bmsMapId.toString());
        if (bmsMapElement == null) {
            String bmsMapName = row[1];
            bmsMapElement = new ResultElement(bmsMapName, ResultElementType.BMS_MAP, parent);
            bmsMapElement.addProperty("BmsId", bmsMapId);
            bmsMapElement.addProperty("BmsName", bmsMapName);
            bmsMapElement.addProperty("OccurID", row[2]);
            boolean isMapset = !row[3].equals("0");
            bmsMapElement.addProperty("IsMapSet", isMapset);
            bmsMapElement.addProperty("MapSet", row[4]);
            String bmsMapPath = row[9];
            if (bmsMapPath != null) {
                Map data = this.descriptor.getState().getData();
                ResultElement parentElement = (ResultElement)((Object)data.get(PARENT_ELEMENT_KEY));
                Integer programTypeId = (Integer)parentElement.getProperty("ProgramTypeID");
                Integer startRow = Integer.valueOf(row[5]);
                Integer startCol = Integer.valueOf(row[6]);
                Integer endRow = Integer.valueOf(row[7]);
                Integer endCol = Integer.valueOf(row[8]);
                com.ez.analysis.mainframe.source.utils.Utils.setFileAttribute(bmsMapElement, String.valueOf(programTypeId), bmsMapPath, startRow, startCol, endRow, endCol);
            }
            parent.addChild(bmsMapId.toString(), bmsMapElement);
            this.addPrjInfoToResultElement(bmsMapElement);
        }
    }

    private void addPrjInfoToResultElement(ResultElement resultElement) {
        Map data = this.descriptor.getState().getData();
        List selProjects = (List)data.get("PROJECT_LIST");
        ProjectInfo selectedPrjInfo = (ProjectInfo)selProjects.get(0);
        resultElement.addProperty("ProjectInfo", selectedPrjInfo);
    }

    private void handleResultElementSelection(SelectionChangedEvent event) {
        StructuredSelection structSelection = (StructuredSelection)event.getSelection();
        final List resultElementList = structSelection.toList();
        final ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        for (ResultElement resultElement : resultElementList) {
            if (resultElement.getProperty("ProjectInfo") != null) {
                EZObjectType inputType = com.ez.analysis.mainframe.source.utils.Utils.createApplicableInputType(resultElement);
                inputs.add(inputType);
                continue;
            }
            inputs.add(null);
        }
        if (!inputs.isEmpty()) {
            final Object availablePrjs = this.descriptor.getState().getData().get("projects");
            AbstractActionContext context = new AbstractActionContext(){

                public Map<String, Object> getData() {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("projects", availablePrjs);
                    data.put("ANALYSIS_TYPE_INPUTS", inputs);
                    ResultElement resultElement = (ResultElement)((Object)resultElementList.get(0));
                    ISelection sel = MainframeSourceCobolViewer.this.getSelection4PropertiesView(resultElement);
                    if (sel != null) {
                        data.put("selection", sel);
                        data.put("unique identifier of the property sheet page contributor", MainframeSourceCobolViewer.this.getContributorIdForProperties(resultElement));
                    }
                    data.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)MainframeSourceCobolViewer.this.manager).getViewSecondaryId()));
                    return data;
                }

                public String getId() {
                    return MainframeSourceCobolViewer.this.descriptor.getId();
                }
            };
            this.descriptor.getState().getData().put("selectedContext", context);
            this.manager.setCurrentContext((IActionContext)context);
        }
    }

    private ISelection getSelection4PropertiesView(ResultElement resultElement) {
        StructuredSelection sel = null;
        if (resultElement.getProperty("Node_Mainframe") != null) {
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg(resultElement.getProperty("Node_Mainframe"));
            EZEntityID entID = new EZEntityID();
            entID.addSegment((EZSegment)sg);
            sel = new StructuredSelection((Object)entID);
        }
        if (sel == null) {
            sel = new StructuredSelection();
        }
        return sel;
    }

    private String getContributorIdForProperties(ResultElement resultElement) {
        if (ResultElementType.PROJECT_INFO.equals((Object)resultElement.getType())) {
            return "ezresource.contributor";
        }
        return "ezselection.contributor";
    }

    private ElementActionWithJob makeLinkEditorAction(ResultElement resultElem) {
        if (resultElem != null && resultElem.getProperty("GOTOSOURCE") != null && ((Boolean)resultElem.getProperty("GOTOSOURCE")).booleanValue()) {
            if (this.linkEditor == null) {
                this.linkEditor = new ElementActionWithJob(){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(MainframeSourceCobolViewer.class, "goToSource.task.text"), -1);
                        ResultElement resultElem = this.getResultElem();
                        HashSet options = (HashSet)resultElem.getProperty("FILE");
                        ProjectInfo pi = (ProjectInfo)resultElem.getProperty("ProjectInfo");
                        String projectName = pi != null ? pi.getName() : null;
                        com.ez.cobol.callgraph.utils.Utils.openEditor((Set)options, (String)projectName);
                        monitor.done();
                    }
                };
                this.linkEditor.setText(this.SHOW_SOURCE);
            }
            this.linkEditor.setResultElem(resultElem);
            return this.linkEditor;
        }
        return null;
    }

    private void handleContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MainframeSourceCobolViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resultsTreeViewer.getControl());
        this.resultsTreeViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection sel = this.resultsTreeViewer.getSelection();
        Object objSel = ((IStructuredSelection)sel).getFirstElement();
        if (objSel != null && objSel instanceof ResultElement && ((IStructuredSelection)sel).size() == 1) {
            ResultElement resultElem = (ResultElement)((Object)objSel);
            ElementActionWithJob action = this.makeLinkEditorAction(resultElem);
            if (action != null) {
                manager.add((IContributionItem)new ActionContributionItem((org.eclipse.jface.action.IAction)action));
                manager.add((IContributionItem)new Separator());
            }
            this.addCopyAction(manager);
            if (resultElem != null) {
                if (resultElem.hasChildren()) {
                    if (this.expandNodeAction == null) {
                        this.expandNodeAction = new ElementAction(){

                            public void run() {
                                ResultElement resultElem = this.getResultElem();
                                MainframeSourceCobolViewer.this.resultsTreeViewer.expandToLevel((Object)resultElem, -1);
                            }
                        };
                        this.expandNodeAction.setText(this.EXPAND_ACTION_TEXT);
                    }
                    this.expandNodeAction.setResultElem(resultElem);
                    this.expandNodeActionContributionItem = new ActionContributionItem((org.eclipse.jface.action.IAction)this.expandNodeAction);
                    manager.add((IContributionItem)this.expandNodeActionContributionItem);
                } else if (this.expandNodeAction != null) {
                    manager.remove((IContributionItem)this.expandNodeActionContributionItem);
                }
            }
        }
    }

    private void addCopyAction(IMenuManager manager) {
        manager.add((org.eclipse.jface.action.IAction)new Action(){
            {
                this.setText(Messages.getString(MainframeSourceCobolViewer.class, "copy.action.text"));
                this.setAccelerator(262243);
            }

            public void run() {
                MainframeSourceCobolViewer.this.copyFromTreeToClipboard();
            }
        });
        manager.add((IContributionItem)new Separator());
    }

    private void copyFromTreeToClipboard() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        ISelection sel = this.resultsTreeViewer.getSelection();
        ResultElement resultElement = (ResultElement)((Object)((IStructuredSelection)sel).getFirstElement());
        if (resultElement != null) {
            cb.setContents(new Object[]{resultElement.getDisplayName()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void close() {
        this.unsetAnnotationsContext();
    }

    protected void instantiateAnnotStateManager() {
        this.annStateManager = new CobolSourceAnnotationPartStateManager(this);
    }

    protected DelegatingStyledCellLabelProvider.IStyledLabelProvider getLabelProvider() {
        return (DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.descriptor.getResultsLabelProvider(this.imgRegistry);
    }

    protected AnnotatedResultsContentProvider getContentProvider() {
        return new ResultsTreeContentProvider((CobolSourceAnnotationPartStateManager)this.annStateManager);
    }

    private class CustomProjectsList
    extends ProjectsListWrapper {
        Map<String, String[][]> contextProjectsAndPrograms;

        public CustomProjectsList(Composite parent, int style) {
            super(parent, style, true);
        }

        public void setContext(Map<String, String[][]> ctx) {
            this.contextProjectsAndPrograms = ctx;
        }

        protected boolean considerProject(ProjectInfo projectInfo) {
            return this.contextProjectsAndPrograms.containsKey(projectInfo.getName());
        }

        protected boolean doFill() {
            return true;
        }

        protected void doSelection(int[] selection, int selIndex) {
            if (!this.contextProjectsAndPrograms.isEmpty()) {
                this.lst.select(selIndex);
                MainframeSourceCobolViewer.this.updateSelectedProjectsList();
                MainframeSourceCobolViewer.this.updateSelectedComboList();
            }
        }
    }
}

