/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.source.cobol;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysis.mainframe.source.Activator;
import com.ez.analysis.mainframe.source.cobol.MainframeSourceCobolDescriptor;
import com.ez.analysis.mainframe.source.internal.Messages;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.util.ActionUtils;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceLockException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZCobolSrcSelectionType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.projects.utils.ExecutionExceptionHandler;
import com.ez.mainframe.projects.utils.ProjectUtils;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.model.segments.EZCobolSrcSelectionSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeSourceCobolAction
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeSourceCobolAction.class);
    private MainframeSourceCobolDescriptor descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;

    public MainframeSourceCobolAction(MainframeSourceCobolDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
        this.analysisType = this.descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
    }

    public boolean canHandle(IActionContext context) {
        return ActionUtils.canHandle((EZAnalysisType)this.analysisType, (EZInputFilter)this.filter, (IActionContext)context);
    }

    public void setInputContext(IActionContext context) {
        Map data;
        List inputs;
        this.context = context;
        if (context != null && (inputs = (List)(data = context.getData()).get("ANALYSIS_TYPE_INPUTS")) != null && !inputs.isEmpty()) {
            EZCobolSrcSelectionType cobolSrcSelectionType = (EZCobolSrcSelectionType)inputs.get(0);
            this.context = this.createContextFromCobolSelection(cobolSrcSelectionType);
        }
    }

    public IActionContext getOutputContext() {
        return this.context;
    }

    public void execute(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        Boolean doRestore = (Boolean)this.context.getData().get("IActionContext.restored.key");
        if (doRestore == null || !doRestore.booleanValue()) {
            this.preloadProgramData((IProgressMonitor)monitor.newChild(100));
        }
        if (this.context != null) {
            this.descriptor.getState().getData().putAll(this.context.getData());
        }
    }

    private void preloadProgramData(IProgressMonitor pmonitor) {
        long preloadStartTime = System.currentTimeMillis();
        L.info("{} - preload data start time: {}", (Object)this.analysisType.toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(MainframeSourceCobolAction.class, "preload.program.data.text"));
        Map data = this.context.getData();
        HashMap<String, String[][]> contextProjectsAndPrograms = new HashMap<String, String[][]>();
        List allProjects = (List)data.get("projects");
        List mainframeProjects = ProjectUtils.filterMainframeProjectsOnly((List)allProjects);
        monitor.setWorkRemaining(mainframeProjects.size());
        for (ProjectInfo projectInfo : mainframeProjects) {
            if (monitor.isCanceled()) break;
            monitor.setTaskName(Messages.getString(MainframeSourceCobolAction.class, "processing.project.text", new String[]{projectInfo.getName()}));
            this.loadProgramsForProject(contextProjectsAndPrograms, projectInfo);
            monitor.worked(1);
        }
        this.descriptor.getState().getData().put("context projects and programs", contextProjectsAndPrograms);
        long duration = System.currentTimeMillis() - preloadStartTime;
        L.info("{} - preload data duration: {} ms.", (Object)this.analysisType.toString(), (Object)duration);
    }

    private void loadProgramsForProject(final Map<String, String[][]> contextProjectsAndPrograms, final ProjectInfo projectInfo) {
        Map data = this.context.getData();
        final String filePath = (String)data.get("source file path");
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(projectInfo.getName(), null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                    monitor.setTaskName(Messages.getString(MainframeSourceCobolAction.class, "query.preload.data.task.text"));
                    String query = "SELECT \n\tC.ProgramID, \n\tC.ProgramName, \n\tCAST(NULL AS VARCHAR(250)) AS includeName \nFROM Paths A \n\tINNER JOIN Occurrences B ON A.PathID = B.PathID \n\tINNER JOIN (\n\t\tSELECT P.ProgramID, PA.AliasName AS ProgramName, P.ProgramTypeID, P.OccurID \n\t\tFROM Programs P \n\t\t\tINNER JOIN ProgramAliases PA ON P.ProgramID = PA.ProgramId AND PA.AliasType = 0 \n\t) C ON B.OccurID = C.OccurID AND C.ProgramTypeID = 1 \nWHERE (UPPER(A.PathStr) = UPPER(?)) \nUNION \nSELECT \n\tC.ProgramID, \n\tC.ProgramName, \n\tD.Name AS includeName \nFROM StatementReference A \n\tINNER JOIN OccurrencesStmt B ON A.OccurID = B.OccurID \n\tINNER JOIN (\n\t\tSELECT P.ProgramID, PA.AliasName AS ProgramName, P.ProgramTypeID \n\t\tFROM Programs P \n\t\t\tINNER JOIN ProgramAliases PA ON P.ProgramID = PA.ProgramId AND PA.AliasType = 0 \n\t) C ON B.ProgID = C.ProgramID \n\tINNER JOIN Resources D ON A.ResourceID = D.ResourceID \n\tINNER JOIN Occurrences E ON D.OccurID = E.OccurID \n\tINNER JOIN Paths F ON E.PathID = F.PathID \nWHERE (A.ResourceType = 13) \n\tAND (UPPER(F.PathStr) = UPPER(?)) \n\tAND (C.ProgramTypeID = 1) ";
                    L.trace("query for preload program data: \n{}", (Object)query);
                    String[][] results = conn.executeSQL(query, new Object[]{filePath, filePath});
                    if (results != null) {
                        L.debug("preloaded data for project: {}", (Object)projectInfo.getName());
                        contextProjectsAndPrograms.put(projectInfo.getName(), results);
                    }
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            L.error("unexpected interrupt", (Throwable)e);
        }
        catch (ExecutionException e) {
            L.error("while getting data", (Throwable)e);
            ExecutionExceptionHandler.checkForEZSourceLockException((ExecutionException)e, (String)projectInfo.getName());
        }
        catch (EZSourceLockException e) {
            L.error("lock exception for project: {}", (Object)projectInfo.getName(), (Object)e);
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(MainframeSourceCobolAction.class, "project.lock.exception.text", new String[]{projectInfo.getName()}), (Plugin)Activator.getDefault(), (boolean)false);
        }
        catch (Exception e) {
            L.error("could not retrieve data for project: {}", (Object)projectInfo.getName(), (Object)e);
        }
    }

    private IActionContext createContextFromCobolSelection(EZCobolSrcSelectionType cobolSrcSelectionType) {
        final EZEntityID entityId = cobolSrcSelectionType.getEntID();
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                ProjectInfo projectInfo;
                HashMap<String, Object> data = new HashMap<String, Object>();
                IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
                List projects = service.getProjects();
                data.put("projects", projects);
                EZSourceProjectIDSg ezsourcePrjSg = (EZSourceProjectIDSg)entityId.getSegment(EZSourceProjectIDSg.class);
                ProjectInfo projectInfo2 = projectInfo = ezsourcePrjSg != null ? ezsourcePrjSg.getProjectInfo() : null;
                if (projectInfo != null) {
                    ArrayList<ProjectInfo> selectedProjects = new ArrayList<ProjectInfo>();
                    selectedProjects.add(projectInfo);
                    data.put("PROJECT_LIST", selectedProjects);
                }
                EZCobolSrcSelectionSg cobolSrcSelectionSg = (EZCobolSrcSelectionSg)entityId.getSegment(EZCobolSrcSelectionSg.class);
                String filePath = cobolSrcSelectionSg.getFilePath();
                Integer startLine = cobolSrcSelectionSg.getStartLine();
                Integer endLine = cobolSrcSelectionSg.getEndLine();
                String selectedText = cobolSrcSelectionSg.getSelectedText();
                data.put("source file path", filePath);
                data.put("start line", startLine);
                data.put("end line", endLine);
                data.put("selected text in editor", selectedText);
                return data;
            }

            public String getId() {
                return "com.ez.analysis.mainframe.source.cobol";
            }
        };
        return context;
    }
}

