/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.datasetflow.StorageInterface;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrientDBConnectPoint
implements StorageInterface {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(OrientDBConnectPoint.class);
    ODatabaseDocumentTx db;
    private OIndex<?> idx;
    static SecureRandom r = new SecureRandom();

    public OrientDBConnectPoint(String location) {
        location = "plocal:" + location + r.nextLong();
        this.startConn(location);
    }

    private void startConn(String url) {
        Throwable th = null;
        OGlobalConfiguration.USE_WAL.setValue((Object)false);
        long start = System.currentTimeMillis();
        OPartitionedDatabasePool pool = new OPartitionedDatabasePool(url, "admin", "admin", 1, -1);
        pool.setAutoCreate(true);
        this.db = pool.acquire();
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
        L.info("open: {}", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        try {
            try {
                OrientDBConnectPoint.createSchema(this.db);
                OrientDBConnectPoint.createUniqueStringIndex(this.db, "Doc", "key");
                OIndexManagerProxy im = this.db.getMetadata().getIndexManager();
                this.idx = im.getIndex("Doc.key");
            }
            catch (Throwable th1) {
                L.error("cannot open/create db", th1);
                th = th1;
                if (th != null) {
                    L.debug("end: {}", (Object)(System.currentTimeMillis() - start));
                    this.stopConn();
                    this.idx = null;
                    this.db = null;
                }
            }
        }
        finally {
            if (th != null) {
                L.debug("end: {}", (Object)(System.currentTimeMillis() - start));
                this.stopConn();
                this.idx = null;
                this.db = null;
            }
        }
    }

    @Override
    public Iterator keysIterator() {
        return this.getKeys().iterator();
    }

    public void stopConn() {
        if (this.db != null) {
            try {
                try {
                    ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
                    this.db.drop();
                }
                catch (Throwable th) {
                    L.error("cannot close db", th);
                    this.idx = null;
                    this.db = null;
                }
            }
            finally {
                this.idx = null;
                this.db = null;
            }
        }
    }

    @Override
    public void add(String leaf, List<String> data) {
        if (this.db != null) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
            ArrayList<ODocument> chains = new ArrayList<ODocument>();
            OIdentifiable rid = (OIdentifiable)this.idx.get((Object)leaf);
            ODocument chain = new ODocument("Chain");
            chain.field("segments", data);
            chains.add(chain);
            ODocument dd = new ODocument("Doc");
            dd.field("value", chains);
            if (rid == null) {
                dd.field("key", (Object)leaf);
                dd.save();
            } else {
                ODocument d = (ODocument)this.db.getRecord(rid);
                d.merge(dd, true, true);
                d.save();
            }
        } else {
            L.warn("cannot add in a null db");
        }
    }

    public List<String> getKeys() {
        ArrayList<String> ret = null;
        if (this.db != null) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
            OSQLSynchQuery query = new OSQLSynchQuery("select key from Doc order by key");
            List result = (List)this.db.command((OCommandRequest)query).execute(new Object[0]);
            if (!result.isEmpty()) {
                ret = new ArrayList<String>();
                for (ODocument d : result) {
                    ret.add((String)d.field("key"));
                }
                Collections.sort(ret, String.CASE_INSENSITIVE_ORDER);
            }
        } else {
            L.warn("cannot getKeys from a null db");
        }
        return ret;
    }

    @Override
    public boolean isNotEmpty() {
        long size = 0L;
        if (this.db != null) {
            OSQLSynchQuery query = new OSQLSynchQuery("SELECT COUNT(*) AS size FROM INDEX:Doc.key");
            List result = (List)this.db.command((OCommandRequest)query).execute(new Object[0]);
            if (!result.isEmpty()) {
                for (ODocument d : result) {
                    size = (Long)d.field("size");
                }
            }
        } else {
            L.warn("cannot getCountKeys() from a null db");
        }
        return size > 0L;
    }

    @Override
    public List<List<String>> getChains(String leaf) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        if (this.db != null) {
            long t1 = System.currentTimeMillis();
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
            OIdentifiable rid = (OIdentifiable)this.idx.get((Object)leaf);
            ODocument d = (ODocument)this.db.getRecord(rid);
            List ch = (List)d.field("value");
            if (ch != null) {
                for (ODocument cha : ch) {
                    List seg = (List)cha.field("segments");
                    ret.add(seg);
                    L.debug("\t {}", (Object)seg);
                }
            }
            L.info("getChains({}) in {}ms ({} chains)", new Object[]{leaf, System.currentTimeMillis() - t1, ret.size()});
        } else {
            L.warn("cannot getChains({}) from a null db", (Object)leaf);
        }
        return ret;
    }

    @Override
    public void clear() {
        if (this.db != null) {
            ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseDocumentInternal)this.db);
            long t1 = System.currentTimeMillis();
            try {
                this.db.getMetadata().getSchema().getClass("Doc").truncate();
            }
            catch (IOException ex) {
                L.error("error truncating content of Doc", (Throwable)ex);
                this.db.command((OCommandRequest)new OCommandSQL("TRUNCATE class Doc")).execute(new Object[0]);
            }
            L.info("clear made in {}ms", (Object)(System.currentTimeMillis() - t1));
        }
    }

    private static void createUniqueStringIndex(ODatabaseDocumentTx db, String classname, String key) {
        OIndexManagerProxy im = db.getMetadata().getIndexManager();
        String iName = String.valueOf(classname) + "." + key;
        OPropertyIndexDefinition indexDefinition = new OPropertyIndexDefinition(classname, key, OType.STRING);
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass cls = schema.getOrCreateClass(classname, schema.getClass(classname));
        ODocument metadata = new ODocument();
        im.createIndex(iName, "UNIQUE_HASH_INDEX", (OIndexDefinition)indexDefinition, cls.getPolymorphicClusterIds(), null, metadata);
    }

    private static void createSchema(ODatabaseDocumentTx db) {
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass docClass = schema.createClass("Doc");
        OClass chClass = schema.createClass("Chain");
        docClass.createProperty("key", OType.STRING);
        docClass.createProperty("value", OType.EMBEDDEDLIST, chClass);
        chClass.createProperty("segments", OType.EMBEDDEDLIST, OType.STRING);
    }
}

