/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.EZGdbReportAnalysis;
import com.ez.gdb.mainframe.reports.datasetflow.DSFlowReportJob;
import com.ez.gdb.mainframe.reports.datasetflow.DSReportDatasetInputFilter;
import com.ez.gdb.mainframe.reports.datasetflow.DSReportProjectInputFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DatasetflowReportAnalysis
extends EZGdbReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DatasetflowReportAnalysis() {
        this(null);
    }

    public DatasetflowReportAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected InputsFilter getInputsFilter() {
        Object iFilter = null;
        List inputs = this.getContextListValue("input_list");
        iFilter = inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType ? new DSReportProjectInputFilter() : new DSReportDatasetInputFilter();
        return iFilter;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, DSFlowReportJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<MultipleVSAMInput> sel = new ArrayList<MultipleVSAMInput>();
                HashSet<String> inputNames = new HashSet<String>();
                for (Object inpObj : inputs) {
                    if (!(inpObj instanceof EZSourceDataset)) continue;
                    EZEntityID entity = ((EZSourceDataset)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                        ProjectInfo pInfo = prjSg.getProjectInfo();
                        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                        this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    }
                    EZSourceDatasetIDSg datasetSg = (EZSourceDatasetIDSg)entity.getSegment(EZSourceDatasetIDSg.class);
                    String name = datasetSg.getDatasetName();
                    MultipleVSAMInput mvsami = new MultipleVSAMInput(name, datasetSg.getDatasetMemberName(), datasetSg.getDatasetId(), datasetSg.getGenerationNumber());
                    mvsami.setIncomplete(datasetSg.isIncompleteSegment());
                    sel.add(mvsami);
                    inputNames.add(name);
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                }
                if (!sel.isEmpty()) {
                    this.params.put("selected resources", sel);
                    this.addContextValue("input_list", list);
                    this.addContextValue("inputs name string", inputNames);
                }
            }
        }
    }

    @Override
    public void addParams() {
        super.addParams();
        if (this.params.get("selected resources") == null) {
            this.params.put("selected resources", this.getContextValue("selected resources"));
        }
        this.params.put("excluded datasets", this.getContextValue("excluded datasets"));
        this.params.put("directed", this.getContextValue("directed"));
        this.params.put("datasetflow threshold", this.getContextValue("datasetflow threshold"));
        this.params.put("datesetflow is limited", this.getContextValue("datesetflow is limited"));
        this.params.put("generate detailed information", this.getContextValue("generate detailed information"));
    }

    @Override
    public void addAllContextValues(Map<String, Object> context) {
        super.addAllContextValues(context);
        Collection c = (Collection)this.getContextValue("not selected datasets");
        if (c != null) {
            c.clear();
        }
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_EZREPORT_DATASETFLOW_ANALYSIS;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Direction cgDirection2;
            Direction cgDirection1 = (Direction)params1.get("directed");
            if (!cgDirection1.equals((Object)(cgDirection2 = (Direction)params2.get("directed")))) {
                ret = false;
            }
            if (ret) {
                Boolean isLimited1 = (Boolean)params1.get("datesetflow is limited");
                isLimited1 = isLimited1 == null ? false : isLimited1;
                Boolean isLimited2 = (Boolean)params2.get("datesetflow is limited");
                if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                    ret = false;
                }
                if (ret && isLimited1.booleanValue()) {
                    Integer cgLimitation1 = (Integer)params1.get("datasetflow threshold");
                    Integer cgLimitation2 = (Integer)params2.get("datasetflow threshold");
                    if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                        ret = false;
                    }
                }
                if (ret) {
                    Boolean b1 = (Boolean)params1.get("generate detailed information");
                    Boolean b2 = (Boolean)params2.get("generate detailed information");
                    if (b1 != null) {
                        ret = b2 != null ? b1.equals(b2) : false;
                    } else {
                        boolean bl = ret = b2 == null;
                    }
                    if (ret) {
                        List lst1 = (List)params1.get("excluded datasets");
                        List lst2 = (List)params2.get("excluded datasets");
                        ret = lst1 != null ? lst1.equals(lst2) : lst2 == null;
                    }
                }
            }
        }
        return ret;
    }
}

