/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.gdb.mainframe.reports.datasetflow.DSFlowReportBuilder;
import com.ez.gdb.mainframe.reports.internal.Activator;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.reports.EzReportInfoAdapter;
import com.ez.mainframe.reports.datasetflow.DatasetFlowExportAsDOCX;
import com.ez.mainframe.reports.datasetflow.DatasetFlowExportAsPDF;
import com.ez.mainframe.reports.datasetflow.DatasetFlowExportAsRTF;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.report.generation.common.ui.AbstractExportCSVAction;
import com.ez.report.generation.common.ui.EZExportAsDocxAction;
import com.ez.report.generation.common.ui.EZExportAsPdfAction;
import com.ez.report.generation.common.ui.ExportAsRtfAction;
import com.ez.report.generation.common.ui.PreGeneratedCSVExportAction;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.ReportViewer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.eclipse.swt.graphics.Image;

public class DSFlowReportJob
extends EZReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DSFlowReportJob(EZEntityID id) {
        this(Messages.getString(DSFlowReportJob.class, "jobname"), id);
    }

    public DSFlowReportJob(String arg0, EZEntityID arg1) {
        super(arg0, arg1);
        this.graphInfo = new EZReportDSFlowGI(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.initialize(this.id);
        this.initialComponent = new JLabel(Messages.getString(DSFlowReportJob.class, "report.label"));
    }

    protected AbstractBuilder getBuilder() {
        DSFlowReportBuilder builder = new DSFlowReportBuilder(this.reportName, null);
        builder.setProject(this.projectName);
        return builder;
    }

    public void setParameters(Map<String, Object> params) {
        this.cleanParams("selected resources", params);
        this.cleanParams("excluded datasets", params);
        super.setParameters(params);
    }

    private void cleanParams(String paramName, Map<String, Object> inputs) {
        Collection old = (Collection)inputs.get(paramName);
        if (old != null) {
            List inpts = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
            inputs.put(paramName, inpts);
        }
    }

    class EZReportDSFlowGI
    extends EzReportInfoAdapter {
        public EZReportDSFlowGI(EZEntityID id) {
            super(id);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/dataset.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            String txt = Messages.getString(DSFlowReportJob.class, "report.tab.title", new String[]{DSFlowReportJob.this.viewTabLabel});
            return txt;
        }

        public String getTooltip() {
            Boolean b1;
            StringBuffer buf = new StringBuffer(this.getText());
            Direction direction = (Direction)DSFlowReportJob.this.analysis.getContextValue("directed");
            if (direction != null) {
                buf.append("; ");
                buf.append(direction.toString());
            }
            if ((b1 = (Boolean)DSFlowReportJob.this.analysis.getContextValue("generate detailed information")).booleanValue()) {
                buf.append(Messages.getString(DSFlowReportJob.class, "info.txt"));
            }
            return buf.toString();
        }

        protected AbstractExportCSVAction instantiateCSVExportAction(ReportViewer reportViewer) {
            return new PreGeneratedCSVExportAction(reportViewer);
        }

        protected EZExportAsPdfAction instantiateExportPDFAction() {
            return new DatasetFlowExportAsPDF((IReportViewer)this.reportViewer);
        }

        protected ExportAsRtfAction instantiateExportRtfAction() {
            return new DatasetFlowExportAsRTF((IReportViewer)this.reportViewer);
        }

        protected EZExportAsDocxAction instantiateExportDocxAction() {
            return new DatasetFlowExportAsDOCX((IReportViewer)this.reportViewer);
        }
    }
}

