/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.EZGdbReportDatasource;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractBuilder;
import com.ez.gdb.mainframe.reports.datasetflow.Container;
import com.ez.gdb.mainframe.reports.datasetflow.DSChainsPersistentMap;
import com.ez.gdb.mainframe.reports.datasetflow.DSFlowReportBuilder;
import com.ez.gdb.mainframe.reports.datasetflow.OrientDBConnectPoint;
import com.ez.gdb.mainframe.reports.datasetflow.StorageInterface;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowModel;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowResults;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowTSGraphBuilder;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.report.application.reports.all.ChainDS;
import com.ez.report.application.reports.all.LegendDataSource;
import com.ez.report.application.reports.all.Object4Report;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFlowReportDatasource
extends EZGdbReportDatasource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSFlowReportDatasource.class);
    private static final String EMPTY_STRING = "    ";
    private Object4Report currentValue;
    private ElementGroupInfo legends;
    private String genDate;
    private SubMonitor monitor;
    DSFactory factory;
    Map reportProps = null;
    private ArrayList<VSAMInput> inputs;
    private List<VSAMInput> excludedDS;
    private Direction repDirection;
    private Integer flowLimit = null;
    private boolean generateDetailed = false;
    private boolean hasFlow = false;
    private boolean appendixBuilded = false;
    private boolean noteAddedInAppendix = false;
    private boolean excludedNoteAddedInAppendix = false;
    DSFlowReportBuilder rBuilder;
    DSFlowTSGraphBuilder graphBuilder;
    String graphsDirectory;
    private String forwardChainsLabel;
    private String backwardChainslabel;
    private boolean graphExported = false;
    DSChainsPersistentMap fwChains;
    DSChainsPersistentMap bkwChains;
    OrientDBConnectPoint gdbConnPoint;
    boolean useMapDB = false;
    int totalChainsNr = 0;
    private Set<String> excludedInputs;
    protected boolean markOnlyExpandable = false;
    private static final String STEP_INFO_QUERY = "select name, in('Steps')[0].name as jobName, in('HasST')[0].name as jclProcName from ";

    public DSFlowReportDatasource(DSFlowReportBuilder reportBuilder, Map reportProps, String genDate, CSVWriter csvWriter, IProgressMonitor pmonitor) {
        Boolean tmp;
        this.genDate = genDate;
        this.csvWriter = csvWriter;
        this.reportProps = new HashMap(reportProps);
        this.factory = new DSFactory();
        this.rBuilder = reportBuilder;
        this.inputs = new ArrayList((List)this.reportProps.get("inputs"));
        Collections.sort(this.inputs);
        this.monitor = (SubMonitor)pmonitor;
        this.monitor.beginTask("", 10 * this.inputs.size());
        this.excludedDS = (List)this.reportProps.get("excluded datasets");
        this.repDirection = (Direction)this.reportProps.get("directed");
        Integer limitObj = (Integer)this.reportProps.get("datasetflow threshold");
        if (limitObj != null) {
            this.flowLimit = (int)limitObj;
        }
        this.generateDetailed = (tmp = (Boolean)this.reportProps.get("generate detailed information")) == null ? false : tmp;
        this.graphsDirectory = com.ez.report.generation.common.utils.Utils.getGraphsDirectory();
        this.forwardChainsLabel = Messages.getString(DSFlowReportDatasource.class, "forward.chains.report.label");
        this.backwardChainslabel = Messages.getString(DSFlowReportDatasource.class, "backward.chains.report.label");
    }

    public boolean nextItem() throws JRException {
        VSAMInput inpt;
        VSAMInput vSAMInput = inpt = this.inputs != null && this.inputs.size() > 0 ? this.inputs.remove(0) : null;
        if (this.isFirst) {
            this.beforeFirstItem();
            this.writeCSVHeader();
        }
        if (inpt != null) {
            this.currentValue = this.buildCurrent(inpt, this.monitor.newChild(10));
        } else {
            this.currentValue = null;
            this.closeDatasource();
            this.closeCsvWriter();
            Boolean showAppendix = (Boolean)this.reportProps.get("show appendix");
            if (showAppendix == null || showAppendix.booleanValue()) {
                if (!this.appendixBuilded) {
                    this.monitor.subTask(Messages.getString(DSFlowReportDatasource.class, "buildappendix.subtask"));
                    this.currentValue = this.buildAppendix();
                    this.monitor.subTask("");
                    L.info("total chains number: {}", (Object)this.totalChainsNr);
                }
            } else {
                L.info("total chains number: {}", (Object)this.totalChainsNr);
            }
        }
        return this.currentValue != null;
    }

    @Override
    public void closeDatasource() {
        if (this.gdbConnPoint != null) {
            this.gdbConnPoint.stopConn();
            this.gdbConnPoint = null;
        }
        super.closeDatasource();
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("summaryDataSource")) {
            value = null;
        } else if (field.getName().equals("detailName")) {
            value = this.currentValue.getDetailName();
        } else if (field.getName().equals("detailsDataSource")) {
            value = this.currentValue.getElemDetails();
        } else if (field.getName().equals("legendDataSource")) {
            value = this.legends;
        } else if (field.getName().equals("detailTOC")) {
            Object object = value = this.currentValue.getDetailTOC() != null ? this.currentValue.getDetailTOC() : this.currentValue.getDetailName();
            if ("".equals(value)) {
                value = null;
            }
        } else if (field.getName().equals("tocTooltip")) {
            value = ReportsUtils.prepareTooltip((String)this.currentValue.getTocTooltip());
        }
        return value;
    }

    private Object4Report buildCurrent(VSAMInput vsamInput, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        L.debug("buildCurrent() for input: {}", (Object)vsamInput.getListableName());
        HashSet<VSAMInput> inputDSNames = new HashSet<VSAMInput>();
        inputDSNames.add(vsamInput);
        Set inptTmp = DSFlowModel.prepareInputs(inputDSNames);
        DSFlowResults flowResults = this.getData(vsamInput, inptTmp, monitor.newChild(50));
        boolean hasChains = flowResults.hasResults(inptTmp, true, true, true);
        this.excludedInputs = flowResults.excluded;
        this.rBuilder.checkCancelStop();
        String listableName = vsamInput.getListableName();
        String groupName4Title = ReportsUtils.stripNonValidXMLCharacters((String)Messages.getString(DSFlowReportDatasource.class, "dataset.report.label", new String[]{listableName}), (boolean)false);
        ElementGroupInfo elem = new ElementGroupInfo(groupName4Title);
        BaseSubreportDataSource elemDS = this.factory.createDS(3);
        ArrayList<Object> chainsObjList = new ArrayList<ObjectForSubreport>();
        ((SC1DataSource)elemDS).setLayout(3);
        elemDS.setList(chainsObjList);
        if (hasChains) {
            ChainDS graphDS = new ChainDS();
            ArrayList graphsList = new ArrayList();
            graphDS.setList(graphsList);
            graphDS.setTocEntry(Messages.getString(DSFlowReportDatasource.class, "graph.lbl"));
            elem.addDataSource((SubreportDataSource)graphDS);
            if (this.graphExported) {
                String graphObjName = "flowgraph";
                ObjectForSubreport obj = Utils.makeGenericEntry(graphsList, (String)graphObjName, null, (String)ReportsUtils.stripNonValidXMLCharacters((String)listableName, (boolean)false));
                String svgfileName = listableName.concat("_").concat(this.genDate);
                svgfileName = svgfileName.concat("-").concat(this.repDirection.name()).concat(" graph.svg");
                String hyp = "./" + svgfileName;
                hyp = hyp.replace("#", "%23");
                hyp = hyp.replaceAll(Matcher.quoteReplacement(File.separator), "/");
                obj.setHyperlink(hyp);
            }
        }
        elem.addDataSource((SubreportDataSource)elemDS);
        Object4Report obj4Rep = new Object4Report(groupName4Title, groupName4Title, elem);
        obj4Rep.setTocTooltip(listableName);
        monitor.worked(5);
        String inptKey = (String)inptTmp.iterator().next();
        this.initOrientTempStorage();
        if (this.repDirection == Direction.FORWARD) {
            if (hasChains && flowResults.hasResults(inptTmp, true, false, true)) {
                this.initMapDBStorage(true);
                this.populate(inptTmp, flowResults, hasChains, listableName, chainsObjList, inptKey, true, monitor);
                elemDS.setTocEntry(this.forwardChainsLabel);
            }
        } else if (this.repDirection == Direction.BACKWARD) {
            if (hasChains && flowResults.hasResults(inptTmp, false, true, true)) {
                this.initMapDBStorage(false);
                this.populate(inptTmp, flowResults, hasChains, listableName, chainsObjList, inptKey, false, monitor);
                elemDS.setTocEntry(this.backwardChainslabel);
            }
        } else if (this.repDirection == Direction.BOTH) {
            if (hasChains && flowResults.hasResults(inptTmp, true, false, true)) {
                this.initMapDBStorage(true);
                this.populate(inptTmp, flowResults, hasChains, listableName, chainsObjList, inptKey, true, monitor);
                elemDS.setTocEntry(this.forwardChainsLabel);
            }
            this.rBuilder.checkCancelStop();
            if (hasChains && flowResults.hasResults(inptTmp, false, true, true)) {
                this.initMapDBStorage(false);
                BaseSubreportDataSource elemDSBack = this.factory.createDS(3);
                chainsObjList = new ArrayList();
                ((SC1DataSource)elemDSBack).setLayout(3);
                elemDSBack.setList(chainsObjList);
                elemDSBack.setTocEntry(this.backwardChainslabel);
                elem.addDataSource((SubreportDataSource)elemDSBack);
                this.populate(inptTmp, flowResults, hasChains, listableName, chainsObjList, inptKey, false, monitor);
            }
        }
        this.rBuilder.checkCancelStop();
        flowResults.clear();
        monitor.done();
        return obj4Rep;
    }

    private void populate(Set<String> inptTmp, DSFlowResults flowResults, boolean hasChains, String listableName, List<ObjectForSubreport> chainsObjList, String inptKey, boolean isForward, SubMonitor monitor) {
        long t1 = System.currentTimeMillis();
        L.trace("{} ({})", inptTmp, (Object)(isForward ? "fw" : "bkw"));
        String lblKey = isForward ? "creating.forwardchains.subtask" : "creating.backwardchains.subtask";
        monitor.subTask(Messages.getString(DSFlowReportDatasource.class, lblKey, new String[]{com.ez.mainframe.gui.utils.Utils.escapeMetaCharacters((String)listableName)}));
        StorageInterface storage = this.getTempStorage(isForward);
        Map results = isForward ? flowResults.fwResults : flowResults.bkwResults;
        this.createChains(inptKey, results, null, storage, (IProgressMonitor)monitor);
        results.clear();
        this.rBuilder.checkCancelStop();
        monitor.worked(10);
        long t2 = System.currentTimeMillis();
        L.info("{}ms for collecting {} chains", (Object)(t2 - t1), (Object)(isForward ? "fw" : "bkw"));
        lblKey = isForward ? "printing.forwardchains.subtask" : "printing.backwardchains.subtask";
        monitor.subTask(Messages.getString(DSFlowReportDatasource.class, lblKey, new String[]{com.ez.mainframe.gui.utils.Utils.escapeMetaCharacters((String)listableName)}));
        this.addChainsToReport(listableName, isForward ? Direction.FORWARD : Direction.BACKWARD, storage, isForward ? this.forwardChainsLabel : this.backwardChainslabel, chainsObjList, flowResults.getDetails(isForward), isForward ? flowResults.fwToMark : flowResults.bkwToMark, (IProgressMonitor)monitor);
        storage.clear();
        flowResults.getDetails(isForward).clear();
        if (isForward) {
            if (flowResults.fwToMark != null) {
                flowResults.fwToMark.clear();
            }
        } else if (flowResults.bkwToMark != null) {
            flowResults.bkwToMark.clear();
        }
        monitor.subTask("");
        monitor.worked(10);
        long t3 = System.currentTimeMillis();
        L.info("{}ms for printing {} chains", (Object)(t3 - t2), (Object)(isForward ? "fw" : "bkw"));
    }

    private List<String> createChains(String inputName, Map<String, Set<String>> results, List<String> chain, StorageInterface gdbConnPoint, IProgressMonitor monitor) {
        if (chain == null) {
            chain = new ArrayList<String>();
            chain.add(inputName);
        }
        if (monitor.isCanceled()) {
            return chain;
        }
        Set<String> children = results.get(inputName);
        if (children != null && children.size() > 0) {
            ArrayList<String> tmp = new ArrayList<String>(children);
            Collections.sort(tmp, String.CASE_INSENSITIVE_ORDER);
            L.debug("create chains : children.size() {} ", (Object)children.size());
            int i = 0;
            while (i < children.size()) {
                String c = tmp.remove(0);
                boolean cont = true;
                if (chain.contains(c)) {
                    L.trace("cycle! {}", chain);
                    cont = false;
                }
                chain.add(c);
                if (cont) {
                    chain = this.createChains(c, results, chain, gdbConnPoint, monitor);
                } else {
                    String leaf = chain.get(chain.size() - 1);
                    L.trace("{}", (Object)chain.toString());
                    gdbConnPoint.add(leaf, chain);
                    chain = new ArrayList<String>(chain);
                    chain.remove(chain.size() - 1);
                }
                if (tmp.size() == 0) {
                    chain.remove(chain.size() - 1);
                }
                ++i;
            }
        } else {
            String leaf = chain.get(chain.size() - 1);
            L.trace("{}", (Object)chain.toString());
            gdbConnPoint.add(leaf, chain);
            chain = new ArrayList<String>(chain);
            chain.remove(chain.size() - 1);
        }
        return chain;
    }

    private void initOrientTempStorage() {
        if (!this.useMapDB && this.gdbConnPoint == null) {
            this.gdbConnPoint = new OrientDBConnectPoint(this.getGdbLocalFolder());
        }
    }

    private void initMapDBStorage(boolean isForward) {
        if (this.useMapDB) {
            if (isForward) {
                this.fwChains = new DSChainsPersistentMap(512);
            } else {
                this.bkwChains = new DSChainsPersistentMap(512);
            }
        }
    }

    private String getGdbLocalFolder() {
        String loc = String.valueOf(com.ez.workspace.preferences.Utils.getTemporaryFolder()) + File.separator + "gdb" + File.separator;
        return loc;
    }

    private void addChainsToReport(String rootDsName, Direction direction, StorageInterface chains, String groupLabel, List<ObjectForSubreport> chainsObjList, Map<String, Map<String, Pair<Set<Object[]>, Integer>>> details, Set<String> toMark, IProgressMonitor monitor) {
        this.rBuilder.checkCancelStop();
        if (chains != null && chains.isNotEmpty()) {
            String csvStartDataset = rootDsName;
            ArrayList<ObjectForSubreport> leafsList = new ArrayList<ObjectForSubreport>();
            Iterator keysIt = chains.keysIterator();
            int nr = 0;
            String prevLeaf = null;
            while (keysIt.hasNext()) {
                String nameToPrint;
                this.rBuilder.checkCancelStop();
                String l = null;
                Object o = keysIt.next();
                if (this.useMapDB) {
                    if (o != null && o instanceof Object[]) {
                        L.debug("array of objects instead of String");
                        Object[] obj = (Object[])o;
                        if (obj != null && obj.length > 0) {
                            L.debug("take first object as String");
                            l = (String)obj[0];
                        }
                    } else {
                        l = (String)o;
                    }
                    if (l.equals(prevLeaf)) continue;
                    prevLeaf = l;
                    ++nr;
                } else {
                    l = (String)o;
                    ++nr;
                }
                String csvTargetDataset = nameToPrint = this.getPrintableName(l);
                ObjectForSubreport chainObj = new ObjectForSubreport();
                chainObj.setExp("");
                chainObj.setElGroup(groupLabel);
                chainObj.setParent(ReportsUtils.stripNonValidXMLCharacters((String)rootDsName, (boolean)false));
                chainObj.setSubreportName("/reports/subCols1-layout3.jasper");
                SC1DataSource leafDs = new SC1DataSource();
                leafDs.setLayout(3);
                leafDs.setTocEntry(EMPTY_STRING + ReportsUtils.stripNonValidXMLCharacters((String)nameToPrint, (boolean)false));
                leafDs.setTocTooltip(nameToPrint);
                leafsList = new ArrayList();
                chainObj.setSubreportDS((BaseSubreportDataSource)leafDs);
                leafDs.setList(leafsList);
                chainsObjList.add(chainObj);
                HashMap<Object, String[]> stepCache = new HashMap<Object, String[]>();
                int chainsNr = 0;
                Iterable tmpchains = chains.getChains(l);
                for (Object c : tmpchains) {
                    List<String> chain = this.useMapDB ? ((Container)c).getChains() : (List<String>)c;
                    this.rBuilder.checkCancelStop();
                    ObjectForSubreport leafObj = new ObjectForSubreport();
                    leafObj.setExp("");
                    boolean wasExcluded = this.excludedInputs != null && this.excludedInputs.contains(l);
                    boolean hasMark = toMark != null && toMark.contains(l);
                    String mark = null;
                    if (wasExcluded) {
                        this.excludedNoteAddedInAppendix = true;
                        mark = " !";
                    } else if (hasMark) {
                        this.noteAddedInAppendix = true;
                        mark = " *";
                    }
                    String leafGroupLabel = mark != null ? String.valueOf(nameToPrint) + mark : nameToPrint;
                    leafObj.setElGroup(leafGroupLabel);
                    leafObj.setParent(String.valueOf(ReportsUtils.stripNonValidXMLCharacters((String)rootDsName, (boolean)false)) + groupLabel);
                    leafObj.setSubreportName("/reports/subCols1-layout3.jasper");
                    SC1DataSource ds = new SC1DataSource();
                    ds.setExtraTitle(ReportsUtils.stripNonValidXMLCharacters((String)rootDsName, (boolean)false));
                    ArrayList<ObjectForSubreport> chainRowsList = new ArrayList<ObjectForSubreport>();
                    ds.setList(chainRowsList);
                    leafObj.setSubreportDS((BaseSubreportDataSource)ds);
                    leafsList.add(leafObj);
                    ++chainsNr;
                    int j = 0;
                    while (j < chain.size() - 1) {
                        String chainKey = chain.get(j + 1);
                        Map<String, Pair<Set<Object[]>, Integer>> v = details.get(chainKey);
                        Pair<Set<Object[]>, Integer> p = v != null ? v.get(chain.get(j)) : null;
                        int i = p != null ? (Integer)p.getSecond() : 0;
                        String chainStep = this.getPrintableName(chainKey);
                        if (p.getFirst() != null) {
                            ArrayList<Object[]> tmp = new ArrayList<Object[]>();
                            for (Object[] data : (Set)p.getFirst()) {
                                if (data == null) continue;
                                Object[] d = Arrays.copyOf(data, 8);
                                d[7] = data[5];
                                String[] det = (String[])stepCache.get(data[4]);
                                if (det == null) {
                                    det = this.getInfo(this.dbg, (String)data[4]);
                                    stepCache.put(data[4], det);
                                }
                                if (stepCache.size() > 5000) {
                                    stepCache.clear();
                                    L.debug("free steps info clear cache ");
                                }
                                d[4] = det[0];
                                d[5] = det[1];
                                d[6] = det[2];
                                tmp.add(d);
                                if (!this.generateDetailed) break;
                            }
                            Collections.sort(tmp, new ChainComparator());
                            boolean firstFromMany = false;
                            for (Object[] data : tmp) {
                                if (data == null) continue;
                                L.trace("{}", (Object)Arrays.toString(data));
                                if (data[3] == null) continue;
                                this.printRow(csvStartDataset, direction, csvTargetDataset, mark, chainRowsList, j, i, firstFromMany, chainStep, data);
                                if (!this.generateDetailed) break;
                                firstFromMany = true;
                            }
                            tmp.clear();
                            tmp = null;
                        }
                        ++j;
                    }
                }
                L.info("{} chains for leaf: {}", (Object)chainsNr, (Object)l);
                this.totalChainsNr += chainsNr;
                stepCache.clear();
                stepCache = null;
            }
            L.info("{} leaves for input {}", (Object)nr, (Object)rootDsName);
        }
    }

    private void printRow(String csvStartDataset, Direction direction, String csvTargetDataset, String mark, List<ObjectForSubreport> chainRowsList, int j, int no, boolean firstFromMany, String chainStep, Object[] data) {
        String csvDirection = null;
        String directionArrow = "";
        if (direction == Direction.BACKWARD) {
            directionArrow = " <- ";
            csvDirection = direction.toString();
        }
        if (direction == Direction.FORWARD) {
            directionArrow = " -> ";
            csvDirection = direction.toString();
        }
        String csvProgram = (String)data[3];
        String csvJobName = data[4] != null ? data[4].toString() : null;
        String csvStepName = data[5] != null ? data[5].toString() : null;
        String csvProcName = data[6] != null ? data[6].toString() : null;
        String csvLineInProc_Job = data[7] != null ? data[7].toString() : null;
        String csvNumberInChain = null;
        String csvDatasetChainElement = null;
        String csvFiltered = Messages.getString(DSFlowReportDatasource.class, "csv.content.filtered.no");
        StringBuffer txtBuffer = new StringBuffer();
        txtBuffer.append(csvProgram);
        txtBuffer.append("[");
        txtBuffer.append(csvJobName).append("/");
        txtBuffer.append(csvStepName);
        if (csvProcName != null) {
            txtBuffer.append("/").append(csvProcName);
        } else {
            csvProcName = "";
        }
        txtBuffer.append("(").append(csvLineInProc_Job).append(")");
        txtBuffer.append("]");
        if (!this.generateDetailed && no > 1) {
            txtBuffer.append(Messages.getString(DSFlowReportDatasource.class, "report.content.1ofMany", new Object[]{no}));
            csvFiltered = Messages.getString(DSFlowReportDatasource.class, "csv.content.1ofMany", new Object[]{no});
        }
        ObjectForSubreport rowObj = new ObjectForSubreport();
        if (!firstFromMany) {
            rowObj.setExp(ReportsUtils.stripNonValidXMLCharacters((String)(String.valueOf(directionArrow) + chainStep), (boolean)false));
        } else {
            rowObj.setExp("");
        }
        rowObj.setExpVal(ReportsUtils.stripNonValidXMLCharacters((String)txtBuffer.toString(), (boolean)false));
        chainRowsList.add(rowObj);
        csvNumberInChain = "" + (j + 1);
        csvDatasetChainElement = chainStep;
        this.writeCsvRow(csvStartDataset, csvDirection, csvTargetDataset, mark, csvNumberInChain, csvDatasetChainElement, csvProgram, csvJobName, csvStepName, csvProcName, csvLineInProc_Job, csvFiltered);
    }

    private String[] getInfo(OrientBaseGraph dbg, String stepRid) {
        String[] ret = null;
        Iterable results = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(STEP_INFO_QUERY.concat(stepRid))).execute(new Object[0]);
        L.debug("execute query for step {} info ", (Object)stepRid);
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            OrientElement elem = (OrientElement)iterator.next();
            String stepName = (String)elem.getProperty("name");
            String jobName = (String)elem.getProperty("jobName");
            String jclProcName = (String)elem.getProperty("jclProcName");
            ret = new String[]{jobName, stepName, jclProcName};
        }
        return ret;
    }

    private void writeCsvRow(String csvStartDataset, String csvDirection, String csvTargetDataset, String mark, String csvNumberInChain, String csvDatasetChainElement, String csvProgram, String csvJobName, String csvStepName, String csvProcName, String csvLineInProc_Job, String csvFiltered) {
        if (this.csvWriter != null) {
            if (this.generateDetailed) {
                this.csvWriter.write(new String[]{csvStartDataset, csvDirection, csvTargetDataset, mark != null ? mark.trim() : "", csvNumberInChain, csvDatasetChainElement, csvProgram, csvJobName, csvStepName, csvProcName, csvLineInProc_Job});
            } else {
                this.csvWriter.write(new String[]{csvStartDataset, csvDirection, csvTargetDataset, mark != null ? mark.trim() : "", csvNumberInChain, csvDatasetChainElement, csvProgram, csvJobName, csvStepName, csvProcName, csvLineInProc_Job, csvFiltered});
            }
        }
    }

    private String getPrintableName(String l) {
        Pair pair = com.ez.gdb.core.utils.Utils.splitDSid((String)l);
        String memberName = pair.getSecond() == null ? "" : (String)pair.getSecond();
        String dsname = (String)pair.getFirst();
        MultipleVSAMInput inpt = new MultipleVSAMInput(dsname, memberName, null, null);
        String nameToPrint = inpt.getListableName();
        return nameToPrint;
    }

    private DSFlowResults getData(VSAMInput vsamInput, Set<String> inptTmp, SubMonitor monitor) {
        long t1 = System.currentTimeMillis();
        DSFlowModel model = new DSFlowModel(this.dbg, inptTmp, DSFlowModel.prepareInputs(this.excludedDS), this.repDirection, this.flowLimit);
        model.setReportCongfigs(true, this.generateDetailed);
        model.setMarkOnlyExpandable(this.markOnlyExpandable);
        monitor.subTask(Messages.getString(DSFlowReportDatasource.class, "gettingdata.subtask", new String[]{com.ez.mainframe.gui.utils.Utils.escapeMetaCharacters((String)vsamInput.getListableName())}));
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DSFlowResults flowResults = model.doFlow(mon.newChild(70));
        long t2 = System.currentTimeMillis();
        L.info("{}ms to get data from OrientDB and build graph model", (Object)(t2 - t1));
        if (!mon.isCanceled()) {
            boolean hasChains;
            boolean bl = hasChains = flowResults != null && !flowResults.isEmpty();
            if (hasChains) {
                monitor.subTask(Messages.getString(DSFlowReportDatasource.class, "creating.graph.subtask", new String[]{com.ez.mainframe.gui.utils.Utils.escapeMetaCharacters((String)vsamInput.getListableName())}));
                this.graphExported = this.buildTSGraph(vsamInput, inptTmp, flowResults, mon.newChild(30));
                long t3 = System.currentTimeMillis();
                L.info("{}ms for building and exporting TS graph", (Object)(t3 - t2));
            } else {
                this.graphExported = false;
                mon.worked(30);
            }
        } else {
            L.debug("build of graph was canceled");
            this.graphExported = false;
            mon.worked(30);
        }
        monitor.subTask("");
        this.hasFlow = this.hasFlow || this.graphExported;
        return flowResults;
    }

    private boolean buildTSGraph(VSAMInput input, Set<String> inptTmp, DSFlowResults flowResults, final SubMonitor monitor) {
        boolean hasGraph;
        block12: {
            hasGraph = false;
            Runnable stopCode = new Runnable(){

                @Override
                public void run() {
                    if (monitor.isCanceled()) {
                        throw new CanceledException(Messages.getString(DSFlowReportDatasource.class, "graph.canceled.message"));
                    }
                }
            };
            if (this.graphBuilder == null) {
                this.graphBuilder = new DSFlowTSGraphBuilder(stopCode);
            }
            TSEGraph graph = null;
            try {
                try {
                    graph = (TSEGraph)this.graphBuilder.getGraphManager().addGraph();
                    hasGraph = this.graphBuilder.fillTSGraph(inptTmp, flowResults, graph, (IProgressMonitor)monitor.newChild(100));
                    if (!hasGraph) {
                        L.debug("no dataset flow graph for inputNames: {}", this.inputs);
                        break block12;
                    }
                    L.info("graph nodes size: {}", (Object)graph.numberOfNodes());
                    L.info("graph edges size: {}", (Object)graph.numberOfEdges());
                    this.useMapDB = graph.numberOfEdges() < 2000;
                    stopCode.run();
                    long t = System.currentTimeMillis();
                    L.debug("applying layout");
                    monitor.subTask(Messages.getString(DSFlowReportDatasource.class, "graph.applyinglayout.subtask"));
                    this.rBuilder.doHierarchicalLayout(this.graphBuilder.getGraphManager(), 3);
                    monitor.subTask("");
                    L.info("{}ms to apply layout", (Object)(System.currentTimeMillis() - t));
                    stopCode.run();
                    this.exportToSvg(input, monitor);
                }
                catch (CanceledException canceledException) {
                    L.info("Export of datasetflow graph of {} was canceled by user", (Object)input.getListableName());
                    hasGraph = false;
                    if (flowResults != null) {
                        flowResults.clear();
                    }
                    if (this.graphBuilder != null) {
                        this.graphBuilder.clean();
                    }
                    if (graph != null) {
                        graph.dispose();
                        graph = null;
                    }
                }
            }
            finally {
                if (this.graphBuilder != null) {
                    this.graphBuilder.clean();
                }
                if (graph != null) {
                    graph.dispose();
                    graph = null;
                }
            }
        }
        return hasGraph;
    }

    private void exportToSvg(VSAMInput input, SubMonitor monitor) {
        String svgfileName = input.getListableName().concat("_").concat(this.genDate);
        svgfileName = svgfileName.concat("-").concat(this.repDirection.name()).concat(" graph.svg");
        L.debug("start export to SVG {}", (Object)svgfileName);
        monitor.subTask(Messages.getString(DSFlowReportDatasource.class, "exporting.graph.subtask", new String[]{com.ez.mainframe.gui.utils.Utils.escapeMetaCharacters((String)input.getListableName()), svgfileName}));
        File gd = new File(this.graphsDirectory);
        if (!gd.exists()) {
            gd.mkdirs();
        }
        String svgFilePath = this.graphsDirectory.concat(File.separator).concat(svgfileName);
        long t = System.currentTimeMillis();
        this.rBuilder.exportToSVGFile(svgFilePath, this.graphBuilder.getGraphManager());
        L.info("{}ms to export graph in SVG", (Object)(System.currentTimeMillis() - t));
        L.debug("finished export -------");
        this.rBuilder.addExportedFile(ExtraFileType.GRAPH, svgfileName);
    }

    private Object4Report buildAppendix() {
        ObjectForSubreport o;
        String[] results;
        VSAMInput dataSet;
        Iterator<Object> iterator;
        ArrayList<ObjectForSubreport> subreportLst;
        SC3DataSource appDS;
        ObjectForSubreport obj;
        this.legends = new ElementGroupInfo("legends");
        SC1DataSource dataSource = (SC1DataSource)this.factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(DSFlowReportDatasource.class, "appendix.chaindescription.extratitle"));
        dataSource.setLayout(2);
        Object[] params = new String[]{Messages.getString(DSFlowReportDatasource.class, "appendix.chaincontent")};
        dataSource.setTitleDescription(ReportsUtils.stripNonValidXMLCharacters((String)Messages.getString(DSFlowReportDatasource.class, "appendix.chaincontent.description.title", params), (boolean)false));
        ArrayList<ObjectForSubreport> list = new ArrayList<ObjectForSubreport>();
        String[] chainElems = new String[]{Messages.getString(DSFlowReportDatasource.class, "appendix.chain.pgm.label"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.job.label"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.step.label"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.procedure.label"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.lineInProc.label"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.oneof.label")};
        String[] strings = new String[]{Messages.getString(DSFlowReportDatasource.class, "appendix.chain.pgm.descr"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.job.desc"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.step.desc"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.proc.desc"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.lineInProc.desc"), Messages.getString(DSFlowReportDatasource.class, "appendix.chain.oneof.desc")};
        int i = 0;
        while (i < chainElems.length) {
            obj = new ObjectForSubreport();
            obj.setExp(ReportsUtils.stripNonValidXMLCharacters((String)(EMPTY_STRING + chainElems[i]), (boolean)false));
            obj.setExpVal(ReportsUtils.stripNonValidXMLCharacters((String)strings[i], (boolean)false));
            list.add(obj);
            ++i;
        }
        dataSource.setList(list);
        this.legends.addDataSource((SubreportDataSource)dataSource);
        this.legends.addDataSource((SubreportDataSource)this.factory.createDS(5));
        if (this.hasFlow) {
            this.createEntry4Legends();
            this.legends.addDataSource((SubreportDataSource)this.factory.createDS(5));
        }
        if (this.noteAddedInAppendix || this.excludedNoteAddedInAppendix) {
            this.legends.addDataSource((SubreportDataSource)CalltreeReportsAbstractBuilder.buildAppendixDS4Notes((DSFactory)this.factory, (boolean)this.noteAddedInAppendix, (boolean)this.markOnlyExpandable, (boolean)this.excludedNoteAddedInAppendix));
        }
        dataSource = (SC1DataSource)this.factory.createDS(3);
        dataSource.setExtraTitle(Messages.getString(DSFlowReportDatasource.class, "rep.inputs.descr"));
        dataSource.setLayout(6);
        list = new ArrayList();
        dataSource.setList(list);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(DSFlowReportDatasource.class, "report.direction"));
        obj.setExpVal(this.repDirection.toString());
        list.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(DSFlowReportDatasource.class, "report.depth.appendix.text"));
        if (this.flowLimit != null) {
            obj.setExpVal(String.valueOf(this.flowLimit));
        } else {
            obj.setExpVal(Messages.getString(DSFlowReportDatasource.class, "report.depth.appendix.unlimtedvalue"));
        }
        list.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(Messages.getString(DSFlowReportDatasource.class, "report.alldetails.appendix.text"));
        if (this.generateDetailed) {
            obj.setExpVal(Messages.getString(DSFlowReportDatasource.class, "report.alldetails.appendix.yes.value"));
        } else {
            obj.setExpVal(Messages.getString(DSFlowReportDatasource.class, "report.alldetails.appendix.no.value"));
        }
        list.add(obj);
        obj = new ObjectForSubreport();
        List workerInputs = (List)this.reportProps.get("inputs");
        Boolean showInputs = (Boolean)this.reportProps.get("showInputDetails");
        if (showInputs.booleanValue()) {
            obj.setExp(Messages.getString(DSFlowReportDatasource.class, "dataset.report.inputs"));
            appDS = new SC3DataSource();
            appDS.setLayout(5);
            subreportLst = new ArrayList<ObjectForSubreport>();
            iterator = workerInputs.iterator();
            while (iterator.hasNext()) {
                this.rBuilder.checkCancelStop();
                dataSet = (VSAMInput)iterator.next();
                results = new String[]{"", ReportsUtils.stripNonValidXMLCharacters((String)dataSet.getListableName(), (boolean)true)};
                o = this.factory.createObj(1, results, "");
                subreportLst.add(o);
            }
            appDS.setList(subreportLst);
            obj.setSubreportDS((BaseSubreportDataSource)appDS);
            obj.setSubreportName("reports/subCols3-layout5.jasper");
        } else {
            obj.setExp(Messages.getString(DSFlowReportDatasource.class, "dataset.report.inputs.short"));
            obj.setExpVal("" + workerInputs.size());
        }
        list.add(obj);
        if (this.excludedDS != null && !this.excludedDS.isEmpty()) {
            obj = new ObjectForSubreport();
            if (showInputs.booleanValue()) {
                obj.setExp(Messages.getString(DSFlowReportDatasource.class, "excluded.inputs"));
                appDS = new SC3DataSource();
                appDS.setLayout(5);
                subreportLst = new ArrayList();
                iterator = this.excludedDS.iterator();
                while (iterator.hasNext()) {
                    this.rBuilder.checkCancelStop();
                    dataSet = (VSAMInput)iterator.next();
                    results = new String[]{"", ReportsUtils.stripNonValidXMLCharacters((String)dataSet.getListableName(), (boolean)true)};
                    o = this.factory.createObj(1, results, "");
                    subreportLst.add(o);
                }
                appDS.setList(subreportLst);
                obj.setSubreportDS((BaseSubreportDataSource)appDS);
                obj.setSubreportName("reports/subCols3-layout5.jasper");
            } else {
                obj.setExp(Messages.getString(DSFlowReportDatasource.class, "excluded.inputs.short"));
                obj.setExpVal("" + this.excludedDS.size());
            }
            list.add(obj);
        }
        this.legends.addDataSource((SubreportDataSource)dataSource);
        this.appendixBuilded = true;
        return new Object4Report("");
    }

    private void createEntry4Legends() {
        ArrayList<String[]> scores = new ArrayList<String[]>();
        String[] stringArray = new String[3];
        stringArray[0] = Messages.getString(DSFlowReportDatasource.class, "nodes.lbl");
        String[] nodesTitle = stringArray;
        String[] stringArray2 = new String[8];
        stringArray2[1] = "paleRed";
        stringArray2[2] = Messages.getString(DSFlowReportDatasource.class, "paleRed.desc");
        stringArray2[7] = "true";
        String[] nodes1 = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[1] = "darkCyan";
        stringArray3[2] = Messages.getString(DSFlowReportDatasource.class, "darkCyan.desc");
        String[] nodes2 = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = Messages.getString(DSFlowReportDatasource.class, "edges.lbl");
        String[] edgesTitle = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[1] = "black";
        stringArray5[2] = Messages.getString(DSFlowReportDatasource.class, "edge.desc");
        String[] edges1 = stringArray5;
        scores.add(nodesTitle);
        scores.add(nodes1);
        scores.add(nodes2);
        scores.add(edgesTitle);
        scores.add(edges1);
        if (this.noteAddedInAppendix || this.excludedNoteAddedInAppendix) {
            String[] stringArray6 = new String[3];
            stringArray6[0] = Messages.getString(DSFlowReportDatasource.class, "appendix.legend.notes.title");
            scores.add(stringArray6);
            if (this.excludedNoteAddedInAppendix) {
                String[] stringArray7 = new String[6];
                stringArray7[2] = Messages.getString(DSFlowReportDatasource.class, "appendix.legend.notes.patternname");
                stringArray7[5] = "patternRestriction";
                scores.add(stringArray7);
            }
            if (this.noteAddedInAppendix) {
                String txt = this.markOnlyExpandable ? Messages.getString(DSFlowReportDatasource.class, "appendix.legend.notes.limitReached.onlyexpandables") : Messages.getString(DSFlowReportDatasource.class, "appendix.legend.notes.limitReached.all");
                String[] stringArray8 = new String[6];
                stringArray8[2] = txt;
                stringArray8[5] = "limitReached";
                scores.add(stringArray8);
            }
        }
        this.legends.addDataSource((SubreportDataSource)new LegendDataSource(Messages.getString(DSFlowReportDatasource.class, "report.appendix.legend.title"), scores));
    }

    @Override
    protected String getProject() {
        String prjName = (String)this.reportProps.get("input_project_names");
        prjName = this.rBuilder.getReportModel().projectName;
        return prjName;
    }

    protected void writeCSVHeader() {
        if (this.csvWriter != null) {
            this.csvWriter.writeLine(Messages.getString(DSFlowReportDatasource.class, "csv.header.report.title"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
            this.csvWriter.writeLine(String.valueOf(Messages.getString(DSFlowReportDatasource.class, "csv.header.date")) + " " + sdf.format(new Date()));
            this.csvWriter.writeLine(Messages.getString(DSFlowReportDatasource.class, "csv.header.project", new String[]{this.getProject()}));
            String limit = Messages.getString(DSFlowReportDatasource.class, "csv.header.depth.unlimtedvalue");
            if (this.flowLimit != null) {
                limit = String.valueOf(this.flowLimit);
            }
            this.csvWriter.writeLine(Messages.getString(DSFlowReportDatasource.class, "csv.header.depth", new String[]{limit}));
            boolean hasLimit = this.flowLimit != null;
            Utils.writeNotePartInCSV((CSVWriter)this.csvWriter, (boolean)hasLimit, (boolean)this.markOnlyExpandable, (boolean)true);
            if (this.generateDetailed) {
                this.csvWriter.write(new String[]{Messages.getString(DSFlowReportDatasource.class, "csv.header.startDataset"), Messages.getString(DSFlowReportDatasource.class, "csv.header.dataflowDirection"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetTarget"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetTargetNote"), Messages.getString(DSFlowReportDatasource.class, "csv.header.numberInChain"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetChainElement"), Messages.getString(DSFlowReportDatasource.class, "csv.header.program"), Messages.getString(DSFlowReportDatasource.class, "csv.header.job"), Messages.getString(DSFlowReportDatasource.class, "csv.header.step"), Messages.getString(DSFlowReportDatasource.class, "csv.header.proc"), Messages.getString(DSFlowReportDatasource.class, "csv.header.lineInJob_Proc")});
            } else {
                this.csvWriter.write(new String[]{Messages.getString(DSFlowReportDatasource.class, "csv.header.startDataset"), Messages.getString(DSFlowReportDatasource.class, "csv.header.dataflowDirection"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetTarget"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetTargetNote"), Messages.getString(DSFlowReportDatasource.class, "csv.header.numberInChain"), Messages.getString(DSFlowReportDatasource.class, "csv.header.datasetChainElement"), Messages.getString(DSFlowReportDatasource.class, "csv.header.program"), Messages.getString(DSFlowReportDatasource.class, "csv.header.job"), Messages.getString(DSFlowReportDatasource.class, "csv.header.step"), Messages.getString(DSFlowReportDatasource.class, "csv.header.proc"), Messages.getString(DSFlowReportDatasource.class, "csv.header.lineInJob_Proc"), Messages.getString(DSFlowReportDatasource.class, "csv.header.filtered")});
            }
        }
    }

    @Override
    public void clear() {
        this.currentValue = null;
        this.excludedDS = null;
        this.excludedInputs = null;
        if (this.inputs != null) {
            this.inputs.clear();
            this.inputs = null;
        }
        this.legends = null;
        if (this.reportProps != null) {
            this.reportProps.clear();
            this.reportProps = null;
        }
        this.rBuilder = null;
        if (this.graphBuilder != null) {
            this.graphBuilder.dispose();
            this.graphBuilder = null;
        }
        this.uninitTempStorage();
        super.clear();
    }

    private StorageInterface getTempStorage(boolean isForward) {
        OrientDBConnectPoint storage = this.useMapDB ? (isForward ? this.fwChains : this.bkwChains) : this.gdbConnPoint;
        return storage;
    }

    private void uninitTempStorage() {
        if (this.bkwChains != null) {
            this.bkwChains.clear();
            this.bkwChains = null;
        }
        if (this.fwChains != null) {
            this.fwChains.clear();
            this.fwChains = null;
        }
        if (this.gdbConnPoint != null) {
            this.gdbConnPoint.stopConn();
            this.gdbConnPoint = null;
        }
    }

    @Override
    protected void prepareInputs() {
        this.markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
    }

    class ChainComparator
    implements Comparator<Object[]> {
        ChainComparator() {
        }

        @Override
        public int compare(Object[] arg0, Object[] arg1) {
            int ret = 0;
            if (arg0[4] != null && arg1[4] != null) {
                ret = ((String)arg0[4]).compareToIgnoreCase((String)arg1[4]);
            }
            if (ret == 0 && arg0[5] != null && arg1[5] != null) {
                ret = ((String)arg0[5]).compareToIgnoreCase((String)arg1[5]);
            }
            if (ret == 0 && arg0[6] != null && arg1[6] != null) {
                ret = ((String)arg0[6]).compareToIgnoreCase((String)arg1[6]);
            }
            if (ret == 0 && arg0[7] != null && arg1[7] != null) {
                ret = ((Integer)arg0[7]).compareTo((Integer)arg1[7]);
            }
            if (ret == 0 && arg0[3] != null && arg1[3] != null) {
                ret = ((String)arg0[3]).compareToIgnoreCase((String)arg1[3]);
            }
            return ret;
        }
    }
}

