/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.datasetflow.DSFlowReportDatasource;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.reports.gui.AbstractReportBuilderWithTS;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.datasetflow.ReportModel;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.Utils;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFlowReportBuilder
extends AbstractReportBuilderWithTS {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSFlowReportBuilder.class);

    public DSFlowReportBuilder(String reportName, String settings) {
        this.report = null;
        this.needsTS = true;
    }

    protected String getReportTemplatePath() {
        return "reports/genericReport.jasper";
    }

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(DSFlowReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String externalized = Messages.getString(DSFlowReportBuilder.class, "report.title");
        this.parameters.put("report.title", externalized);
        Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"detailsSubreportTemplate", (Map)this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) throws Exception {
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        String genDate = this.getGenDate(this.report);
        DSFlowReportDatasource dds = new DSFlowReportDatasource(this, this.report.properties, genDate, csvWriter, monitor);
        return dds;
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public void cleanMemory() {
        if (this.ds != null) {
            ((DSFlowReportDatasource)this.ds).clear();
        }
        super.cleanMemory();
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            ArrayList inpts = new ArrayList((List)this.inputs.get("selected resources"));
            this.report.addProperty("inputs", inpts);
            this.report.addProperty("datasetflow threshold", this.inputs.get("datasetflow threshold"));
            List excludedDatasets = (List)this.inputs.get("excluded datasets");
            this.report.addProperty("excluded datasets", (Object)excludedDatasets);
            Direction direction = (Direction)this.inputs.get("directed");
            this.report.addProperty("directed", (Object)direction);
            Object gdi = this.inputs.get("generate detailed information");
            boolean generateDetailedInfo = gdi != null ? (Boolean)gdi : false;
            this.report.addProperty("generate detailed information", (Object)generateDetailedInfo);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected void doHierarchicalLayout(TSEGraphManager gManager, int levelDirection) {
        L.trace("before layout");
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)gManager);
        TSHierarchicalLayoutInputTailor hierarchicalLayoutInputTailor = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData);
        hierarchicalLayoutInputTailor.setGraph(gManager.getMainDisplayGraph());
        hierarchicalLayoutInputTailor.setLevelDirection(3);
        hierarchicalLayoutInputTailor.setLevelAlignment(1);
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSApplyLayoutResults applyResults = new TSApplyLayoutResults();
        applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        if (this.applyRouting(inputData, gManager)) {
            outputData = new TSServiceOutputData();
            layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
            applyResults = new TSApplyLayoutResults();
            applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        }
        L.trace("after layout");
    }

    public void exportToSVGFile(String svgFilePath, TSEGraphManager graphManager) {
        this.exportToSVGFile(new File(svgFilePath), graphManager);
    }

    protected void checkCancelStop() {
        this.checkStop();
    }
}

