/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.datasetflow.ChainsSerializer;
import com.ez.gdb.mainframe.reports.datasetflow.Container;
import com.ez.gdb.mainframe.reports.datasetflow.StorageInterface;
import com.ez.report.application.utils.mapDB.PersistentCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerArrayTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSChainsPersistentMap
extends PersistentCollection
implements Map<String, Iterable<Container>>,
StorageInterface {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSChainsPersistentMap.class);
    NavigableSet<Object[]> map;

    DSChainsPersistentMap(int cacheSize) {
        super(DSChainsPersistentMap.class, cacheSize);
        this.createMap();
    }

    private void createMap() {
        this.map = (NavigableSet)this.db.treeSet("chains").serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{Serializer.STRING, new ChainsSerializer()}, new Comparator[]{String.CASE_INSENSITIVE_ORDER, new Comparator<Container>(){

            @Override
            public int compare(Container o1, Container o2) {
                return o1.compareTo(o2);
            }
        }})).create();
    }

    @Override
    public void add(String leaf, List<String> data) {
        long t;
        block8: {
            Throwable th2;
            block9: {
                L.debug("------------------- begin add -----------------------------");
                t = System.currentTimeMillis();
                try {
                    Container cont = new Container(data);
                    boolean added = this.map.add(new Object[]{leaf, cont});
                    if (!added) {
                        L.info("data {} not added to leaf {}", (Object)data.toString(), (Object)leaf);
                    }
                    break block8;
                }
                catch (Throwable th2) {
                    L.error("exception adding data {} to leaf [{}]; ignored", new Object[]{data, leaf, th2});
                    if (!L.isTraceEnabled()) break block9;
                    try {
                        Object it = this.get(leaf);
                        if (it != null && it.iterator() != null && it.iterator().hasNext()) {
                            Iterator iter = it.iterator();
                            while (iter.hasNext()) {
                                L.trace(((Container)iter.next()).chains.toString());
                            }
                        } else {
                            L.trace("no values for leaf [{}]", (Object)leaf);
                        }
                    }
                    catch (Throwable th22) {
                        L.error("error showing values for {}", (Object)leaf, (Object)th22);
                    }
                }
            }
            throw th2;
        }
        L.debug("------------------- end add; time={} -----------------------------", (Object)(System.currentTimeMillis() - t));
    }

    @Override
    public Iterable<Container> get(Object leaf) {
        Iterable<Container> iterable = null;
        String leafAsString = (String)leaf;
        Object[] objectArray = new Object[2];
        objectArray[0] = leafAsString;
        SortedSet<Object[]> mapSubset = this.map.subSet(new Object[]{leafAsString}, objectArray);
        if (!mapSubset.isEmpty()) {
            ArrayList vals = new ArrayList();
            mapSubset.forEach((? super T s) -> {
                boolean bl = vals.add((Container)s[1]);
            });
            iterable = () -> vals.iterator();
        } else {
            iterable = Collections.emptyList();
        }
        return iterable;
    }

    @Override
    public boolean isEmpty() {
        return this.map != null && this.map.isEmpty();
    }

    @Override
    public Iterator keysIterator() {
        return this.map.iterator();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Iterable getChains(String leaf) {
        return this.get(leaf);
    }

    @Override
    public Set<String> keySet() {
        L.warn("keySet() not implemented!");
        return null;
    }

    @Override
    public boolean containsKey(Object arg0) {
        L.warn("containsKey(arg0) not implemented!");
        return false;
    }

    @Override
    public boolean containsValue(Object arg0) {
        L.warn("containsValue(arg0) not implemented!");
        return false;
    }

    @Override
    public Set<Map.Entry<String, Iterable<Container>>> entrySet() {
        L.warn("entrySet() not implemented!");
        return null;
    }

    @Override
    public Iterable<Container> put(String key, Iterable<Container> value) {
        L.warn("put(key, value) not implemented!");
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Iterable<Container>> m) {
        L.warn("putAll() not implemented!");
    }

    @Override
    public Iterable<Container> remove(Object key) {
        L.warn("remove(key) not implemented!");
        return null;
    }

    @Override
    public int size() {
        L.warn("size() not implemented!");
        return 0;
    }

    @Override
    public Collection<Iterable<Container>> values() {
        L.warn("values() not implemented!");
        return null;
    }
}

