/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.datasetflow;

import com.ez.gdb.mainframe.reports.datasetflow.Container;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainsSerializer
implements Serializer<Container>,
Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ChainsSerializer.class);

    public void serialize(DataOutput2 out, Container data) throws IOException {
        try {
            if (data == null) {
                L.debug("serialize; null_object");
                out.writeInt(0);
                out.writeUTF("null_object");
            } else if (data.chains != null && !data.chains.isEmpty()) {
                out.writeInt(data.chains.size());
                int i = 0;
                while (i < data.chains.size()) {
                    out.writeUTF(data.chains.get(i));
                    ++i;
                }
            } else {
                L.debug("serialize; null_list");
                out.writeInt(0);
                out.writeUTF("null_list");
            }
        }
        catch (Exception ex) {
            L.error("exception at serialization; ignored", (Throwable)ex);
        }
    }

    public Container deserialize(DataInput2 in, int available) throws IOException {
        Container data = null;
        try {
            if (available == 0) {
                L.info("deserialize; available=0");
            }
            int size = in.readInt();
            String tmp = in.readUTF();
            if ("null_object".equals(tmp)) {
                L.debug("deserialize; {}, {}", (Object)tmp, (Object)size);
            } else {
                ArrayList<String> lst = null;
                if ("null_list".equals(tmp)) {
                    L.debug("deserialize; {}, {}", (Object)tmp, (Object)size);
                    data = new Container(lst);
                } else {
                    lst = new ArrayList<String>();
                    data = new Container(lst);
                    int i = 0;
                    while (i < size) {
                        lst.add(tmp);
                        if (i < size - 1) {
                            tmp = in.readUTF();
                        }
                        ++i;
                    }
                }
            }
            L.trace("deserialize data={}", (Object)data.chains.toString());
        }
        catch (Exception ex) {
            L.error("exception at serialization; ignored", (Throwable)ex);
        }
        return data;
    }

    public int fixedSize() {
        return -1;
    }
}

