/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree.ui;

import com.ez.common.ui.listselection.Listable;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CallchainsReportsWizardPage<T extends Listable>
extends GenericSelectInputPage4Report<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final String errorMsg = Messages.getString(CallchainsReportsWizardPage.class, "level.thresold.error");
    private Button btnlimited;
    private Text thresholdLimit;

    public CallchainsReportsWizardPage(String pageName, boolean useFilters) {
        super(pageName, useFilters);
    }

    protected void addShowAppendixOptions(Composite group) {
        super.addShowAppendixOptions(group);
        Composite cParent = new Composite(group, 0);
        cParent.setLayout((Layout)new GridLayout(2, false));
        cParent.setLayoutData((Object)new GridData(4, 4, true, true));
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.wizard.set("is graph limited", (Object)isLimited);
        this.btnlimited = new Button(cParent, 32);
        this.btnlimited.setText(Messages.getString(CallchainsReportsWizardPage.class, "showFiltered.lbl"));
        this.btnlimited.setSelection(isLimited);
        this.btnlimited.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isCgLimited = CallchainsReportsWizardPage.this.btnlimited.getSelection();
                CallchainsReportsWizardPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                CallchainsReportsWizardPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (isCgLimited) {
                    CallchainsReportsWizardPage.this.catchThresholdLimit();
                } else {
                    CallchainsReportsWizardPage.this.wizard.set("limit number for graph levels", null);
                    CallchainsReportsWizardPage.this.setErrorMessage(null);
                }
            }
        });
        GridData data = new GridData();
        this.btnlimited.setLayoutData((Object)data);
        this.thresholdLimit = new Text(cParent, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CallchainsReportsWizardPage.this.catchThresholdLimit();
                CallchainsReportsWizardPage.this.setPageComplete(CallchainsReportsWizardPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
        if (isLimited) {
            this.catchThresholdLimit();
        }
    }

    private void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(this.errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(this.errorMsg);
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", (Object)threshold);
            }
        }
    }
}

