/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree.sqlbackward;

import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractBuilder;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractDS;
import com.ez.gdb.mainframe.reports.calltree.ReportDetailsGroup;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC3DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlBackwCallsReportDS
extends CalltreeReportsAbstractDS {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SqlBackwCallsReportDS.class);
    private static final String QUOTE = "'";
    private String commandBackward = "select @rid.asString() as startRid, name, $a.out.inE('ProxyFor').out.@rid.asString() as calledProxies, $a.out.inE('ProxyFor').out.name.asString() as calledProxiesName, out('Ancestor')[0].name as ancestor from\t(traverse in('ProxyFor','ProgramCall') \tfrom (select from ProgramProxy where (( @rid in @@@@@EZLEGACY@@@@)@@@@@EZLEGACY_NAME@@@@ ) FETCHPLAN in_*:-2 out_*:-2) @@@@@EZLEGACY_LIMIT@@@@@@@@@WHILE@EZLEGACY@@@@ STRATEGY BREADTH_FIRST) \nlet $a = inE('ProgramCall') where @class='ProgramProxy'";
    private String getProgramsQuery = " select prgRid, name from SqlUsageInfo where name in list(@@@@@EZLEGACY@@@@)";
    private String getProgDetailQuery = "select name, @rid.asString() as prgRID, type, $a.name as ancestor, $a.@rid.asString() as ancRID, $a.type as ancType, inE('ProxyFor').out[0].@rid.asString() as proxyRID  from Program let $a = in('ProxyFor')[0].out('Ancestor')[0] where @rid in list( @@@@@EZLEGACY@@@@ )";
    Map<String, Pair<String, Set<String>>> progs = new HashMap<String, Pair<String, Set<String>>>();
    Map<String, Set<String>> sqls = new HashMap<String, Set<String>>();
    private Set<String> inputSqlTbls = new HashSet<String>();
    private Set<String> currentSqlTables;
    ElementGroupInfo ds;
    Map<String, String> progsTmp = new HashMap<String, String>();

    public SqlBackwCallsReportDS(Collection inputs, Integer depthLimit, String chainDirection, ElementGroupInfo sqlSummaryDS, CalltreeReportsAbstractBuilder builder, IProgressMonitor pmonitor) {
        super(inputs, depthLimit, chainDirection, builder, pmonitor);
        this.ds = sqlSummaryDS;
        this.queryFilter = " @rid ";
    }

    @Override
    protected void prepareInputs() {
        if (this.inputPrgs != null && !this.inputPrgs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.inputPrgs.iterator();
            EZSourceProjectIDSg prjSg = null;
            while (it.hasNext()) {
                EZSourceSQLTableIDSg sg;
                EZEntityID id = (EZEntityID)it.next();
                if (prjSg == null) {
                    prjSg = (EZSourceProjectIDSg)id.getSegment(EZSourceProjectIDSg.class);
                }
                if ((sg = (EZSourceSQLTableIDSg)id.getSegment(EZSourceSQLTableIDSg.class)) != null) {
                    sb.append(QUOTE);
                    String tn = sg.getSQLTableName();
                    if (tn.contains(QUOTE)) {
                        tn = tn.replaceAll(QUOTE, "\\\\'");
                    }
                    sb.append(tn);
                    sb.append(QUOTE);
                    sb.append(", ");
                }
                this.inputSqlTbls.add(sg.getSQLTableName());
                it.remove();
            }
            if (sb.length() > 0) {
                sb = sb.delete(sb.length() - 2, sb.length() - 1);
            }
            this.inputPrgs.clear();
            String query = this.getProgramsQuery.replace("@@@@@EZLEGACY@@@@", sb.toString());
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            if (res != null) {
                for (OrientElement elem : res) {
                    HashSet<String> sqlNames;
                    String progRid = ((String)elem.getProperty("prgRid")).trim();
                    String sqlTblName = (String)elem.getProperty("name");
                    Pair tmp = this.progs.get(progRid);
                    if (tmp == null) {
                        tmp = new Pair();
                        this.progs.put(progRid, (Pair<String, Set<String>>)tmp);
                    }
                    if ((sqlNames = (HashSet<String>)tmp.getSecond()) == null) {
                        sqlNames = new HashSet<String>();
                        tmp.setSecond(sqlNames);
                    }
                    sqlNames.add(sqlTblName);
                    Set<String> progRIDs = this.sqls.get(sqlTblName);
                    if (progRIDs == null) {
                        progRIDs = new HashSet<String>();
                        this.sqls.put(sqlTblName, progRIDs);
                    }
                    progRIDs.add(progRid);
                }
                this.fillProgramsDetail(prjSg);
            } else {
                this.progs.clear();
                this.sqls.clear();
                L.debug("there are no programs using SQL tables: {}", (Object)this.inputSqlTbls.toString());
            }
        }
    }

    @Override
    protected Map<String, Pair<String, List<String>>> getData(EZSourceProgramIDSg inptSg) {
        HashMap<String, Pair<String, List<String>>> tmp = new HashMap<String, Pair<String, List<String>>>();
        HashSet<String> allCalledProxies = new HashSet<String>();
        HashSet<String> ridsToResolve = new HashSet<String>();
        boolean restrictedVisibilityStatus = WorkspacePrefUtils.getPreferenceStore().getBoolean("callgraphRestrictedNodesVisibility");
        String query = this.getQuery(inptSg, false);
        if (query != null && !query.isEmpty()) {
            L.trace("executed query: {}", (Object)query);
            long startLocal = System.currentTimeMillis();
            CloseableIterable res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
            L.debug("execute query in: {}ms", (Object)(System.currentTimeMillis() - startLocal));
            this.processResult(inptSg, res, tmp, allCalledProxies, ridsToResolve, restrictedVisibilityStatus);
        } else {
            L.warn("please get a query");
        }
        return tmp;
    }

    private void fillProgramsDetail(EZSourceProjectIDSg prjSg) {
        String query;
        CloseableIterable res;
        StringBuilder sb = new StringBuilder();
        for (String rid : this.progs.keySet()) {
            sb.append(rid);
            sb.append(", ");
        }
        if (sb.length() > 0) {
            sb = sb.delete(sb.length() - 2, sb.length() - 1);
        }
        if ((res = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query = this.getProgDetailQuery.replace("@@@@@EZLEGACY@@@@", sb.toString()))).execute(new Object[0])) != null) {
            for (Object r : res) {
                OrientElement elem = (OrientElement)r;
                String progRid = ((String)elem.getProperty("prgRID")).trim();
                String prgName = (String)elem.getProperty("name");
                Integer prgType = (Integer)elem.getProperty("type");
                String proxyRID = (String)elem.getProperty("proxyRID");
                String ancestor = (String)elem.getProperty("ancestor");
                EZSourceProgramIDSg sg = null;
                String fullPrgName = prgName;
                if (ancestor != null && !ancestor.isEmpty()) {
                    fullPrgName = String.valueOf(ancestor) + ":" + prgName;
                    Integer ancestorType = (Integer)elem.getProperty("ancType");
                    sg = new EZSourceProgramIDSg(ancestor, null, ancestorType);
                    String ancestorRid = ((String)elem.getProperty("ancRID")).trim();
                    sg.setOdbRID(ancestorRid);
                    HashSet<String> cChildren = (HashSet<String>)this.children.get(ancestorRid);
                    if (cChildren == null) {
                        cChildren = new HashSet<String>();
                        this.children.put(ancestorRid, cChildren);
                    }
                    cChildren.add(proxyRID);
                } else {
                    sg = new EZSourceProgramIDSg(prgName, null, prgType);
                    sg.setOdbRID(proxyRID);
                }
                this.progsTmp.put(proxyRID, progRid);
                this.progs.get(progRid).setFirst((Object)fullPrgName);
                EZEntityID id = new EZEntityID();
                id.addSegment((EZSegment)prjSg);
                id.addSegment((EZSegment)sg);
                int k = 0;
                for (Object o : this.inputPrgs) {
                    EZEntityID ent = (EZEntityID)o;
                    EZSourceProgramIDSg seg = (EZSourceProgramIDSg)ent.getSegment(EZSourceProgramIDSg.class);
                    if (seg == null) continue;
                    if (seg.equals((Object)sg)) {
                        k = -1;
                        break;
                    }
                    int comp = fullPrgName.compareTo(seg.getListableName());
                    if (comp < 0) break;
                    ++k;
                }
                if (k <= -1) continue;
                ((List)this.inputPrgs).add(k, id);
            }
        } else {
            L.warn("no results for programs names! query={}", (Object)query);
        }
        this.initNoInputs();
        this.buildSummary();
        this.inputSqlTbls.clear();
    }

    @Override
    public Object getFieldValue(JRField fieldName) throws JRException {
        Object value = null;
        String fName = fieldName.getName();
        if (fName.equals("usedResources")) {
            Set<String> sqlTbls;
            String inputRid = this.currentGroup.odbRID;
            Set<String> set = sqlTbls = inputRid != null && !inputRid.isEmpty() ? this.currentSqlTables : null;
            if (sqlTbls != null) {
                ArrayList<String> tmp = new ArrayList<String>(sqlTbls);
                Collections.sort(tmp);
                String temp = ((Object)tmp).toString();
                temp = temp.substring(1, temp.length());
                temp = temp.substring(0, temp.length() - 1);
                value = Messages.getString(SqlBackwCallsReportDS.class, "program.uses.label", new String[]{temp});
            }
            L.trace("sql={}", value);
        } else {
            value = super.getFieldValue(fieldName);
        }
        return value;
    }

    @Override
    protected ReportDetailsGroup buildNextGroup() {
        ReportDetailsGroup gr = null;
        try {
            gr = super.buildNextGroup();
            if (gr != null) {
                if (this.progs.get(gr.odbRID) != null) {
                    this.currentSqlTables = (Set)this.progs.remove(gr.odbRID).getSecond();
                } else {
                    String prgRID = this.progsTmp.get(gr.odbRID);
                    if (this.progs.get(prgRID) != null) {
                        this.currentSqlTables = (Set)this.progs.remove(prgRID).getSecond();
                    } else {
                        Set c = (Set)this.children.get(gr.odbRID);
                        if (c != null && !c.isEmpty()) {
                            HashSet<String> tmp = new HashSet<String>();
                            for (String tId : c) {
                                String cId = this.progsTmp.get(tId);
                                if (this.progs.get(cId) == null) continue;
                                tmp.addAll((Collection)this.progs.remove(cId).getSecond());
                            }
                            this.currentSqlTables = tmp;
                        }
                    }
                }
            } else {
                this.currentSqlTables = null;
            }
        }
        catch (Throwable e) {
            this.currentSqlTables = null;
            throw e;
        }
        return gr;
    }

    @Override
    protected void addFinalParams() {
        super.addFinalParams();
        this.builder.h.setTotalPrgs(Integer.valueOf(this.withResults + this.withoutResults));
    }

    private void buildSummary() {
        DSFactory factory = new DSFactory();
        SC3DataSource elemDS = null;
        ArrayList<ObjectForSubreport> objList = null;
        ObjectForSubreport obj = null;
        ArrayList<String> tmp = new ArrayList<String>(this.inputSqlTbls);
        Collections.sort(tmp);
        ArrayList<String> notUsed = new ArrayList<String>();
        for (String sqlTbl : tmp) {
            Set<String> progs = this.sqls.remove(sqlTbl);
            if (progs != null && !progs.isEmpty()) {
                elemDS = new SC3DataSource();
                elemDS.setLayout(2);
                elemDS.setTitle(sqlTbl);
                objList = new ArrayList();
                elemDS.setList(objList);
                this.ds.addDataSource((SubreportDataSource)elemDS);
                ArrayList<String> tempPrg = new ArrayList<String>();
                for (String rid : progs) {
                    String prgName = (String)this.progs.get(rid).getFirst();
                    tempPrg.add(prgName);
                }
                Collections.sort(tempPrg);
                progs = null;
                for (String prgName : tempPrg) {
                    String[] results = new String[]{sqlTbl, prgName};
                    obj = factory.createObj(1, results, "");
                    obj.setAnchor(String.valueOf(prgName) + "_" + sqlTbl);
                    objList.add(obj);
                }
                continue;
            }
            notUsed.add(sqlTbl);
            L.info("{} is not used by a program", (Object)sqlTbl);
        }
        if (!notUsed.isEmpty()) {
            String groupLbl = Messages.getString(SqlBackwCallsReportDS.class, "noUsed.resources.label");
            elemDS = new SC3DataSource();
            elemDS.setLayout(2);
            elemDS.setTitle(groupLbl);
            objList = new ArrayList<ObjectForSubreport>();
            elemDS.setList(objList);
            this.ds.addDataSource((SubreportDataSource)elemDS);
            Collections.sort(notUsed);
            for (String tbl : notUsed) {
                String[] results = new String[]{groupLbl, tbl};
                obj = factory.createObj(1, results, "");
                objList.add(obj);
            }
        }
    }

    @Override
    protected void writeRowToCSV() {
        if (this.csvWriter != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.currentSqlTables != null) {
                for (String sqlTable : this.currentSqlTables) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(sqlTable);
                }
            }
            List<String> rowAsList = this.currentGroup.getRowAsList();
            rowAsList.add(0, stringBuilder.toString());
            this.csvWriter.write(rowAsList.toArray(new String[0]));
        }
    }

    @Override
    protected String getQuery(EZSourceProgramIDSg inpt, boolean decreaseLimit) {
        String query = this.generateQuery(inpt, this.commandBackward, false);
        query = this.replaceLimitMarkersInQuery(inpt, query, decreaseLimit);
        L.trace("query: {}", (Object)query);
        return query;
    }

    @Override
    public void clear() {
        this.ds = null;
        if (this.currentSqlTables != null) {
            this.currentSqlTables.clear();
            this.currentSqlTables = null;
        }
        if (this.inputPrgs != null) {
            this.inputPrgs.clear();
            this.inputPrgs = null;
        }
        if (this.progs != null) {
            this.progs.clear();
            this.progs = null;
        }
        if (this.sqls != null) {
            this.sqls.clear();
            this.sqls = null;
        }
        if (this.progsTmp != null) {
            this.progsTmp.clear();
            this.progsTmp = null;
        }
        super.clear();
    }

    @Override
    protected String getFirstStepQuery(EZSourceProgramIDSg input, boolean isProcessing) {
        return null;
    }

    @Override
    protected boolean vertexHasDirectionalEdges(Vertex v) {
        return v.getEdges(Direction.IN, new String[]{"ProgramCall"}).iterator().hasNext();
    }
}

