/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree.forward;

import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractDS;
import com.ez.gdb.mainframe.reports.calltree.forward.ForwardCallsReportBuilder;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardCallsReportDS
extends CalltreeReportsAbstractDS {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ForwardCallsReportDS.class);
    private String commandForward = "select @rid.asString() as startRid, name, $a.in.@rid.asString() as calledProxies, $a.in.name.asString() as calledProxiesName, out('Ancestor')[0].name as ancestor, type \nfrom\t(traverse out('ProgramCall','ProxyFor') \n\tfrom (select from ProgramProxy where ( (@rid in @@@@@EZLEGACY@@@@)@@@@@EZLEGACY_NAME@@@@ ) FETCHPLAN in_*:-2 out_*:-2) @@@@@EZLEGACY_LIMIT@@@@@@@@@WHILE@EZLEGACY@@@@ STRATEGY BREADTH_FIRST) \nlet $a = out('ProxyFor').outE('ProgramCall') where @class='ProgramProxy'";
    private static final String queryStep1 = "select @rid.asString() as startRid, $pp.name as name, $callE.in.@rid.asString() as calledProxies, $callE.in.name.asString() as calledProxiesName, in('ProxyFor')[0].out('Ancestor')[0].name as ancestor, type \n from  Program \n let $callE = outE('ProgramCall'),\n $pp = in('ProxyFor')[aliasType = 0] where sid in @@@@@EZLEGACY@@@@ and $callE.size() > 0";

    public ForwardCallsReportDS(Collection inputs, Integer depthLimit, String chainDirection, ForwardCallsReportBuilder builder, IProgressMonitor pmonitor) {
        super(inputs, depthLimit, chainDirection, builder, pmonitor);
        this.isForward = true;
    }

    @Override
    protected String getQuery(EZSourceProgramIDSg inpt, boolean decreaseLimit) {
        String query = this.generateQuery(inpt, this.commandForward, false);
        query = this.replaceLimitMarkersInQuery(inpt, query, decreaseLimit);
        L.trace("query: {}", (Object)query);
        return query;
    }

    @Override
    protected String getFirstStepQuery(EZSourceProgramIDSg input, boolean isProcessing) {
        String queryFirstStep = this.generateQuery(input, queryStep1, true);
        return queryFirstStep;
    }

    @Override
    protected boolean vertexHasDirectionalEdges(Vertex v) {
        return v.getEdges(Direction.OUT, new String[]{"ProxyFor"}).iterator().hasNext();
    }
}

