/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree.backward;

import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractBuilder;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractDS;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardCallsReportDS
extends CalltreeReportsAbstractDS {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BackwardCallsReportDS.class);
    private static final String TYPE_MARKER = "@@type@@";
    private static final String NAME_MARKER = "@@name@@";
    private static final String CHILDREN_RID_MARKER = "@@childRid@@";
    private static final String CHILDREN_MARKER = "@@children@@";
    private static final String CHILDREN_PART = "or (@rid in @@childRid@@)";
    private static final String queryStep1 = "select @rid.asString() as startRid, $pp.name as name, $a.@rid.asString() as calledProxies, $a.out('ProxyFor').name.asString() as calledProxiesName, in('ProxyFor')[0].out('Ancestor')[0].name as ancestor, type \n from Program \n let $a = in('ProxyFor').in('ProgramCall').in('ProxyFor'), \n $pp = in('ProxyFor')[aliasType = 0] where @@@@@EZLEGACY@@@@ and $a.size() > 0 FETCHPLAN in_*:-2 out_*:-2";
    private static final String queryStep1WithNameType = "select @rid.asString() as calledProxies from ProgramProxy where ( name = '@@name@@' and type=@@type@@) @@children@@ FETCHPLAN in_*:-2 out_*:-2";
    private String commandWithSID = "select @rid.asString() as startRid, ifnull(out('ProxyFor')[0].name, name) as name, $a.@rid.asString() as calledProxies, $a.out('ProxyFor').name.asString() as calledProxiesName, out('Ancestor')[0].name as ancestor, type \nfrom\t(traverse in('ProgramCall','ProxyFor') \n\tfrom (select from ProgramProxy where (( @rid in @@@@@EZLEGACY@@@@)@@@@@EZLEGACY_NAME@@@@ ) FETCHPLAN in_*:-2 out_*:-2) @@@@@EZLEGACY_LIMIT@@@@@@@@@WHILE@EZLEGACY@@@@ STRATEGY BREADTH_FIRST) \nlet $a = in('ProgramCall').in('ProxyFor') where @class='ProgramProxy' ";

    public BackwardCallsReportDS(Collection inputs, Integer depthLimit, String chainDirection, CalltreeReportsAbstractBuilder builder, IProgressMonitor pmonitor) {
        super(inputs, depthLimit, chainDirection, builder, pmonitor);
    }

    @Override
    protected String getQuery(EZSourceProgramIDSg inpt, boolean decreaseLimit) {
        String query = this.generateQuery(inpt, this.commandWithSID, false);
        query = this.replaceLimitMarkersInQuery(inpt, query, decreaseLimit);
        L.trace("query: {}", (Object)query);
        return query;
    }

    @Override
    protected String getFirstStepQuery(EZSourceProgramIDSg input, boolean isProcessing) {
        Integer sid = input.getProgramId();
        String queryFirstStep = null;
        if (sid != null && sid == -1 || input.getOccur() != null && !input.getOccur().booleanValue()) {
            if (isProcessing) {
                return null;
            }
            String key = this.getInptKey(input);
            this.registerChildren(input, key, true);
            Set cChildren = (Set)this.children.get(key);
            queryFirstStep = queryStep1WithNameType.replace(NAME_MARKER, input.getProgramName());
            queryFirstStep = queryFirstStep.replace(TYPE_MARKER, input.getTypeId().toString());
            if (cChildren != null && !cChildren.isEmpty()) {
                queryFirstStep = queryFirstStep.replace(CHILDREN_MARKER, CHILDREN_PART);
                queryFirstStep = queryFirstStep.replace(CHILDREN_RID_MARKER, cChildren.toString());
            } else {
                queryFirstStep = queryFirstStep.replace(CHILDREN_MARKER, "");
            }
        } else {
            String key = this.getInptKey(input);
            Set<String> cChildren = this.registerChildren(input, key, true);
            queryFirstStep = cChildren != null && !cChildren.isEmpty() ? queryStep1.replace("@@@@@EZLEGACY@@@@", " sid in " + cChildren.toString()) : queryStep1.replace("@@@@@EZLEGACY@@@@", " sid = " + input.getProgramId());
        }
        return queryFirstStep;
    }

    @Override
    protected boolean vertexHasDirectionalEdges(Vertex v) {
        return v.getEdges(Direction.IN, new String[]{"ProgramCall"}).iterator().hasNext();
    }
}

