/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractDS;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.calltree.Group;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDetailsGroup
extends Group {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportDetailsGroup.class);
    int rowNo = 0;
    public final String odbRID;
    private String[] row = null;
    private Stack<State> states = new Stack();
    private final CalltreeReportsAbstractDS ds;
    private boolean processed = false;
    private final Integer limit;
    private boolean isForward = false;
    private Set<String> assChildren = null;
    private Map<String, String> assChildNames;
    private List<String> sortedNames;

    public ReportDetailsGroup(CalltreeReportsAbstractDS ds, String direction, EZSourceProgramIDSg prgsg, String inptRID, Integer limit, boolean isForward) {
        super(direction);
        this.prgName = prgsg.getListableName();
        this.odbRID = inptRID != null && !inptRID.equals(prgsg.getOdbRID()) ? inptRID : prgsg.getOdbRID();
        this.ds = ds;
        this.limit = limit;
        this.isForward = isForward;
    }

    public void selectRow() {
    }

    public String getRowAsString() {
        StringBuffer buf = new StringBuffer();
        String[] row = this.getRow();
        String pName = row[0];
        buf.append(pName);
        int i = 1;
        while (i < row.length) {
            pName = row[i];
            if (pName == null) break;
            buf.append(this.direction).append(pName);
            ++i;
        }
        String s = buf.toString();
        return ReportsUtils.stripNonValidXMLCharacters((String)s, (boolean)true);
    }

    public List<String> getRowAsList() {
        String[] row = this.getRow();
        ArrayList<String> rowAsList = new ArrayList<String>();
        String pName = row[0];
        rowAsList.add(pName);
        int i = 1;
        while (i < row.length) {
            pName = row[i];
            if (pName == null) break;
            rowAsList.add(pName);
            ++i;
        }
        return rowAsList;
    }

    public boolean isParsed() {
        return this.getRow() == null;
    }

    public String[] getRow() {
        if (this.row == null) {
            this.row = this.obtainRow();
            if (this.row != null) {
                ++this.rowNo;
            }
        }
        return this.row;
    }

    public void removeRow() {
        this.row = null;
    }

    private String[] obtainRow() {
        if (!this.processed && this.states.isEmpty()) {
            this.processed = true;
            Pair<String, List<String>> node = null;
            if (this.sortedNames != null) {
                if (!this.sortedNames.isEmpty()) {
                    String assName = this.sortedNames.remove(0);
                    String assRID = this.assChildNames.remove(assName);
                    node = this.ds.getDataFor(assRID);
                }
            } else {
                node = this.ds.getDataFor(this.odbRID);
            }
            if (node != null && node.getSecond() != null && !((List)node.getSecond()).isEmpty()) {
                State state = new State();
                state.node = node;
                state.chain.add((String)state.node.getFirst());
                this.states.push(state);
            }
        }
        String[] row = null;
        if (!this.states.isEmpty()) {
            row = this.getChain(this.states.peek());
        }
        if (row == null && this.sortedNames != null && !this.sortedNames.isEmpty()) {
            this.processed = false;
            row = this.obtainRow();
        }
        return row;
    }

    private String[] getChain(State state) {
        String[] ret = null;
        while (ret == null && !this.states.isEmpty()) {
            if (!state.expanded) {
                Map<String, String> children = null;
                if (this.limit == null || this.limit >= state.chain.size()) {
                    children = this.getChildren(state.node);
                }
                if (children == null || children.isEmpty()) {
                    ret = state.chain.toArray(new String[0]);
                    this.states.pop();
                } else {
                    if (this.isForward) {
                        this.ds.checkAndAddUsedProgram((String)state.node.getFirst());
                    }
                    state.expanded = true;
                    ArrayList<String> lst = new ArrayList<String>(children.keySet());
                    Collections.sort(lst, String.CASE_INSENSITIVE_ORDER);
                    state.namesToExpand = lst;
                    state.idxToExpand = 0;
                    state.children = children;
                }
            }
            if (ret != null) continue;
            if (state.idxToExpand >= state.namesToExpand.size()) {
                this.states.pop();
                if (this.states.isEmpty()) continue;
                state = this.states.peek();
                continue;
            }
            String cName = state.namesToExpand.get(state.idxToExpand);
            ++state.idxToExpand;
            boolean cycle = state.chain.contains(cName);
            ArrayList<String> chain = new ArrayList<String>(state.chain);
            chain.add(cName);
            if (!cycle) {
                State newState = new State();
                newState.node = this.ds.getDataFor(state.children.get(cName));
                newState.chain = chain;
                this.states.push(newState);
                state = newState;
                continue;
            }
            ret = chain.toArray(new String[0]);
        }
        return ret;
    }

    protected List<String> buildChains(List<String[]> ret, Map<String, Pair<String, List<String>>> tmp, List<String> chain, Pair<String, List<String>> p) {
        List childrenIds = (List)p.getSecond();
        if (chain == null && childrenIds != null && !childrenIds.isEmpty()) {
            chain = new ArrayList<String>();
            chain.add((String)p.getFirst());
        }
        if (childrenIds != null) {
            Map<String, String> children = this.getChildren(p);
            if (children.isEmpty()) {
                ret.add(chain.toArray(new String[0]));
                chain.remove(chain.size() - 1);
            } else {
                ArrayList<String> lst = new ArrayList<String>(children.keySet());
                Collections.sort(lst, String.CASE_INSENSITIVE_ORDER);
                for (String cName : lst) {
                    boolean cycle = chain.contains(cName);
                    chain.add(cName);
                    if (!cycle) {
                        p = tmp.get(children.get(cName));
                        chain = this.buildChains(ret, tmp, chain, p);
                        continue;
                    }
                    ret.add(chain.toArray(new String[0]));
                    chain.remove(chain.size() - 1);
                }
                chain.remove(chain.size() - 1);
            }
        } else if (chain != null) {
            ret.add(chain.toArray(new String[0]));
            chain.remove(chain.size() - 1);
        }
        return chain;
    }

    protected Map<String, String> getChildren(Pair<String, List<String>> p) {
        HashMap<String, String> children = new HashMap<String, String>();
        if (p.getSecond() != null) {
            for (String cRID : (List)p.getSecond()) {
                Pair<String, List<String>> pp = this.ds.getDataFor(cRID);
                if (pp != null) {
                    if (!this.isForward) {
                        this.ds.checkAndAddUsedProgram((String)pp.getFirst());
                    }
                    children.put((String)pp.getFirst(), cRID);
                    continue;
                }
                L.debug("child not loaded; cRID={}", (Object)cRID);
            }
        }
        return children;
    }

    public void setChildren(Set<String> children) {
        this.assChildren = children;
        if (this.assChildren != null && !this.assChildren.isEmpty()) {
            this.assChildNames = new HashMap<String, String>();
            for (String rid : this.assChildren) {
                Pair<String, List<String>> p = this.ds.getDataFor(rid);
                if (p == null) continue;
                this.assChildNames.put((String)p.getFirst(), rid);
            }
            this.sortedNames = new ArrayList<String>(this.assChildNames.keySet());
            Collections.sort(this.sortedNames);
        } else {
            this.sortedNames = null;
            this.assChildNames = null;
        }
    }

    class State {
        public boolean expanded = false;
        public Pair<String, List<String>> node;
        List<String> chain = new ArrayList<String>();
        int idxToExpand = 0;
        List<String> namesToExpand = new ArrayList<String>();
        public Map<String, String> children;

        State() {
        }
    }
}

