/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAbstractBuilder;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.BuilderFinishAdapter;
import com.ez.report.application.reports.FinishListener;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.Status;

public abstract class CalltreeReportsJob
extends EZReportJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Integer cgLimitation = null;
    Boolean isCgLimited = null;

    public CalltreeReportsJob(String arg0, EZEntityID arg1) {
        super(arg0, arg1);
    }

    protected AbstractBuilder getBuilder() {
        final AbstractReportBuilder builder = this.instantiateReportBuilder();
        builder.setProject(this.projectName);
        builder.setFinishListener((FinishListener)new BuilderFinishAdapter(){

            public void reportFinished(AbstractReport model, JasperPrint print, boolean mustWrite, GenerationStatus status) {
                Set<String> usedProgramsSet = ((CalltreeReportsAbstractBuilder)builder).getUsedProgramsSet();
                if (usedProgramsSet != null && !usedProgramsSet.isEmpty()) {
                    StringBuilder sBuilder = new StringBuilder();
                    for (String programName : usedProgramsSet) {
                        sBuilder.append(programName);
                        sBuilder.append(",");
                    }
                    if (sBuilder.length() > 0) {
                        sBuilder.deleteCharAt(sBuilder.length() - 1);
                    }
                    String prj = (String)CalltreeReportsJob.this.inputs.get("project_name");
                    StringBuilder buff = new StringBuilder();
                    Collection inputs = (Collection)CalltreeReportsJob.this.inputs.get("input_list");
                    for (EZEntityID id : inputs) {
                        String toPrint = null;
                        EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                        if (prgsg == null) {
                            prgsg = (EZSourceSQLTableIDSg)id.getSegment(EZSourceSQLTableIDSg.class);
                            toPrint = ((EZSourceSQLTableIDSg)prgsg).getSQLTableName();
                        } else {
                            toPrint = prgsg.getListableName();
                        }
                        buff.append(toPrint);
                        buff.append(",");
                    }
                    buff = buff.deleteCharAt(buff.length() - 1);
                    String programsMsgLabel = Messages.getString(CalltreeReportsJob.class, "programsMsg.label", new String[]{CalltreeReportsJob.this.getReportName4Tooltip(), prj, buff.toString(), sBuilder.toString()});
                    LogUtil.displayErrorMessage((Status)new Status(1, "com.ez.gdb.mainframe.reports", 2, programsMsgLabel, null), (boolean)false);
                }
            }
        });
        return builder;
    }

    protected abstract AbstractReportBuilder instantiateReportBuilder();

    public void setParameters(Map<String, Object> params) {
        super.setParameters(params);
        this.calcLimits();
    }

    private void calcLimits() {
        this.isCgLimited = (Boolean)this.inputs.get("is graph limited");
        if (this.isCgLimited != null && this.isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)this.inputs.get("limit number for graph levels");
        }
    }

    protected String getTabToolTip() {
        String tt = this.isCgLimited != null && this.isCgLimited != false ? Messages.getString(CalltreeReportsJob.class, "report.tab.tooltip.limited", new String[]{this.getReportName4Tooltip(), this.cgLimitation.toString()}) : Messages.getString(CalltreeReportsJob.class, "report.tab.tooltip.unlimited", new String[]{this.getReportName4Tooltip()});
        return tt;
    }

    protected String getReportName4Tooltip() {
        return "";
    }
}

