/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.common.model.BaseListable;
import com.ez.common.model.BaseResourceInput;
import com.ez.gdb.core.analysis.inputs.SQLTable;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.gdb.core.collectors.ODBProgramCollector;
import com.ez.gdb.core.ui.ODBCallGraphWizardDialog;
import com.ez.gdb.core.ui.ODBCallgraphWizard;
import com.ez.gdb.mainframe.reports.calltree.CalltreeReportsAnalysis;
import com.ez.gdb.mainframe.reports.calltree.ui.CallchainsReportsWizardPage;
import com.ez.gdb.mainframe.reports.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public abstract class CalltreeReportsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String AVAILABLE_CHILDREN_RESOURCES = "AVAILABLE_CHILDREN_RESOURCES";
    private static final String PRGS_CHILDREN_PAGE_NAME = "children_page";
    protected boolean hasChildrenPage = true;

    protected CalltreeReportsFilter(ProjectInfo projectInfo) {
        this.prjInfo = projectInfo;
    }

    protected PrepareReportWizard getWizard() {
        ODBCallgraphWizard wizard = new ODBCallgraphWizard();
        wizard.setWindowTitle(Messages.getString(((Object)((Object)this)).getClass(), "wizard.title"));
        CallchainsReportsWizardPage selectProgramsPage = new CallchainsReportsWizardPage("programs for callgraph page", true);
        selectProgramsPage.setResourcesCollector((ResourcesCollector)this.getInputCollector());
        this.setObjectType4WizardPage(selectProgramsPage);
        wizard.addPage(selectProgramsPage);
        if (this.hasChildrenPage) {
            SelectProgramsPage selectChildrenPage = new SelectProgramsPage(PRGS_CHILDREN_PAGE_NAME, true, false);
            selectChildrenPage.setSelectedPropName("selected ass resources");
            selectChildrenPage.setAvailablePropName(AVAILABLE_CHILDREN_RESOURCES);
            selectChildrenPage.setTitle(Messages.getString(CalltreeReportsFilter.class, "children.page.title"));
            selectChildrenPage.setDescription(Messages.getString(CalltreeReportsFilter.class, "children.page.description"));
            selectChildrenPage.setLeftGroupLabel(Messages.getString(CalltreeReportsFilter.class, "av.children.type"));
            selectChildrenPage.setRightGroupLabel(Messages.getString(CalltreeReportsFilter.class, "sel.children.type"));
            selectChildrenPage.setErrMsgNoResource(Messages.getString(CalltreeReportsFilter.class, "err.message"));
            ODBProgramCollector asspc = new ODBProgramCollector();
            selectChildrenPage.setResourcesCollector((ResourcesCollector)asspc);
            wizard.set("children_query", (Object)this.getChildrenQuery());
            wizard.addPage((IWizardPage)selectChildrenPage);
        }
        return wizard;
    }

    protected void setObjectType4WizardPage(CallchainsReportsWizardPage selectInputsPage) {
    }

    protected String getChildrenQuery() {
        return null;
    }

    protected abstract ODBAbstractCollector getInputCollector();

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selectedChildren = wizard.getList("selected ass resources");
        List selObjs = wizard.getList("selected resources");
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(this.prjInfo);
        List allChildren = wizard.getList(AVAILABLE_CHILDREN_RESOURCES);
        HashSet<String> inputNames = new HashSet<String>();
        for (BaseListable input : selObjs) {
            EZEntityID entity = null;
            String name = null;
            if (!(input instanceof BaseMainframeResource4GUI)) continue;
            BaseResourceInput o = ((BaseMainframeResource4GUI)input).getObject();
            if (o instanceof ProgramInput) {
                ProgramInput pi = (ProgramInput)o;
                EZSourceProgramIDSg prgIdSg = this.checkAndAdd(pi, selectedChildren, allChildren);
                if (prgIdSg == null) continue;
                entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                entity.addSegment((EZSegment)prgIdSg);
                this.addToList(list, entity);
                inputNames.add(prgIdSg.getListableName());
                continue;
            }
            if (!(o instanceof SQLTable)) continue;
            SQLTable root = (SQLTable)o;
            entity = new EZEntityID();
            entity.addSegment((EZSegment)prjIdSg);
            EZSourceSQLTableIDSg sqlIdSg = new EZSourceSQLTableIDSg(root.getSqlTableName());
            entity.addSegment((EZSegment)sqlIdSg);
            name = root.getSqlTableName();
            list.add(entity);
            inputNames.add(name);
        }
        if (selectedChildren != null) {
            for (BaseMainframeResource4GUI obj : selectedChildren) {
                ProgramInput assChild = (ProgramInput)obj.getObject();
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(assChild.getName(), assChild.getProgramID(), assChild.getTypeCode(), Boolean.valueOf(true));
                prgIdSg.setOdbRID(assChild.getOdbRID());
                prgIdSg.setAncestorName(assChild.getAncestorName());
                prgIdSg.setAncestorId(assChild.getAncestorDBId());
                entity.addSegment((EZSegment)prgIdSg);
                this.addToList(list, entity);
                inputNames.add(assChild.getListableName());
            }
        }
        analysis.addContextValue("input_list", list);
        analysis.addContextValue("PROJECT_INFO", (Object)this.prjInfo);
        analysis.addContextValue("inputs name string", inputNames);
        HashMap params = new HashMap();
        params.putAll(wizard.getValues());
        analysis.addAllContextValues(params);
        ((CalltreeReportsAnalysis)analysis).addParams();
    }

    private void addToList(List<EZEntityID> lst, EZEntityID toAdd) {
        int idx = 0;
        EZSourceProgramIDSg prgsgToAdd = (EZSourceProgramIDSg)toAdd.getSegment(EZSourceProgramIDSg.class);
        if (lst != null && !lst.isEmpty()) {
            for (EZEntityID id : lst) {
                EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                String prg = prgsg.getListableName();
                if (prgsgToAdd.getListableName().compareToIgnoreCase(prg) < 0) break;
                ++idx;
            }
        }
        lst.add(idx, toAdd);
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        ODBCallGraphWizardDialog dialog = new ODBCallGraphWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }
}

