/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.mainframe.reports.calltree;

import com.ez.gdb.mainframe.reports.EZGdbReportAnalysis;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceSQLTable;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.report.application.model.AbstractReport;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class CalltreeReportsAnalysis
extends EZGdbReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final String RESTRICTED_NAMES = "restrictedProgramNames";

    public CalltreeReportsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        super.setInputs(inputs);
        String[] cgRestrictions = PreferenceUtils.getCallgraphNamesCheckedRestrictions();
        this.addContextValue(RESTRICTED_NAMES, cgRestrictions);
        if (inputs.get(0) instanceof EZSourceProgram || inputs.get(0) instanceof EZSourceSQLTable) {
            this.params.put("input_list", this.getContextValue("input_list"));
            IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
            int levelLimit = store.getInt("callgraphLimitExceed");
            boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
            this.params.put("is graph limited", isLimited);
            this.params.put("limit number for graph levels", levelLimit);
            this.params.put(RESTRICTED_NAMES, this.getContextValue(RESTRICTED_NAMES));
        }
    }

    @Override
    public void addParams() {
        super.addParams();
        this.params.put("is graph limited", this.getContextValue("is graph limited"));
        this.params.put("limit number for graph levels", this.getContextValue("limit number for graph levels"));
        this.params.put(RESTRICTED_NAMES, this.getContextValue(RESTRICTED_NAMES));
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            Object[] v1 = params1.get("is graph limited");
            Object[] v2 = params2.get("is graph limited");
            if (v1 != null) {
                ret = v1.equals(v2);
            } else {
                boolean bl = ret = v2 == null;
            }
            if (ret) {
                if (v1 != null && ((Boolean)v1).booleanValue()) {
                    v1 = params1.get("limit number for graph levels");
                    v2 = params2.get("limit number for graph levels");
                    if (v1 != null) {
                        ret = v1.equals(v2);
                    } else {
                        boolean bl = ret = v2 == null;
                    }
                }
                if (ret) {
                    v1 = (Boolean)params1.get("show appendix");
                    v2 = (Boolean)params2.get("show appendix");
                    if (v1 != null) {
                        ret = v1.equals(v2);
                    } else {
                        boolean bl = ret = v2 == null;
                    }
                    if (ret) {
                        v1 = (Boolean)params1.get("showInputDetails");
                        v2 = (Boolean)params2.get("showInputDetails");
                        if (v1 != null) {
                            ret = v1.equals(v2);
                        } else {
                            boolean bl = ret = v2 == null;
                        }
                        if (ret) {
                            v1 = (String[])params1.get(RESTRICTED_NAMES);
                            v2 = (String[])params2.get(RESTRICTED_NAMES);
                            ret = v1 != null ? Arrays.equals(v1, v2) : v2 == null;
                        }
                    }
                }
            }
        }
        return ret;
    }
}

